/*
 * Decompiled with CFR 0.152.
 */
package org.firstinspires.ftc.onbotjava;

import android.content.res.AssetManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.qualcomm.robotcore.util.ReadWriteFile;
import com.qualcomm.robotcore.util.RobotLog;
import com.qualcomm.robotcore.util.Util;
import fi.iki.elonen.NanoHTTPD;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.firstinspires.ftc.onbotjava.OnBotJavaManager;
import org.firstinspires.ftc.onbotjava.OnBotJavaSecurityManager;
import org.firstinspires.ftc.onbotjava.StandardResponses;
import org.firstinspires.ftc.robotcore.external.Predicate;
import org.firstinspires.ftc.robotcore.internal.system.AppUtil;
import org.firstinspires.ftc.robotserver.internal.webserver.MimeTypesUtil;

public final class OnBotJavaFileSystemUtils {
    private static final String TAG = OnBotJavaFileSystemUtils.class.getName();
    public static final File templatesDir = new File(OnBotJavaManager.javaRoot, "templates");
    public static final String PATH_SEPARATOR = "/";
    public static final String EXT_TEMP_FILE = ".tmp";
    public static final String EXT_JAVA_FILE = ".java";
    public static final String EXT_ZIP_FILE = ".zip";

    private OnBotJavaFileSystemUtils() {
    }

    public static NanoHTTPD.Response getFile(Map<String, List<String>> data) {
        return OnBotJavaFileSystemUtils.getFile(data, false, null);
    }

    public static NanoHTTPD.Response getFile(Map<String, List<String>> data, boolean folderAsZip, String lineEndings) {
        if (!data.containsKey("f")) {
            return StandardResponses.badRequest();
        }
        String trimmedUri = data.get("f").get(0);
        String filePath = trimmedUri.startsWith("/src/ExternalLibraries") ? OnBotJavaManager.extLibDir.getAbsolutePath() + trimmedUri.substring("/src/ExternalLibraries".length()) : OnBotJavaManager.javaRoot.getAbsolutePath() + trimmedUri;
        if (OnBotJavaSecurityManager.isValidSourceFileLocation(trimmedUri)) {
            return OnBotJavaFileSystemUtils.getFileAsFile(lineEndings, filePath);
        }
        if (OnBotJavaSecurityManager.isValidSourceFileOrFolder(trimmedUri, false)) {
            if (folderAsZip) {
                ReadWriteFile.ensureAllChangesAreCommitted((File)OnBotJavaManager.srcDir);
                return OnBotJavaFileSystemUtils.getFolderAsZip(filePath);
            }
            ReadWriteFile.ensureAllChangesAreCommitted((File)OnBotJavaManager.srcDir);
            return OnBotJavaFileSystemUtils.getFolderAsTree(filePath);
        }
        return StandardResponses.unauthorizedAccess();
    }

    @NonNull
    private static NanoHTTPD.Response getFolderAsTree(String filePath) {
        StringBuilder builder = new StringBuilder("Contents:\n");
        for (String file : new File(filePath).list()) {
            builder.append(file).append(LineEndings.UNIX.lineEnding);
        }
        return StandardResponses.successfulJsonRequest(builder.toString());
    }

    public static File tempFolder(String filePath) throws IOException {
        File tempFolder = File.createTempFile("onbotjava", EXT_TEMP_FILE, AppUtil.getDefContext().getCacheDir());
        if (!tempFolder.delete()) {
            throw new IOException("Could not delete temp file: " + tempFolder.getAbsolutePath());
        }
        if (!tempFolder.mkdirs()) {
            throw new IOException("Could not create temp folder: " + tempFolder.getAbsolutePath());
        }
        return tempFolder;
    }

    @NonNull
    private static NanoHTTPD.Response getFolderAsZip(String filePath) {
        File outputZipFile;
        File tempFolder;
        File sourceFolder = new File(filePath);
        try {
            tempFolder = OnBotJavaFileSystemUtils.tempFolder(filePath);
            outputZipFile = new File(tempFolder, filePath.substring(filePath.lastIndexOf(PATH_SEPARATOR) + 1) + EXT_ZIP_FILE);
            OnBotJavaFileSystemUtils.createZipFileFrom(sourceFolder, outputZipFile);
        }
        catch (Exception e) {
            return StandardResponses.serverError();
        }
        outputZipFile.deleteOnExit();
        tempFolder.deleteOnExit();
        try {
            return NanoHTTPD.newChunkedResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, (String)MimeTypesUtil.getMimeType((String)EXT_ZIP_FILE), (InputStream)new FileInputStream(outputZipFile));
        }
        catch (FileNotFoundException e) {
            return StandardResponses.serverError();
        }
    }

    public static void createZipFileFrom(final File sourceFolder, File outputZipFile) throws IOException {
        try (FileOutputStream destOutput = new FileOutputStream(outputZipFile);
             final ZipOutputStream zipOutputStream = new ZipOutputStream(destOutput);){
            zipOutputStream.setMethod(8);
            Util.forEachInFolder((File)sourceFolder, (boolean)true, (Predicate)new Predicate<File>(){

                public boolean test(File file) {
                    try {
                        String entryName = file.getAbsolutePath();
                        if (entryName.endsWith(OnBotJavaFileSystemUtils.EXT_TEMP_FILE)) {
                            return true;
                        }
                        if ((entryName = entryName.substring(sourceFolder.getAbsolutePath().length())).startsWith(OnBotJavaFileSystemUtils.PATH_SEPARATOR)) {
                            entryName = entryName.substring(1);
                        }
                        if (file.isDirectory() && !entryName.endsWith(OnBotJavaFileSystemUtils.PATH_SEPARATOR)) {
                            entryName = entryName + OnBotJavaFileSystemUtils.PATH_SEPARATOR;
                        }
                        ZipEntry entry = new ZipEntry(entryName);
                        zipOutputStream.putNextEntry(entry);
                        if (!file.isDirectory()) {
                            try (FileInputStream inputStream = new FileInputStream(file);){
                                AppUtil.getInstance().copyStream((InputStream)inputStream, (OutputStream)zipOutputStream);
                            }
                        }
                        zipOutputStream.closeEntry();
                    }
                    catch (IOException ex) {
                        RobotLog.ww((String)TAG, (Throwable)ex, (String)"Cannot save file \"%s\" in zip", (Object[])new Object[]{file.getAbsolutePath()});
                    }
                    return true;
                }
            });
        }
        catch (IOException ex) {
            RobotLog.ee((String)TAG, (Throwable)ex, (String)"Cannot create zip file");
            throw ex;
        }
    }

    @NonNull
    private static NanoHTTPD.Response getFileAsFile(String lineEndings, String filePath) {
        try {
            if (lineEndings == null) {
                return OnBotJavaFileSystemUtils.serveFile(filePath);
            }
            return OnBotJavaFileSystemUtils.serveFile(filePath, lineEndings);
        }
        catch (FileNotFoundException e) {
            return StandardResponses.fileNotFound();
        }
    }

    private static boolean copyAsset(@NonNull String assetPath, @NonNull File dest, boolean mirror) throws IOException {
        boolean templatesEnsured;
        block15: {
            if (assetPath.isEmpty()) {
                throw new IllegalArgumentException("assetPath cannot be empty");
            }
            templatesEnsured = true;
            AssetManager assetManager = AppUtil.getInstance().getRootActivity().getAssets();
            assetPath = assetPath.endsWith(PATH_SEPARATOR) ? assetPath.substring(0, assetPath.length() - 1) : assetPath;
            String name = assetPath.substring(assetPath.lastIndexOf(PATH_SEPARATOR) + 1);
            File newDest = new File(dest, name);
            if (mirror && newDest.exists()) {
                AppUtil.getInstance().delete(newDest);
                if (newDest.exists()) {
                    throw new IOException(String.format(Locale.ENGLISH, "Failed to remove %s to in order to create a clean copy", newDest.getAbsolutePath()));
                }
            }
            try {
                List<String> children = Arrays.asList(assetManager.list(assetPath));
                if (children.isEmpty()) {
                    try (InputStream stream = assetManager.open(assetPath);){
                        try {
                            AppUtil.getInstance().copyStream(stream, newDest);
                        }
                        catch (FileNotFoundException ex) {
                            RobotLog.ww((String)TAG, (Throwable)ex, (String)"Could not open file %s", (Object[])new Object[]{newDest.getAbsolutePath()});
                            templatesEnsured = false;
                        }
                        break block15;
                    }
                }
                newDest.mkdirs();
                for (String child : children) {
                    if (OnBotJavaFileSystemUtils.copyAsset(assetPath + PATH_SEPARATOR + child, newDest, mirror)) continue;
                    templatesEnsured = false;
                }
            }
            catch (IOException e) {
                RobotLog.ee((String)TAG, (Throwable)e, (String)"Cannot copy asset, template data might be invalid");
                templatesEnsured = false;
            }
        }
        return templatesEnsured;
    }

    public static boolean ensureTemplates() {
        if (templatesDir.exists() && !templatesDir.isDirectory()) {
            templatesDir.delete();
        }
        String javaTemplatesDirPath = "java/templates";
        try {
            return OnBotJavaFileSystemUtils.copyAsset("java/templates", templatesDir.getParentFile(), !new File(templatesDir, "user").exists());
        }
        catch (IOException ex) {
            throw new RuntimeException("ensureTemplates", ex);
        }
    }

    public static void searchForFiles(@NonNull String startPath, @NonNull File startFile, @NonNull List<String> results, boolean includeFolders) {
        if (!startFile.isDirectory()) {
            throw new IllegalArgumentException("startFile is not a directory");
        }
        if (results == null) {
            throw new NullPointerException("results is null");
        }
        for (File srcFile : startFile.listFiles()) {
            String absolutePath = srcFile.getAbsolutePath();
            String string = absolutePath = absolutePath.startsWith(startPath) ? absolutePath.substring(startPath.length()) : absolutePath;
            if (srcFile.isDirectory()) {
                absolutePath = absolutePath + PATH_SEPARATOR;
            }
            if (!srcFile.isDirectory() || includeFolders) {
                results.add(absolutePath);
            }
            if (!srcFile.isDirectory()) continue;
            OnBotJavaFileSystemUtils.searchForFiles(startPath, srcFile, results, includeFolders);
        }
    }

    @NonNull
    public static NanoHTTPD.Response serveFile(@NonNull String uri) throws FileNotFoundException {
        return OnBotJavaFileSystemUtils.serveFile(uri, null);
    }

    @NonNull
    private static NanoHTTPD.Response serveFile(@NonNull String uri, @Nullable String lineEnding) throws FileNotFoundException {
        File test = new File(uri);
        if (!(uri = test.getAbsolutePath()).startsWith(AppUtil.FIRST_FOLDER.getAbsolutePath()) && !uri.contains("..")) {
            return StandardResponses.unauthorizedAccess();
        }
        File file = new File(uri);
        ReadWriteFile.ensureChangesAreCommitted((File)file);
        String mime = MimeTypesUtil.determineMimeType((String)uri);
        if (file.exists() && file.canRead()) {
            FileInputStream reader = new FileInputStream(file);
            if (lineEnding != null) {
                StringBuilder builder = OnBotJavaFileSystemUtils.readFile(lineEnding, reader);
                return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, (String)mime, (String)builder.toString());
            }
            return NanoHTTPD.newChunkedResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, (String)mime, (InputStream)reader);
        }
        return StandardResponses.fileNotFound();
    }

    @NonNull
    public static StringBuilder readFile(@NonNull LineEndings lineEnding, @NonNull File file) throws IOException {
        return OnBotJavaFileSystemUtils.readFile(lineEnding.lineEnding, file);
    }

    @NonNull
    public static StringBuilder readFile(@NonNull String lineEnding, @NonNull File file) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(file);){
            StringBuilder stringBuilder = OnBotJavaFileSystemUtils.readFile(lineEnding, inputStream);
            return stringBuilder;
        }
    }

    @NonNull
    private static StringBuilder readFile(@NonNull String lineEnding, @NonNull FileInputStream reader) {
        StringBuilder builder = new StringBuilder();
        try (BufferedReader reader1 = new BufferedReader(new InputStreamReader(reader));){
            String line;
            while ((line = reader1.readLine()) != null) {
                builder.append(line).append(lineEnding);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return builder;
    }

    public static enum LineEndings {
        WINDOWS("\r\n"),
        UNIX("\n");

        public final String lineEnding;

        private LineEndings(String ending) {
            this.lineEnding = ending;
        }
    }
}

