/*
 * Decompiled with CFR 0.152.
 */
package org.firstinspires.ftc.onbotjava;

import com.qualcomm.robotcore.util.RobotLog;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.firstinspires.ftc.onbotjava.ExternalLibraries;
import org.firstinspires.ftc.onbotjava.OnBotJavaClassLoader;
import org.firstinspires.ftc.onbotjava.OnBotJavaManager;
import org.firstinspires.ftc.robotcore.internal.opmode.OnBotJavaHelper;

public class OnBotJavaHelperImpl
implements OnBotJavaHelper {
    private static final String TAG = "OnBotJavaHelperImpl";

    public ClassLoader createOnBotJavaClassLoader() {
        StringBuilder dexPath = new StringBuilder();
        String delimiter = "";
        for (File dotDexFile : OnBotJavaManager.getOutputDexFiles()) {
            dexPath.append(delimiter).append(dotDexFile.getAbsolutePath());
            delimiter = File.pathSeparator;
        }
        return new OnBotJavaClassLoader(dexPath.toString(), OnBotJavaManager.getParentClassLoaderForOnBotJava());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getOnBotJavaClassNames() {
        HashSet<String> classNames = new HashSet<String>();
        for (File dotJarFile : OnBotJavaManager.getOutputJarFiles()) {
            try (JarFile jarFile = new JarFile(dotJarFile);){
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    String entryName;
                    JarEntry entry = entries.nextElement();
                    if (entry.isDirectory() || !(entryName = entry.getName()).endsWith(".class")) continue;
                    String className = entryName.substring(0, entryName.lastIndexOf(46)).replace('/', '.');
                    classNames.add(className);
                }
            }
            catch (IOException e) {
                RobotLog.ee((String)TAG, (Throwable)e, (String)"getOnBotJavaClassNames");
            }
        }
        return classNames;
    }

    public Collection<String> getExternalLibrariesClassNames() {
        return ExternalLibraries.getInstance().getClassNames();
    }

    public boolean isExternalLibrariesError(NoClassDefFoundError e) {
        return ExternalLibraries.getInstance().isExternalLibrariesError(e);
    }
}

