/*
 * Decompiled with CFR 0.152.
 */
package org.firstinspires.ftc.onbotjava;

import android.content.res.AssetManager;
import androidx.annotation.Nullable;
import com.android.tools.r8.ClassFileResourceProvider;
import com.android.tools.r8.CompilationFailedException;
import com.android.tools.r8.D8;
import com.android.tools.r8.D8Command;
import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.ProgramConsumer;
import com.android.tools.r8.ProgramResourceProvider;
import com.qualcomm.robotcore.util.ReadWriteFile;
import com.qualcomm.robotcore.util.RobotLog;
import com.qualcomm.robotcore.util.ThreadPool;
import dk.sgjesse.d8onandroid.D8DiagnosticsHandler;
import dk.sgjesse.r8api.AndroidDexIndexedConsumer;
import dk.sgjesse.r8api.ArchiveClassFileResourceProvider;
import dk.sgjesse.r8api.ArchiveProgramResourceProvider;
import dk.sgjesse.r8api.OrderedClassFileResourceProvider;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.firstinspires.ftc.onbotjava.ExternalLibraries;
import org.firstinspires.ftc.onbotjava.OnBotJavaBackupManager;
import org.firstinspires.ftc.onbotjava.OnBotJavaCompiler;
import org.firstinspires.ftc.onbotjava.OnBotJavaDiagnosticsListener;
import org.firstinspires.ftc.robotcore.external.Supplier;
import org.firstinspires.ftc.robotcore.external.ThrowingCallable;
import org.firstinspires.ftc.robotcore.internal.files.FileModifyObserver;
import org.firstinspires.ftc.robotcore.internal.opmode.OnBotJavaBuildLocker;
import org.firstinspires.ftc.robotcore.internal.opmode.OnBotJavaHelper;
import org.firstinspires.ftc.robotcore.internal.system.AppUtil;
import org.firstinspires.ftc.robotcore.internal.system.Assert;
import org.threeten.bp.LocalDateTime;
import org.threeten.bp.ZoneOffset;
import org.threeten.bp.temporal.TemporalAccessor;

public class OnBotJavaManager
implements Closeable {
    public static final File javaRoot = new File(AppUtil.FIRST_FOLDER, "/java/");
    public static final File libDir = new File(javaRoot, "/lib/");
    public static final File srcDir = new File(javaRoot, "/src/");
    public static final File srcBackupDir = new File(javaRoot, "/srcBackups");
    public static final String EXTERNAL_LIBRARIES = "/ExternalLibraries";
    public static final File extLibDir = new File(AppUtil.FIRST_FOLDER, "/ExternalLibraries");
    public static final File controlDir = new File(javaRoot, "/control/");
    public static final File buildRequestFile = new File(controlDir, "buildRequest.txt");
    public static final File buildLockDir = new File(controlDir, "/buildLock/");
    public static final File statusDir = new File(javaRoot, "/status/");
    public static final File buildLogFile = new File(statusDir, "buildLog.txt");
    public static final File buildStartedFile = new File(statusDir, "buildStarted.txt");
    public static final File buildCompleteFile = new File(statusDir, "buildComplete.txt");
    public static final File currentOnBotJavaDirFile = new File(statusDir, "currentOnBotJavaDir.txt");
    public static final File buildDir = new File(javaRoot, "/build/");
    public static final File sourceOutputDir = new File(buildDir, "/gensrc/");
    public static final File classesOutputDir = new File(buildDir, "/classes/");
    public static final File jarsOutputDir = new File(buildDir, "/jars/");
    public static final String onBotJavaJarName = "OnBotJava.jar";
    public static final File assetRoot = new File("java");
    public static final String[] platformClassPathLibs = new String[]{"android.jar", "androidx-rs.jar"};
    private static final String[] ftcClassPathLibs = new String[]{"onbotjava-classes.jar", "desugar_jdk_libs-1.1.1.jar", "core-lambda-stubs-30.0.3.jar"};
    public static final String TAG = "OnBotJava";
    protected static final Object startStopLock = new Object();
    protected final ThreadPool.Singleton<Void> buildSingleton;
    protected FileModifyObserver controlObserver;
    protected OnBotJavaDiagnosticsListener diagnosticListener;
    protected static volatile BuildStatus buildStatus = BuildStatus.NOT_STARTED;

    public static void initialize() {
        OnBotJavaManager.ensureDirectories();
        OnBotJavaManager.extractAssets();
    }

    protected static void ensureDirectories() {
        OnBotJavaManager.ensureDirs(libDir);
        OnBotJavaManager.ensureDirs(srcDir);
        OnBotJavaManager.ensureDirs(srcBackupDir);
        OnBotJavaManager.ensureDirs(extLibDir);
        OnBotJavaManager.ensureDirs(controlDir);
        OnBotJavaManager.ensureDirs(statusDir);
        OnBotJavaManager.ensureDirs(buildDir);
        ReadWriteFile.ensureAllChangesAreCommitted((File)srcDir);
    }

    protected void ensureBuildDirs() {
        this.trace("ensureBuildDirs()", new Runnable(){

            @Override
            public void run() {
                OnBotJavaManager.ensureDirs(sourceOutputDir);
                OnBotJavaManager.ensureDirs(classesOutputDir);
                OnBotJavaManager.ensureDirs(jarsOutputDir);
            }
        });
    }

    protected static void ensureDirs(File file) {
        AppUtil.getInstance().ensureDirectoryExists(file);
    }

    protected static void extractAssets() {
        for (String libName : platformClassPathLibs) {
            OnBotJavaManager.extractJavaLibraryAsset(libName);
        }
        for (String libName : ftcClassPathLibs) {
            OnBotJavaManager.extractJavaLibraryAsset(libName);
        }
    }

    protected static void extractJavaLibraryAsset(String name) {
        File asset = new File(assetRoot, name);
        File libFile = new File(libDir, name);
        try {
            AssetManager assetManager = AppUtil.getDefContext().getAssets();
            try (InputStream inputStream = assetManager.open(asset.getPath(), 2);){
                if (!libFile.exists() || asset.length() != libFile.length() || asset.lastModified() != libFile.lastModified()) {
                    AppUtil.getInstance().copyStream(inputStream, libFile);
                    libFile.setLastModified(asset.lastModified());
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("exception in extractJavaLibraryAsset()", e);
        }
    }

    public OnBotJavaManager() {
        RobotLog.vv((String)TAG, (String)"ctor()...");
        this.buildSingleton = new ThreadPool.Singleton();
        this.buildSingleton.setService(ThreadPool.getDefault());
        this.controlObserver = new FileModifyObserver(buildRequestFile, new FileModifyObserver.Listener(){

            public void onFileChanged(int event, File file) {
                RobotLog.vv((String)OnBotJavaManager.TAG, (String)"build request file changed: 0x%08x %s", (Object[])new Object[]{event, file.getAbsolutePath()});
                OnBotJavaManager.this.buildSingleton.submit(new Runnable(){

                    @Override
                    public void run() {
                        OnBotJavaBuildLocker.lockBuildExclusiveWhile((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                OnBotJavaManager.this.build();
                            }
                        });
                    }
                });
            }
        });
        RobotLog.vv((String)TAG, (String)"...ctor()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        RobotLog.vv((String)TAG, (String)"close()");
        Object object = startStopLock;
        synchronized (object) {
            if (this.controlObserver != null) {
                this.controlObserver.close();
                this.controlObserver = null;
            }
        }
    }

    protected synchronized void build() {
        this.trace("build()", new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block11: {
                    try {
                        OnBotJavaManager.this.diagnosticListener = new OnBotJavaDiagnosticsListener(srcDir);
                        try {
                            buildStatus = BuildStatus.RUNNING;
                            OnBotJavaManager.this.writeBuildStatusFile(buildStartedFile, "build started");
                            try {
                                OnBotJavaManager.this.clean();
                                OnBotJavaManager.this.ensureBuildDirs();
                                if (OnBotJavaManager.this.compileJavaFiles()) {
                                    SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd+HH.mm.ss", Locale.US);
                                    File onBotJavaDirDirectory = AppUtil.getInstance().createTempDirectory("onBotJavaJar-" + formatter.format(new Date()) + "-", "", jarsOutputDir);
                                    ReadWriteFile.writeFile((File)currentOnBotJavaDirFile, (String)onBotJavaDirDirectory.getAbsolutePath());
                                    OnBotJavaManager.this.consolidateClassFilesToJar(onBotJavaDirDirectory);
                                    OnBotJavaManager.this.dexifyJarFiles(onBotJavaDirDirectory);
                                    OnBotJavaBackupManager.archiveSourceForBuild();
                                    buildStatus = BuildStatus.SUCCESSFUL;
                                    OnBotJavaManager.this.writeBuildStatusFile(OnBotJavaHelper.buildSuccessfulFile, "last successful build finished");
                                    RobotLog.vv((String)OnBotJavaManager.TAG, (String)"onBotJava build finished successfully");
                                }
                                buildStatus = buildStatus == BuildStatus.SUCCESSFUL ? BuildStatus.SUCCESSFUL : BuildStatus.FAILED;
                            }
                            catch (RuntimeException ex) {
                                try {
                                    RobotLog.ee((String)OnBotJavaManager.TAG, (Throwable)ex, (String)"OnBotJava build failed due to an exception");
                                    buildStatus = buildStatus == BuildStatus.SUCCESSFUL ? BuildStatus.SUCCESSFUL : BuildStatus.FAILED;
                                }
                                catch (Throwable throwable) {
                                    buildStatus = buildStatus == BuildStatus.SUCCESSFUL ? BuildStatus.SUCCESSFUL : BuildStatus.FAILED;
                                    OnBotJavaManager.this.writeBuildStatusFile(buildCompleteFile, "build completed");
                                    throw throwable;
                                }
                                OnBotJavaManager.this.writeBuildStatusFile(buildCompleteFile, "build completed");
                                break block11;
                            }
                            OnBotJavaManager.this.writeBuildStatusFile(buildCompleteFile, "build completed");
                        }
                        finally {
                            OnBotJavaManager.this.diagnosticListener.flush();
                            OnBotJavaManager.this.diagnosticListener.close();
                            OnBotJavaManager.this.diagnosticListener = null;
                        }
                    }
                    catch (IOException e) {
                        RobotLog.logStackTrace((Throwable)e);
                    }
                    catch (RuntimeException ex) {
                        RobotLog.ee((String)OnBotJavaManager.TAG, (Throwable)ex, (String)"Error occurred probably while dex-ing OnBotJava build, suggest cleaning build folder and trying again");
                    }
                }
            }
        });
    }

    protected void writeBuildStatusFile(File file, String message) {
        String contents = String.format(Locale.getDefault(), "%s\n%s\n", AppUtil.getInstance().getIso8601DateTimeFormatter().format((TemporalAccessor)LocalDateTime.now().atOffset(ZoneOffset.UTC)), message);
        ReadWriteFile.writeFile((File)file, (String)contents);
    }

    protected void clean() {
        this.trace("clean()", new Runnable(){

            @Override
            public void run() {
                AppUtil.getInstance().delete(classesOutputDir);
                AppUtil.getInstance().delete(sourceOutputDir);
                File curDir = OnBotJavaManager.getCurrentOutputDir();
                for (File child : AppUtil.getInstance().filesIn(jarsOutputDir)) {
                    if (child.equals(curDir)) continue;
                    AppUtil.getInstance().delete(child);
                }
            }
        });
    }

    protected boolean compileJavaFiles() {
        return this.trace("compileJavaFiles()", new Supplier<Boolean>(){

            public Boolean get() {
                OnBotJavaCompiler javaCompiler = new OnBotJavaCompiler();
                return javaCompiler.compile(srcDir, OnBotJavaManager.this.diagnosticListener);
            }
        });
    }

    protected void consolidateClassFilesToJar(final File onBotJavaDirDirectory) throws IOException {
        this.trace("consolidateClassFilesInJar()", new ThrowingCallable<Void, IOException>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Void call() throws IOException {
                File onBotJavaJar = new File(onBotJavaDirDirectory, OnBotJavaManager.onBotJavaJarName);
                AppUtil.getInstance().ensureDirectoryExists(onBotJavaDirDirectory, false);
                RobotLog.vv((String)OnBotJavaManager.TAG, (String)"consolidating to %s", (Object[])new Object[]{onBotJavaJar.getPath()});
                try (FileOutputStream outputStream = new FileOutputStream(onBotJavaJar);){
                    Manifest manifest = new Manifest();
                    try (JarOutputStream jarOutputStream = new JarOutputStream((OutputStream)outputStream, manifest);){
                        for (File classFile : AppUtil.getInstance().filesUnder(classesOutputDir, ".class")) {
                            ZipEntry ze = new ZipEntry(AppUtil.getInstance().getRelativePath(classesOutputDir, classFile).getPath());
                            ze.setTime(classFile.lastModified());
                            jarOutputStream.putNextEntry(ze);
                            AppUtil.getInstance().copyStream(classFile, (OutputStream)jarOutputStream);
                            jarOutputStream.closeEntry();
                        }
                    }
                }
                return null;
            }
        });
    }

    protected void dexifyJarFiles(final File onBotJavaDirDirectory) throws IOException {
        this.trace("dexifyJarFiles()", new ThrowingCallable<Void, IOException>(){

            public Void call() throws IOException {
                File robotJavaJar = null;
                for (File jarFile : OnBotJavaManager.getOutputFiles(onBotJavaDirDirectory, ".jar")) {
                    if (jarFile.getName().equals(OnBotJavaManager.onBotJavaJarName)) {
                        if (robotJavaJar != null) {
                            RobotLog.ee((String)OnBotJavaManager.TAG, (String)"two consolidators: %s %s", (Object[])new Object[]{robotJavaJar.getPath(), jarFile.getPath()});
                        }
                        robotJavaJar = jarFile;
                    }
                    OnBotJavaManager.this.dexifyJarFile(jarFile);
                }
                return null;
            }
        });
    }

    public static List<File> getOutputJarFiles() {
        return OnBotJavaManager.getOutputFiles(null, ".jar");
    }

    public static List<File> getOutputDexFiles() {
        return OnBotJavaManager.getOutputFiles(null, ".dex");
    }

    private static List<File> getOutputFiles(@Nullable File onBotJavaDirDirectory, String extension) {
        ArrayList<File> result = new ArrayList<File>();
        File currentOutputDir = OnBotJavaManager.getCurrentOutputDir();
        if (currentOutputDir != null) {
            if (onBotJavaDirDirectory != null) {
                Assert.assertTrue((boolean)currentOutputDir.equals(onBotJavaDirDirectory));
            }
            result.addAll(AppUtil.getInstance().filesIn(currentOutputDir, extension));
        }
        return result;
    }

    @Nullable
    private static File getCurrentOutputDir() {
        if (currentOnBotJavaDirFile.exists()) {
            try {
                String currentOnBotJavaDirName = ReadWriteFile.readFile((File)currentOnBotJavaDirFile);
                File currentOnBotJavaDir = new File(currentOnBotJavaDirName);
                if (currentOnBotJavaDir.isDirectory()) {
                    return currentOnBotJavaDir;
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        RobotLog.vv((String)TAG, (String)"getCurrentOutputDir() unavailable");
        return null;
    }

    public static BuildStatus getBuildStatus() {
        return buildStatus;
    }

    protected void dexifyJarFile(File jarFile) throws RuntimeException {
        try {
            File dexFileParent = jarFile.getParentFile();
            OnBotJavaManager.dexifyFiles(Collections.singleton(jarFile), dexFileParent, this.diagnosticListener);
        }
        catch (RuntimeException e) {
            RobotLog.ee((String)TAG, (Throwable)e, (String)"Cannot finish OBJ build. Dex failed");
            throw e;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void dexifyFiles(Collection<File> inputFiles, File dexFileParent, OnBotJavaDiagnosticsListener diagnosticListener) {
        if (!dexFileParent.isDirectory()) {
            throw new IllegalArgumentException("dexFileParent must be a directory " + dexFileParent.getAbsolutePath());
        }
        StringBuilder sb = new StringBuilder();
        for (File inputFile : inputFiles) {
            sb.append(" " + inputFile.getAbsolutePath());
        }
        RobotLog.vv((String)TAG, (String)"dexifying %s...", (Object[])new Object[]{sb.toString()});
        File tmpDir = new File(dexFileParent, UUID.randomUUID().toString());
        tmpDir.mkdir();
        File tmpZipFile = new File(tmpDir, "out.zip");
        try {
            File file;
            RobotLog.vv((String)TAG, (String)"using d8");
            D8Command.Builder d8CommandBuilder = (D8Command.Builder)D8Command.builder((DiagnosticsHandler)new D8DiagnosticsHandler()).setProgramConsumer((ProgramConsumer)new AndroidDexIndexedConsumer(tmpZipFile));
            OrderedClassFileResourceProvider classpathResourceProvider = new OrderedClassFileResourceProvider();
            for (String string : ftcClassPathLibs) {
                file = new File(libDir, string);
                classpathResourceProvider.addClassFileResourceProvider(new ArchiveClassFileResourceProvider(file));
            }
            for (File file2 : ExternalLibraries.getInstance().getClasspathFiles()) {
                classpathResourceProvider.addClassFileResourceProvider(new ArchiveClassFileResourceProvider(file2));
            }
            for (String string : platformClassPathLibs) {
                file = new File(libDir, string);
                classpathResourceProvider.addClassFileResourceProvider(new ArchiveClassFileResourceProvider(file));
            }
            if (!classpathResourceProvider.isEmpty()) {
                d8CommandBuilder.addClasspathResourceProvider((ClassFileResourceProvider)classpathResourceProvider);
            }
            for (File inputFile : inputFiles) {
                d8CommandBuilder.addProgramResourceProvider((ProgramResourceProvider)new ArchiveProgramResourceProvider(inputFile));
            }
            D8.run((D8Command)((D8Command)d8CommandBuilder.build()));
            classpathResourceProvider.close();
            OnBotJavaManager.unpackZipFile(tmpZipFile, tmpDir);
            for (File tmpDexFile : AppUtil.getInstance().filesUnder(tmpDir, ".dex")) {
                String name;
                File file3;
                if (!tmpDexFile.renameTo(file3 = new File(dexFileParent, name = tmpDexFile.getName()))) {
                    throw new RuntimeException("failed to move " + tmpDexFile.getAbsolutePath() + " to " + file3.getAbsolutePath());
                }
                RobotLog.vv((String)TAG, (String)"Wrote %s", (Object[])new Object[]{file3.getAbsolutePath()});
            }
        }
        catch (CompilationFailedException e) {
            try {
                diagnosticListener.getPrintStream().format(diagnosticListener.locale, "dex: CompilationFailedException: %s", e.getMessage());
                throw new RuntimeException(e);
                catch (IOException e2) {
                    diagnosticListener.getPrintStream().format(diagnosticListener.locale, "dex: IOException: %s", e2.getMessage());
                    throw new RuntimeException(e2);
                }
                catch (RuntimeException e3) {
                    diagnosticListener.getPrintStream().format(diagnosticListener.locale, "dex: RuntimeException: %s", e3.getMessage());
                    throw e3;
                }
            }
            catch (Throwable throwable) {
                AppUtil.getInstance().delete(tmpDir);
                RobotLog.vv((String)TAG, (String)"...dexifying %s", (Object[])new Object[]{sb.toString()});
                throw throwable;
            }
        }
        AppUtil.getInstance().delete(tmpDir);
        RobotLog.vv((String)TAG, (String)"...dexifying %s", (Object[])new Object[]{sb.toString()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void unpackZipFile(File file, File destDir) throws IOException {
        try (ZipFile zipFile = new ZipFile(file);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) continue;
                String entryName = entry.getName();
                File destFile = new File(destDir, entryName);
                destFile.getParentFile().mkdirs();
                AppUtil.getInstance().copyStream(zipFile.getInputStream(entry), destFile);
            }
        }
    }

    public static ClassLoader getParentClassLoaderForOnBotJava() {
        ClassLoader extLibClassLoader = ExternalLibraries.getInstance().getClassLoader();
        return extLibClassLoader != null ? extLibClassLoader : OnBotJavaManager.class.getClassLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <VALUE, EXCEPTION_T extends IOException> VALUE trace(String message, ThrowingCallable<VALUE, EXCEPTION_T> callable) throws IOException {
        this.pretrace(message);
        try {
            Object object = callable.call();
            return (VALUE)object;
        }
        finally {
            this.posttrace(message);
        }
    }

    protected void trace(String message, Runnable runnable) {
        this.pretrace(message);
        try {
            runnable.run();
        }
        finally {
            this.posttrace(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T trace(String message, Supplier<T> supplier) {
        this.pretrace(message);
        try {
            Object object = supplier.get();
            return (T)object;
        }
        finally {
            this.posttrace(message);
        }
    }

    protected void pretrace(String message) {
        RobotLog.vv((String)TAG, (String)"%s...", (Object[])new Object[]{message});
        this.testBusy(message, "pre");
    }

    protected void posttrace(String message) {
        this.testBusy(message, "post");
        RobotLog.vv((String)TAG, (String)"...%s", (Object[])new Object[]{message});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void testBusy(String message, String phase) {
        File file = new File(jarsOutputDir, "testBusy.txt");
        try {
            ReadWriteFile.writeFileOrThrow((File)file, (String)message);
        }
        catch (IOException e) {
            RobotLog.ee((String)TAG, (Throwable)e, (String)"%s: %s: %s is now busy", (Object[])new Object[]{message, phase, jarsOutputDir});
        }
        finally {
            file.delete();
        }
    }

    static {
        RobotLog.vv((String)TAG, (String)"OnBotJavaManager::static");
        OnBotJavaManager.initialize();
    }

    public static enum BuildStatus {
        RUNNING,
        FAILED,
        SUCCESSFUL,
        NOT_STARTED;

    }
}

