/*
 * Decompiled with CFR 0.152.
 */
package org.firstinspires.ftc.onbotjava;

public final class OnBotJavaSecurityManager {
    private static final String VALID_TEMPLATE_FILE_REGEX = "templates/([\\w.\\d/_]+/)*([\\w.\\d_]+\\.(?:java|txt|md|properties|groovy|/)|[\\w\\d_]+)$";
    private static final String VALID_SRC_FILE_REGEX = "/(?:src|jars)[\\w.\\d/_$]+[\\w.\\d_$]+\\.(?:java|aar|jar|zip|txt|md|properties|groovy|json)$";
    private static final String VALID_SRC_FILE_OR_FOLDER_REGEX = "(/(src|jars)([\\w.\\d/_$]+[\\w.\\d_$]+(\\.(java|aar|jar|zip|txt|md|properties|groovy|json)|/)|/))$";

    private OnBotJavaSecurityManager() {
    }

    public static boolean isValidSourceFileLocation(String filename) {
        return OnBotJavaSecurityManager.isValidFileLocation(filename, VALID_SRC_FILE_REGEX);
    }

    public static boolean isValidSourceFileOrFolder(String filename) {
        return OnBotJavaSecurityManager.isValidSourceFileOrFolder(filename, false);
    }

    public static boolean isValidSourceFileOrFolder(String filename, boolean allowSourceRootDir) {
        return OnBotJavaSecurityManager.isValidFileLocation(filename, VALID_SRC_FILE_OR_FOLDER_REGEX) || allowSourceRootDir && filename.equals("/src/");
    }

    public static boolean isValidTemplateFile(String filename) {
        return OnBotJavaSecurityManager.isValidFileLocation(filename, VALID_TEMPLATE_FILE_REGEX);
    }

    private static boolean isValidFileLocation(String fileName, String regularExpression) {
        return fileName.matches(regularExpression) && !fileName.matches("\\.{2}");
    }
}

