/*
 * Decompiled with CFR 0.152.
 */
package org.firstinspires.ftc.onbotjava;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import org.firstinspires.ftc.onbotjava.ExternalLibraries;
import org.firstinspires.ftc.onbotjava.OnBotJavaDelegatingStandardFileManager;
import org.firstinspires.ftc.onbotjava.OnBotJavaManager;
import org.firstinspires.ftc.robotcore.internal.system.AppUtil;

public class OnBotJavaStandardFileManager
extends OnBotJavaDelegatingStandardFileManager {
    public static final String TAG = "OnBotJava:FileManager";

    public OnBotJavaStandardFileManager(StandardJavaFileManager delegate) {
        super(delegate);
        try {
            ArrayList<File> classPath = new ArrayList<File>();
            classPath.addAll(AppUtil.getInstance().filesIn(OnBotJavaManager.libDir, ".jar"));
            classPath.addAll(ExternalLibraries.getInstance().getClasspathFiles());
            ArrayList<File> platformClassPath = new ArrayList<File>();
            for (String libName : OnBotJavaManager.platformClassPathLibs) {
                platformClassPath.add(new File(OnBotJavaManager.libDir, libName));
            }
            delegate.setLocation(StandardLocation.CLASS_OUTPUT, Collections.singletonList(OnBotJavaManager.classesOutputDir));
            delegate.setLocation(StandardLocation.SOURCE_OUTPUT, Collections.singletonList(OnBotJavaManager.sourceOutputDir));
            delegate.setLocation(StandardLocation.CLASS_PATH, classPath);
            delegate.setLocation(StandardLocation.SOURCE_PATH, Collections.singletonList(OnBotJavaManager.srcDir));
            delegate.setLocation(StandardLocation.ANNOTATION_PROCESSOR_PATH, Collections.emptyList());
            delegate.setLocation(StandardLocation.PLATFORM_CLASS_PATH, platformClassPath);
        }
        catch (IOException e) {
            throw AppUtil.getInstance().unreachable("OnBotJava", (Throwable)e);
        }
    }

    public void setSourcePath(Iterable<? extends File> srcPath) {
        try {
            this.delegate.setLocation(StandardLocation.SOURCE_PATH, srcPath);
        }
        catch (IOException e) {
            throw AppUtil.getInstance().unreachable("OnBotJava", (Throwable)e);
        }
    }
}

