/*
 * Decompiled with CFR 0.152.
 */
package org.firstinspires.ftc.onbotjava;

import androidx.annotation.NonNull;
import fi.iki.elonen.NanoHTTPD;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public final class RequestConditions {
    public static final String REQUEST_KEY_FILE = "f";
    public static final String REQUEST_KEY_NEW = "new";
    public static final String REQUEST_KEY_SAVE = "data";
    public static final String REQUEST_KEY_TEMPLATE = "template";
    public static final String REQUEST_KEY_OPMODE_NAME = "opModeName";
    public static final String REQUEST_KEY_TEAM_NAME = "teamName";
    public static final String REQUEST_KEY_SETUP_HARDWARE = "rcSetupHardware";
    public static final String REQUEST_KEY_OPMODE_ANNOTATIONS = "opModeAnnotations";
    public static final String REQUEST_KEY_ID = "id";
    public static final String REQUEST_KEY_COPY_FROM = "origin";
    public static final String REQUEST_KEY_COPY_TO = "dest";
    public static final String REQUEST_KEY_DELETE = "delete";
    public static final String REQUEST_KEY_PRESERVE = "preserve";

    private RequestConditions() {
    }

    public static boolean containsParameters(@NonNull NanoHTTPD.IHTTPSession session, String ... parameters) {
        Map data = session.getParameters();
        for (String parameter : parameters) {
            if (data.containsKey(parameter)) continue;
            return false;
        }
        return true;
    }

    public static String dataForParameter(@NonNull NanoHTTPD.IHTTPSession session, @NonNull String parameter) {
        Map data = session.getParameters();
        if (!data.containsKey(parameter)) {
            RequestConditions.throwBecauseParameterMissing(parameter);
        }
        return (String)((List)data.get(parameter)).get(0);
    }

    private static void throwBecauseParameterMissing(@NonNull String parameterName) {
        if (parameterName == null) {
            throw new NullPointerException();
        }
        throw new RuntimeException(String.format(Locale.ENGLISH, "Missing parameter \"%s\" from payload", parameterName));
    }
}

