/*
 * Decompiled with CFR 0.152.
 */
package org.firstinspires.ftc.onbotjava;

import androidx.annotation.NonNull;
import fi.iki.elonen.NanoHTTPD;
import org.firstinspires.ftc.onbotjava.OnBotJavaWebInterfaceManager;

public final class StandardResponses {
    @NonNull
    public static NanoHTTPD.Response successfulRequest() {
        return StandardResponses.successfulJsonRequest("{\"success\":\"true\"}");
    }

    @NonNull
    public static NanoHTTPD.Response successfulRequest(Object serializableObject) {
        return StandardResponses.successfulJsonRequest(OnBotJavaWebInterfaceManager.instance().gson().toJson(serializableObject));
    }

    @NonNull
    public static NanoHTTPD.Response successfulRequest(String mimeType, String message) {
        return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, (String)mimeType, (String)message);
    }

    @NonNull
    public static NanoHTTPD.Response successfulRequest(String message) {
        return StandardResponses.successfulRequest("text/plain", message);
    }

    @NonNull
    public static NanoHTTPD.Response successfulJsonRequest(String message) {
        return StandardResponses.successfulRequest("application/json", message);
    }

    @NonNull
    public static NanoHTTPD.Response serverError() {
        return StandardResponses.serverError("Server Error");
    }

    @NonNull
    public static NanoHTTPD.Response serverError(@NonNull String message) {
        return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.INTERNAL_ERROR, (String)"text/plain", (String)message);
    }

    @NonNull
    public static NanoHTTPD.Response badRequest() {
        return StandardResponses.badRequest("{\"success\":\"false\"}");
    }

    @NonNull
    public static NanoHTTPD.Response badRequest(@NonNull String message) {
        return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.BAD_REQUEST, (String)"application/json", (String)message);
    }

    @NonNull
    public static NanoHTTPD.Response fileNotFound() {
        return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.NOT_FOUND, (String)"text/plain", (String)"File Not Found!");
    }

    @NonNull
    public static NanoHTTPD.Response unauthorizedAccess() {
        return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.UNAUTHORIZED, (String)"text/plain", (String)"Access is not allowed");
    }
}

