/*
 * Decompiled with CFR 0.152.
 */
package org.firstinspires.ftc.onbotjava.handlers.admin;

import android.annotation.SuppressLint;
import com.qualcomm.robotcore.util.RobotLog;
import fi.iki.elonen.NanoHTTPD;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.firstinspires.ftc.onbotjava.OnBotJavaFileSystemUtils;
import org.firstinspires.ftc.onbotjava.OnBotJavaManager;
import org.firstinspires.ftc.onbotjava.OnBotJavaWebInterfaceManager;
import org.firstinspires.ftc.onbotjava.RegisterWebHandler;
import org.firstinspires.ftc.onbotjava.StandardResponses;
import org.firstinspires.ftc.robotcore.internal.system.AppUtil;
import org.firstinspires.ftc.robotcore.internal.webserver.WebHandler;

@RegisterWebHandler(uri="/java/admin/factory_reset")
public class ResetOnBotJava
implements WebHandler {
    private static final String TAG = ResetOnBotJava.class.getName();
    private static final long INVALID_ID = -1L;
    private long handshakeId = -1L;

    public NanoHTTPD.Response getResponse(NanoHTTPD.IHTTPSession session) {
        Map parameters = session.getParameters();
        if (!parameters.containsKey("id")) {
            this.handshakeId = UUID.randomUUID().getMostSignificantBits();
            return StandardResponses.successfulRequest(Long.toString(this.handshakeId));
        }
        String possibleHandshakeIdString = (String)((List)parameters.get("id")).get(0);
        long possibleHandshakeId = -1L;
        try {
            possibleHandshakeId = Long.parseLong(possibleHandshakeIdString);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (this.handshakeId != -1L && this.handshakeId == possibleHandshakeId) {
            try {
                if (this.resetOnBotJava()) {
                    return StandardResponses.successfulRequest("done");
                }
                return StandardResponses.serverError("user intervention required");
            }
            catch (RuntimeException ex) {
                return StandardResponses.serverError("see logs");
            }
        }
        this.handshakeId = -1L;
        return StandardResponses.badRequest("invalid handshake");
    }

    @SuppressLint(value={"SetWorldReadable", "SetWorldWritable"})
    private boolean resetOnBotJava() {
        File javaRoot = OnBotJavaManager.javaRoot;
        javaRoot.setReadable(true, false);
        javaRoot.setWritable(true, false);
        javaRoot.setExecutable(true, false);
        for (File file : AppUtil.getInstance().filesIn(javaRoot)) {
            file.setWritable(true, false);
            file.setReadable(true, false);
            if (!file.isDirectory()) continue;
            file.setExecutable(true, false);
        }
        AppUtil.getInstance().delete(javaRoot);
        if (javaRoot.exists()) {
            if (javaRoot.isDirectory()) {
                for (File file : AppUtil.getInstance().filesIn(javaRoot)) {
                    RobotLog.e((String)TAG, (Object[])new Object[]{"[RESET] Delete failed for %s", file.getAbsolutePath()});
                }
            } else {
                RobotLog.e((String)TAG, (Object[])new Object[]{"[RESET] Delete of javaRoot (\"%s\") failed, not a directory??? User required to delete \"%s\"", javaRoot, javaRoot});
            }
            return false;
        }
        OnBotJavaManager.initialize();
        OnBotJavaFileSystemUtils.ensureTemplates();
        OnBotJavaWebInterfaceManager.instance().editorSettings().resetToDefaults();
        return true;
    }
}

