/*
 * Decompiled with CFR 0.152.
 */
package org.firstinspires.ftc.onbotjava.handlers.file;

import fi.iki.elonen.NanoHTTPD;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import org.firstinspires.ftc.onbotjava.JavaSourceFile;
import org.firstinspires.ftc.onbotjava.OnBotJavaManager;
import org.firstinspires.ftc.onbotjava.OnBotJavaSecurityManager;
import org.firstinspires.ftc.onbotjava.RegisterWebHandler;
import org.firstinspires.ftc.onbotjava.RequestConditions;
import org.firstinspires.ftc.onbotjava.StandardResponses;
import org.firstinspires.ftc.robotcore.internal.webserver.WebHandler;

@RegisterWebHandler(uri="/java/file/copy")
public class CopyFile
implements WebHandler {
    public NanoHTTPD.Response getResponse(NanoHTTPD.IHTTPSession session) {
        if (!RequestConditions.containsParameters(session, "dest", "origin")) {
            return StandardResponses.badRequest();
        }
        String fromFileName = RequestConditions.dataForParameter(session, "origin");
        String destFileName = RequestConditions.dataForParameter(session, "dest");
        if (!OnBotJavaSecurityManager.isValidSourceFileOrFolder(fromFileName) || !OnBotJavaSecurityManager.isValidSourceFileOrFolder(destFileName)) {
            return StandardResponses.badRequest();
        }
        File origin = new File(OnBotJavaManager.javaRoot, fromFileName);
        File dest = new File(OnBotJavaManager.javaRoot, destFileName);
        try {
            ArrayList opsList = new ArrayList();
            this.generateRecursiveCopyList(origin, dest, opsList);
            this.executeRecursiveCopy(opsList);
        }
        catch (IOException ex) {
            return StandardResponses.badRequest("cannot copy files");
        }
        return StandardResponses.successfulRequest();
    }

    private void generateRecursiveCopyList(File origin, File dest, List<? super RecursiveCopyOperation> filesToCopy) throws IOException {
        if (origin.isDirectory()) {
            String[] files;
            dest = this.checkForSameNameConflicts(dest);
            filesToCopy.add(new RecursiveCopyOperation(origin, dest));
            for (String file : files = origin.list()) {
                File src = new File(origin, file);
                File destFile = new File(dest, file);
                destFile = this.checkForSameNameConflicts(destFile);
                if (src.getAbsolutePath().equals(dest.getAbsolutePath())) continue;
                if (src.isDirectory()) {
                    filesToCopy.add(new RecursiveCopyOperation(src, destFile));
                }
                this.generateRecursiveCopyList(src, destFile, filesToCopy);
            }
        } else {
            filesToCopy.add(new RecursiveCopyOperation(origin, dest));
        }
    }

    private void executeRecursiveCopy(List<? extends RecursiveCopyOperation> ops) throws IOException {
        for (RecursiveCopyOperation recursiveCopyOperation : ops) {
            File src = recursiveCopyOperation.src;
            File dst = recursiveCopyOperation.dest;
            if (src.isDirectory()) {
                dst.mkdirs();
                continue;
            }
            this.copyFile(src, dst);
        }
    }

    private void copyFile(File source, File dest) throws IOException {
        dest = this.checkForSameNameConflicts(dest);
        if (source.getPath().endsWith(".java")) {
            JavaSourceFile.forFile(source).copyTo(dest);
        } else {
            try (FileChannel sourceChannel = new FileInputStream(source).getChannel();
                 FileChannel destChannel = new FileOutputStream(dest).getChannel();){
                destChannel.transferFrom(sourceChannel, 0L, sourceChannel.size());
            }
        }
    }

    private File checkForSameNameConflicts(File dest) {
        if (dest.exists()) {
            String suffix;
            String originalName = dest.getName();
            String ext = "";
            if (originalName.contains(".")) {
                ext = originalName.substring(originalName.lastIndexOf(46));
                originalName = originalName.substring(0, originalName.lastIndexOf(46));
            }
            if (originalName.endsWith(suffix = "_Copy")) {
                suffix = "";
            }
            dest = new File(dest.getParentFile(), originalName + suffix + ext);
            for (int i = 2; i < 1000 && dest.exists(); ++i) {
                dest = new File(dest.getParentFile(), originalName + suffix + i + ext);
            }
        }
        return dest;
    }

    private static class RecursiveCopyOperation {
        private File src;
        private File dest;

        private RecursiveCopyOperation(File src, File dest) {
            this.src = src;
            this.dest = dest;
        }
    }
}

