/*
 * Decompiled with CFR 0.152.
 */
package org.firstinspires.ftc.onbotjava.handlers.file;

import com.google.gson.JsonSyntaxException;
import fi.iki.elonen.NanoHTTPD;
import java.io.File;
import org.firstinspires.ftc.onbotjava.ExternalLibraries;
import org.firstinspires.ftc.onbotjava.OnBotJavaManager;
import org.firstinspires.ftc.onbotjava.OnBotJavaWebInterfaceManager;
import org.firstinspires.ftc.onbotjava.RegisterWebHandler;
import org.firstinspires.ftc.onbotjava.RequestConditions;
import org.firstinspires.ftc.onbotjava.StandardResponses;
import org.firstinspires.ftc.robotcore.internal.system.AppUtil;
import org.firstinspires.ftc.robotcore.internal.webserver.WebHandler;

@RegisterWebHandler(uri="/java/file/delete")
public class DeleteFile
implements WebHandler {
    private static final String EXTERNAL_LIBRARIES_PREFIX = "src/ExternalLibraries/";

    public NanoHTTPD.Response getResponse(NanoHTTPD.IHTTPSession session) {
        if (RequestConditions.containsParameters(session, "delete")) {
            String[] deleteFiles;
            try {
                deleteFiles = (String[])OnBotJavaWebInterfaceManager.instance().gson().fromJson(RequestConditions.dataForParameter(session, "delete"), String[].class);
            }
            catch (JsonSyntaxException ex) {
                return StandardResponses.badRequest("Invalid delete syntax - bad JSON");
            }
            for (String fileToDeletePath : deleteFiles) {
                if (fileToDeletePath.startsWith(EXTERNAL_LIBRARIES_PREFIX)) {
                    String relativePath = fileToDeletePath.substring(EXTERNAL_LIBRARIES_PREFIX.length());
                    File uploadedFile = new File(OnBotJavaManager.extLibDir, relativePath);
                    ExternalLibraries.getInstance().deleteExternalLibrary(uploadedFile);
                    continue;
                }
                File fileToDelete = new File(OnBotJavaManager.javaRoot, fileToDeletePath);
                if (!fileToDelete.exists()) continue;
                AppUtil.getInstance().delete(fileToDelete);
            }
            return StandardResponses.successfulRequest();
        }
        return StandardResponses.badRequest();
    }
}

