/*
 * Decompiled with CFR 0.152.
 */
package org.firstinspires.ftc.onbotjava.handlers.file;

import com.qualcomm.robotcore.util.ReadWriteFile;
import fi.iki.elonen.NanoHTTPD;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.UUID;
import org.firstinspires.ftc.onbotjava.OnBotJavaFileSystemUtils;
import org.firstinspires.ftc.onbotjava.OnBotJavaManager;
import org.firstinspires.ftc.onbotjava.RegisterWebHandler;
import org.firstinspires.ftc.robotcore.internal.webserver.WebHandler;

@RegisterWebHandler(uri="/java/file/all")
public class FetchSourceTree
implements WebHandler {
    public NanoHTTPD.Response getResponse(NanoHTTPD.IHTTPSession session) throws IOException, NanoHTTPD.ResponseException {
        String randomBoundary = UUID.randomUUID().toString();
        ArrayList<String> srcList = new ArrayList<String>();
        String srcPath = OnBotJavaManager.srcDir.getAbsolutePath();
        File srcDir = OnBotJavaManager.srcDir;
        ReadWriteFile.ensureAllChangesAreCommitted((File)srcDir);
        OnBotJavaFileSystemUtils.searchForFiles(srcPath, srcDir, srcList, true);
        ArrayList<InputStream> sourceFiles = new ArrayList<InputStream>();
        sourceFiles.add(new ByteArrayInputStream(MessageFormat.format("\nBOUNDARY {0}\n", randomBoundary).getBytes(StandardCharsets.UTF_8)));
        for (String sourceFile : srcList) {
            File file = new File(srcPath + sourceFile);
            if (!file.canRead() || file.isDirectory()) continue;
            FileInputStream fileInputStream = new FileInputStream(srcPath + sourceFile);
            InputStream inputStream = this.fileNamedChunkStream(randomBoundary, sourceFile, fileInputStream);
            sourceFiles.add(inputStream);
        }
        SequenceInputStream files = new SequenceInputStream(Collections.enumeration(sourceFiles));
        return NanoHTTPD.newChunkedResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, (String)"text/plain", (InputStream)files);
    }

    public InputStream fileNamedChunkStream(String boundary, String fileName, FileInputStream fileInputStream) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(MessageFormat.format("\nBOUNDARY {0} {1}\n", boundary, fileName).getBytes(StandardCharsets.UTF_8));
        return new SequenceInputStream(inputStream, fileInputStream);
    }
}

