/*
 * Decompiled with CFR 0.152.
 */
package org.firstinspires.ftc.onbotjava.handlers.file;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.blocks.ftcrobotcontroller.hardware.HardwareItem;
import com.google.blocks.ftcrobotcontroller.hardware.HardwareItemMap;
import com.qualcomm.robotcore.hardware.DcMotorController;
import com.qualcomm.robotcore.hardware.HardwareDevice;
import com.qualcomm.robotcore.hardware.ServoController;
import com.qualcomm.robotcore.hardware.VoltageSensor;
import com.qualcomm.robotcore.util.ReadWriteFile;
import com.qualcomm.robotcore.util.RobotLog;
import fi.iki.elonen.NanoHTTPD;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.firstinspires.ftc.onbotjava.JavaSourceFile;
import org.firstinspires.ftc.onbotjava.OnBotJavaManager;
import org.firstinspires.ftc.onbotjava.OnBotJavaSecurityManager;
import org.firstinspires.ftc.onbotjava.OnBotJavaWebInterfaceManager;
import org.firstinspires.ftc.onbotjava.RegisterWebHandler;
import org.firstinspires.ftc.onbotjava.RequestConditions;
import org.firstinspires.ftc.onbotjava.StandardResponses;
import org.firstinspires.ftc.robotcore.internal.webserver.WebHandler;

@RegisterWebHandler(uri="/java/file/new")
public class NewFile
implements WebHandler {
    private static final String TAG = NewFile.class.getName();
    private static final List<Class<? extends HardwareDevice>> HARDWARE_TYPES_PREVENTED_FROM_HARDWARE_SETUP = Arrays.asList(DcMotorController.class, ServoController.class, VoltageSensor.class);

    public NanoHTTPD.Response getResponse(NanoHTTPD.IHTTPSession session) {
        Map data = session.getParameters();
        if (!RequestConditions.containsParameters(session, "new", "f")) {
            return StandardResponses.badRequest();
        }
        String fileNameUri = RequestConditions.dataForParameter(session, "f");
        File file = new File(OnBotJavaManager.javaRoot, fileNameUri);
        if (fileNameUri.endsWith("/")) {
            file.mkdirs();
            return StandardResponses.successfulRequest();
        }
        Map<String, String> templateKeyMap = this.buildTemplateKeyMap(fileNameUri, data, file);
        if (!OnBotJavaSecurityManager.isValidSourceFileLocation(fileNameUri)) {
            return StandardResponses.badRequest();
        }
        if (RequestConditions.containsParameters(session, "template")) {
            File templateFile;
            String template = RequestConditions.dataForParameter(session, "template");
            if (OnBotJavaSecurityManager.isValidTemplateFile(template) && (templateFile = new File(OnBotJavaManager.javaRoot, template)).exists() && !templateFile.isDirectory()) {
                String templateData = ReadWriteFile.readFile((File)templateFile);
                this.newFileFromTemplate(file, templateKeyMap, templateData, templateFile, RequestConditions.containsParameters(session, "preserve"));
                return StandardResponses.successfulRequest();
            }
            return StandardResponses.badRequest();
        }
        String newFileData = this.defaultTemplateForFile(fileNameUri);
        this.newFileFromTemplate(file, templateKeyMap, newFileData, null, false);
        return StandardResponses.successfulRequest();
    }

    private Map<String, String> buildTemplateKeyMap(String uri, Map<String, List<String>> data, File file) {
        String name = file.getName();
        String packageName = this.packageNameFromUri(uri, name);
        name = name.lastIndexOf(46) == -1 ? name : name.substring(0, name.lastIndexOf(46));
        String opModeName = data.containsKey("opModeName") ? data.get("opModeName").get(0) : name;
        String opModeAnnotations = data.containsKey("opModeAnnotations") ? data.get("opModeAnnotations").get(0) : "";
        opModeAnnotations = opModeAnnotations.replaceAll("\\{\\{ \\+opModeName \\}\\}", opModeName);
        HashMap<String, String> results = new HashMap<String, String>();
        results.put("packageName", packageName);
        results.put("opModeAnnotations", opModeAnnotations);
        results.put("name", name);
        results.put("opModeName", opModeName);
        results.put("year", new SimpleDateFormat("yyyy", Locale.US).format(new Date()));
        if (data.containsKey("teamName")) {
            results.put("teamName", data.get("teamName").get(0));
        }
        if (data.containsKey("rcSetupHardware") && data.get("rcSetupHardware").get(0).equals("1")) {
            HardwareItemMap hardwareItemMap = HardwareItemMap.newHardwareItemMap();
            StringBuilder rcHardwareFieldsBuilder = new StringBuilder();
            StringBuilder rcHardwareSetupBuilder = new StringBuilder();
            HashSet<String> knownDeviceNames = new HashSet<String>();
            for (HardwareItem device : hardwareItemMap.getAllHardwareItems()) {
                String deviceName = device.deviceName;
                char[] sanitizedDeviceNameChars = deviceName.toCharArray();
                if (sanitizedDeviceNameChars.length > 0) {
                    int sanitizedDeviceNameChar = Character.toLowerCase(sanitizedDeviceNameChars[0]);
                    sanitizedDeviceNameChars[0] = Character.isJavaIdentifierStart((char)sanitizedDeviceNameChar) ? sanitizedDeviceNameChar : 95;
                }
                for (int i = 1; i < sanitizedDeviceNameChars.length; ++i) {
                    int sanitizedDeviceNameChar = sanitizedDeviceNameChars[i];
                    sanitizedDeviceNameChars[i] = Character.isJavaIdentifierPart((char)sanitizedDeviceNameChar) ? sanitizedDeviceNameChar : 95;
                }
                String sanitizedDeviceName = new String(sanitizedDeviceNameChars);
                if (knownDeviceNames.contains(sanitizedDeviceName)) continue;
                knownDeviceNames.add(sanitizedDeviceName);
                Class typeClass = this.getHardwareTypeName(device.hardwareType.deviceType);
                if (typeClass == null) {
                    typeClass = device.hardwareType.deviceType;
                }
                if (HARDWARE_TYPES_PREVENTED_FROM_HARDWARE_SETUP.indexOf(typeClass) >= 0) continue;
                String typeName = typeClass.getSimpleName();
                if (OnBotJavaWebInterfaceManager.instance().editorSettings().whitespaceSetting.get().equals("tab")) {
                    rcHardwareFieldsBuilder.append('\t');
                    rcHardwareSetupBuilder.append("\t\t");
                } else {
                    for (int i = 0; i < OnBotJavaWebInterfaceManager.instance().editorSettings().spacesToTabSetting.get(); ++i) {
                        rcHardwareFieldsBuilder.append(' ');
                        rcHardwareSetupBuilder.append("  ");
                    }
                }
                rcHardwareFieldsBuilder.append(String.format(Locale.ENGLISH, "private %s %s;\n", typeName, sanitizedDeviceName));
                rcHardwareSetupBuilder.append(String.format(Locale.ENGLISH, "%s = hardwareMap.get(%s.class, \"%s\");\n", sanitizedDeviceName, typeName, deviceName));
            }
            results.put("rcHardwareFields", rcHardwareFieldsBuilder.toString());
            results.put("rcHardwareSetup", rcHardwareSetupBuilder.toString());
        }
        return results;
    }

    private Class getHardwareTypeName(Class typeClass) {
        if (typeClass.equals(Object.class)) {
            return null;
        }
        String packageName = "com.qualcomm.robotcore.hardware";
        if (typeClass.getPackage().getName().equals("com.qualcomm.robotcore.hardware")) {
            return typeClass;
        }
        for (Class<?> klazz : typeClass.getInterfaces()) {
            if (!klazz.getPackage().getName().equals("com.qualcomm.robotcore.hardware")) continue;
            return klazz;
        }
        if (typeClass.getSuperclass().getPackage().getName().equals("com.qualcomm.robotcore.hardware")) {
            return typeClass.getSuperclass();
        }
        return this.getHardwareTypeName(typeClass.getSuperclass());
    }

    @NonNull
    private String packageNameFromUri(String uri, String name) {
        String packageName = uri;
        if (packageName.indexOf("/jars") == 0) {
            packageName = packageName.substring("/jars".length());
        } else if (packageName.indexOf("/src") == 0) {
            packageName = packageName.substring("/src".length());
        }
        packageName = packageName.substring(0, packageName.lastIndexOf(name));
        if (!packageName.isEmpty()) {
            if (packageName.equals("/")) {
                return "";
            }
            packageName = packageName.indexOf("/") == 0 ? packageName.substring(1) : packageName;
            int packageNameLength = packageName.length();
            packageName = packageName.lastIndexOf("/") == packageNameLength - 1 ? packageName.substring(0, packageNameLength - 1) : packageName;
            packageName = packageName.replace("/", ".");
        }
        return packageName;
    }

    private void newFileFromTemplate(File file, Map<String, String> templateKeyMap, String templateData, @Nullable File templateSource, boolean preserveAnnotations) {
        templateData = this.parseTemplate(templateData, templateKeyMap, preserveAnnotations);
        if (templateSource != null) {
            JavaSourceFile javaTemplateSourceFile = JavaSourceFile.forFile(templateSource);
            String oldClassName = javaTemplateSourceFile.className();
            String oldPackageName = JavaSourceFile.extractPackageNameFromContents(templateData);
            javaTemplateSourceFile.writeJavaFileFromContents(oldClassName, oldPackageName, templateData, file);
        } else {
            ReadWriteFile.writeFile((File)file, (String)templateData);
        }
    }

    @NonNull
    private String defaultTemplateForFile(String uri) {
        String newFileData = uri.endsWith(".java") ? "package {{ +packageName }};\n\n{{ +opModeAnnotations }}\npublic class {{ +name }} {\n{{ +rcHardwareFields }}\n\t// todo: write your code here\n}" : "";
        return newFileData;
    }

    private String parseTemplate(String templateData, Map<String, String> valueMap, boolean preserveAnnotations) {
        for (Map.Entry<String, String> entry : valueMap.entrySet()) {
            RobotLog.dd((String)TAG, (String)"Processing template tag '%s'", (Object[])new Object[]{entry.getKey()});
            templateData = templateData.replaceAll("\\{\\{ \\+" + entry.getKey() + " \\}\\}", Matcher.quoteReplacement(entry.getValue()));
        }
        if (!preserveAnnotations && valueMap.containsKey("opModeAnnotations")) {
            Pattern pattern;
            Matcher matcher;
            String opModeAnnotations = valueMap.get("opModeAnnotations");
            if (!opModeAnnotations.contains("@Disabled") && (matcher = (pattern = Pattern.compile("^\\s*@Disabled.*$", 8)).matcher(templateData)).find()) {
                templateData = matcher.replaceAll("");
            }
            if (!opModeAnnotations.contains("@Autonomous")) {
                pattern = Pattern.compile("^\\s*@Autonomous(|\\([^)]+\\))(.*)$", 8);
                templateData = opModeAnnotations.contains("@TeleOp") ? pattern.matcher(templateData).replaceAll("@TeleOp$1$2") : pattern.matcher(templateData).replaceAll("");
            }
            if (!opModeAnnotations.contains("@TeleOp")) {
                pattern = Pattern.compile("^\\s*@TeleOp(|\\([^)]+\\))(.*)$", 8);
                templateData = opModeAnnotations.contains("@Autonomous") ? pattern.matcher(templateData).replaceAll("@Autonomous$1$2") : pattern.matcher(templateData).replaceAll("");
            }
        }
        templateData = templateData.replaceAll("\\{\\{ \\+\\w+ \\}\\}", "");
        return templateData;
    }
}

