/*
 * Decompiled with CFR 0.152.
 */
package org.firstinspires.ftc.onbotjava.handlers.javascript;

import com.qualcomm.robotcore.util.RobotLog;
import fi.iki.elonen.NanoHTTPD;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.firstinspires.ftc.onbotjava.OnBotJavaManager;
import org.firstinspires.ftc.onbotjava.OnBotJavaWebInterfaceManager;
import org.firstinspires.ftc.onbotjava.RegisterWebHandler;
import org.firstinspires.ftc.onbotjava.StandardResponses;
import org.firstinspires.ftc.robotcore.internal.system.AppUtil;
import org.firstinspires.ftc.robotcore.internal.webserver.WebHandler;

@RegisterWebHandler(uri="/java/js/editor/autocomplete")
public class FetchAutocompleteJavaScript
implements WebHandler {
    private static volatile String response = null;
    private static final Object lock = new Object();

    public FetchAutocompleteJavaScript() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    FetchAutocompleteJavaScript.buildResponse();
                }
                catch (Exception e) {
                    RobotLog.ee((String)FetchAutocompleteJavaScript.class.getName(), (Throwable)e, (String)"Error with autocomplete response");
                    response = "";
                }
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NanoHTTPD.Response getResponse(NanoHTTPD.IHTTPSession session) {
        Object object = lock;
        synchronized (object) {
            while (response == null) {
                try {
                    lock.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return StandardResponses.serverError();
                }
            }
        }
        if (response.equals("")) {
            return StandardResponses.serverError();
        }
        return StandardResponses.successfulJsonRequest(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void buildResponse() throws IOException {
        ClassLoader parentClassLoader = OnBotJavaManager.getParentClassLoaderForOnBotJava();
        List jarFiles = AppUtil.getInstance().filesIn(OnBotJavaManager.libDir, ".jar");
        jarFiles.addAll(AppUtil.getInstance().filesUnder(OnBotJavaManager.extLibDir, ".jar"));
        HashMap<String, List<AutoClass>> autoClassList = new HashMap<String, List<AutoClass>>();
        for (File jarFile : jarFiles) {
            JarEntry entry;
            boolean isExternalLibrary = jarFile.getParentFile().equals(OnBotJavaManager.extLibDir);
            JarInputStream jarInputStream = new JarInputStream(new FileInputStream(jarFile));
            while ((entry = jarInputStream.getNextJarEntry()) != null) {
                Class<?> currentClass;
                String className;
                String myClass;
                String entryName = entry.getName();
                if (!entryName.endsWith(".class") || !isExternalLibrary && !FetchAutocompleteJavaScript.packagesToAutoComplete(entryName) || (myClass = (className = entryName.replaceAll("/", "\\.")).substring(0, className.lastIndexOf(46))).contains("$")) continue;
                try {
                    currentClass = Class.forName(myClass, false, parentClassLoader);
                }
                catch (ClassNotFoundException ignored) {
                    continue;
                }
                FetchAutocompleteJavaScript.parseClassForAutocomplete(autoClassList, currentClass);
            }
        }
        response = OnBotJavaWebInterfaceManager.instance().gson().toJson(autoClassList);
        Object object = lock;
        synchronized (object) {
            lock.notifyAll();
        }
    }

    private static void parseClassForAutocomplete(HashMap<String, List<AutoClass>> autoClassList, Class currentClass) {
        String superclassName;
        SecurityModifier classModifier = SecurityModifier.fromModifierInt(currentClass.getModifiers());
        if (classModifier != SecurityModifier.PUBLIC && classModifier != SecurityModifier.PROTECTED && classModifier != SecurityModifier.PACKAGE_PRIVATE) {
            return;
        }
        String currentClassName = FetchAutocompleteJavaScript.classNameFor(currentClass);
        String packageName = currentClass.getPackage().getName();
        if (autoClassList.containsKey(currentClassName)) {
            for (AutoClass autoClass : autoClassList.get(currentClassName)) {
                if (!autoClass.packageName.equals(packageName)) continue;
                return;
            }
        }
        HashMap<String, AutoField> fields = new HashMap<String, AutoField>();
        for (Field field : currentClass.getDeclaredFields()) {
            SecurityModifier fieldSecurityModifier = SecurityModifier.fromModifierInt(field.getModifiers());
            if (fieldSecurityModifier == SecurityModifier.PRIVATE) continue;
            String name1 = field.getName();
            String fieldType = field.getType().getName();
            if (field.isSynthetic()) continue;
            fields.put(name1, new AutoField(fieldSecurityModifier, fieldType, Modifier.isStatic(field.getModifiers())));
        }
        HashMap hashMap = new HashMap();
        for (Method method : currentClass.getDeclaredMethods()) {
            SecurityModifier fieldSecurityModifier = SecurityModifier.fromModifierInt(method.getModifiers());
            if (fieldSecurityModifier == SecurityModifier.PRIVATE) continue;
            String methodName = method.getName();
            String fieldType = method.getReturnType().getName();
            Class<?>[] parameterTypes = method.getParameterTypes();
            ArrayList<String> paramTypes = new ArrayList<String>(parameterTypes.length);
            for (Class<?> paramType : parameterTypes) {
                paramTypes.add(paramType.getName());
            }
            if (method.isSynthetic()) continue;
            if (!hashMap.containsKey(methodName)) {
                hashMap.put(methodName, new ArrayList());
            }
            ((ArrayList)hashMap.get(methodName)).add(new AutoMethod(fieldSecurityModifier, fieldType, paramTypes, Modifier.isStatic(method.getModifiers())));
        }
        Class superclass = currentClass.getSuperclass();
        if (superclass != null) {
            superclassName = superclass.getName();
            FetchAutocompleteJavaScript.parseClassForAutocomplete(autoClassList, superclass);
        } else {
            superclassName = Object.class.getName();
        }
        List<String> interfaces = FetchAutocompleteJavaScript.getInterfacesFor(currentClass, autoClassList, new ArrayList<String>());
        AutoClass autoClass = new AutoClass(classModifier, hashMap, fields, currentClassName, packageName, interfaces, superclassName);
        if (!autoClassList.containsKey(currentClassName)) {
            autoClassList.put(currentClassName, new ArrayList());
        }
        autoClassList.get(currentClassName).add(autoClass);
        for (Class<?> innerClass : currentClass.getDeclaredClasses()) {
            FetchAutocompleteJavaScript.parseClassForAutocomplete(autoClassList, innerClass);
        }
    }

    private static List<String> getInterfacesFor(Class<?> currentClass, HashMap<String, List<AutoClass>> autoClassMap, List<String> list) {
        if (currentClass == null || currentClass.equals(Object.class)) {
            return list;
        }
        for (Class<?> klazz : currentClass.getInterfaces()) {
            list.add(klazz.getName());
            FetchAutocompleteJavaScript.parseClassForAutocomplete(autoClassMap, klazz);
        }
        return FetchAutocompleteJavaScript.getInterfacesFor(currentClass.getSuperclass(), autoClassMap, list);
    }

    private static boolean packagesToAutoComplete(String entryName) {
        for (String testPackage : OnBotJavaWebInterfaceManager.packagesToAutocomplete()) {
            if (!entryName.startsWith(testPackage)) continue;
            return true;
        }
        return false;
    }

    private static String classNameFor(Class<?> klazz) {
        String fullClassName = klazz.getName();
        if (fullClassName.indexOf(46) >= 0) {
            return fullClassName.substring(fullClassName.lastIndexOf(46) + 1);
        }
        return fullClassName;
    }

    private static enum SecurityModifier {
        PUBLIC,
        PRIVATE,
        PROTECTED,
        PACKAGE_PRIVATE,
        UNKNOWN;


        static SecurityModifier fromModifierInt(int modifier) {
            if (Modifier.isPublic(modifier)) {
                return PUBLIC;
            }
            if (Modifier.isPrivate(modifier)) {
                return PRIVATE;
            }
            if (Modifier.isProtected(modifier)) {
                return PROTECTED;
            }
            return PACKAGE_PRIVATE;
        }
    }

    private static class AutoMethod {
        private SecurityModifier modifier;
        private String type;
        private List<String> params;
        private boolean isStatic;

        private AutoMethod(SecurityModifier modifier, String type, List<String> params, boolean isStatic) {
            this.modifier = modifier;
            this.type = type;
            this.params = params;
            this.isStatic = isStatic;
        }
    }

    private static class AutoField {
        private SecurityModifier modifier;
        private String type;
        private boolean isStatic;

        private AutoField(SecurityModifier modifier, String type, boolean isStatic) {
            this.modifier = modifier;
            this.type = type;
            this.isStatic = isStatic;
        }
    }

    private static class AutoClass {
        private SecurityModifier modifier;
        private HashMap<String, ArrayList<AutoMethod>> methods;
        private HashMap<String, AutoField> fields;
        private String packageName;
        private List<String> interfaces;
        private String parentClass;

        private AutoClass(SecurityModifier modifier, HashMap<String, ArrayList<AutoMethod>> methods, HashMap<String, AutoField> fields, String name, String packageName, List<String> interfaces, String parentClass) {
            this.modifier = modifier;
            this.methods = methods;
            this.fields = fields;
            this.packageName = packageName;
            this.interfaces = interfaces;
            this.parentClass = parentClass;
        }
    }
}

