/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.parser;

import com.sun.source.tree.MemberReferenceTree;
import com.sun.tools.javac.code.BoundKind;
import com.sun.tools.javac.code.Flags;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.parser.LazyDocCommentTable;
import com.sun.tools.javac.parser.Lexer;
import com.sun.tools.javac.parser.Parser;
import com.sun.tools.javac.parser.ParserFactory;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.tree.DocCommentTable;
import com.sun.tools.javac.tree.EndPosTable;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Convert;
import com.sun.tools.javac.util.Filter;
import com.sun.tools.javac.util.IntHashTable;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import java.util.ArrayList;
import java.util.Collection;

public class JavacParser
implements Parser {
    private static final int infixPrecedenceLevels = 10;
    protected Lexer S;
    protected TreeMaker F;
    private Log log;
    private Source source;
    private Names names;
    private final AbstractEndPosTable endPosTable;
    private List<JCTree.JCAnnotation> typeAnnotationsPushedBack = List.nil();
    private boolean permitTypeAnnotationsPushBack = false;
    boolean allowGenerics;
    boolean allowDiamond;
    boolean allowMulticatch;
    boolean allowVarargs;
    boolean allowAsserts;
    boolean allowEnums;
    boolean allowForeach;
    boolean allowStaticImport;
    boolean allowAnnotations;
    boolean allowTWR;
    boolean allowStringFolding;
    boolean allowLambda;
    boolean allowMethodReferences;
    boolean allowDefaultMethods;
    boolean allowStaticInterfaceMethods;
    boolean allowIntersectionTypesInCast;
    boolean keepDocComments;
    boolean keepLineMap;
    boolean allowTypeAnnotations;
    boolean allowAnnotationsAfterTypeParams;
    boolean allowThisIdent;
    JCTree.JCVariableDecl receiverParam;
    static final int EXPR = 1;
    static final int TYPE = 2;
    static final int NOPARAMS = 4;
    static final int TYPEARG = 8;
    static final int DIAMOND = 16;
    private int mode = 0;
    private int lastmode = 0;
    protected Tokens.Token token;
    private JCTree.JCErroneous errorTree;
    private int errorPos = -1;
    private final DocCommentTable docComments;
    ArrayList<JCTree.JCExpression[]> odStackSupply = new ArrayList();
    ArrayList<Tokens.Token[]> opStackSupply = new ArrayList();
    Filter<Tokens.TokenKind> LAX_IDENTIFIER = new Filter<Tokens.TokenKind>(){

        @Override
        public boolean accepts(Tokens.TokenKind t) {
            return t == Tokens.TokenKind.IDENTIFIER || t == Tokens.TokenKind.UNDERSCORE || t == Tokens.TokenKind.ASSERT || t == Tokens.TokenKind.ENUM;
        }
    };

    protected JavacParser(ParserFactory fac, Lexer S, boolean keepDocComments, boolean keepLineMap, boolean keepEndPositions) {
        this.S = S;
        this.nextToken();
        this.F = fac.F;
        this.log = fac.log;
        this.names = fac.names;
        this.source = fac.source;
        this.allowGenerics = this.source.allowGenerics();
        this.allowVarargs = this.source.allowVarargs();
        this.allowAsserts = this.source.allowAsserts();
        this.allowEnums = this.source.allowEnums();
        this.allowForeach = this.source.allowForeach();
        this.allowStaticImport = this.source.allowStaticImport();
        this.allowAnnotations = this.source.allowAnnotations();
        this.allowTWR = this.source.allowTryWithResources();
        this.allowDiamond = this.source.allowDiamond();
        this.allowMulticatch = this.source.allowMulticatch();
        this.allowStringFolding = fac.options.getBoolean("allowStringFolding", true);
        this.allowLambda = this.source.allowLambda();
        this.allowMethodReferences = this.source.allowMethodReferences();
        this.allowDefaultMethods = this.source.allowDefaultMethods();
        this.allowStaticInterfaceMethods = this.source.allowStaticInterfaceMethods();
        this.allowIntersectionTypesInCast = this.source.allowIntersectionTypesInCast();
        this.allowTypeAnnotations = this.source.allowTypeAnnotations();
        this.allowAnnotationsAfterTypeParams = this.source.allowAnnotationsAfterTypeParams();
        this.keepDocComments = keepDocComments;
        this.docComments = this.newDocCommentTable(keepDocComments, fac);
        this.keepLineMap = keepLineMap;
        this.errorTree = this.F.Erroneous();
        this.endPosTable = this.newEndPosTable(keepEndPositions);
    }

    protected AbstractEndPosTable newEndPosTable(boolean keepEndPositions) {
        return keepEndPositions ? new SimpleEndPosTable(this) : new EmptyEndPosTable(this);
    }

    protected DocCommentTable newDocCommentTable(boolean keepDocComments, ParserFactory fac) {
        return keepDocComments ? new LazyDocCommentTable(fac) : null;
    }

    public Tokens.Token token() {
        return this.token;
    }

    public void nextToken() {
        this.S.nextToken();
        this.token = this.S.token();
    }

    protected boolean peekToken(Filter<Tokens.TokenKind> tk) {
        return this.peekToken(0, tk);
    }

    protected boolean peekToken(int lookahead, Filter<Tokens.TokenKind> tk) {
        return tk.accepts(this.S.token((int)(lookahead + 1)).kind);
    }

    protected boolean peekToken(Filter<Tokens.TokenKind> tk1, Filter<Tokens.TokenKind> tk2) {
        return this.peekToken(0, tk1, tk2);
    }

    protected boolean peekToken(int lookahead, Filter<Tokens.TokenKind> tk1, Filter<Tokens.TokenKind> tk2) {
        return tk1.accepts(this.S.token((int)(lookahead + 1)).kind) && tk2.accepts(this.S.token((int)(lookahead + 2)).kind);
    }

    protected boolean peekToken(Filter<Tokens.TokenKind> tk1, Filter<Tokens.TokenKind> tk2, Filter<Tokens.TokenKind> tk3) {
        return this.peekToken(0, tk1, tk2, tk3);
    }

    protected boolean peekToken(int lookahead, Filter<Tokens.TokenKind> tk1, Filter<Tokens.TokenKind> tk2, Filter<Tokens.TokenKind> tk3) {
        return tk1.accepts(this.S.token((int)(lookahead + 1)).kind) && tk2.accepts(this.S.token((int)(lookahead + 2)).kind) && tk3.accepts(this.S.token((int)(lookahead + 3)).kind);
    }

    protected boolean peekToken(Filter<Tokens.TokenKind> ... kinds) {
        return this.peekToken(0, kinds);
    }

    protected boolean peekToken(int lookahead, Filter<Tokens.TokenKind> ... kinds) {
        while (lookahead < kinds.length) {
            if (!kinds[lookahead].accepts(this.S.token((int)(lookahead + 1)).kind)) {
                return false;
            }
            ++lookahead;
        }
        return true;
    }

    private void skip(boolean stopAtImport, boolean stopAtMemberDecl, boolean stopAtIdentifier, boolean stopAtStatement) {
        while (true) {
            switch (this.token.kind) {
                case SEMI: {
                    this.nextToken();
                    return;
                }
                case PUBLIC: 
                case FINAL: 
                case ABSTRACT: 
                case MONKEYS_AT: 
                case EOF: 
                case CLASS: 
                case INTERFACE: 
                case ENUM: {
                    return;
                }
                case IMPORT: {
                    if (!stopAtImport) break;
                    return;
                }
                case LBRACE: 
                case RBRACE: 
                case PRIVATE: 
                case PROTECTED: 
                case STATIC: 
                case TRANSIENT: 
                case NATIVE: 
                case VOLATILE: 
                case SYNCHRONIZED: 
                case STRICTFP: 
                case LT: 
                case BYTE: 
                case SHORT: 
                case CHAR: 
                case INT: 
                case LONG: 
                case FLOAT: 
                case DOUBLE: 
                case BOOLEAN: 
                case VOID: {
                    if (!stopAtMemberDecl) break;
                    return;
                }
                case UNDERSCORE: 
                case IDENTIFIER: {
                    if (!stopAtIdentifier) break;
                    return;
                }
                case CASE: 
                case DEFAULT: 
                case IF: 
                case FOR: 
                case WHILE: 
                case DO: 
                case TRY: 
                case SWITCH: 
                case RETURN: 
                case THROW: 
                case BREAK: 
                case CONTINUE: 
                case ELSE: 
                case FINALLY: 
                case CATCH: {
                    if (!stopAtStatement) break;
                    return;
                }
            }
            this.nextToken();
        }
    }

    private JCTree.JCErroneous syntaxError(int pos, String key, Tokens.TokenKind ... args) {
        return this.syntaxError(pos, List.nil(), key, args);
    }

    private JCTree.JCErroneous syntaxError(int pos, List<JCTree> errs, String key, Tokens.TokenKind ... args) {
        JCTree last;
        this.setErrorEndPos(pos);
        JCTree.JCErroneous err = this.F.at(pos).Erroneous(errs);
        this.reportSyntaxError(err, key, (Object[])args);
        if (errs != null && (last = errs.last()) != null) {
            this.storeEnd(last, pos);
        }
        return this.toP(err);
    }

    private void reportSyntaxError(int pos, String key, Object ... args) {
        JCDiagnostic.SimpleDiagnosticPosition diag = new JCDiagnostic.SimpleDiagnosticPosition(pos);
        this.reportSyntaxError(diag, key, args);
    }

    private void reportSyntaxError(JCDiagnostic.DiagnosticPosition diagPos, String key, Object ... args) {
        int pos = diagPos.getPreferredPosition();
        if (pos > this.S.errPos() || pos == -1) {
            if (this.token.kind == Tokens.TokenKind.EOF) {
                this.error(diagPos, "premature.eof", new Object[0]);
            } else {
                this.error(diagPos, key, args);
            }
        }
        this.S.errPos(pos);
        if (this.token.pos == this.errorPos) {
            this.nextToken();
        }
        this.errorPos = this.token.pos;
    }

    private JCTree.JCErroneous syntaxError(String key) {
        return this.syntaxError(this.token.pos, key, new Tokens.TokenKind[0]);
    }

    private JCTree.JCErroneous syntaxError(String key, Tokens.TokenKind arg) {
        return this.syntaxError(this.token.pos, key, arg);
    }

    public void accept(Tokens.TokenKind tk) {
        if (this.token.kind == tk) {
            this.nextToken();
        } else {
            this.setErrorEndPos(this.token.pos);
            this.reportSyntaxError(this.S.prevToken().endPos, "expected", tk);
        }
    }

    JCTree.JCExpression illegal(int pos) {
        this.setErrorEndPos(pos);
        if ((this.mode & 1) != 0) {
            return this.syntaxError(pos, "illegal.start.of.expr", new Tokens.TokenKind[0]);
        }
        return this.syntaxError(pos, "illegal.start.of.type", new Tokens.TokenKind[0]);
    }

    JCTree.JCExpression illegal() {
        return this.illegal(this.token.pos);
    }

    void checkNoMods(long mods) {
        if (mods != 0L) {
            long lowestMod = mods & -mods;
            this.error(this.token.pos, "mod.not.allowed.here", Flags.asFlagSet(lowestMod));
        }
    }

    void attach(JCTree tree, Tokens.Comment dc) {
        if (this.keepDocComments && dc != null) {
            this.docComments.putComment(tree, dc);
        }
    }

    private void setErrorEndPos(int errPos) {
        this.endPosTable.setErrorEndPos(errPos);
    }

    private void storeEnd(JCTree tree, int endpos) {
        this.endPosTable.storeEnd(tree, endpos);
    }

    private <T extends JCTree> T to(T t) {
        return this.endPosTable.to(t);
    }

    private <T extends JCTree> T toP(T t) {
        return this.endPosTable.toP(t);
    }

    public int getStartPos(JCTree tree) {
        return TreeInfo.getStartPos(tree);
    }

    public int getEndPos(JCTree tree) {
        return this.endPosTable.getEndPos(tree);
    }

    public Name ident() {
        if (this.token.kind == Tokens.TokenKind.IDENTIFIER) {
            Name name = this.token.name();
            this.nextToken();
            return name;
        }
        if (this.token.kind == Tokens.TokenKind.ASSERT) {
            if (this.allowAsserts) {
                this.error(this.token.pos, "assert.as.identifier", new Object[0]);
                this.nextToken();
                return this.names.error;
            }
            this.warning(this.token.pos, "assert.as.identifier", new Object[0]);
            Name name = this.token.name();
            this.nextToken();
            return name;
        }
        if (this.token.kind == Tokens.TokenKind.ENUM) {
            if (this.allowEnums) {
                this.error(this.token.pos, "enum.as.identifier", new Object[0]);
                this.nextToken();
                return this.names.error;
            }
            this.warning(this.token.pos, "enum.as.identifier", new Object[0]);
            Name name = this.token.name();
            this.nextToken();
            return name;
        }
        if (this.token.kind == Tokens.TokenKind.THIS) {
            if (this.allowThisIdent) {
                this.checkTypeAnnotations();
                Name name = this.token.name();
                this.nextToken();
                return name;
            }
            this.error(this.token.pos, "this.as.identifier", new Object[0]);
            this.nextToken();
            return this.names.error;
        }
        if (this.token.kind == Tokens.TokenKind.UNDERSCORE) {
            this.warning(this.token.pos, "underscore.as.identifier", new Object[0]);
            Name name = this.token.name();
            this.nextToken();
            return name;
        }
        this.accept(Tokens.TokenKind.IDENTIFIER);
        return this.names.error;
    }

    public JCTree.JCExpression qualident(boolean allowAnnos) {
        JCTree.JCExpression t = this.toP(this.F.at(this.token.pos).Ident(this.ident()));
        while (this.token.kind == Tokens.TokenKind.DOT) {
            int pos = this.token.pos;
            this.nextToken();
            List<JCTree.JCAnnotation> tyannos = null;
            if (allowAnnos) {
                tyannos = this.typeAnnotationsOpt();
            }
            t = this.toP(this.F.at(pos).Select(t, this.ident()));
            if (tyannos == null || !tyannos.nonEmpty()) continue;
            t = this.toP(this.F.at(((JCTree.JCAnnotation)tyannos.head).pos).AnnotatedType(tyannos, t));
        }
        return t;
    }

    JCTree.JCExpression literal(Name prefix) {
        return this.literal(prefix, this.token.pos);
    }

    JCTree.JCExpression literal(Name prefix, int pos) {
        JCTree.JCExpression t = this.errorTree;
        switch (this.token.kind) {
            case INTLITERAL: {
                try {
                    t = this.F.at(pos).Literal(TypeTag.INT, Convert.string2int(this.strval(prefix), this.token.radix()));
                }
                catch (NumberFormatException ex) {
                    this.error(this.token.pos, "int.number.too.large", this.strval(prefix));
                }
                break;
            }
            case LONGLITERAL: {
                try {
                    t = this.F.at(pos).Literal(TypeTag.LONG, new Long(Convert.string2long(this.strval(prefix), this.token.radix())));
                }
                catch (NumberFormatException ex) {
                    this.error(this.token.pos, "int.number.too.large", this.strval(prefix));
                }
                break;
            }
            case FLOATLITERAL: {
                Float n;
                String proper = this.token.radix() == 16 ? "0x" + this.token.stringVal() : this.token.stringVal();
                try {
                    n = Float.valueOf(proper);
                }
                catch (NumberFormatException ex) {
                    n = Float.valueOf(Float.NaN);
                }
                if (n.floatValue() == 0.0f && !this.isZero(proper)) {
                    this.error(this.token.pos, "fp.number.too.small", new Object[0]);
                    break;
                }
                if (n.floatValue() == Float.POSITIVE_INFINITY) {
                    this.error(this.token.pos, "fp.number.too.large", new Object[0]);
                    break;
                }
                t = this.F.at(pos).Literal(TypeTag.FLOAT, n);
                break;
            }
            case DOUBLELITERAL: {
                Double n;
                String proper = this.token.radix() == 16 ? "0x" + this.token.stringVal() : this.token.stringVal();
                try {
                    n = Double.valueOf(proper);
                }
                catch (NumberFormatException ex) {
                    n = Double.NaN;
                }
                if (n == 0.0 && !this.isZero(proper)) {
                    this.error(this.token.pos, "fp.number.too.small", new Object[0]);
                    break;
                }
                if (n == Double.POSITIVE_INFINITY) {
                    this.error(this.token.pos, "fp.number.too.large", new Object[0]);
                    break;
                }
                t = this.F.at(pos).Literal(TypeTag.DOUBLE, n);
                break;
            }
            case CHARLITERAL: {
                t = this.F.at(pos).Literal(TypeTag.CHAR, this.token.stringVal().charAt(0) + '\u0000');
                break;
            }
            case STRINGLITERAL: {
                t = this.F.at(pos).Literal(TypeTag.CLASS, this.token.stringVal());
                break;
            }
            case TRUE: 
            case FALSE: {
                t = this.F.at(pos).Literal(TypeTag.BOOLEAN, this.token.kind == Tokens.TokenKind.TRUE ? 1 : 0);
                break;
            }
            case NULL: {
                t = this.F.at(pos).Literal(TypeTag.BOT, null);
                break;
            }
            default: {
                Assert.error();
            }
        }
        if (t == this.errorTree) {
            t = this.F.at(pos).Erroneous();
        }
        this.storeEnd(t, this.token.endPos);
        this.nextToken();
        return t;
    }

    boolean isZero(String s) {
        int i;
        char[] cs = s.toCharArray();
        int base = cs.length > 1 && Character.toLowerCase(cs[1]) == 'x' ? 16 : 10;
        int n = i = base == 16 ? 2 : 0;
        while (i < cs.length && (cs[i] == '0' || cs[i] == '.')) {
            ++i;
        }
        return i >= cs.length || Character.digit(cs[i], base) <= 0;
    }

    String strval(Name prefix) {
        String s = this.token.stringVal();
        return prefix.isEmpty() ? s : prefix + s;
    }

    @Override
    public JCTree.JCExpression parseExpression() {
        return this.term(1);
    }

    @Override
    public JCTree.JCExpression parseType() {
        List<JCTree.JCAnnotation> annotations = this.typeAnnotationsOpt();
        return this.parseType(annotations);
    }

    public JCTree.JCExpression parseType(List<JCTree.JCAnnotation> annotations) {
        JCTree.JCExpression result = this.unannotatedType();
        if (annotations.nonEmpty()) {
            result = this.insertAnnotationsToMostInner(result, annotations, false);
        }
        return result;
    }

    public JCTree.JCExpression unannotatedType() {
        return this.term(2);
    }

    JCTree.JCExpression term(int newmode) {
        int prevmode = this.mode;
        this.mode = newmode;
        JCTree.JCExpression t = this.term();
        this.lastmode = this.mode;
        this.mode = prevmode;
        return t;
    }

    JCTree.JCExpression term() {
        JCTree.JCExpression t = this.term1();
        if ((this.mode & 1) != 0 && this.token.kind == Tokens.TokenKind.EQ || Tokens.TokenKind.PLUSEQ.compareTo(this.token.kind) <= 0 && this.token.kind.compareTo(Tokens.TokenKind.GTGTGTEQ) <= 0) {
            return this.termRest(t);
        }
        return t;
    }

    JCTree.JCExpression termRest(JCTree.JCExpression t) {
        switch (this.token.kind) {
            case EQ: {
                int pos = this.token.pos;
                this.nextToken();
                this.mode = 1;
                JCTree.JCExpression t1 = this.term();
                return this.toP(this.F.at(pos).Assign(t, t1));
            }
            case PLUSEQ: 
            case SUBEQ: 
            case STAREQ: 
            case SLASHEQ: 
            case PERCENTEQ: 
            case AMPEQ: 
            case BAREQ: 
            case CARETEQ: 
            case LTLTEQ: 
            case GTGTEQ: 
            case GTGTGTEQ: {
                int pos = this.token.pos;
                Tokens.TokenKind tk = this.token.kind;
                this.nextToken();
                this.mode = 1;
                JCTree.JCExpression t1 = this.term();
                return this.F.at(pos).Assignop(JavacParser.optag(tk), t, t1);
            }
        }
        return t;
    }

    JCTree.JCExpression term1() {
        JCTree.JCExpression t = this.term2();
        if ((this.mode & 1) != 0 && this.token.kind == Tokens.TokenKind.QUES) {
            this.mode = 1;
            return this.term1Rest(t);
        }
        return t;
    }

    JCTree.JCExpression term1Rest(JCTree.JCExpression t) {
        if (this.token.kind == Tokens.TokenKind.QUES) {
            int pos = this.token.pos;
            this.nextToken();
            JCTree.JCExpression t1 = this.term();
            this.accept(Tokens.TokenKind.COLON);
            JCTree.JCExpression t2 = this.term1();
            return this.F.at(pos).Conditional(t, t1, t2);
        }
        return t;
    }

    JCTree.JCExpression term2() {
        JCTree.JCExpression t = this.term3();
        if ((this.mode & 1) != 0 && JavacParser.prec(this.token.kind) >= 4) {
            this.mode = 1;
            return this.term2Rest(t, 4);
        }
        return t;
    }

    JCTree.JCExpression term2Rest(JCTree.JCExpression t, int minprec) {
        JCTree.JCExpression[] odStack = this.newOdStack();
        Tokens.Token[] opStack = this.newOpStack();
        int top = 0;
        odStack[0] = t;
        int startPos = this.token.pos;
        Tokens.Token topOp = Tokens.DUMMY;
        while (JavacParser.prec(this.token.kind) >= minprec) {
            opStack[top] = topOp;
            topOp = this.token;
            this.nextToken();
            JCTree.JCExpression jCExpression = odStack[++top] = topOp.kind == Tokens.TokenKind.INSTANCEOF ? this.parseType() : this.term3();
            while (top > 0 && JavacParser.prec(topOp.kind) >= JavacParser.prec(this.token.kind)) {
                odStack[top - 1] = this.makeOp(topOp.pos, topOp.kind, odStack[top - 1], odStack[top]);
                topOp = opStack[--top];
            }
        }
        Assert.check(top == 0);
        t = odStack[0];
        if (t.hasTag(JCTree.Tag.PLUS)) {
            t = this.foldStrings(t);
        }
        this.odStackSupply.add(odStack);
        this.opStackSupply.add(opStack);
        return t;
    }

    private JCTree.JCExpression makeOp(int pos, Tokens.TokenKind topOp, JCTree.JCExpression od1, JCTree.JCExpression od2) {
        if (topOp == Tokens.TokenKind.INSTANCEOF) {
            return this.F.at(pos).TypeTest(od1, od2);
        }
        return this.F.at(pos).Binary(JavacParser.optag(topOp), od1, od2);
    }

    protected JCTree.JCExpression foldStrings(JCTree.JCExpression tree) {
        if (!this.allowStringFolding) {
            return tree;
        }
        ListBuffer<JCTree.JCExpression> opStack = new ListBuffer<JCTree.JCExpression>();
        ListBuffer<JCTree.JCLiteral> litBuf = new ListBuffer<JCTree.JCLiteral>();
        boolean needsFolding = false;
        JCTree.JCExpression curr = tree;
        while (curr.hasTag(JCTree.Tag.PLUS)) {
            JCTree.JCBinary op = (JCTree.JCBinary)curr;
            needsFolding |= this.foldIfNeeded(op.rhs, litBuf, opStack, false);
            curr = op.lhs;
        }
        if (needsFolding |= this.foldIfNeeded(curr, litBuf, opStack, true)) {
            List<JCTree.JCExpression> ops = opStack.toList();
            JCTree.JCExpression res = (JCTree.JCExpression)ops.head;
            for (JCTree.JCExpression op : ops.tail) {
                res = this.F.at(op.getStartPosition()).Binary(JavacParser.optag(Tokens.TokenKind.PLUS), res, op);
                this.storeEnd(res, this.getEndPos(op));
            }
            return res;
        }
        return tree;
    }

    private boolean foldIfNeeded(JCTree.JCExpression tree, ListBuffer<JCTree.JCLiteral> litBuf, ListBuffer<JCTree.JCExpression> opStack, boolean last) {
        JCTree.JCLiteral str = this.stringLiteral(tree);
        if (str != null) {
            litBuf.prepend(str);
            return last && this.merge(litBuf, opStack);
        }
        boolean res = this.merge(litBuf, opStack);
        litBuf.clear();
        opStack.prepend(tree);
        return res;
    }

    boolean merge(ListBuffer<JCTree.JCLiteral> litBuf, ListBuffer<JCTree.JCExpression> opStack) {
        if (litBuf.isEmpty()) {
            return false;
        }
        if (litBuf.size() == 1) {
            opStack.prepend(litBuf.first());
            return false;
        }
        StringBuilder sb = new StringBuilder();
        for (JCTree.JCLiteral lit : litBuf) {
            sb.append(lit.getValue());
        }
        JCTree.JCLiteral t = this.F.at(litBuf.first().getStartPosition()).Literal(TypeTag.CLASS, sb.toString());
        this.storeEnd(t, litBuf.last().getEndPosition(this.endPosTable));
        opStack.prepend(t);
        return true;
    }

    private JCTree.JCLiteral stringLiteral(JCTree tree) {
        if (tree.hasTag(JCTree.Tag.LITERAL)) {
            JCTree.JCLiteral lit = (JCTree.JCLiteral)tree;
            if (lit.typetag == TypeTag.CLASS) {
                return lit;
            }
        }
        return null;
    }

    private JCTree.JCExpression[] newOdStack() {
        if (this.odStackSupply.isEmpty()) {
            return new JCTree.JCExpression[11];
        }
        return this.odStackSupply.remove(this.odStackSupply.size() - 1);
    }

    private Tokens.Token[] newOpStack() {
        if (this.opStackSupply.isEmpty()) {
            return new Tokens.Token[11];
        }
        return this.opStackSupply.remove(this.opStackSupply.size() - 1);
    }

    protected JCTree.JCExpression term3() {
        JCTree.JCExpression t;
        int pos = this.token.pos;
        List<JCTree.JCExpression> typeArgs = this.typeArgumentsOpt(1);
        block0 : switch (this.token.kind) {
            case QUES: {
                if ((this.mode & 2) != 0 && (this.mode & 0xC) == 8) {
                    this.mode = 2;
                    return this.typeArgument();
                }
                return this.illegal();
            }
            case PLUSPLUS: 
            case SUBSUB: 
            case BANG: 
            case TILDE: 
            case PLUS: 
            case SUB: {
                if (typeArgs == null && (this.mode & 1) != 0) {
                    Tokens.TokenKind tk = this.token.kind;
                    this.nextToken();
                    this.mode = 1;
                    if (tk == Tokens.TokenKind.SUB && (this.token.kind == Tokens.TokenKind.INTLITERAL || this.token.kind == Tokens.TokenKind.LONGLITERAL) && this.token.radix() == 10) {
                        this.mode = 1;
                        t = this.literal(this.names.hyphen, pos);
                        break;
                    }
                    JCTree.JCExpression t2 = this.term3();
                    return this.F.at(pos).Unary(JavacParser.unoptag(tk), t2);
                }
                return this.illegal();
            }
            case LPAREN: {
                if (typeArgs == null && (this.mode & 1) != 0) {
                    ParensResult pres = this.analyzeParens();
                    switch (pres) {
                        case CAST: {
                            this.accept(Tokens.TokenKind.LPAREN);
                            this.mode = 2;
                            int pos1 = pos;
                            JCTree.JCExpression t3 = this.term3();
                            List<JCTree.JCExpression> targets = List.of(t3);
                            while (this.token.kind == Tokens.TokenKind.AMP) {
                                this.checkIntersectionTypesInCast();
                                this.accept(Tokens.TokenKind.AMP);
                                targets = targets.prepend(this.term3());
                            }
                            if (targets.length() > 1) {
                                t3 = this.toP(this.F.at(pos1).TypeIntersection(targets.reverse()));
                            }
                            this.accept(Tokens.TokenKind.RPAREN);
                            this.mode = 1;
                            JCTree.JCExpression t1 = this.term3();
                            return this.F.at(pos).TypeCast(t3, t1);
                        }
                        case IMPLICIT_LAMBDA: 
                        case EXPLICIT_LAMBDA: {
                            t = this.lambdaExpressionOrStatement(true, pres == ParensResult.EXPLICIT_LAMBDA, pos);
                            break block0;
                        }
                    }
                    this.accept(Tokens.TokenKind.LPAREN);
                    this.mode = 1;
                    t = this.termRest(this.term1Rest(this.term2Rest(this.term3(), 4)));
                    this.accept(Tokens.TokenKind.RPAREN);
                    t = this.toP(this.F.at(pos).Parens(t));
                    break;
                }
                return this.illegal();
            }
            case THIS: {
                if ((this.mode & 1) != 0) {
                    this.mode = 1;
                    t = this.to(this.F.at(pos).Ident(this.names._this));
                    this.nextToken();
                    t = typeArgs == null ? this.argumentsOpt(null, t) : this.arguments(typeArgs, t);
                    typeArgs = null;
                    break;
                }
                return this.illegal();
            }
            case SUPER: {
                if ((this.mode & 1) != 0) {
                    this.mode = 1;
                    t = this.to(this.F.at(pos).Ident(this.names._super));
                    t = this.superSuffix(typeArgs, t);
                    typeArgs = null;
                    break;
                }
                return this.illegal();
            }
            case INTLITERAL: 
            case LONGLITERAL: 
            case FLOATLITERAL: 
            case DOUBLELITERAL: 
            case CHARLITERAL: 
            case STRINGLITERAL: 
            case TRUE: 
            case FALSE: 
            case NULL: {
                if (typeArgs == null && (this.mode & 1) != 0) {
                    this.mode = 1;
                    t = this.literal(this.names.empty);
                    break;
                }
                return this.illegal();
            }
            case NEW: {
                if (typeArgs != null) {
                    return this.illegal();
                }
                if ((this.mode & 1) != 0) {
                    this.mode = 1;
                    this.nextToken();
                    if (this.token.kind == Tokens.TokenKind.LT) {
                        typeArgs = this.typeArguments(false);
                    }
                    t = this.creator(pos, typeArgs);
                    typeArgs = null;
                    break;
                }
                return this.illegal();
            }
            case MONKEYS_AT: {
                List<JCTree.JCAnnotation> typeAnnos = this.typeAnnotationsOpt();
                if (typeAnnos.isEmpty()) {
                    throw new AssertionError((Object)"Expected type annotations, but found none!");
                }
                JCTree.JCExpression expr = this.term3();
                if ((this.mode & 2) == 0) {
                    switch (expr.getTag()) {
                        case REFERENCE: {
                            JCTree.JCMemberReference mref = (JCTree.JCMemberReference)expr;
                            mref.expr = this.toP(this.F.at(pos).AnnotatedType(typeAnnos, mref.expr));
                            t = mref;
                            break block0;
                        }
                        case SELECT: {
                            JCTree.JCFieldAccess sel = (JCTree.JCFieldAccess)expr;
                            if (sel.name != this.names._class) {
                                return this.illegal();
                            }
                            this.log.error(this.token.pos, "no.annotations.on.dot.class", new Object[0]);
                            return expr;
                        }
                    }
                    return this.illegal(((JCTree.JCAnnotation)typeAnnos.head).pos);
                }
                t = this.insertAnnotationsToMostInner(expr, typeAnnos, false);
                break;
            }
            case ENUM: 
            case UNDERSCORE: 
            case IDENTIFIER: 
            case ASSERT: {
                if (typeArgs != null) {
                    return this.illegal();
                }
                if ((this.mode & 1) != 0 && this.peekToken((Filter<Tokens.TokenKind>)Tokens.TokenKind.ARROW)) {
                    t = this.lambdaExpressionOrStatement(false, false, pos);
                } else {
                    t = this.toP(this.F.at(this.token.pos).Ident(this.ident()));
                    block35: while (true) {
                        pos = this.token.pos;
                        List<JCTree.JCAnnotation> annos = this.typeAnnotationsOpt();
                        if (!annos.isEmpty() && this.token.kind != Tokens.TokenKind.LBRACKET && this.token.kind != Tokens.TokenKind.ELLIPSIS) {
                            return this.illegal(((JCTree.JCAnnotation)annos.head).pos);
                        }
                        switch (this.token.kind) {
                            case LBRACKET: {
                                this.nextToken();
                                if (this.token.kind == Tokens.TokenKind.RBRACKET) {
                                    JCTree.JCExpression nt;
                                    this.nextToken();
                                    t = this.bracketsOpt(t);
                                    t = this.toP(this.F.at(pos).TypeArray(t));
                                    if (annos.nonEmpty()) {
                                        t = this.toP(this.F.at(pos).AnnotatedType(annos, t));
                                    }
                                    if ((nt = this.bracketsSuffix(t)) != t && (annos.nonEmpty() || TreeInfo.containsTypeAnnotation(t))) {
                                        this.syntaxError("no.annotations.on.dot.class");
                                    }
                                    t = nt;
                                    break block35;
                                }
                                if ((this.mode & 1) != 0) {
                                    this.mode = 1;
                                    JCTree.JCExpression t1 = this.term();
                                    if (!annos.isEmpty()) {
                                        t = this.illegal(((JCTree.JCAnnotation)annos.head).pos);
                                    }
                                    t = this.to(this.F.at(pos).Indexed(t, t1));
                                }
                                this.accept(Tokens.TokenKind.RBRACKET);
                                break block35;
                            }
                            case LPAREN: {
                                if ((this.mode & 1) != 0) {
                                    this.mode = 1;
                                    t = this.arguments(typeArgs, t);
                                    if (!annos.isEmpty()) {
                                        t = this.illegal(((JCTree.JCAnnotation)annos.head).pos);
                                    }
                                    typeArgs = null;
                                }
                                break block35;
                            }
                            case DOT: {
                                this.nextToken();
                                int oldmode = this.mode;
                                this.mode &= 0xFFFFFFFB;
                                typeArgs = this.typeArgumentsOpt(1);
                                this.mode = oldmode;
                                if ((this.mode & 1) != 0) {
                                    switch (this.token.kind) {
                                        case CLASS: {
                                            if (typeArgs != null) {
                                                return this.illegal();
                                            }
                                            this.mode = 1;
                                            t = this.to(this.F.at(pos).Select(t, this.names._class));
                                            this.nextToken();
                                            break block35;
                                        }
                                        case THIS: {
                                            if (typeArgs != null) {
                                                return this.illegal();
                                            }
                                            this.mode = 1;
                                            t = this.to(this.F.at(pos).Select(t, this.names._this));
                                            this.nextToken();
                                            break block35;
                                        }
                                        case SUPER: {
                                            this.mode = 1;
                                            t = this.to(this.F.at(pos).Select(t, this.names._super));
                                            t = this.superSuffix(typeArgs, t);
                                            typeArgs = null;
                                            break block35;
                                        }
                                        case NEW: {
                                            if (typeArgs != null) {
                                                return this.illegal();
                                            }
                                            this.mode = 1;
                                            int pos1 = this.token.pos;
                                            this.nextToken();
                                            if (this.token.kind == Tokens.TokenKind.LT) {
                                                typeArgs = this.typeArguments(false);
                                            }
                                            t = this.innerCreator(pos1, typeArgs, t);
                                            typeArgs = null;
                                            break block35;
                                        }
                                    }
                                }
                                List<JCTree.JCAnnotation> tyannos = null;
                                if ((this.mode & 2) != 0 && this.token.kind == Tokens.TokenKind.MONKEYS_AT) {
                                    tyannos = this.typeAnnotationsOpt();
                                }
                                t = this.toP(this.F.at(pos).Select(t, this.ident()));
                                if (tyannos == null || !tyannos.nonEmpty()) continue block35;
                                t = this.toP(this.F.at(((JCTree.JCAnnotation)tyannos.head).pos).AnnotatedType(tyannos, t));
                                continue block35;
                            }
                            case ELLIPSIS: {
                                if (this.permitTypeAnnotationsPushBack) {
                                    this.typeAnnotationsPushedBack = annos;
                                    break block35;
                                }
                                if (annos.nonEmpty()) {
                                    this.illegal(((JCTree.JCAnnotation)annos.head).pos);
                                }
                                break block35;
                            }
                            case LT: {
                                if ((this.mode & 2) == 0 && this.isUnboundMemberRef()) {
                                    int pos1 = this.token.pos;
                                    this.accept(Tokens.TokenKind.LT);
                                    ListBuffer<JCTree.JCExpression> args = new ListBuffer<JCTree.JCExpression>();
                                    args.append(this.typeArgument());
                                    while (this.token.kind == Tokens.TokenKind.COMMA) {
                                        this.nextToken();
                                        args.append(this.typeArgument());
                                    }
                                    this.accept(Tokens.TokenKind.GT);
                                    t = this.toP(this.F.at(pos1).TypeApply(t, args.toList()));
                                    this.checkGenerics();
                                    while (this.token.kind == Tokens.TokenKind.DOT) {
                                        this.nextToken();
                                        this.mode = 2;
                                        t = this.toP(this.F.at(this.token.pos).Select(t, this.ident()));
                                        t = this.typeArgumentsOpt(t);
                                    }
                                    t = this.bracketsOpt(t);
                                    if (this.token.kind != Tokens.TokenKind.COLCOL) {
                                        t = this.illegal();
                                    }
                                    this.mode = 1;
                                    return this.term3Rest(t, typeArgs);
                                }
                                break block35;
                            }
                        }
                        break;
                    }
                }
                if (typeArgs != null) {
                    this.illegal();
                }
                t = this.typeArgumentsOpt(t);
                break;
            }
            case BYTE: 
            case SHORT: 
            case CHAR: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case BOOLEAN: {
                if (typeArgs != null) {
                    this.illegal();
                }
                t = this.bracketsSuffix(this.bracketsOpt(this.basicType()));
                break;
            }
            case VOID: {
                if (typeArgs != null) {
                    this.illegal();
                }
                if ((this.mode & 1) != 0) {
                    this.nextToken();
                    if (this.token.kind == Tokens.TokenKind.DOT) {
                        JCTree.JCPrimitiveTypeTree ti = this.toP(this.F.at(pos).TypeIdent(TypeTag.VOID));
                        t = this.bracketsSuffix(ti);
                        break;
                    }
                    return this.illegal(pos);
                }
                JCTree.JCPrimitiveTypeTree ti = this.to(this.F.at(pos).TypeIdent(TypeTag.VOID));
                this.nextToken();
                return ti;
            }
            default: {
                return this.illegal();
            }
        }
        return this.term3Rest(t, typeArgs);
    }

    JCTree.JCExpression term3Rest(JCTree.JCExpression t, List<JCTree.JCExpression> typeArgs) {
        List<JCTree.JCAnnotation> annos;
        if (typeArgs != null) {
            this.illegal();
        }
        while (true) {
            int pos1 = this.token.pos;
            annos = this.typeAnnotationsOpt();
            if (this.token.kind == Tokens.TokenKind.LBRACKET) {
                this.nextToken();
                if ((this.mode & 2) != 0) {
                    int oldmode = this.mode;
                    this.mode = 2;
                    if (this.token.kind == Tokens.TokenKind.RBRACKET) {
                        this.nextToken();
                        t = this.bracketsOpt(t);
                        t = this.toP(this.F.at(pos1).TypeArray(t));
                        if (this.token.kind == Tokens.TokenKind.COLCOL) {
                            this.mode = 1;
                            continue;
                        }
                        if (annos.nonEmpty()) {
                            t = this.toP(this.F.at(pos1).AnnotatedType(annos, t));
                        }
                        return t;
                    }
                    this.mode = oldmode;
                }
                if ((this.mode & 1) != 0) {
                    this.mode = 1;
                    JCTree.JCExpression t1 = this.term();
                    t = this.to(this.F.at(pos1).Indexed(t, t1));
                }
                this.accept(Tokens.TokenKind.RBRACKET);
                continue;
            }
            if (this.token.kind == Tokens.TokenKind.DOT) {
                this.nextToken();
                typeArgs = this.typeArgumentsOpt(1);
                if (this.token.kind == Tokens.TokenKind.SUPER && (this.mode & 1) != 0) {
                    this.mode = 1;
                    t = this.to(this.F.at(pos1).Select(t, this.names._super));
                    this.nextToken();
                    t = this.arguments(typeArgs, t);
                    typeArgs = null;
                    continue;
                }
                if (this.token.kind == Tokens.TokenKind.NEW && (this.mode & 1) != 0) {
                    if (typeArgs != null) {
                        return this.illegal();
                    }
                    this.mode = 1;
                    int pos2 = this.token.pos;
                    this.nextToken();
                    if (this.token.kind == Tokens.TokenKind.LT) {
                        typeArgs = this.typeArguments(false);
                    }
                    t = this.innerCreator(pos2, typeArgs, t);
                    typeArgs = null;
                    continue;
                }
                List<JCTree.JCAnnotation> tyannos = null;
                if ((this.mode & 2) != 0 && this.token.kind == Tokens.TokenKind.MONKEYS_AT) {
                    tyannos = this.typeAnnotationsOpt();
                }
                t = this.toP(this.F.at(pos1).Select(t, this.ident()));
                if (tyannos != null && tyannos.nonEmpty()) {
                    t = this.toP(this.F.at(((JCTree.JCAnnotation)tyannos.head).pos).AnnotatedType(tyannos, t));
                }
                t = this.argumentsOpt(typeArgs, this.typeArgumentsOpt(t));
                typeArgs = null;
                continue;
            }
            if ((this.mode & 1) == 0 || this.token.kind != Tokens.TokenKind.COLCOL) break;
            this.mode = 1;
            if (typeArgs != null) {
                return this.illegal();
            }
            this.accept(Tokens.TokenKind.COLCOL);
            t = this.memberReferenceSuffix(pos1, t);
        }
        if (!annos.isEmpty()) {
            if (this.permitTypeAnnotationsPushBack) {
                this.typeAnnotationsPushedBack = annos;
            } else {
                return this.illegal(((JCTree.JCAnnotation)annos.head).pos);
            }
        }
        while ((this.token.kind == Tokens.TokenKind.PLUSPLUS || this.token.kind == Tokens.TokenKind.SUBSUB) && (this.mode & 1) != 0) {
            this.mode = 1;
            t = this.to(this.F.at(this.token.pos).Unary(this.token.kind == Tokens.TokenKind.PLUSPLUS ? JCTree.Tag.POSTINC : JCTree.Tag.POSTDEC, t));
            this.nextToken();
        }
        return this.toP(t);
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean isUnboundMemberRef() {
        int pos = 0;
        int depth = 0;
        Tokens.Token t = this.S.token(pos);
        while (true) {
            block0 : switch (t.kind) {
                case MONKEYS_AT: 
                case BYTE: 
                case SHORT: 
                case CHAR: 
                case INT: 
                case LONG: 
                case FLOAT: 
                case DOUBLE: 
                case BOOLEAN: 
                case UNDERSCORE: 
                case IDENTIFIER: 
                case SUPER: 
                case LBRACKET: 
                case DOT: 
                case QUES: 
                case EXTENDS: 
                case RBRACKET: 
                case COMMA: {
                    break;
                }
                case LPAREN: {
                    int nesting = 0;
                    while (true) {
                        Tokens.TokenKind tk2 = this.S.token((int)pos).kind;
                        switch (tk2) {
                            case EOF: {
                                return false;
                            }
                            case LPAREN: {
                                ++nesting;
                                break;
                            }
                            case RPAREN: {
                                if (--nesting == 0) break block0;
                            }
                        }
                        ++pos;
                    }
                }
                case LT: {
                    ++depth;
                    break;
                }
                case GTGTGT: {
                    --depth;
                }
                case GTGT: {
                    --depth;
                }
                case GT: {
                    if (--depth != 0) break;
                    Tokens.TokenKind nextKind = this.S.token((int)(pos + 1)).kind;
                    if (nextKind == Tokens.TokenKind.DOT) return true;
                    if (nextKind == Tokens.TokenKind.LBRACKET) return true;
                    if (nextKind == Tokens.TokenKind.COLCOL) return true;
                    return false;
                }
                default: {
                    return false;
                }
            }
            t = this.S.token(++pos);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    ParensResult analyzeParens() {
        int depth = 0;
        boolean type = false;
        int lookahead = 0;
        while (true) {
            Tokens.TokenKind tk = this.S.token((int)lookahead).kind;
            block0 : switch (tk) {
                case COMMA: {
                    type = true;
                }
                case SUPER: 
                case DOT: 
                case EXTENDS: 
                case AMP: {
                    break;
                }
                case QUES: {
                    if (!this.peekToken(lookahead, (Filter<Tokens.TokenKind>)Tokens.TokenKind.EXTENDS) && !this.peekToken(lookahead, (Filter<Tokens.TokenKind>)Tokens.TokenKind.SUPER)) break;
                    type = true;
                    break;
                }
                case BYTE: 
                case SHORT: 
                case CHAR: 
                case INT: 
                case LONG: 
                case FLOAT: 
                case DOUBLE: 
                case BOOLEAN: {
                    if (this.peekToken(lookahead, (Filter<Tokens.TokenKind>)Tokens.TokenKind.RPAREN)) {
                        return ParensResult.CAST;
                    }
                    if (!this.peekToken(lookahead, this.LAX_IDENTIFIER)) break;
                    return ParensResult.EXPLICIT_LAMBDA;
                }
                case LPAREN: {
                    if (lookahead != 0) {
                        return ParensResult.PARENS;
                    }
                    if (!this.peekToken(lookahead, (Filter<Tokens.TokenKind>)Tokens.TokenKind.RPAREN)) break;
                    return ParensResult.EXPLICIT_LAMBDA;
                }
                case RPAREN: {
                    if (type) {
                        return ParensResult.CAST;
                    }
                    switch (this.S.token((int)(lookahead + 1)).kind) {
                        case ENUM: 
                        case BYTE: 
                        case SHORT: 
                        case CHAR: 
                        case INT: 
                        case LONG: 
                        case FLOAT: 
                        case DOUBLE: 
                        case BOOLEAN: 
                        case VOID: 
                        case UNDERSCORE: 
                        case IDENTIFIER: 
                        case INTLITERAL: 
                        case LONGLITERAL: 
                        case FLOATLITERAL: 
                        case DOUBLELITERAL: 
                        case CHARLITERAL: 
                        case STRINGLITERAL: 
                        case TRUE: 
                        case FALSE: 
                        case NULL: 
                        case THIS: 
                        case SUPER: 
                        case NEW: 
                        case LPAREN: 
                        case BANG: 
                        case TILDE: 
                        case ASSERT: {
                            return ParensResult.CAST;
                        }
                    }
                    return ParensResult.PARENS;
                }
                case ENUM: 
                case UNDERSCORE: 
                case IDENTIFIER: 
                case ASSERT: {
                    if (this.peekToken(lookahead, this.LAX_IDENTIFIER)) {
                        return ParensResult.EXPLICIT_LAMBDA;
                    }
                    if (this.peekToken(lookahead, (Filter<Tokens.TokenKind>)Tokens.TokenKind.RPAREN, (Filter<Tokens.TokenKind>)Tokens.TokenKind.ARROW)) {
                        return ParensResult.IMPLICIT_LAMBDA;
                    }
                    type = false;
                    break;
                }
                case FINAL: 
                case ELLIPSIS: {
                    return ParensResult.EXPLICIT_LAMBDA;
                }
                case MONKEYS_AT: {
                    type = true;
                    ++lookahead;
                    while (this.peekToken(lookahead, (Filter<Tokens.TokenKind>)Tokens.TokenKind.DOT)) {
                        lookahead += 2;
                    }
                    if (!this.peekToken(lookahead, (Filter<Tokens.TokenKind>)Tokens.TokenKind.LPAREN)) break;
                    ++lookahead;
                    int nesting = 0;
                    while (true) {
                        Tokens.TokenKind tk2 = this.S.token((int)lookahead).kind;
                        switch (tk2) {
                            case EOF: {
                                return ParensResult.PARENS;
                            }
                            case LPAREN: {
                                ++nesting;
                                break;
                            }
                            case RPAREN: {
                                if (--nesting == 0) break block0;
                            }
                        }
                        ++lookahead;
                    }
                }
                case LBRACKET: {
                    if (this.peekToken(lookahead, (Filter<Tokens.TokenKind>)Tokens.TokenKind.RBRACKET, this.LAX_IDENTIFIER)) {
                        return ParensResult.EXPLICIT_LAMBDA;
                    }
                    if (this.peekToken(lookahead, (Filter<Tokens.TokenKind>)Tokens.TokenKind.RBRACKET, (Filter<Tokens.TokenKind>)Tokens.TokenKind.RPAREN) || this.peekToken(lookahead, (Filter<Tokens.TokenKind>)Tokens.TokenKind.RBRACKET, (Filter<Tokens.TokenKind>)Tokens.TokenKind.AMP)) {
                        return ParensResult.CAST;
                    }
                    if (!this.peekToken(lookahead, (Filter<Tokens.TokenKind>)Tokens.TokenKind.RBRACKET)) {
                        return ParensResult.PARENS;
                    }
                    type = true;
                    ++lookahead;
                    break;
                }
                case LT: {
                    ++depth;
                    break;
                }
                case GTGTGT: {
                    --depth;
                }
                case GTGT: {
                    --depth;
                }
                case GT: {
                    if (--depth == 0) {
                        if (this.peekToken(lookahead, (Filter<Tokens.TokenKind>)Tokens.TokenKind.RPAREN) || this.peekToken(lookahead, (Filter<Tokens.TokenKind>)Tokens.TokenKind.AMP)) {
                            return ParensResult.CAST;
                        }
                        if (this.peekToken(lookahead, this.LAX_IDENTIFIER, (Filter<Tokens.TokenKind>)Tokens.TokenKind.COMMA) || this.peekToken(lookahead, this.LAX_IDENTIFIER, (Filter<Tokens.TokenKind>)Tokens.TokenKind.RPAREN, (Filter<Tokens.TokenKind>)Tokens.TokenKind.ARROW) || this.peekToken(lookahead, (Filter<Tokens.TokenKind>)Tokens.TokenKind.ELLIPSIS)) {
                            return ParensResult.EXPLICIT_LAMBDA;
                        }
                        type = true;
                        break;
                    }
                    if (depth >= 0) break;
                    return ParensResult.PARENS;
                }
                default: {
                    return ParensResult.PARENS;
                }
            }
            ++lookahead;
        }
    }

    JCTree.JCExpression lambdaExpressionOrStatement(boolean hasParens, boolean explicitParams, int pos) {
        List<JCTree.JCVariableDecl> params = explicitParams ? this.formalParameters(true) : this.implicitParameters(hasParens);
        return this.lambdaExpressionOrStatementRest(params, pos);
    }

    JCTree.JCExpression lambdaExpressionOrStatementRest(List<JCTree.JCVariableDecl> args, int pos) {
        this.checkLambda();
        this.accept(Tokens.TokenKind.ARROW);
        return this.token.kind == Tokens.TokenKind.LBRACE ? this.lambdaStatement(args, pos, pos) : this.lambdaExpression(args, pos);
    }

    JCTree.JCExpression lambdaStatement(List<JCTree.JCVariableDecl> args, int pos, int pos2) {
        JCTree.JCBlock block = this.block(pos2, 0L);
        return this.toP(this.F.at(pos).Lambda(args, block));
    }

    JCTree.JCExpression lambdaExpression(List<JCTree.JCVariableDecl> args, int pos) {
        JCTree.JCExpression expr = this.parseExpression();
        return this.toP(this.F.at(pos).Lambda(args, expr));
    }

    JCTree.JCExpression superSuffix(List<JCTree.JCExpression> typeArgs, JCTree.JCExpression t) {
        this.nextToken();
        if (this.token.kind == Tokens.TokenKind.LPAREN || typeArgs != null) {
            t = this.arguments(typeArgs, t);
        } else if (this.token.kind == Tokens.TokenKind.COLCOL) {
            if (typeArgs != null) {
                return this.illegal();
            }
            t = this.memberReferenceSuffix(t);
        } else {
            int pos = this.token.pos;
            this.accept(Tokens.TokenKind.DOT);
            typeArgs = this.token.kind == Tokens.TokenKind.LT ? this.typeArguments(false) : null;
            t = this.toP(this.F.at(pos).Select(t, this.ident()));
            t = this.argumentsOpt(typeArgs, t);
        }
        return t;
    }

    JCTree.JCPrimitiveTypeTree basicType() {
        JCTree.JCPrimitiveTypeTree t = this.to(this.F.at(this.token.pos).TypeIdent(JavacParser.typetag(this.token.kind)));
        this.nextToken();
        return t;
    }

    JCTree.JCExpression argumentsOpt(List<JCTree.JCExpression> typeArgs, JCTree.JCExpression t) {
        if ((this.mode & 1) != 0 && this.token.kind == Tokens.TokenKind.LPAREN || typeArgs != null) {
            this.mode = 1;
            return this.arguments(typeArgs, t);
        }
        return t;
    }

    List<JCTree.JCExpression> arguments() {
        ListBuffer<JCTree.JCExpression> args = new ListBuffer<JCTree.JCExpression>();
        if (this.token.kind == Tokens.TokenKind.LPAREN) {
            this.nextToken();
            if (this.token.kind != Tokens.TokenKind.RPAREN) {
                args.append(this.parseExpression());
                while (this.token.kind == Tokens.TokenKind.COMMA) {
                    this.nextToken();
                    args.append(this.parseExpression());
                }
            }
            this.accept(Tokens.TokenKind.RPAREN);
        } else {
            this.syntaxError(this.token.pos, "expected", Tokens.TokenKind.LPAREN);
        }
        return args.toList();
    }

    JCTree.JCMethodInvocation arguments(List<JCTree.JCExpression> typeArgs, JCTree.JCExpression t) {
        int pos = this.token.pos;
        List<JCTree.JCExpression> args = this.arguments();
        return this.toP(this.F.at(pos).Apply(typeArgs, t, args));
    }

    JCTree.JCExpression typeArgumentsOpt(JCTree.JCExpression t) {
        if (this.token.kind == Tokens.TokenKind.LT && (this.mode & 2) != 0 && (this.mode & 4) == 0) {
            this.mode = 2;
            this.checkGenerics();
            return this.typeArguments(t, false);
        }
        return t;
    }

    List<JCTree.JCExpression> typeArgumentsOpt() {
        return this.typeArgumentsOpt(2);
    }

    List<JCTree.JCExpression> typeArgumentsOpt(int useMode) {
        if (this.token.kind == Tokens.TokenKind.LT) {
            this.checkGenerics();
            if ((this.mode & useMode) == 0 || (this.mode & 4) != 0) {
                this.illegal();
            }
            this.mode = useMode;
            return this.typeArguments(false);
        }
        return null;
    }

    List<JCTree.JCExpression> typeArguments(boolean diamondAllowed) {
        if (this.token.kind == Tokens.TokenKind.LT) {
            this.nextToken();
            if (this.token.kind == Tokens.TokenKind.GT && diamondAllowed) {
                this.checkDiamond();
                this.mode |= 0x10;
                this.nextToken();
                return List.nil();
            }
            ListBuffer<JCTree.JCExpression> args = new ListBuffer<JCTree.JCExpression>();
            args.append((this.mode & 1) == 0 ? this.typeArgument() : this.parseType());
            while (this.token.kind == Tokens.TokenKind.COMMA) {
                this.nextToken();
                args.append((this.mode & 1) == 0 ? this.typeArgument() : this.parseType());
            }
            switch (this.token.kind) {
                case GTGTEQ: 
                case GTGTGTEQ: 
                case GTGTGT: 
                case GTGT: 
                case GTEQ: {
                    this.token = this.S.split();
                    break;
                }
                case GT: {
                    this.nextToken();
                    break;
                }
                default: {
                    args.append(this.syntaxError(this.token.pos, "expected", Tokens.TokenKind.GT));
                }
            }
            return args.toList();
        }
        return List.of(this.syntaxError(this.token.pos, "expected", Tokens.TokenKind.LT));
    }

    JCTree.JCExpression typeArgument() {
        JCTree.JCExpression result;
        List<JCTree.JCAnnotation> annotations = this.typeAnnotationsOpt();
        if (this.token.kind != Tokens.TokenKind.QUES) {
            return this.parseType(annotations);
        }
        int pos = this.token.pos;
        this.nextToken();
        if (this.token.kind == Tokens.TokenKind.EXTENDS) {
            JCTree.TypeBoundKind t = this.to(this.F.at(pos).TypeBoundKind(BoundKind.EXTENDS));
            this.nextToken();
            JCTree.JCExpression bound = this.parseType();
            result = this.F.at(pos).Wildcard(t, bound);
        } else if (this.token.kind == Tokens.TokenKind.SUPER) {
            JCTree.TypeBoundKind t = this.to(this.F.at(pos).TypeBoundKind(BoundKind.SUPER));
            this.nextToken();
            JCTree.JCExpression bound = this.parseType();
            result = this.F.at(pos).Wildcard(t, bound);
        } else if (this.LAX_IDENTIFIER.accepts(this.token.kind)) {
            JCTree.TypeBoundKind t = this.F.at(-1).TypeBoundKind(BoundKind.UNBOUND);
            JCTree.JCExpression wc = this.toP(this.F.at(pos).Wildcard(t, null));
            JCTree.JCIdent id = this.toP(this.F.at(this.token.pos).Ident(this.ident()));
            JCTree.JCErroneous err = this.F.at(pos).Erroneous(List.of(wc, id));
            this.reportSyntaxError(err, "expected3", Tokens.TokenKind.GT, Tokens.TokenKind.EXTENDS, Tokens.TokenKind.SUPER);
            result = err;
        } else {
            JCTree.TypeBoundKind t = this.toP(this.F.at(pos).TypeBoundKind(BoundKind.UNBOUND));
            result = this.toP(this.F.at(pos).Wildcard(t, null));
        }
        if (!annotations.isEmpty()) {
            result = this.toP(this.F.at(((JCTree.JCAnnotation)annotations.head).pos).AnnotatedType(annotations, result));
        }
        return result;
    }

    JCTree.JCTypeApply typeArguments(JCTree.JCExpression t, boolean diamondAllowed) {
        int pos = this.token.pos;
        List<JCTree.JCExpression> args = this.typeArguments(diamondAllowed);
        return this.toP(this.F.at(pos).TypeApply(t, args));
    }

    private JCTree.JCExpression bracketsOpt(JCTree.JCExpression t, List<JCTree.JCAnnotation> annotations) {
        List<JCTree.JCAnnotation> nextLevelAnnotations = this.typeAnnotationsOpt();
        if (this.token.kind == Tokens.TokenKind.LBRACKET) {
            int pos = this.token.pos;
            this.nextToken();
            t = this.bracketsOptCont(t, pos, nextLevelAnnotations);
        } else if (!nextLevelAnnotations.isEmpty()) {
            if (this.permitTypeAnnotationsPushBack) {
                this.typeAnnotationsPushedBack = nextLevelAnnotations;
            } else {
                return this.illegal(((JCTree.JCAnnotation)nextLevelAnnotations.head).pos);
            }
        }
        if (!annotations.isEmpty()) {
            t = this.toP(this.F.at(this.token.pos).AnnotatedType(annotations, t));
        }
        return t;
    }

    private JCTree.JCExpression bracketsOpt(JCTree.JCExpression t) {
        return this.bracketsOpt(t, List.nil());
    }

    private JCTree.JCExpression bracketsOptCont(JCTree.JCExpression t, int pos, List<JCTree.JCAnnotation> annotations) {
        this.accept(Tokens.TokenKind.RBRACKET);
        t = this.bracketsOpt(t);
        t = this.toP(this.F.at(pos).TypeArray(t));
        if (annotations.nonEmpty()) {
            t = this.toP(this.F.at(pos).AnnotatedType(annotations, t));
        }
        return t;
    }

    JCTree.JCExpression bracketsSuffix(JCTree.JCExpression t) {
        if ((this.mode & 1) != 0 && this.token.kind == Tokens.TokenKind.DOT) {
            this.mode = 1;
            int pos = this.token.pos;
            this.nextToken();
            this.accept(Tokens.TokenKind.CLASS);
            if (this.token.pos == this.endPosTable.errorEndPos) {
                Name name;
                if (this.LAX_IDENTIFIER.accepts(this.token.kind)) {
                    name = this.token.name();
                    this.nextToken();
                } else {
                    name = this.names.error;
                }
                t = this.F.at(pos).Erroneous(List.of(this.toP(this.F.at(pos).Select(t, name))));
            } else {
                t = this.toP(this.F.at(pos).Select(t, this.names._class));
            }
        } else if ((this.mode & 2) != 0) {
            if (this.token.kind != Tokens.TokenKind.COLCOL) {
                this.mode = 2;
            }
        } else if (this.token.kind != Tokens.TokenKind.COLCOL) {
            this.syntaxError(this.token.pos, "dot.class.expected", new Tokens.TokenKind[0]);
        }
        return t;
    }

    JCTree.JCExpression memberReferenceSuffix(JCTree.JCExpression t) {
        int pos1 = this.token.pos;
        this.accept(Tokens.TokenKind.COLCOL);
        return this.memberReferenceSuffix(pos1, t);
    }

    JCTree.JCExpression memberReferenceSuffix(int pos1, JCTree.JCExpression t) {
        Name refName;
        MemberReferenceTree.ReferenceMode refMode;
        this.checkMethodReferences();
        this.mode = 1;
        List<JCTree.JCExpression> typeArgs = null;
        if (this.token.kind == Tokens.TokenKind.LT) {
            typeArgs = this.typeArguments(false);
        }
        if (this.token.kind == Tokens.TokenKind.NEW) {
            refMode = MemberReferenceTree.ReferenceMode.NEW;
            refName = this.names.init;
            this.nextToken();
        } else {
            refMode = MemberReferenceTree.ReferenceMode.INVOKE;
            refName = this.ident();
        }
        return this.toP(this.F.at(t.getStartPosition()).Reference(refMode, refName, t, typeArgs));
    }

    JCTree.JCExpression creator(int newpos, List<JCTree.JCExpression> typeArgs) {
        List<JCTree.JCAnnotation> newAnnotations = this.typeAnnotationsOpt();
        switch (this.token.kind) {
            case BYTE: 
            case SHORT: 
            case CHAR: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case BOOLEAN: {
                if (typeArgs != null) break;
                if (newAnnotations.isEmpty()) {
                    return this.arrayCreatorRest(newpos, this.basicType());
                }
                return this.arrayCreatorRest(newpos, this.toP(this.F.at(((JCTree.JCAnnotation)newAnnotations.head).pos).AnnotatedType(newAnnotations, this.basicType())));
            }
        }
        JCTree.JCExpression t = this.qualident(true);
        int oldmode = this.mode;
        this.mode = 2;
        boolean diamondFound = false;
        int lastTypeargsPos = -1;
        if (this.token.kind == Tokens.TokenKind.LT) {
            this.checkGenerics();
            lastTypeargsPos = this.token.pos;
            t = this.typeArguments(t, true);
            boolean bl = diamondFound = (this.mode & 0x10) != 0;
        }
        while (this.token.kind == Tokens.TokenKind.DOT) {
            if (diamondFound) {
                this.illegal();
            }
            int pos = this.token.pos;
            this.nextToken();
            List<JCTree.JCAnnotation> tyannos = this.typeAnnotationsOpt();
            t = this.toP(this.F.at(pos).Select(t, this.ident()));
            if (tyannos != null && tyannos.nonEmpty()) {
                t = this.toP(this.F.at(((JCTree.JCAnnotation)tyannos.head).pos).AnnotatedType(tyannos, t));
            }
            if (this.token.kind != Tokens.TokenKind.LT) continue;
            lastTypeargsPos = this.token.pos;
            this.checkGenerics();
            t = this.typeArguments(t, true);
            diamondFound = (this.mode & 0x10) != 0;
        }
        this.mode = oldmode;
        if (this.token.kind == Tokens.TokenKind.LBRACKET || this.token.kind == Tokens.TokenKind.MONKEYS_AT) {
            if (newAnnotations.nonEmpty()) {
                t = this.insertAnnotationsToMostInner(t, newAnnotations, false);
            }
            JCTree.JCExpression e = this.arrayCreatorRest(newpos, t);
            if (diamondFound) {
                this.reportSyntaxError(lastTypeargsPos, "cannot.create.array.with.diamond", new Object[0]);
                return this.toP(this.F.at(newpos).Erroneous(List.of(e)));
            }
            if (typeArgs != null) {
                int pos = newpos;
                if (!typeArgs.isEmpty() && ((JCTree.JCExpression)typeArgs.head).pos != -1) {
                    pos = ((JCTree.JCExpression)typeArgs.head).pos;
                }
                this.setErrorEndPos(this.S.prevToken().endPos);
                JCTree.JCErroneous err = this.F.at(pos).Erroneous(typeArgs.prepend(e));
                this.reportSyntaxError(err, "cannot.create.array.with.type.arguments", new Object[0]);
                return this.toP(err);
            }
            return e;
        }
        if (this.token.kind == Tokens.TokenKind.LPAREN) {
            JCTree.JCNewClass newClass = this.classCreatorRest(newpos, null, typeArgs, t);
            if (newClass.def != null) {
                assert (newClass.def.mods.annotations.isEmpty());
                if (newAnnotations.nonEmpty()) {
                    newClass.def.mods.pos = JavacParser.earlier(newClass.def.mods.pos, ((JCTree.JCAnnotation)newAnnotations.head).pos);
                    newClass.def.mods.annotations = newAnnotations;
                }
            } else if (newAnnotations.nonEmpty()) {
                newClass.clazz = t = this.insertAnnotationsToMostInner(t, newAnnotations, false);
            }
            return newClass;
        }
        this.setErrorEndPos(this.token.pos);
        this.reportSyntaxError(this.token.pos, "expected2", Tokens.TokenKind.LPAREN, Tokens.TokenKind.LBRACKET);
        t = this.toP(this.F.at(newpos).NewClass(null, typeArgs, t, List.nil(), null));
        return this.toP(this.F.at(newpos).Erroneous(List.of(t)));
    }

    JCTree.JCExpression innerCreator(int newpos, List<JCTree.JCExpression> typeArgs, JCTree.JCExpression encl) {
        List<JCTree.JCAnnotation> newAnnotations = this.typeAnnotationsOpt();
        JCTree.JCExpression t = this.toP(this.F.at(this.token.pos).Ident(this.ident()));
        if (newAnnotations.nonEmpty()) {
            t = this.toP(this.F.at(((JCTree.JCAnnotation)newAnnotations.head).pos).AnnotatedType(newAnnotations, t));
        }
        if (this.token.kind == Tokens.TokenKind.LT) {
            int oldmode = this.mode;
            this.checkGenerics();
            t = this.typeArguments(t, true);
            this.mode = oldmode;
        }
        return this.classCreatorRest(newpos, encl, typeArgs, t);
    }

    JCTree.JCExpression arrayCreatorRest(int newpos, JCTree.JCExpression elemtype) {
        List<JCTree.JCAnnotation> annos = this.typeAnnotationsOpt();
        this.accept(Tokens.TokenKind.LBRACKET);
        if (this.token.kind == Tokens.TokenKind.RBRACKET) {
            this.accept(Tokens.TokenKind.RBRACKET);
            elemtype = this.bracketsOpt(elemtype, annos);
            if (this.token.kind == Tokens.TokenKind.LBRACE) {
                JCTree.JCNewArray na = (JCTree.JCNewArray)this.arrayInitializer(newpos, elemtype);
                if (annos.nonEmpty()) {
                    JCTree.JCAnnotatedType annotated = (JCTree.JCAnnotatedType)elemtype;
                    assert (annotated.annotations == annos);
                    na.annotations = annotated.annotations;
                    na.elemtype = annotated.underlyingType;
                }
                return na;
            }
            JCTree.JCExpression t = this.toP(this.F.at(newpos).NewArray(elemtype, List.nil(), null));
            return this.syntaxError(this.token.pos, List.of(t), "array.dimension.missing", new Tokens.TokenKind[0]);
        }
        ListBuffer<JCTree.JCExpression> dims = new ListBuffer<JCTree.JCExpression>();
        ListBuffer<List<JCTree.JCAnnotation>> dimAnnotations = new ListBuffer<List<JCTree.JCAnnotation>>();
        dimAnnotations.append(annos);
        dims.append(this.parseExpression());
        this.accept(Tokens.TokenKind.RBRACKET);
        while (this.token.kind == Tokens.TokenKind.LBRACKET || this.token.kind == Tokens.TokenKind.MONKEYS_AT) {
            List<JCTree.JCAnnotation> maybeDimAnnos = this.typeAnnotationsOpt();
            int pos = this.token.pos;
            this.nextToken();
            if (this.token.kind == Tokens.TokenKind.RBRACKET) {
                elemtype = this.bracketsOptCont(elemtype, pos, maybeDimAnnos);
                continue;
            }
            if (this.token.kind == Tokens.TokenKind.RBRACKET) {
                elemtype = this.bracketsOptCont(elemtype, pos, maybeDimAnnos);
                continue;
            }
            dimAnnotations.append(maybeDimAnnos);
            dims.append(this.parseExpression());
            this.accept(Tokens.TokenKind.RBRACKET);
        }
        JCTree.JCNewArray na = this.toP(this.F.at(newpos).NewArray(elemtype, dims.toList(), null));
        na.dimAnnotations = dimAnnotations.toList();
        return na;
    }

    JCTree.JCNewClass classCreatorRest(int newpos, JCTree.JCExpression encl, List<JCTree.JCExpression> typeArgs, JCTree.JCExpression t) {
        List<JCTree.JCExpression> args = this.arguments();
        JCTree.JCClassDecl body = null;
        if (this.token.kind == Tokens.TokenKind.LBRACE) {
            int pos = this.token.pos;
            List<JCTree> defs = this.classOrInterfaceBody(this.names.empty, false);
            JCTree.JCModifiers mods = this.F.at(-1).Modifiers(0L);
            body = this.toP(this.F.at(pos).AnonymousClassDef(mods, defs));
        }
        return this.toP(this.F.at(newpos).NewClass(encl, typeArgs, t, args, body));
    }

    JCTree.JCExpression arrayInitializer(int newpos, JCTree.JCExpression t) {
        this.accept(Tokens.TokenKind.LBRACE);
        ListBuffer<JCTree.JCExpression> elems = new ListBuffer<JCTree.JCExpression>();
        if (this.token.kind == Tokens.TokenKind.COMMA) {
            this.nextToken();
        } else if (this.token.kind != Tokens.TokenKind.RBRACE) {
            elems.append(this.variableInitializer());
            while (this.token.kind == Tokens.TokenKind.COMMA) {
                this.nextToken();
                if (this.token.kind == Tokens.TokenKind.RBRACE) break;
                elems.append(this.variableInitializer());
            }
        }
        this.accept(Tokens.TokenKind.RBRACE);
        return this.toP(this.F.at(newpos).NewArray(t, List.nil(), elems.toList()));
    }

    public JCTree.JCExpression variableInitializer() {
        return this.token.kind == Tokens.TokenKind.LBRACE ? this.arrayInitializer(this.token.pos, null) : this.parseExpression();
    }

    JCTree.JCExpression parExpression() {
        int pos = this.token.pos;
        this.accept(Tokens.TokenKind.LPAREN);
        JCTree.JCExpression t = this.parseExpression();
        this.accept(Tokens.TokenKind.RPAREN);
        return this.toP(this.F.at(pos).Parens(t));
    }

    JCTree.JCBlock block(int pos, long flags) {
        this.accept(Tokens.TokenKind.LBRACE);
        List<JCTree.JCStatement> stats = this.blockStatements();
        JCTree.JCBlock t = this.F.at(pos).Block(flags, stats);
        while (this.token.kind == Tokens.TokenKind.CASE || this.token.kind == Tokens.TokenKind.DEFAULT) {
            this.syntaxError("orphaned", this.token.kind);
            this.switchBlockStatementGroups();
        }
        t.endpos = this.token.pos;
        this.accept(Tokens.TokenKind.RBRACE);
        return this.toP(t);
    }

    public JCTree.JCBlock block() {
        return this.block(this.token.pos, 0L);
    }

    List<JCTree.JCStatement> blockStatements() {
        ListBuffer<JCTree.JCStatement> stats = new ListBuffer<JCTree.JCStatement>();
        List<JCTree.JCStatement> stat;
        while (!(stat = this.blockStatement()).isEmpty()) {
            if (this.token.pos <= this.endPosTable.errorEndPos) {
                this.skip(false, true, true, true);
            }
            stats.addAll((Collection<JCTree.JCStatement>)stat);
        }
        return stats.toList();
    }

    JCTree.JCStatement parseStatementAsBlock() {
        int pos = this.token.pos;
        List<JCTree.JCStatement> stats = this.blockStatement();
        if (stats.isEmpty()) {
            JCTree.JCErroneous e = this.F.at(pos).Erroneous();
            this.error(e, "illegal.start.of.stmt", new Object[0]);
            return this.F.at(pos).Exec(e);
        }
        JCTree.JCStatement first = (JCTree.JCStatement)stats.head;
        String error = null;
        switch (first.getTag()) {
            case CLASSDEF: {
                error = "class.not.allowed";
                break;
            }
            case VARDEF: {
                error = "variable.not.allowed";
            }
        }
        if (error != null) {
            this.error(first, error, new Object[0]);
            List<JCTree.JCBlock> blist = List.of(this.F.at(first.pos).Block(0L, stats));
            return this.toP(this.F.at(pos).Exec(this.F.at(first.pos).Erroneous(blist)));
        }
        return first;
    }

    List<JCTree.JCStatement> blockStatement() {
        int pos = this.token.pos;
        switch (this.token.kind) {
            case EOF: 
            case RBRACE: 
            case CASE: 
            case DEFAULT: {
                return List.nil();
            }
            case SEMI: 
            case LBRACE: 
            case SYNCHRONIZED: 
            case IF: 
            case FOR: 
            case WHILE: 
            case DO: 
            case TRY: 
            case SWITCH: 
            case RETURN: 
            case THROW: 
            case BREAK: 
            case CONTINUE: 
            case ELSE: 
            case FINALLY: 
            case CATCH: {
                return List.of(this.parseStatement());
            }
            case FINAL: 
            case MONKEYS_AT: {
                Tokens.Comment dc = this.token.comment(Tokens.Comment.CommentStyle.JAVADOC);
                JCTree.JCModifiers mods = this.modifiersOpt();
                if (this.token.kind == Tokens.TokenKind.INTERFACE || this.token.kind == Tokens.TokenKind.CLASS || this.allowEnums && this.token.kind == Tokens.TokenKind.ENUM) {
                    return List.of(this.classOrInterfaceOrEnumDeclaration(mods, dc));
                }
                JCTree.JCExpression t = this.parseType();
                ListBuffer stats = this.variableDeclarators(mods, t, new ListBuffer());
                this.storeEnd((JCTree)stats.last(), this.token.endPos);
                this.accept(Tokens.TokenKind.SEMI);
                return stats.toList();
            }
            case ABSTRACT: 
            case STRICTFP: {
                Tokens.Comment dc = this.token.comment(Tokens.Comment.CommentStyle.JAVADOC);
                JCTree.JCModifiers mods = this.modifiersOpt();
                return List.of(this.classOrInterfaceOrEnumDeclaration(mods, dc));
            }
            case CLASS: 
            case INTERFACE: {
                Tokens.Comment dc = this.token.comment(Tokens.Comment.CommentStyle.JAVADOC);
                return List.of(this.classOrInterfaceOrEnumDeclaration(this.modifiersOpt(), dc));
            }
            case ENUM: 
            case ASSERT: {
                if (this.allowEnums && this.token.kind == Tokens.TokenKind.ENUM) {
                    this.error(this.token.pos, "local.enum", new Object[0]);
                    Tokens.Comment dc = this.token.comment(Tokens.Comment.CommentStyle.JAVADOC);
                    return List.of(this.classOrInterfaceOrEnumDeclaration(this.modifiersOpt(), dc));
                }
                if (!this.allowAsserts || this.token.kind != Tokens.TokenKind.ASSERT) break;
                return List.of(this.parseStatement());
            }
        }
        Tokens.Token prevToken = this.token;
        JCTree.JCExpression t = this.term(3);
        if (this.token.kind == Tokens.TokenKind.COLON && t.hasTag(JCTree.Tag.IDENT)) {
            this.nextToken();
            JCTree.JCStatement stat = this.parseStatement();
            return List.of(this.F.at(pos).Labelled(prevToken.name(), stat));
        }
        if ((this.lastmode & 2) != 0 && this.LAX_IDENTIFIER.accepts(this.token.kind)) {
            pos = this.token.pos;
            JCTree.JCModifiers mods = this.F.at(-1).Modifiers(0L);
            this.F.at(pos);
            ListBuffer stats = this.variableDeclarators(mods, t, new ListBuffer());
            this.storeEnd((JCTree)stats.last(), this.token.endPos);
            this.accept(Tokens.TokenKind.SEMI);
            return stats.toList();
        }
        JCTree.JCExpressionStatement expr = this.to(this.F.at(pos).Exec(this.checkExprStat(t)));
        this.accept(Tokens.TokenKind.SEMI);
        return List.of(expr);
    }

    @Override
    public JCTree.JCStatement parseStatement() {
        int pos = this.token.pos;
        switch (this.token.kind) {
            case LBRACE: {
                return this.block();
            }
            case IF: {
                this.nextToken();
                JCTree.JCExpression cond = this.parExpression();
                JCTree.JCStatement thenpart = this.parseStatementAsBlock();
                JCTree.JCStatement elsepart = null;
                if (this.token.kind == Tokens.TokenKind.ELSE) {
                    this.nextToken();
                    elsepart = this.parseStatementAsBlock();
                }
                return this.F.at(pos).If(cond, thenpart, elsepart);
            }
            case FOR: {
                List<Object> inits;
                this.nextToken();
                this.accept(Tokens.TokenKind.LPAREN);
                List<Object> list = inits = this.token.kind == Tokens.TokenKind.SEMI ? List.nil() : this.forInit();
                if (inits.length() == 1 && ((JCTree.JCStatement)inits.head).hasTag(JCTree.Tag.VARDEF) && ((JCTree.JCVariableDecl)inits.head).init == null && this.token.kind == Tokens.TokenKind.COLON) {
                    this.checkForeach();
                    JCTree.JCVariableDecl var = (JCTree.JCVariableDecl)inits.head;
                    this.accept(Tokens.TokenKind.COLON);
                    JCTree.JCExpression expr = this.parseExpression();
                    this.accept(Tokens.TokenKind.RPAREN);
                    JCTree.JCStatement body = this.parseStatementAsBlock();
                    return this.F.at(pos).ForeachLoop(var, expr, body);
                }
                this.accept(Tokens.TokenKind.SEMI);
                JCTree.JCExpression cond = this.token.kind == Tokens.TokenKind.SEMI ? null : this.parseExpression();
                this.accept(Tokens.TokenKind.SEMI);
                List<JCTree.JCExpressionStatement> steps = this.token.kind == Tokens.TokenKind.RPAREN ? List.nil() : this.forUpdate();
                this.accept(Tokens.TokenKind.RPAREN);
                JCTree.JCStatement body = this.parseStatementAsBlock();
                return this.F.at(pos).ForLoop(inits, cond, steps, body);
            }
            case WHILE: {
                this.nextToken();
                JCTree.JCExpression cond = this.parExpression();
                JCTree.JCStatement body = this.parseStatementAsBlock();
                return this.F.at(pos).WhileLoop(cond, body);
            }
            case DO: {
                this.nextToken();
                JCTree.JCStatement body = this.parseStatementAsBlock();
                this.accept(Tokens.TokenKind.WHILE);
                JCTree.JCExpression cond = this.parExpression();
                JCTree.JCDoWhileLoop t = this.to(this.F.at(pos).DoLoop(body, cond));
                this.accept(Tokens.TokenKind.SEMI);
                return t;
            }
            case TRY: {
                this.nextToken();
                List<Object> resources = List.nil();
                if (this.token.kind == Tokens.TokenKind.LPAREN) {
                    this.checkTryWithResources();
                    this.nextToken();
                    resources = this.resources();
                    this.accept(Tokens.TokenKind.RPAREN);
                }
                JCTree.JCBlock body = this.block();
                ListBuffer<JCTree.JCCatch> catchers = new ListBuffer<JCTree.JCCatch>();
                JCTree.JCBlock finalizer = null;
                if (this.token.kind == Tokens.TokenKind.CATCH || this.token.kind == Tokens.TokenKind.FINALLY) {
                    while (this.token.kind == Tokens.TokenKind.CATCH) {
                        catchers.append(this.catchClause());
                    }
                    if (this.token.kind == Tokens.TokenKind.FINALLY) {
                        this.nextToken();
                        finalizer = this.block();
                    }
                } else if (this.allowTWR) {
                    if (resources.isEmpty()) {
                        this.error(pos, "try.without.catch.finally.or.resource.decls", new Object[0]);
                    }
                } else {
                    this.error(pos, "try.without.catch.or.finally", new Object[0]);
                }
                return this.F.at(pos).Try(resources, body, catchers.toList(), finalizer);
            }
            case SWITCH: {
                this.nextToken();
                JCTree.JCExpression selector = this.parExpression();
                this.accept(Tokens.TokenKind.LBRACE);
                List<JCTree.JCCase> cases = this.switchBlockStatementGroups();
                JCTree.JCSwitch t = this.to(this.F.at(pos).Switch(selector, cases));
                this.accept(Tokens.TokenKind.RBRACE);
                return t;
            }
            case SYNCHRONIZED: {
                this.nextToken();
                JCTree.JCExpression lock = this.parExpression();
                JCTree.JCBlock body = this.block();
                return this.F.at(pos).Synchronized(lock, body);
            }
            case RETURN: {
                this.nextToken();
                JCTree.JCExpression result = this.token.kind == Tokens.TokenKind.SEMI ? null : this.parseExpression();
                JCTree.JCReturn t = this.to(this.F.at(pos).Return(result));
                this.accept(Tokens.TokenKind.SEMI);
                return t;
            }
            case THROW: {
                this.nextToken();
                JCTree.JCExpression exc = this.parseExpression();
                JCTree.JCThrow t = this.to(this.F.at(pos).Throw(exc));
                this.accept(Tokens.TokenKind.SEMI);
                return t;
            }
            case BREAK: {
                this.nextToken();
                Name label = this.LAX_IDENTIFIER.accepts(this.token.kind) ? this.ident() : null;
                JCTree.JCBreak t = this.to(this.F.at(pos).Break(label));
                this.accept(Tokens.TokenKind.SEMI);
                return t;
            }
            case CONTINUE: {
                this.nextToken();
                Name label = this.LAX_IDENTIFIER.accepts(this.token.kind) ? this.ident() : null;
                JCTree.JCContinue t = this.to(this.F.at(pos).Continue(label));
                this.accept(Tokens.TokenKind.SEMI);
                return t;
            }
            case SEMI: {
                this.nextToken();
                return this.toP(this.F.at(pos).Skip());
            }
            case ELSE: {
                int elsePos = this.token.pos;
                this.nextToken();
                return this.doRecover(elsePos, BasicErrorRecoveryAction.BLOCK_STMT, "else.without.if");
            }
            case FINALLY: {
                int finallyPos = this.token.pos;
                this.nextToken();
                return this.doRecover(finallyPos, BasicErrorRecoveryAction.BLOCK_STMT, "finally.without.try");
            }
            case CATCH: {
                return this.doRecover(this.token.pos, BasicErrorRecoveryAction.CATCH_CLAUSE, "catch.without.try");
            }
            case ASSERT: {
                if (!this.allowAsserts || this.token.kind != Tokens.TokenKind.ASSERT) break;
                this.nextToken();
                JCTree.JCExpression assertion = this.parseExpression();
                JCTree.JCExpression message = null;
                if (this.token.kind == Tokens.TokenKind.COLON) {
                    this.nextToken();
                    message = this.parseExpression();
                }
                JCTree.JCAssert t = this.to(this.F.at(pos).Assert(assertion, message));
                this.accept(Tokens.TokenKind.SEMI);
                return t;
            }
        }
        Tokens.Token prevToken = this.token;
        JCTree.JCExpression expr = this.parseExpression();
        if (this.token.kind == Tokens.TokenKind.COLON && expr.hasTag(JCTree.Tag.IDENT)) {
            this.nextToken();
            JCTree.JCStatement stat = this.parseStatement();
            return this.F.at(pos).Labelled(prevToken.name(), stat);
        }
        JCTree.JCExpressionStatement stat = this.to(this.F.at(pos).Exec(this.checkExprStat(expr)));
        this.accept(Tokens.TokenKind.SEMI);
        return stat;
    }

    private JCTree.JCStatement doRecover(int startPos, ErrorRecoveryAction action, String key) {
        int errPos = this.S.errPos();
        JCTree stm = action.doRecover(this);
        this.S.errPos(errPos);
        return this.toP(this.F.Exec(this.syntaxError(startPos, List.of(stm), key, new Tokens.TokenKind[0])));
    }

    protected JCTree.JCCatch catchClause() {
        int pos = this.token.pos;
        this.accept(Tokens.TokenKind.CATCH);
        this.accept(Tokens.TokenKind.LPAREN);
        JCTree.JCModifiers mods = this.optFinal(0x200000000L);
        List<JCTree.JCExpression> catchTypes = this.catchTypes();
        JCTree.JCExpression paramType = catchTypes.size() > 1 ? (JCTree.JCExpression)this.toP(this.F.at(((JCTree.JCExpression)catchTypes.head).getStartPosition()).TypeUnion(catchTypes)) : (JCTree.JCExpression)catchTypes.head;
        JCTree.JCVariableDecl formal = this.variableDeclaratorId(mods, paramType);
        this.accept(Tokens.TokenKind.RPAREN);
        JCTree.JCBlock body = this.block();
        return this.F.at(pos).Catch(formal, body);
    }

    List<JCTree.JCExpression> catchTypes() {
        ListBuffer<JCTree.JCExpression> catchTypes = new ListBuffer<JCTree.JCExpression>();
        catchTypes.add(this.parseType());
        while (this.token.kind == Tokens.TokenKind.BAR) {
            this.checkMulticatch();
            this.nextToken();
            catchTypes.add(this.parseType());
        }
        return catchTypes.toList();
    }

    List<JCTree.JCCase> switchBlockStatementGroups() {
        ListBuffer<JCTree.JCCase> cases = new ListBuffer<JCTree.JCCase>();
        block4: while (true) {
            int pos = this.token.pos;
            switch (this.token.kind) {
                case CASE: 
                case DEFAULT: {
                    cases.append(this.switchBlockStatementGroup());
                    continue block4;
                }
                case EOF: 
                case RBRACE: {
                    return cases.toList();
                }
            }
            this.nextToken();
            this.syntaxError(pos, "expected3", Tokens.TokenKind.CASE, Tokens.TokenKind.DEFAULT, Tokens.TokenKind.RBRACE);
        }
    }

    protected JCTree.JCCase switchBlockStatementGroup() {
        int pos = this.token.pos;
        switch (this.token.kind) {
            case CASE: {
                this.nextToken();
                JCTree.JCExpression pat = this.parseExpression();
                this.accept(Tokens.TokenKind.COLON);
                List<JCTree.JCStatement> stats = this.blockStatements();
                JCTree.JCCase c = this.F.at(pos).Case(pat, stats);
                if (stats.isEmpty()) {
                    this.storeEnd(c, this.S.prevToken().endPos);
                }
                return c;
            }
            case DEFAULT: {
                this.nextToken();
                this.accept(Tokens.TokenKind.COLON);
                List<JCTree.JCStatement> stats = this.blockStatements();
                JCTree.JCCase c = this.F.at(pos).Case(null, stats);
                if (stats.isEmpty()) {
                    this.storeEnd(c, this.S.prevToken().endPos);
                }
                return c;
            }
        }
        throw new AssertionError((Object)"should not reach here");
    }

    <T extends ListBuffer<? super JCTree.JCExpressionStatement>> T moreStatementExpressions(int pos, JCTree.JCExpression first, T stats) {
        stats.append((JCTree.JCExpressionStatement)this.toP(this.F.at(pos).Exec(this.checkExprStat(first))));
        while (this.token.kind == Tokens.TokenKind.COMMA) {
            this.nextToken();
            pos = this.token.pos;
            JCTree.JCExpression t = this.parseExpression();
            stats.append((JCTree.JCExpressionStatement)this.toP(this.F.at(pos).Exec(this.checkExprStat(t))));
        }
        return stats;
    }

    List<JCTree.JCStatement> forInit() {
        ListBuffer stats = new ListBuffer();
        int pos = this.token.pos;
        if (this.token.kind == Tokens.TokenKind.FINAL || this.token.kind == Tokens.TokenKind.MONKEYS_AT) {
            return this.variableDeclarators(this.optFinal(0L), this.parseType(), stats).toList();
        }
        JCTree.JCExpression t = this.term(3);
        if ((this.lastmode & 2) != 0 && this.LAX_IDENTIFIER.accepts(this.token.kind)) {
            return this.variableDeclarators(this.mods(pos, 0L, List.nil()), t, stats).toList();
        }
        if ((this.lastmode & 2) != 0 && this.token.kind == Tokens.TokenKind.COLON) {
            this.error(pos, "bad.initializer", "for-loop");
            return List.of(this.F.at(pos).VarDef(null, null, t, null));
        }
        return this.moreStatementExpressions(pos, t, stats).toList();
    }

    List<JCTree.JCExpressionStatement> forUpdate() {
        return this.moreStatementExpressions(this.token.pos, this.parseExpression(), new ListBuffer()).toList();
    }

    List<JCTree.JCAnnotation> annotationsOpt(JCTree.Tag kind) {
        if (this.token.kind != Tokens.TokenKind.MONKEYS_AT) {
            return List.nil();
        }
        ListBuffer<JCTree.JCAnnotation> buf = new ListBuffer<JCTree.JCAnnotation>();
        int prevmode = this.mode;
        while (this.token.kind == Tokens.TokenKind.MONKEYS_AT) {
            int pos = this.token.pos;
            this.nextToken();
            buf.append(this.annotation(pos, kind));
        }
        this.lastmode = this.mode;
        this.mode = prevmode;
        List<JCTree.JCAnnotation> annotations = buf.toList();
        return annotations;
    }

    List<JCTree.JCAnnotation> typeAnnotationsOpt() {
        List<JCTree.JCAnnotation> annotations = this.annotationsOpt(JCTree.Tag.TYPE_ANNOTATION);
        return annotations;
    }

    JCTree.JCModifiers modifiersOpt() {
        return this.modifiersOpt(null);
    }

    protected JCTree.JCModifiers modifiersOpt(JCTree.JCModifiers partial) {
        int pos;
        long flags;
        ListBuffer<JCTree.JCAnnotation> annotations = new ListBuffer<JCTree.JCAnnotation>();
        if (partial == null) {
            flags = 0L;
            pos = this.token.pos;
        } else {
            flags = partial.flags;
            annotations.appendList(partial.annotations);
            pos = partial.pos;
        }
        if (this.token.deprecatedFlag()) {
            flags |= 0x20000L;
        }
        block20: while (true) {
            long flag;
            switch (this.token.kind) {
                case PRIVATE: {
                    flag = 2L;
                    break;
                }
                case PROTECTED: {
                    flag = 4L;
                    break;
                }
                case PUBLIC: {
                    flag = 1L;
                    break;
                }
                case STATIC: {
                    flag = 8L;
                    break;
                }
                case TRANSIENT: {
                    flag = 128L;
                    break;
                }
                case FINAL: {
                    flag = 16L;
                    break;
                }
                case ABSTRACT: {
                    flag = 1024L;
                    break;
                }
                case NATIVE: {
                    flag = 256L;
                    break;
                }
                case VOLATILE: {
                    flag = 64L;
                    break;
                }
                case SYNCHRONIZED: {
                    flag = 32L;
                    break;
                }
                case STRICTFP: {
                    flag = 2048L;
                    break;
                }
                case MONKEYS_AT: {
                    flag = 8192L;
                    break;
                }
                case DEFAULT: {
                    this.checkDefaultMethods();
                    flag = 0x80000000000L;
                    break;
                }
                case ERROR: {
                    flag = 0L;
                    this.nextToken();
                    break;
                }
                default: {
                    break block20;
                }
            }
            if ((flags & flag) != 0L) {
                this.error(this.token.pos, "repeated.modifier", new Object[0]);
            }
            int lastPos = this.token.pos;
            this.nextToken();
            if (flag == 8192L) {
                this.checkAnnotations();
                if (this.token.kind != Tokens.TokenKind.INTERFACE) {
                    JCTree.JCAnnotation ann = this.annotation(lastPos, JCTree.Tag.ANNOTATION);
                    if (flags == 0L && annotations.isEmpty()) {
                        pos = ann.pos;
                    }
                    annotations.append(ann);
                    flag = 0L;
                }
            }
            flags |= flag;
        }
        switch (this.token.kind) {
            case ENUM: {
                flags |= 0x4000L;
                break;
            }
            case INTERFACE: {
                flags |= 0x200L;
                break;
            }
        }
        return this.mods(pos, flags, annotations.toList());
    }

    JCTree.JCModifiers mods(int pos, long flags, List<JCTree.JCAnnotation> annotations) {
        if ((flags & 0x80000002DFFL) == 0L && annotations.isEmpty()) {
            pos = -1;
        }
        JCTree.JCModifiers mods = this.F.at(pos).Modifiers(flags, annotations);
        if (pos != -1) {
            this.storeEnd(mods, this.S.prevToken().endPos);
        }
        return mods;
    }

    JCTree.JCAnnotation annotation(int pos, JCTree.Tag kind) {
        JCTree.JCAnnotation ann;
        this.checkAnnotations();
        if (kind == JCTree.Tag.TYPE_ANNOTATION) {
            this.checkTypeAnnotations();
        }
        JCTree.JCExpression ident = this.qualident(false);
        List<JCTree.JCExpression> fieldValues = this.annotationFieldValuesOpt();
        if (kind == JCTree.Tag.ANNOTATION) {
            ann = this.F.at(pos).Annotation(ident, fieldValues);
        } else if (kind == JCTree.Tag.TYPE_ANNOTATION) {
            ann = this.F.at(pos).TypeAnnotation(ident, fieldValues);
        } else {
            throw new AssertionError((Object)("Unhandled annotation kind: " + (Object)((Object)kind)));
        }
        this.storeEnd(ann, this.S.prevToken().endPos);
        return ann;
    }

    List<JCTree.JCExpression> annotationFieldValuesOpt() {
        return this.token.kind == Tokens.TokenKind.LPAREN ? this.annotationFieldValues() : List.nil();
    }

    List<JCTree.JCExpression> annotationFieldValues() {
        this.accept(Tokens.TokenKind.LPAREN);
        ListBuffer<JCTree.JCExpression> buf = new ListBuffer<JCTree.JCExpression>();
        if (this.token.kind != Tokens.TokenKind.RPAREN) {
            buf.append(this.annotationFieldValue());
            while (this.token.kind == Tokens.TokenKind.COMMA) {
                this.nextToken();
                buf.append(this.annotationFieldValue());
            }
        }
        this.accept(Tokens.TokenKind.RPAREN);
        return buf.toList();
    }

    JCTree.JCExpression annotationFieldValue() {
        if (this.LAX_IDENTIFIER.accepts(this.token.kind)) {
            this.mode = 1;
            JCTree.JCExpression t1 = this.term1();
            if (t1.hasTag(JCTree.Tag.IDENT) && this.token.kind == Tokens.TokenKind.EQ) {
                int pos = this.token.pos;
                this.accept(Tokens.TokenKind.EQ);
                JCTree.JCExpression v = this.annotationValue();
                return this.toP(this.F.at(pos).Assign(t1, v));
            }
            return t1;
        }
        return this.annotationValue();
    }

    JCTree.JCExpression annotationValue() {
        switch (this.token.kind) {
            case MONKEYS_AT: {
                int pos = this.token.pos;
                this.nextToken();
                return this.annotation(pos, JCTree.Tag.ANNOTATION);
            }
            case LBRACE: {
                int pos = this.token.pos;
                this.accept(Tokens.TokenKind.LBRACE);
                ListBuffer<JCTree.JCExpression> buf = new ListBuffer<JCTree.JCExpression>();
                if (this.token.kind == Tokens.TokenKind.COMMA) {
                    this.nextToken();
                } else if (this.token.kind != Tokens.TokenKind.RBRACE) {
                    buf.append(this.annotationValue());
                    while (this.token.kind == Tokens.TokenKind.COMMA) {
                        this.nextToken();
                        if (this.token.kind == Tokens.TokenKind.RBRACE) break;
                        buf.append(this.annotationValue());
                    }
                }
                this.accept(Tokens.TokenKind.RBRACE);
                return this.toP(this.F.at(pos).NewArray(null, List.nil(), buf.toList()));
            }
        }
        this.mode = 1;
        return this.term1();
    }

    public <T extends ListBuffer<? super JCTree.JCVariableDecl>> T variableDeclarators(JCTree.JCModifiers mods, JCTree.JCExpression type, T vdefs) {
        return this.variableDeclaratorsRest(this.token.pos, mods, type, this.ident(), false, null, vdefs);
    }

    <T extends ListBuffer<? super JCTree.JCVariableDecl>> T variableDeclaratorsRest(int pos, JCTree.JCModifiers mods, JCTree.JCExpression type, Name name, boolean reqInit, Tokens.Comment dc, T vdefs) {
        vdefs.append((JCTree.JCVariableDecl)this.variableDeclaratorRest(pos, mods, type, name, reqInit, dc));
        while (this.token.kind == Tokens.TokenKind.COMMA) {
            this.storeEnd(vdefs.last(), this.token.endPos);
            this.nextToken();
            vdefs.append((JCTree.JCVariableDecl)this.variableDeclarator(mods, type, reqInit, dc));
        }
        return vdefs;
    }

    JCTree.JCVariableDecl variableDeclarator(JCTree.JCModifiers mods, JCTree.JCExpression type, boolean reqInit, Tokens.Comment dc) {
        return this.variableDeclaratorRest(this.token.pos, mods, type, this.ident(), reqInit, dc);
    }

    JCTree.JCVariableDecl variableDeclaratorRest(int pos, JCTree.JCModifiers mods, JCTree.JCExpression type, Name name, boolean reqInit, Tokens.Comment dc) {
        type = this.bracketsOpt(type);
        JCTree.JCExpression init = null;
        if (this.token.kind == Tokens.TokenKind.EQ) {
            this.nextToken();
            init = this.variableInitializer();
        } else if (reqInit) {
            this.syntaxError(this.token.pos, "expected", Tokens.TokenKind.EQ);
        }
        JCTree.JCVariableDecl result = this.toP(this.F.at(pos).VarDef(mods, name, type, init));
        this.attach(result, dc);
        return result;
    }

    JCTree.JCVariableDecl variableDeclaratorId(JCTree.JCModifiers mods, JCTree.JCExpression type) {
        return this.variableDeclaratorId(mods, type, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    JCTree.JCVariableDecl variableDeclaratorId(JCTree.JCModifiers mods, JCTree.JCExpression type, boolean lambdaParameter) {
        Name name;
        int pos;
        block8: {
            pos = this.token.pos;
            if (lambdaParameter && this.token.kind == Tokens.TokenKind.UNDERSCORE) {
                this.log.error(pos, "underscore.as.identifier.in.lambda", new Object[0]);
                name = this.token.name();
                this.nextToken();
            } else {
                if (this.allowThisIdent) {
                    JCTree.JCExpression pn = this.qualident(false);
                    if (pn.hasTag(JCTree.Tag.IDENT) && ((JCTree.JCIdent)pn).name != this.names._this) {
                        name = ((JCTree.JCIdent)pn).name;
                        break block8;
                    } else {
                        if ((mods.flags & 0x400000000L) != 0L) {
                            this.log.error(this.token.pos, "varargs.and.receiver", new Object[0]);
                        }
                        if (this.token.kind == Tokens.TokenKind.LBRACKET) {
                            this.log.error(this.token.pos, "array.and.receiver", new Object[0]);
                        }
                        return this.toP(this.F.at(pos).ReceiverVarDef(mods, pn, type));
                    }
                }
                name = this.ident();
            }
        }
        if ((mods.flags & 0x400000000L) != 0L && this.token.kind == Tokens.TokenKind.LBRACKET) {
            this.log.error(this.token.pos, "varargs.and.old.array.syntax", new Object[0]);
        }
        type = this.bracketsOpt(type);
        return this.toP(this.F.at(pos).VarDef(mods, name, type, null));
    }

    List<JCTree> resources() {
        ListBuffer<JCTree> defs = new ListBuffer<JCTree>();
        defs.append(this.resource());
        while (this.token.kind == Tokens.TokenKind.SEMI) {
            this.storeEnd((JCTree)defs.last(), this.token.endPos);
            int semiColonPos = this.token.pos;
            this.nextToken();
            if (this.token.kind == Tokens.TokenKind.RPAREN) break;
            defs.append(this.resource());
        }
        return defs.toList();
    }

    protected JCTree resource() {
        JCTree.JCModifiers optFinal = this.optFinal(16L);
        JCTree.JCExpression type = this.parseType();
        int pos = this.token.pos;
        Name ident = this.ident();
        return this.variableDeclaratorRest(pos, optFinal, type, ident, true, null);
    }

    @Override
    public JCTree.JCCompilationUnit parseCompilationUnit() {
        Tokens.Token firstToken = this.token;
        JCTree.JCExpression pid = null;
        JCTree.JCModifiers mods = null;
        boolean consumedToplevelDoc = false;
        boolean seenImport = false;
        boolean seenPackage = false;
        List<JCTree.JCAnnotation> packageAnnotations = List.nil();
        if (this.token.kind == Tokens.TokenKind.MONKEYS_AT) {
            mods = this.modifiersOpt();
        }
        if (this.token.kind == Tokens.TokenKind.PACKAGE) {
            seenPackage = true;
            if (mods != null) {
                this.checkNoMods(mods.flags);
                packageAnnotations = mods.annotations;
                mods = null;
            }
            this.nextToken();
            pid = this.qualident(false);
            this.accept(Tokens.TokenKind.SEMI);
        }
        ListBuffer<JCTree> defs = new ListBuffer<JCTree>();
        boolean checkForImports = true;
        boolean firstTypeDecl = true;
        while (this.token.kind != Tokens.TokenKind.EOF) {
            JCTree def;
            if (this.token.pos > 0 && this.token.pos <= this.endPosTable.errorEndPos) {
                this.skip(checkForImports, false, false, false);
                if (this.token.kind == Tokens.TokenKind.EOF) break;
            }
            if (checkForImports && mods == null && this.token.kind == Tokens.TokenKind.IMPORT) {
                seenImport = true;
                defs.append(this.importDeclaration());
                continue;
            }
            Tokens.Comment docComment = this.token.comment(Tokens.Comment.CommentStyle.JAVADOC);
            if (firstTypeDecl && !seenImport && !seenPackage) {
                docComment = firstToken.comment(Tokens.Comment.CommentStyle.JAVADOC);
                consumedToplevelDoc = true;
            }
            if ((def = this.typeDeclaration(mods, docComment)) instanceof JCTree.JCExpressionStatement) {
                def = ((JCTree.JCExpressionStatement)def).expr;
            }
            defs.append(def);
            if (def instanceof JCTree.JCClassDecl) {
                checkForImports = false;
            }
            mods = null;
            firstTypeDecl = false;
        }
        JCTree.JCCompilationUnit toplevel = this.F.at(firstToken.pos).TopLevel(packageAnnotations, pid, defs.toList());
        if (!consumedToplevelDoc) {
            this.attach(toplevel, firstToken.comment(Tokens.Comment.CommentStyle.JAVADOC));
        }
        if (defs.isEmpty()) {
            this.storeEnd(toplevel, this.S.prevToken().endPos);
        }
        if (this.keepDocComments) {
            toplevel.docComments = this.docComments;
        }
        if (this.keepLineMap) {
            toplevel.lineMap = this.S.getLineMap();
        }
        this.endPosTable.setParser(null);
        toplevel.endPositions = this.endPosTable;
        return toplevel;
    }

    JCTree importDeclaration() {
        int pos = this.token.pos;
        this.nextToken();
        boolean importStatic = false;
        if (this.token.kind == Tokens.TokenKind.STATIC) {
            this.checkStaticImports();
            importStatic = true;
            this.nextToken();
        }
        JCTree.JCExpression pid = this.toP(this.F.at(this.token.pos).Ident(this.ident()));
        do {
            int pos1 = this.token.pos;
            this.accept(Tokens.TokenKind.DOT);
            if (this.token.kind == Tokens.TokenKind.STAR) {
                pid = this.to(this.F.at(pos1).Select(pid, this.names.asterisk));
                this.nextToken();
                break;
            }
            pid = this.toP(this.F.at(pos1).Select(pid, this.ident()));
        } while (this.token.kind == Tokens.TokenKind.DOT);
        this.accept(Tokens.TokenKind.SEMI);
        return this.toP(this.F.at(pos).Import(pid, importStatic));
    }

    JCTree typeDeclaration(JCTree.JCModifiers mods, Tokens.Comment docComment) {
        int pos = this.token.pos;
        if (mods == null && this.token.kind == Tokens.TokenKind.SEMI) {
            this.nextToken();
            return this.toP(this.F.at(pos).Skip());
        }
        return this.classOrInterfaceOrEnumDeclaration(this.modifiersOpt(mods), docComment);
    }

    JCTree.JCStatement classOrInterfaceOrEnumDeclaration(JCTree.JCModifiers mods, Tokens.Comment dc) {
        List<JCTree> errs;
        if (this.token.kind == Tokens.TokenKind.CLASS) {
            return this.classDeclaration(mods, dc);
        }
        if (this.token.kind == Tokens.TokenKind.INTERFACE) {
            return this.interfaceDeclaration(mods, dc);
        }
        if (this.allowEnums) {
            List<JCTree> errs2;
            if (this.token.kind == Tokens.TokenKind.ENUM) {
                return this.enumDeclaration(mods, dc);
            }
            int pos = this.token.pos;
            if (this.LAX_IDENTIFIER.accepts(this.token.kind)) {
                errs2 = List.of(mods, this.toP(this.F.at(pos).Ident(this.ident())));
                this.setErrorEndPos(this.token.pos);
            } else {
                errs2 = List.of(mods);
            }
            return this.toP(this.F.Exec(this.syntaxError(pos, errs2, "expected3", Tokens.TokenKind.CLASS, Tokens.TokenKind.INTERFACE, Tokens.TokenKind.ENUM)));
        }
        if (this.token.kind == Tokens.TokenKind.ENUM) {
            this.error(this.token.pos, "enums.not.supported.in.source", this.source.name);
            this.allowEnums = true;
            return this.enumDeclaration(mods, dc);
        }
        int pos = this.token.pos;
        if (this.LAX_IDENTIFIER.accepts(this.token.kind)) {
            errs = List.of(mods, this.toP(this.F.at(pos).Ident(this.ident())));
            this.setErrorEndPos(this.token.pos);
        } else {
            errs = List.of(mods);
        }
        return this.toP(this.F.Exec(this.syntaxError(pos, errs, "expected2", Tokens.TokenKind.CLASS, Tokens.TokenKind.INTERFACE)));
    }

    protected JCTree.JCClassDecl classDeclaration(JCTree.JCModifiers mods, Tokens.Comment dc) {
        int pos = this.token.pos;
        this.accept(Tokens.TokenKind.CLASS);
        Name name = this.ident();
        List<JCTree.JCTypeParameter> typarams = this.typeParametersOpt();
        JCTree.JCExpression extending = null;
        if (this.token.kind == Tokens.TokenKind.EXTENDS) {
            this.nextToken();
            extending = this.parseType();
        }
        List<JCTree.JCExpression> implementing = List.nil();
        if (this.token.kind == Tokens.TokenKind.IMPLEMENTS) {
            this.nextToken();
            implementing = this.typeList();
        }
        List<JCTree> defs = this.classOrInterfaceBody(name, false);
        JCTree.JCClassDecl result = this.toP(this.F.at(pos).ClassDef(mods, name, typarams, extending, implementing, defs));
        this.attach(result, dc);
        return result;
    }

    protected JCTree.JCClassDecl interfaceDeclaration(JCTree.JCModifiers mods, Tokens.Comment dc) {
        int pos = this.token.pos;
        this.accept(Tokens.TokenKind.INTERFACE);
        Name name = this.ident();
        List<JCTree.JCTypeParameter> typarams = this.typeParametersOpt();
        List<JCTree.JCExpression> extending = List.nil();
        if (this.token.kind == Tokens.TokenKind.EXTENDS) {
            this.nextToken();
            extending = this.typeList();
        }
        List<JCTree> defs = this.classOrInterfaceBody(name, true);
        JCTree.JCClassDecl result = this.toP(this.F.at(pos).ClassDef(mods, name, typarams, null, extending, defs));
        this.attach(result, dc);
        return result;
    }

    protected JCTree.JCClassDecl enumDeclaration(JCTree.JCModifiers mods, Tokens.Comment dc) {
        int pos = this.token.pos;
        this.accept(Tokens.TokenKind.ENUM);
        Name name = this.ident();
        List<JCTree.JCExpression> implementing = List.nil();
        if (this.token.kind == Tokens.TokenKind.IMPLEMENTS) {
            this.nextToken();
            implementing = this.typeList();
        }
        List<JCTree> defs = this.enumBody(name);
        mods.flags |= 0x4000L;
        JCTree.JCClassDecl result = this.toP(this.F.at(pos).ClassDef(mods, name, List.nil(), null, implementing, defs));
        this.attach(result, dc);
        return result;
    }

    List<JCTree> enumBody(Name enumName) {
        this.accept(Tokens.TokenKind.LBRACE);
        ListBuffer<JCTree> defs = new ListBuffer<JCTree>();
        if (this.token.kind == Tokens.TokenKind.COMMA) {
            this.nextToken();
        } else if (this.token.kind != Tokens.TokenKind.RBRACE && this.token.kind != Tokens.TokenKind.SEMI) {
            defs.append(this.enumeratorDeclaration(enumName));
            while (this.token.kind == Tokens.TokenKind.COMMA) {
                this.nextToken();
                if (this.token.kind == Tokens.TokenKind.RBRACE || this.token.kind == Tokens.TokenKind.SEMI) break;
                defs.append(this.enumeratorDeclaration(enumName));
            }
            if (this.token.kind != Tokens.TokenKind.SEMI && this.token.kind != Tokens.TokenKind.RBRACE) {
                defs.append(this.syntaxError(this.token.pos, "expected3", Tokens.TokenKind.COMMA, Tokens.TokenKind.RBRACE, Tokens.TokenKind.SEMI));
                this.nextToken();
            }
        }
        if (this.token.kind == Tokens.TokenKind.SEMI) {
            this.nextToken();
            while (this.token.kind != Tokens.TokenKind.RBRACE && this.token.kind != Tokens.TokenKind.EOF) {
                defs.appendList(this.classOrInterfaceBodyDeclaration(enumName, false));
                if (this.token.pos > this.endPosTable.errorEndPos) continue;
                this.skip(false, true, true, false);
            }
        }
        this.accept(Tokens.TokenKind.RBRACE);
        return defs.toList();
    }

    JCTree enumeratorDeclaration(Name enumName) {
        Tokens.Comment dc = this.token.comment(Tokens.Comment.CommentStyle.JAVADOC);
        int flags = 16409;
        if (this.token.deprecatedFlag()) {
            flags |= 0x20000;
        }
        int pos = this.token.pos;
        List<JCTree.JCAnnotation> annotations = this.annotationsOpt(JCTree.Tag.ANNOTATION);
        JCTree.JCModifiers mods = this.F.at(annotations.isEmpty() ? -1 : pos).Modifiers(flags, annotations);
        List<JCTree.JCExpression> typeArgs = this.typeArgumentsOpt();
        int identPos = this.token.pos;
        Name name = this.ident();
        int createPos = this.token.pos;
        List<Object> args = this.token.kind == Tokens.TokenKind.LPAREN ? this.arguments() : List.nil();
        JCTree.JCClassDecl body = null;
        if (this.token.kind == Tokens.TokenKind.LBRACE) {
            JCTree.JCModifiers mods1 = this.F.at(-1).Modifiers(16392L);
            List<JCTree> defs = this.classOrInterfaceBody(this.names.empty, false);
            body = this.toP(this.F.at(identPos).AnonymousClassDef(mods1, defs));
        }
        if (args.isEmpty() && body == null) {
            createPos = identPos;
        }
        JCTree.JCIdent ident = this.F.at(identPos).Ident(enumName);
        JCTree.JCNewClass create = this.F.at(createPos).NewClass(null, typeArgs, ident, args, body);
        if (createPos != identPos) {
            this.storeEnd(create, this.S.prevToken().endPos);
        }
        ident = this.F.at(identPos).Ident(enumName);
        JCTree.JCVariableDecl result = this.toP(this.F.at(pos).VarDef(mods, name, ident, create));
        this.attach(result, dc);
        return result;
    }

    List<JCTree.JCExpression> typeList() {
        ListBuffer<JCTree.JCExpression> ts = new ListBuffer<JCTree.JCExpression>();
        ts.append(this.parseType());
        while (this.token.kind == Tokens.TokenKind.COMMA) {
            this.nextToken();
            ts.append(this.parseType());
        }
        return ts.toList();
    }

    List<JCTree> classOrInterfaceBody(Name className, boolean isInterface) {
        this.accept(Tokens.TokenKind.LBRACE);
        if (this.token.pos <= this.endPosTable.errorEndPos) {
            this.skip(false, true, false, false);
            if (this.token.kind == Tokens.TokenKind.LBRACE) {
                this.nextToken();
            }
        }
        ListBuffer<JCTree> defs = new ListBuffer<JCTree>();
        while (this.token.kind != Tokens.TokenKind.RBRACE && this.token.kind != Tokens.TokenKind.EOF) {
            defs.appendList(this.classOrInterfaceBodyDeclaration(className, isInterface));
            if (this.token.pos > this.endPosTable.errorEndPos) continue;
            this.skip(false, true, true, false);
        }
        this.accept(Tokens.TokenKind.RBRACE);
        return defs.toList();
    }

    protected List<JCTree> classOrInterfaceBodyDeclaration(Name className, boolean isInterface) {
        JCTree.JCExpression type;
        boolean isVoid;
        List<JCTree.JCAnnotation> annosAfterParams;
        if (this.token.kind == Tokens.TokenKind.SEMI) {
            this.nextToken();
            return List.nil();
        }
        Tokens.Comment dc = this.token.comment(Tokens.Comment.CommentStyle.JAVADOC);
        int pos = this.token.pos;
        JCTree.JCModifiers mods = this.modifiersOpt();
        if (this.token.kind == Tokens.TokenKind.CLASS || this.token.kind == Tokens.TokenKind.INTERFACE || this.allowEnums && this.token.kind == Tokens.TokenKind.ENUM) {
            return List.of(this.classOrInterfaceOrEnumDeclaration(mods, dc));
        }
        if (this.token.kind == Tokens.TokenKind.LBRACE && !isInterface && (mods.flags & 0xFFFL & 0xFFFFFFFFFFFFFFF7L) == 0L && mods.annotations.isEmpty()) {
            return List.of(this.block(pos, mods.flags));
        }
        pos = this.token.pos;
        List<JCTree.JCTypeParameter> typarams = this.typeParametersOpt();
        if (typarams.nonEmpty() && mods.pos == -1) {
            mods.pos = pos;
            this.storeEnd(mods, pos);
        }
        if ((annosAfterParams = this.annotationsOpt(JCTree.Tag.ANNOTATION)).nonEmpty()) {
            this.checkAnnotationsAfterTypeParams(((JCTree.JCAnnotation)annosAfterParams.head).pos);
            mods.annotations = mods.annotations.appendList(annosAfterParams);
            if (mods.pos == -1) {
                mods.pos = ((JCTree.JCAnnotation)mods.annotations.head).pos;
            }
        }
        Tokens.Token tk = this.token;
        pos = this.token.pos;
        boolean bl = isVoid = this.token.kind == Tokens.TokenKind.VOID;
        if (isVoid) {
            type = this.to(this.F.at(pos).TypeIdent(TypeTag.VOID));
            this.nextToken();
        } else {
            type = this.unannotatedType();
        }
        if (this.token.kind == Tokens.TokenKind.LPAREN && !isInterface && type.hasTag(JCTree.Tag.IDENT)) {
            if (isInterface || tk.name() != className) {
                this.error(pos, "invalid.meth.decl.ret.type.req", new Object[0]);
            } else if (annosAfterParams.nonEmpty()) {
                this.illegal(((JCTree.JCAnnotation)annosAfterParams.head).pos);
            }
            return List.of(this.methodDeclaratorRest(pos, mods, null, this.names.init, typarams, isInterface, true, dc));
        }
        pos = this.token.pos;
        Name name = this.ident();
        if (this.token.kind == Tokens.TokenKind.LPAREN) {
            return List.of(this.methodDeclaratorRest(pos, mods, type, name, typarams, isInterface, isVoid, dc));
        }
        if (!isVoid && typarams.isEmpty()) {
            List<JCTree> defs = this.variableDeclaratorsRest(pos, mods, type, name, isInterface, dc, new ListBuffer()).toList();
            this.storeEnd((JCTree)defs.last(), this.token.endPos);
            this.accept(Tokens.TokenKind.SEMI);
            return defs;
        }
        pos = this.token.pos;
        List<JCTree.JCMethodDecl> err = isVoid ? List.of(this.toP(this.F.at(pos).MethodDef(mods, name, type, typarams, List.nil(), List.nil(), null, null))) : null;
        return List.of(this.syntaxError(this.token.pos, err, "expected", Tokens.TokenKind.LPAREN));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JCTree methodDeclaratorRest(int pos, JCTree.JCModifiers mods, JCTree.JCExpression type, Name name, List<JCTree.JCTypeParameter> typarams, boolean isInterface, boolean isVoid, Tokens.Comment dc) {
        if (isInterface && (mods.flags & 8L) != 0L) {
            this.checkStaticInterfaceMethods();
        }
        JCTree.JCVariableDecl prevReceiverParam = this.receiverParam;
        try {
            JCTree.JCExpression defaultValue;
            this.receiverParam = null;
            List<JCTree.JCVariableDecl> params = this.formalParameters();
            if (!isVoid) {
                type = this.bracketsOpt(type);
            }
            List<JCTree.JCExpression> thrown = List.nil();
            if (this.token.kind == Tokens.TokenKind.THROWS) {
                this.nextToken();
                thrown = this.qualidentList();
            }
            JCTree.JCBlock body = null;
            if (this.token.kind == Tokens.TokenKind.LBRACE) {
                body = this.block();
                defaultValue = null;
            } else {
                if (this.token.kind == Tokens.TokenKind.DEFAULT) {
                    this.accept(Tokens.TokenKind.DEFAULT);
                    defaultValue = this.annotationValue();
                } else {
                    defaultValue = null;
                }
                this.accept(Tokens.TokenKind.SEMI);
                if (this.token.pos <= this.endPosTable.errorEndPos) {
                    this.skip(false, true, false, false);
                    if (this.token.kind == Tokens.TokenKind.LBRACE) {
                        body = this.block();
                    }
                }
            }
            JCTree.JCMethodDecl result = this.toP(this.F.at(pos).MethodDef(mods, name, type, typarams, this.receiverParam, params, thrown, body, defaultValue));
            this.attach(result, dc);
            JCTree.JCMethodDecl jCMethodDecl = result;
            return jCMethodDecl;
        }
        finally {
            this.receiverParam = prevReceiverParam;
        }
    }

    List<JCTree.JCExpression> qualidentList() {
        JCTree.JCExpression at;
        ListBuffer<JCTree.JCExpression> ts = new ListBuffer<JCTree.JCExpression>();
        List<JCTree.JCAnnotation> typeAnnos = this.typeAnnotationsOpt();
        JCTree.JCExpression qi = this.qualident(true);
        if (!typeAnnos.isEmpty()) {
            at = this.insertAnnotationsToMostInner(qi, typeAnnos, false);
            ts.append(at);
        } else {
            ts.append(qi);
        }
        while (this.token.kind == Tokens.TokenKind.COMMA) {
            this.nextToken();
            typeAnnos = this.typeAnnotationsOpt();
            qi = this.qualident(true);
            if (!typeAnnos.isEmpty()) {
                at = this.insertAnnotationsToMostInner(qi, typeAnnos, false);
                ts.append(at);
                continue;
            }
            ts.append(qi);
        }
        return ts.toList();
    }

    List<JCTree.JCTypeParameter> typeParametersOpt() {
        if (this.token.kind == Tokens.TokenKind.LT) {
            this.checkGenerics();
            ListBuffer<JCTree.JCTypeParameter> typarams = new ListBuffer<JCTree.JCTypeParameter>();
            this.nextToken();
            typarams.append(this.typeParameter());
            while (this.token.kind == Tokens.TokenKind.COMMA) {
                this.nextToken();
                typarams.append(this.typeParameter());
            }
            this.accept(Tokens.TokenKind.GT);
            return typarams.toList();
        }
        return List.nil();
    }

    JCTree.JCTypeParameter typeParameter() {
        int pos = this.token.pos;
        List<JCTree.JCAnnotation> annos = this.typeAnnotationsOpt();
        Name name = this.ident();
        ListBuffer<JCTree.JCExpression> bounds = new ListBuffer<JCTree.JCExpression>();
        if (this.token.kind == Tokens.TokenKind.EXTENDS) {
            this.nextToken();
            bounds.append(this.parseType());
            while (this.token.kind == Tokens.TokenKind.AMP) {
                this.nextToken();
                bounds.append(this.parseType());
            }
        }
        return this.toP(this.F.at(pos).TypeParameter(name, bounds.toList(), annos));
    }

    List<JCTree.JCVariableDecl> formalParameters() {
        return this.formalParameters(false);
    }

    List<JCTree.JCVariableDecl> formalParameters(boolean lambdaParameters) {
        ListBuffer<JCTree.JCVariableDecl> params = new ListBuffer<JCTree.JCVariableDecl>();
        this.accept(Tokens.TokenKind.LPAREN);
        if (this.token.kind != Tokens.TokenKind.RPAREN) {
            this.allowThisIdent = true;
            JCTree.JCVariableDecl lastParam = this.formalParameter(lambdaParameters);
            if (lastParam.nameexpr != null) {
                this.receiverParam = lastParam;
            } else {
                params.append(lastParam);
            }
            this.allowThisIdent = false;
            while ((lastParam.mods.flags & 0x400000000L) == 0L && this.token.kind == Tokens.TokenKind.COMMA) {
                this.nextToken();
                lastParam = this.formalParameter(lambdaParameters);
                params.append(lastParam);
            }
        }
        this.accept(Tokens.TokenKind.RPAREN);
        return params.toList();
    }

    List<JCTree.JCVariableDecl> implicitParameters(boolean hasParens) {
        if (hasParens) {
            this.accept(Tokens.TokenKind.LPAREN);
        }
        ListBuffer<JCTree.JCVariableDecl> params = new ListBuffer<JCTree.JCVariableDecl>();
        if (this.token.kind != Tokens.TokenKind.RPAREN && this.token.kind != Tokens.TokenKind.ARROW) {
            params.append(this.implicitParameter());
            while (this.token.kind == Tokens.TokenKind.COMMA) {
                this.nextToken();
                params.append(this.implicitParameter());
            }
        }
        if (hasParens) {
            this.accept(Tokens.TokenKind.RPAREN);
        }
        return params.toList();
    }

    JCTree.JCModifiers optFinal(long flags) {
        JCTree.JCModifiers mods = this.modifiersOpt();
        this.checkNoMods(mods.flags & 0xFFFFFFFFFFFDFFEFL);
        mods.flags |= flags;
        return mods;
    }

    private JCTree.JCExpression insertAnnotationsToMostInner(JCTree.JCExpression type, List<JCTree.JCAnnotation> annos, boolean createNewLevel) {
        int origEndPos = this.getEndPos(type);
        JCTree.JCExpression mostInnerType = type;
        JCTree.JCArrayTypeTree mostInnerArrayType = null;
        while (TreeInfo.typeIn(mostInnerType).hasTag(JCTree.Tag.TYPEARRAY)) {
            mostInnerArrayType = (JCTree.JCArrayTypeTree)TreeInfo.typeIn(mostInnerType);
            mostInnerType = mostInnerArrayType.elemtype;
        }
        if (createNewLevel) {
            mostInnerType = this.to(this.F.at(this.token.pos).TypeArray(mostInnerType));
        }
        JCTree.JCExpression mostInnerTypeToReturn = mostInnerType;
        if (annos.nonEmpty()) {
            JCTree.JCExpression lastToModify = mostInnerType;
            while (TreeInfo.typeIn(mostInnerType).hasTag(JCTree.Tag.SELECT) || TreeInfo.typeIn(mostInnerType).hasTag(JCTree.Tag.TYPEAPPLY)) {
                while (TreeInfo.typeIn(mostInnerType).hasTag(JCTree.Tag.SELECT)) {
                    lastToModify = mostInnerType;
                    mostInnerType = ((JCTree.JCFieldAccess)TreeInfo.typeIn(mostInnerType)).getExpression();
                }
                while (TreeInfo.typeIn(mostInnerType).hasTag(JCTree.Tag.TYPEAPPLY)) {
                    lastToModify = mostInnerType;
                    mostInnerType = ((JCTree.JCTypeApply)TreeInfo.typeIn((JCTree.JCExpression)mostInnerType)).clazz;
                }
            }
            mostInnerType = this.F.at(((JCTree.JCAnnotation)annos.head).pos).AnnotatedType(annos, mostInnerType);
            if (TreeInfo.typeIn(lastToModify).hasTag(JCTree.Tag.TYPEAPPLY)) {
                ((JCTree.JCTypeApply)TreeInfo.typeIn((JCTree.JCExpression)lastToModify)).clazz = mostInnerType;
            } else if (TreeInfo.typeIn(lastToModify).hasTag(JCTree.Tag.SELECT)) {
                ((JCTree.JCFieldAccess)TreeInfo.typeIn((JCTree.JCExpression)lastToModify)).selected = mostInnerType;
            } else {
                mostInnerTypeToReturn = mostInnerType;
            }
        }
        if (mostInnerArrayType == null) {
            return mostInnerTypeToReturn;
        }
        mostInnerArrayType.elemtype = mostInnerTypeToReturn;
        this.storeEnd(type, origEndPos);
        return type;
    }

    protected JCTree.JCVariableDecl formalParameter() {
        return this.formalParameter(false);
    }

    protected JCTree.JCVariableDecl formalParameter(boolean lambdaParameter) {
        JCTree.JCModifiers mods = this.optFinal(0x200000000L);
        this.permitTypeAnnotationsPushBack = true;
        JCTree.JCExpression type = this.parseType();
        this.permitTypeAnnotationsPushBack = false;
        if (this.token.kind == Tokens.TokenKind.ELLIPSIS) {
            List<JCTree.JCAnnotation> varargsAnnos = this.typeAnnotationsPushedBack;
            this.typeAnnotationsPushedBack = List.nil();
            this.checkVarargs();
            mods.flags |= 0x400000000L;
            type = this.insertAnnotationsToMostInner(type, varargsAnnos, true);
            this.nextToken();
        } else {
            if (this.typeAnnotationsPushedBack.nonEmpty()) {
                this.reportSyntaxError(((JCTree.JCAnnotation)this.typeAnnotationsPushedBack.head).pos, "illegal.start.of.type", new Object[0]);
            }
            this.typeAnnotationsPushedBack = List.nil();
        }
        return this.variableDeclaratorId(mods, type, lambdaParameter);
    }

    protected JCTree.JCVariableDecl implicitParameter() {
        JCTree.JCModifiers mods = this.F.at(this.token.pos).Modifiers(0x200000000L);
        return this.variableDeclaratorId(mods, null, true);
    }

    void error(int pos, String key, Object ... args) {
        this.log.error(JCDiagnostic.DiagnosticFlag.SYNTAX, pos, key, args);
    }

    void error(JCDiagnostic.DiagnosticPosition pos, String key, Object ... args) {
        this.log.error(JCDiagnostic.DiagnosticFlag.SYNTAX, pos, key, args);
    }

    void warning(int pos, String key, Object ... args) {
        this.log.warning(pos, key, args);
    }

    protected JCTree.JCExpression checkExprStat(JCTree.JCExpression t) {
        if (!TreeInfo.isExpressionStatement(t)) {
            JCTree.JCErroneous ret = this.F.at(t.pos).Erroneous(List.of(t));
            this.error(ret, "not.stmt", new Object[0]);
            return ret;
        }
        return t;
    }

    static int prec(Tokens.TokenKind token) {
        JCTree.Tag oc = JavacParser.optag(token);
        return oc != JCTree.Tag.NO_TAG ? TreeInfo.opPrec(oc) : -1;
    }

    static int earlier(int pos1, int pos2) {
        if (pos1 == -1) {
            return pos2;
        }
        if (pos2 == -1) {
            return pos1;
        }
        return pos1 < pos2 ? pos1 : pos2;
    }

    static JCTree.Tag optag(Tokens.TokenKind token) {
        switch (token) {
            case BARBAR: {
                return JCTree.Tag.OR;
            }
            case AMPAMP: {
                return JCTree.Tag.AND;
            }
            case BAR: {
                return JCTree.Tag.BITOR;
            }
            case BAREQ: {
                return JCTree.Tag.BITOR_ASG;
            }
            case CARET: {
                return JCTree.Tag.BITXOR;
            }
            case CARETEQ: {
                return JCTree.Tag.BITXOR_ASG;
            }
            case AMP: {
                return JCTree.Tag.BITAND;
            }
            case AMPEQ: {
                return JCTree.Tag.BITAND_ASG;
            }
            case EQEQ: {
                return JCTree.Tag.EQ;
            }
            case BANGEQ: {
                return JCTree.Tag.NE;
            }
            case LT: {
                return JCTree.Tag.LT;
            }
            case GT: {
                return JCTree.Tag.GT;
            }
            case LTEQ: {
                return JCTree.Tag.LE;
            }
            case GTEQ: {
                return JCTree.Tag.GE;
            }
            case LTLT: {
                return JCTree.Tag.SL;
            }
            case LTLTEQ: {
                return JCTree.Tag.SL_ASG;
            }
            case GTGT: {
                return JCTree.Tag.SR;
            }
            case GTGTEQ: {
                return JCTree.Tag.SR_ASG;
            }
            case GTGTGT: {
                return JCTree.Tag.USR;
            }
            case GTGTGTEQ: {
                return JCTree.Tag.USR_ASG;
            }
            case PLUS: {
                return JCTree.Tag.PLUS;
            }
            case PLUSEQ: {
                return JCTree.Tag.PLUS_ASG;
            }
            case SUB: {
                return JCTree.Tag.MINUS;
            }
            case SUBEQ: {
                return JCTree.Tag.MINUS_ASG;
            }
            case STAR: {
                return JCTree.Tag.MUL;
            }
            case STAREQ: {
                return JCTree.Tag.MUL_ASG;
            }
            case SLASH: {
                return JCTree.Tag.DIV;
            }
            case SLASHEQ: {
                return JCTree.Tag.DIV_ASG;
            }
            case PERCENT: {
                return JCTree.Tag.MOD;
            }
            case PERCENTEQ: {
                return JCTree.Tag.MOD_ASG;
            }
            case INSTANCEOF: {
                return JCTree.Tag.TYPETEST;
            }
        }
        return JCTree.Tag.NO_TAG;
    }

    static JCTree.Tag unoptag(Tokens.TokenKind token) {
        switch (token) {
            case PLUS: {
                return JCTree.Tag.POS;
            }
            case SUB: {
                return JCTree.Tag.NEG;
            }
            case BANG: {
                return JCTree.Tag.NOT;
            }
            case TILDE: {
                return JCTree.Tag.COMPL;
            }
            case PLUSPLUS: {
                return JCTree.Tag.PREINC;
            }
            case SUBSUB: {
                return JCTree.Tag.PREDEC;
            }
        }
        return JCTree.Tag.NO_TAG;
    }

    static TypeTag typetag(Tokens.TokenKind token) {
        switch (token) {
            case BYTE: {
                return TypeTag.BYTE;
            }
            case CHAR: {
                return TypeTag.CHAR;
            }
            case SHORT: {
                return TypeTag.SHORT;
            }
            case INT: {
                return TypeTag.INT;
            }
            case LONG: {
                return TypeTag.LONG;
            }
            case FLOAT: {
                return TypeTag.FLOAT;
            }
            case DOUBLE: {
                return TypeTag.DOUBLE;
            }
            case BOOLEAN: {
                return TypeTag.BOOLEAN;
            }
        }
        return TypeTag.NONE;
    }

    void checkGenerics() {
        if (!this.allowGenerics) {
            this.error(this.token.pos, "generics.not.supported.in.source", this.source.name);
            this.allowGenerics = true;
        }
    }

    void checkVarargs() {
        if (!this.allowVarargs) {
            this.error(this.token.pos, "varargs.not.supported.in.source", this.source.name);
            this.allowVarargs = true;
        }
    }

    void checkForeach() {
        if (!this.allowForeach) {
            this.error(this.token.pos, "foreach.not.supported.in.source", this.source.name);
            this.allowForeach = true;
        }
    }

    void checkStaticImports() {
        if (!this.allowStaticImport) {
            this.error(this.token.pos, "static.import.not.supported.in.source", this.source.name);
            this.allowStaticImport = true;
        }
    }

    void checkAnnotations() {
        if (!this.allowAnnotations) {
            this.error(this.token.pos, "annotations.not.supported.in.source", this.source.name);
            this.allowAnnotations = true;
        }
    }

    void checkDiamond() {
        if (!this.allowDiamond) {
            this.error(this.token.pos, "diamond.not.supported.in.source", this.source.name);
            this.allowDiamond = true;
        }
    }

    void checkMulticatch() {
        if (!this.allowMulticatch) {
            this.error(this.token.pos, "multicatch.not.supported.in.source", this.source.name);
            this.allowMulticatch = true;
        }
    }

    void checkTryWithResources() {
        if (!this.allowTWR) {
            this.error(this.token.pos, "try.with.resources.not.supported.in.source", this.source.name);
            this.allowTWR = true;
        }
    }

    void checkLambda() {
        if (!this.allowLambda) {
            this.log.error(this.token.pos, "lambda.not.supported.in.source", this.source.name);
            this.allowLambda = true;
        }
    }

    void checkMethodReferences() {
        if (!this.allowMethodReferences) {
            this.log.error(this.token.pos, "method.references.not.supported.in.source", this.source.name);
            this.allowMethodReferences = true;
        }
    }

    void checkDefaultMethods() {
        if (!this.allowDefaultMethods) {
            this.log.error(this.token.pos, "default.methods.not.supported.in.source", this.source.name);
            this.allowDefaultMethods = true;
        }
    }

    void checkIntersectionTypesInCast() {
        if (!this.allowIntersectionTypesInCast) {
            this.log.error(this.token.pos, "intersection.types.in.cast.not.supported.in.source", this.source.name);
            this.allowIntersectionTypesInCast = true;
        }
    }

    void checkStaticInterfaceMethods() {
        if (!this.allowStaticInterfaceMethods) {
            this.log.error(this.token.pos, "static.intf.methods.not.supported.in.source", this.source.name);
            this.allowStaticInterfaceMethods = true;
        }
    }

    void checkTypeAnnotations() {
        if (!this.allowTypeAnnotations) {
            this.log.error(this.token.pos, "type.annotations.not.supported.in.source", this.source.name);
            this.allowTypeAnnotations = true;
        }
    }

    void checkAnnotationsAfterTypeParams(int pos) {
        if (!this.allowAnnotationsAfterTypeParams) {
            this.log.error(pos, "annotations.after.type.params.not.supported.in.source", this.source.name);
            this.allowAnnotationsAfterTypeParams = true;
        }
    }

    protected static abstract class AbstractEndPosTable
    implements EndPosTable {
        protected JavacParser parser;
        protected int errorEndPos;

        public AbstractEndPosTable(JavacParser parser) {
            this.parser = parser;
        }

        protected abstract <T extends JCTree> T to(T var1);

        protected abstract <T extends JCTree> T toP(T var1);

        protected void setErrorEndPos(int errPos) {
            if (errPos > this.errorEndPos) {
                this.errorEndPos = errPos;
            }
        }

        protected void setParser(JavacParser parser) {
            this.parser = parser;
        }
    }

    protected static class EmptyEndPosTable
    extends AbstractEndPosTable {
        EmptyEndPosTable(JavacParser parser) {
            super(parser);
        }

        @Override
        public void storeEnd(JCTree tree, int endpos) {
        }

        @Override
        protected <T extends JCTree> T to(T t) {
            return t;
        }

        @Override
        protected <T extends JCTree> T toP(T t) {
            return t;
        }

        @Override
        public int getEndPos(JCTree tree) {
            return -1;
        }

        @Override
        public int replaceTree(JCTree oldTree, JCTree newTree) {
            return -1;
        }
    }

    protected static class SimpleEndPosTable
    extends AbstractEndPosTable {
        private final IntHashTable endPosMap = new IntHashTable();

        SimpleEndPosTable(JavacParser parser) {
            super(parser);
        }

        @Override
        public void storeEnd(JCTree tree, int endpos) {
            this.endPosMap.putAtIndex(tree, this.errorEndPos > endpos ? this.errorEndPos : endpos, this.endPosMap.lookup(tree));
        }

        @Override
        protected <T extends JCTree> T to(T t) {
            this.storeEnd(t, this.parser.token.endPos);
            return t;
        }

        @Override
        protected <T extends JCTree> T toP(T t) {
            this.storeEnd(t, this.parser.S.prevToken().endPos);
            return t;
        }

        @Override
        public int getEndPos(JCTree tree) {
            int value = this.endPosMap.getFromIndex(this.endPosMap.lookup(tree));
            return value == -1 ? -1 : value;
        }

        @Override
        public int replaceTree(JCTree oldTree, JCTree newTree) {
            int pos = this.endPosMap.remove(oldTree);
            if (pos != -1) {
                this.storeEnd(newTree, pos);
                return pos;
            }
            return -1;
        }
    }

    static enum ParensResult {
        CAST,
        EXPLICIT_LAMBDA,
        IMPLICIT_LAMBDA,
        PARENS;

    }

    static enum BasicErrorRecoveryAction implements ErrorRecoveryAction
    {
        BLOCK_STMT{

            @Override
            public JCTree doRecover(JavacParser parser) {
                return parser.parseStatementAsBlock();
            }
        }
        ,
        CATCH_CLAUSE{

            @Override
            public JCTree doRecover(JavacParser parser) {
                return parser.catchClause();
            }
        };

    }

    static interface ErrorRecoveryAction {
        public JCTree doRecover(JavacParser var1);
    }
}

