/*
 * Decompiled with CFR 0.152.
 */
package androidx.renderscript;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.util.Log;
import android.view.Surface;
import androidx.renderscript.BaseObj;
import androidx.renderscript.Element;
import androidx.renderscript.FieldPacker;
import androidx.renderscript.RSIllegalArgumentException;
import androidx.renderscript.RSInvalidStateException;
import androidx.renderscript.RSRuntimeException;
import androidx.renderscript.RenderScript;
import androidx.renderscript.Type;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class Allocation
extends BaseObj {
    Type mType;
    Bitmap mBitmap;
    int mUsage;
    int mSize;
    Allocation mAdaptedAllocation;
    ByteBuffer mByteBuffer = null;
    long mByteBufferStride = 0L;
    boolean mConstrainedLOD;
    boolean mConstrainedFace;
    boolean mConstrainedY;
    boolean mConstrainedZ;
    boolean mReadAllowed = true;
    boolean mWriteAllowed = true;
    boolean mAutoPadding = false;
    int mSelectedY;
    int mSelectedZ;
    int mSelectedLOD;
    Type.CubemapFace mSelectedFace = Type.CubemapFace.POSITIVE_X;
    int mCurrentDimX;
    int mCurrentDimY;
    int mCurrentDimZ;
    int mCurrentCount;
    long mIncCompatAllocation;
    boolean mIncAllocDestroyed;
    public static final int USAGE_SCRIPT = 1;
    public static final int USAGE_GRAPHICS_TEXTURE = 2;
    public static final int USAGE_IO_INPUT = 32;
    public static final int USAGE_IO_OUTPUT = 64;
    public static final int USAGE_SHARED = 128;
    static BitmapFactory.Options mBitmapOptions = new BitmapFactory.Options();

    private Element.DataType validateObjectIsPrimitiveArray(Object d, boolean checkType) {
        Class<?> c = d.getClass();
        if (!c.isArray()) {
            throw new RSIllegalArgumentException("Object passed is not an array of primitives.");
        }
        Class<?> cmp = c.getComponentType();
        if (!cmp.isPrimitive()) {
            throw new RSIllegalArgumentException("Object passed is not an Array of primitives.");
        }
        if (cmp == Long.TYPE) {
            if (checkType) {
                this.validateIsInt64();
                return this.mType.mElement.mType;
            }
            return Element.DataType.SIGNED_64;
        }
        if (cmp == Integer.TYPE) {
            if (checkType) {
                this.validateIsInt32();
                return this.mType.mElement.mType;
            }
            return Element.DataType.SIGNED_32;
        }
        if (cmp == Short.TYPE) {
            if (checkType) {
                this.validateIsInt16();
                return this.mType.mElement.mType;
            }
            return Element.DataType.SIGNED_16;
        }
        if (cmp == Byte.TYPE) {
            if (checkType) {
                this.validateIsInt8();
                return this.mType.mElement.mType;
            }
            return Element.DataType.SIGNED_8;
        }
        if (cmp == Float.TYPE) {
            if (checkType) {
                this.validateIsFloat32();
            }
            return Element.DataType.FLOAT_32;
        }
        if (cmp == Double.TYPE) {
            if (checkType) {
                this.validateIsFloat64();
            }
            return Element.DataType.FLOAT_64;
        }
        return null;
    }

    public long getIncAllocID() {
        return this.mIncCompatAllocation;
    }

    public void setIncAllocID(long id) {
        this.mIncCompatAllocation = id;
    }

    private long getIDSafe() {
        if (this.mAdaptedAllocation != null) {
            return this.mAdaptedAllocation.getID(this.mRS);
        }
        return this.getID(this.mRS);
    }

    public Element getElement() {
        return this.mType.getElement();
    }

    public int getUsage() {
        return this.mUsage;
    }

    public void setAutoPadding(boolean useAutoPadding) {
        this.mAutoPadding = useAutoPadding;
    }

    public int getBytesSize() {
        if (this.mType.mDimYuv != 0) {
            return (int)Math.ceil((double)(this.mType.getCount() * this.mType.getElement().getBytesSize()) * 1.5);
        }
        return this.mType.getCount() * this.mType.getElement().getBytesSize();
    }

    private void updateCacheInfo(Type t) {
        this.mCurrentDimX = t.getX();
        this.mCurrentDimY = t.getY();
        this.mCurrentDimZ = t.getZ();
        this.mCurrentCount = this.mCurrentDimX;
        if (this.mCurrentDimY > 1) {
            this.mCurrentCount *= this.mCurrentDimY;
        }
        if (this.mCurrentDimZ > 1) {
            this.mCurrentCount *= this.mCurrentDimZ;
        }
    }

    private void setBitmap(Bitmap b) {
        this.mBitmap = b;
    }

    Allocation(long id, RenderScript rs, Type t, int usage) {
        super(id, rs);
        if ((usage & 0xFFFFFF1C) != 0) {
            throw new RSIllegalArgumentException("Unknown usage specified.");
        }
        if ((usage & 0x20) != 0) {
            this.mWriteAllowed = false;
            if ((usage & 0xFFFFFFDC) != 0) {
                throw new RSIllegalArgumentException("Invalid usage combination.");
            }
        }
        this.mType = t;
        this.mUsage = usage;
        this.mIncCompatAllocation = 0L;
        this.mIncAllocDestroyed = false;
        if (t != null) {
            this.mSize = this.mType.getCount() * this.mType.getElement().getBytesSize();
            this.updateCacheInfo(t);
        }
        if (RenderScript.sUseGCHooks) {
            try {
                RenderScript.registerNativeAllocation.invoke(RenderScript.sRuntime, this.mSize);
            }
            catch (Exception e) {
                Log.e((String)"RenderScript_jni", (String)("Couldn't invoke registerNativeAllocation:" + e));
                throw new RSRuntimeException("Couldn't invoke registerNativeAllocation:" + e);
            }
        }
    }

    @Override
    protected void finalize() throws Throwable {
        if (RenderScript.sUseGCHooks) {
            RenderScript.registerNativeFree.invoke(RenderScript.sRuntime, this.mSize);
        }
        super.finalize();
    }

    private void validateIsInt64() {
        if (this.mType.mElement.mType == Element.DataType.SIGNED_64 || this.mType.mElement.mType == Element.DataType.UNSIGNED_64) {
            return;
        }
        throw new RSIllegalArgumentException("64 bit integer source does not match allocation type " + (Object)((Object)this.mType.mElement.mType));
    }

    private void validateIsInt32() {
        if (this.mType.mElement.mType == Element.DataType.SIGNED_32 || this.mType.mElement.mType == Element.DataType.UNSIGNED_32) {
            return;
        }
        throw new RSIllegalArgumentException("32 bit integer source does not match allocation type " + (Object)((Object)this.mType.mElement.mType));
    }

    private void validateIsInt16() {
        if (this.mType.mElement.mType == Element.DataType.SIGNED_16 || this.mType.mElement.mType == Element.DataType.UNSIGNED_16) {
            return;
        }
        throw new RSIllegalArgumentException("16 bit integer source does not match allocation type " + (Object)((Object)this.mType.mElement.mType));
    }

    private void validateIsInt8() {
        if (this.mType.mElement.mType == Element.DataType.SIGNED_8 || this.mType.mElement.mType == Element.DataType.UNSIGNED_8) {
            return;
        }
        throw new RSIllegalArgumentException("8 bit integer source does not match allocation type " + (Object)((Object)this.mType.mElement.mType));
    }

    private void validateIsFloat32() {
        if (this.mType.mElement.mType == Element.DataType.FLOAT_32) {
            return;
        }
        throw new RSIllegalArgumentException("32 bit float source does not match allocation type " + (Object)((Object)this.mType.mElement.mType));
    }

    private void validateIsFloat64() {
        if (this.mType.mElement.mType == Element.DataType.FLOAT_64) {
            return;
        }
        throw new RSIllegalArgumentException("64 bit float source does not match allocation type " + (Object)((Object)this.mType.mElement.mType));
    }

    private void validateIsObject() {
        if (this.mType.mElement.mType == Element.DataType.RS_ELEMENT || this.mType.mElement.mType == Element.DataType.RS_TYPE || this.mType.mElement.mType == Element.DataType.RS_ALLOCATION || this.mType.mElement.mType == Element.DataType.RS_SAMPLER || this.mType.mElement.mType == Element.DataType.RS_SCRIPT) {
            return;
        }
        throw new RSIllegalArgumentException("Object source does not match allocation type " + (Object)((Object)this.mType.mElement.mType));
    }

    public Type getType() {
        return this.mType;
    }

    public void syncAll(int srcLocation) {
        switch (srcLocation) {
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new RSIllegalArgumentException("Source must be exactly one usage type.");
            }
        }
        this.mRS.validate();
        this.mRS.nAllocationSyncAll(this.getIDSafe(), srcLocation);
    }

    public void ioSend() {
        if ((this.mUsage & 0x40) == 0) {
            throw new RSIllegalArgumentException("Can only send buffer if IO_OUTPUT usage specified.");
        }
        this.mRS.validate();
        this.mRS.nAllocationIoSend(this.getID(this.mRS));
    }

    public void ioSendOutput() {
        this.ioSend();
    }

    public ByteBuffer getByteBuffer() {
        int xBytesSize = this.mType.getX() * this.mType.getElement().getBytesSize();
        if (this.mRS.getDispatchAPILevel() < 21) {
            byte[] data = null;
            if (this.mType.getZ() > 0) {
                return null;
            }
            if (this.mType.getY() > 0) {
                data = new byte[xBytesSize * this.mType.getY()];
                this.copy2DRangeToUnchecked(0, 0, this.mType.getX(), this.mType.getY(), data, Element.DataType.SIGNED_8, xBytesSize * this.mType.getY());
            } else {
                data = new byte[xBytesSize];
                this.copy1DRangeToUnchecked(0, this.mType.getX(), data);
            }
            ByteBuffer bBuffer = ByteBuffer.wrap(data).asReadOnlyBuffer();
            this.mByteBufferStride = xBytesSize;
            return bBuffer;
        }
        if (this.mByteBuffer == null || (this.mUsage & 0x20) != 0) {
            this.mByteBuffer = this.mRS.nAllocationGetByteBuffer(this.getID(this.mRS), xBytesSize, this.mType.getY(), this.mType.getZ());
        }
        return this.mByteBuffer;
    }

    public long getStride() {
        if (this.mByteBufferStride == 0L) {
            this.mByteBufferStride = this.mRS.getDispatchAPILevel() > 21 ? this.mRS.nAllocationGetStride(this.getID(this.mRS)) : (long)(this.mType.getX() * this.mType.getElement().getBytesSize());
        }
        return this.mByteBufferStride;
    }

    public void ioReceive() {
        if ((this.mUsage & 0x20) == 0) {
            throw new RSIllegalArgumentException("Can only receive if IO_INPUT usage specified.");
        }
        this.mRS.validate();
        this.mRS.nAllocationIoReceive(this.getID(this.mRS));
    }

    public void copyFrom(BaseObj[] d) {
        this.mRS.validate();
        this.validateIsObject();
        if (d.length != this.mCurrentCount) {
            throw new RSIllegalArgumentException("Array size mismatch, allocation sizeX = " + this.mCurrentCount + ", array length = " + d.length);
        }
        if (RenderScript.sPointerSize == 8) {
            long[] i = new long[d.length * 4];
            for (int ct = 0; ct < d.length; ++ct) {
                i[ct * 4] = d[ct].getID(this.mRS);
            }
            this.copy1DRangeFromUnchecked(0, this.mCurrentCount, (Object)i);
        } else {
            int[] i = new int[d.length];
            for (int ct = 0; ct < d.length; ++ct) {
                i[ct] = (int)d[ct].getID(this.mRS);
            }
            this.copy1DRangeFromUnchecked(0, this.mCurrentCount, i);
        }
    }

    private void validateBitmapFormat(Bitmap b) {
        Bitmap.Config bc = b.getConfig();
        if (bc == null) {
            throw new RSIllegalArgumentException("Bitmap has an unsupported format for this operation");
        }
        switch (bc) {
            case ALPHA_8: {
                if (this.mType.getElement().mKind == Element.DataKind.PIXEL_A) break;
                throw new RSIllegalArgumentException("Allocation kind is " + (Object)((Object)this.mType.getElement().mKind) + ", type " + (Object)((Object)this.mType.getElement().mType) + " of " + this.mType.getElement().getBytesSize() + " bytes, passed bitmap was " + bc);
            }
            case ARGB_8888: {
                if (this.mType.getElement().mKind == Element.DataKind.PIXEL_RGBA && this.mType.getElement().getBytesSize() == 4) break;
                throw new RSIllegalArgumentException("Allocation kind is " + (Object)((Object)this.mType.getElement().mKind) + ", type " + (Object)((Object)this.mType.getElement().mType) + " of " + this.mType.getElement().getBytesSize() + " bytes, passed bitmap was " + bc);
            }
            case RGB_565: {
                if (this.mType.getElement().mKind == Element.DataKind.PIXEL_RGB && this.mType.getElement().getBytesSize() == 2) break;
                throw new RSIllegalArgumentException("Allocation kind is " + (Object)((Object)this.mType.getElement().mKind) + ", type " + (Object)((Object)this.mType.getElement().mType) + " of " + this.mType.getElement().getBytesSize() + " bytes, passed bitmap was " + bc);
            }
            case ARGB_4444: {
                if (this.mType.getElement().mKind == Element.DataKind.PIXEL_RGBA && this.mType.getElement().getBytesSize() == 2) break;
                throw new RSIllegalArgumentException("Allocation kind is " + (Object)((Object)this.mType.getElement().mKind) + ", type " + (Object)((Object)this.mType.getElement().mType) + " of " + this.mType.getElement().getBytesSize() + " bytes, passed bitmap was " + bc);
            }
        }
    }

    private void validateBitmapSize(Bitmap b) {
        if (this.mCurrentDimX != b.getWidth() || this.mCurrentDimY != b.getHeight()) {
            throw new RSIllegalArgumentException("Cannot update allocation from bitmap, sizes mismatch");
        }
    }

    private void copyFromUnchecked(Object array, Element.DataType dt, int arrayLen) {
        this.mRS.validate();
        if (this.mCurrentDimZ > 0) {
            this.copy3DRangeFromUnchecked(0, 0, 0, this.mCurrentDimX, this.mCurrentDimY, this.mCurrentDimZ, array, dt, arrayLen);
        } else if (this.mCurrentDimY > 0) {
            this.copy2DRangeFromUnchecked(0, 0, this.mCurrentDimX, this.mCurrentDimY, array, dt, arrayLen);
        } else {
            this.copy1DRangeFromUnchecked(0, this.mCurrentCount, array, dt, arrayLen);
        }
    }

    public void copyFromUnchecked(Object array) {
        this.copyFromUnchecked(array, this.validateObjectIsPrimitiveArray(array, false), Array.getLength(array));
    }

    public void copyFromUnchecked(int[] d) {
        this.copyFromUnchecked(d, Element.DataType.SIGNED_32, d.length);
    }

    public void copyFromUnchecked(short[] d) {
        this.copyFromUnchecked(d, Element.DataType.SIGNED_16, d.length);
    }

    public void copyFromUnchecked(byte[] d) {
        this.copyFromUnchecked(d, Element.DataType.SIGNED_8, d.length);
    }

    public void copyFromUnchecked(float[] d) {
        this.copyFromUnchecked(d, Element.DataType.FLOAT_32, d.length);
    }

    public void copyFrom(Object array) {
        this.copyFromUnchecked(array, this.validateObjectIsPrimitiveArray(array, true), Array.getLength(array));
    }

    public void copyFrom(int[] d) {
        this.validateIsInt32();
        this.copyFromUnchecked(d, Element.DataType.SIGNED_32, d.length);
    }

    public void copyFrom(short[] d) {
        this.validateIsInt16();
        this.copyFromUnchecked(d, Element.DataType.SIGNED_16, d.length);
    }

    public void copyFrom(byte[] d) {
        this.validateIsInt8();
        this.copyFromUnchecked(d, Element.DataType.SIGNED_8, d.length);
    }

    public void copyFrom(float[] d) {
        this.validateIsFloat32();
        this.copyFromUnchecked(d, Element.DataType.FLOAT_32, d.length);
    }

    public void copyFrom(Bitmap b) {
        this.mRS.validate();
        if (b.getConfig() == null) {
            Bitmap newBitmap = Bitmap.createBitmap((int)b.getWidth(), (int)b.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas c = new Canvas(newBitmap);
            c.drawBitmap(b, 0.0f, 0.0f, null);
            this.copyFrom(newBitmap);
            return;
        }
        this.validateBitmapSize(b);
        this.validateBitmapFormat(b);
        this.mRS.nAllocationCopyFromBitmap(this.getID(this.mRS), b);
    }

    public void copyFrom(Allocation a) {
        this.mRS.validate();
        if (!this.mType.equals(a.getType())) {
            throw new RSIllegalArgumentException("Types of allocations must match.");
        }
        this.copy2DRangeFrom(0, 0, this.mCurrentDimX, this.mCurrentDimY, a, 0, 0);
    }

    public void setFromFieldPacker(int xoff, FieldPacker fp) {
        this.mRS.validate();
        int eSize = this.mType.mElement.getBytesSize();
        byte[] data = fp.getData();
        int data_length = fp.getPos();
        int count = data_length / eSize;
        if (eSize * count != data_length) {
            throw new RSIllegalArgumentException("Field packer length " + data_length + " not divisible by element size " + eSize + ".");
        }
        this.copy1DRangeFromUnchecked(xoff, count, data);
    }

    public void setFromFieldPacker(int xoff, int component_number, FieldPacker fp) {
        this.mRS.validate();
        if (component_number >= this.mType.mElement.mElements.length) {
            throw new RSIllegalArgumentException("Component_number " + component_number + " out of range.");
        }
        if (xoff < 0) {
            throw new RSIllegalArgumentException("Offset must be >= 0.");
        }
        byte[] data = fp.getData();
        int data_length = fp.getPos();
        int eSize = this.mType.mElement.mElements[component_number].getBytesSize();
        if (data_length != (eSize *= this.mType.mElement.mArraySizes[component_number])) {
            throw new RSIllegalArgumentException("Field packer sizelength " + data_length + " does not match component size " + eSize + ".");
        }
        this.mRS.nAllocationElementData1D(this.getIDSafe(), xoff, this.mSelectedLOD, component_number, data, data_length);
    }

    private void data1DChecks(int off, int count, int len, int dataSize, boolean usePadding) {
        this.mRS.validate();
        if (off < 0) {
            throw new RSIllegalArgumentException("Offset must be >= 0.");
        }
        if (count < 1) {
            throw new RSIllegalArgumentException("Count must be >= 1.");
        }
        if (off + count > this.mCurrentCount) {
            throw new RSIllegalArgumentException("Overflow, Available count " + this.mCurrentCount + ", got " + count + " at offset " + off + ".");
        }
        if (usePadding ? len < dataSize / 4 * 3 : len < dataSize) {
            throw new RSIllegalArgumentException("Array too small for allocation type.");
        }
    }

    public void generateMipmaps() {
        this.mRS.nAllocationGenerateMipmaps(this.getID(this.mRS));
    }

    private void copy1DRangeFromUnchecked(int off, int count, Object array, Element.DataType dt, int arrayLen) {
        int dataSize = this.mType.mElement.getBytesSize() * count;
        boolean usePadding = false;
        if (this.mAutoPadding && this.mType.getElement().getVectorSize() == 3) {
            usePadding = true;
        }
        this.data1DChecks(off, count, arrayLen * dt.mSize, dataSize, usePadding);
        this.mRS.nAllocationData1D(this.getIDSafe(), off, this.mSelectedLOD, count, array, dataSize, dt, this.mType.mElement.mType.mSize, usePadding);
    }

    public void copy1DRangeFromUnchecked(int off, int count, Object array) {
        this.copy1DRangeFromUnchecked(off, count, array, this.validateObjectIsPrimitiveArray(array, false), Array.getLength(array));
    }

    public void copy1DRangeFromUnchecked(int off, int count, int[] d) {
        this.copy1DRangeFromUnchecked(off, count, d, Element.DataType.SIGNED_32, d.length);
    }

    public void copy1DRangeFromUnchecked(int off, int count, short[] d) {
        this.copy1DRangeFromUnchecked(off, count, d, Element.DataType.SIGNED_16, d.length);
    }

    public void copy1DRangeFromUnchecked(int off, int count, byte[] d) {
        this.copy1DRangeFromUnchecked(off, count, d, Element.DataType.SIGNED_8, d.length);
    }

    public void copy1DRangeFromUnchecked(int off, int count, float[] d) {
        this.copy1DRangeFromUnchecked(off, count, d, Element.DataType.FLOAT_32, d.length);
    }

    public void copy1DRangeFrom(int off, int count, Object array) {
        this.copy1DRangeFromUnchecked(off, count, array, this.validateObjectIsPrimitiveArray(array, true), Array.getLength(array));
    }

    public void copy1DRangeFrom(int off, int count, int[] d) {
        this.validateIsInt32();
        this.copy1DRangeFromUnchecked(off, count, d, Element.DataType.SIGNED_32, d.length);
    }

    public void copy1DRangeFrom(int off, int count, short[] d) {
        this.validateIsInt16();
        this.copy1DRangeFromUnchecked(off, count, d, Element.DataType.SIGNED_16, d.length);
    }

    public void copy1DRangeFrom(int off, int count, byte[] d) {
        this.validateIsInt8();
        this.copy1DRangeFromUnchecked(off, count, d, Element.DataType.SIGNED_8, d.length);
    }

    public void copy1DRangeFrom(int off, int count, float[] d) {
        this.validateIsFloat32();
        this.copy1DRangeFromUnchecked(off, count, d, Element.DataType.FLOAT_32, d.length);
    }

    public void copy1DRangeFrom(int off, int count, Allocation data, int dataOff) {
        this.mRS.nAllocationData2D(this.getIDSafe(), off, 0, this.mSelectedLOD, this.mSelectedFace.mID, count, 1, data.getID(this.mRS), dataOff, 0, data.mSelectedLOD, data.mSelectedFace.mID);
    }

    private void validate2DRange(int xoff, int yoff, int w, int h) {
        if (this.mAdaptedAllocation == null) {
            if (xoff < 0 || yoff < 0) {
                throw new RSIllegalArgumentException("Offset cannot be negative.");
            }
            if (h < 0 || w < 0) {
                throw new RSIllegalArgumentException("Height or width cannot be negative.");
            }
            if (xoff + w > this.mCurrentDimX || yoff + h > this.mCurrentDimY) {
                throw new RSIllegalArgumentException("Updated region larger than allocation.");
            }
        }
    }

    void copy2DRangeFromUnchecked(int xoff, int yoff, int w, int h, Object array, Element.DataType dt, int arrayLen) {
        this.mRS.validate();
        this.validate2DRange(xoff, yoff, w, h);
        int dataSize = this.mType.mElement.getBytesSize() * w * h;
        boolean usePadding = false;
        int sizeBytes = arrayLen * dt.mSize;
        if (this.mAutoPadding && this.mType.getElement().getVectorSize() == 3) {
            if (dataSize / 4 * 3 > sizeBytes) {
                throw new RSIllegalArgumentException("Array too small for allocation type.");
            }
            usePadding = true;
            sizeBytes = dataSize;
        } else if (dataSize > sizeBytes) {
            throw new RSIllegalArgumentException("Array too small for allocation type.");
        }
        this.mRS.nAllocationData2D(this.getIDSafe(), xoff, yoff, this.mSelectedLOD, this.mSelectedFace.mID, w, h, array, sizeBytes, dt, this.mType.mElement.mType.mSize, usePadding);
    }

    public void copy2DRangeFrom(int xoff, int yoff, int w, int h, Object array) {
        this.copy2DRangeFromUnchecked(xoff, yoff, w, h, array, this.validateObjectIsPrimitiveArray(array, true), Array.getLength(array));
    }

    public void copy2DRangeFrom(int xoff, int yoff, int w, int h, byte[] data) {
        this.validateIsInt8();
        this.copy2DRangeFromUnchecked(xoff, yoff, w, h, data, Element.DataType.SIGNED_8, data.length);
    }

    public void copy2DRangeFrom(int xoff, int yoff, int w, int h, short[] data) {
        this.validateIsInt16();
        this.copy2DRangeFromUnchecked(xoff, yoff, w, h, data, Element.DataType.SIGNED_16, data.length);
    }

    public void copy2DRangeFrom(int xoff, int yoff, int w, int h, int[] data) {
        this.validateIsInt32();
        this.copy2DRangeFromUnchecked(xoff, yoff, w, h, data, Element.DataType.SIGNED_32, data.length);
    }

    public void copy2DRangeFrom(int xoff, int yoff, int w, int h, float[] data) {
        this.validateIsFloat32();
        this.copy2DRangeFromUnchecked(xoff, yoff, w, h, data, Element.DataType.FLOAT_32, data.length);
    }

    public void copy2DRangeFrom(int xoff, int yoff, int w, int h, Allocation data, int dataXoff, int dataYoff) {
        this.mRS.validate();
        this.validate2DRange(xoff, yoff, w, h);
        this.mRS.nAllocationData2D(this.getIDSafe(), xoff, yoff, this.mSelectedLOD, this.mSelectedFace.mID, w, h, data.getID(this.mRS), dataXoff, dataYoff, data.mSelectedLOD, data.mSelectedFace.mID);
    }

    public void copy2DRangeFrom(int xoff, int yoff, Bitmap data) {
        this.mRS.validate();
        if (data.getConfig() == null) {
            Bitmap newBitmap = Bitmap.createBitmap((int)data.getWidth(), (int)data.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas c = new Canvas(newBitmap);
            c.drawBitmap(data, 0.0f, 0.0f, null);
            this.copy2DRangeFrom(xoff, yoff, newBitmap);
            return;
        }
        this.validateBitmapFormat(data);
        this.validate2DRange(xoff, yoff, data.getWidth(), data.getHeight());
        this.mRS.nAllocationData2D(this.getIDSafe(), xoff, yoff, this.mSelectedLOD, this.mSelectedFace.mID, data);
    }

    private void validate3DRange(int xoff, int yoff, int zoff, int w, int h, int d) {
        if (this.mAdaptedAllocation == null) {
            if (xoff < 0 || yoff < 0 || zoff < 0) {
                throw new RSIllegalArgumentException("Offset cannot be negative.");
            }
            if (h < 0 || w < 0 || d < 0) {
                throw new RSIllegalArgumentException("Height or width cannot be negative.");
            }
            if (xoff + w > this.mCurrentDimX || yoff + h > this.mCurrentDimY || zoff + d > this.mCurrentDimZ) {
                throw new RSIllegalArgumentException("Updated region larger than allocation.");
            }
        }
    }

    private void copy3DRangeFromUnchecked(int xoff, int yoff, int zoff, int w, int h, int d, Object array, Element.DataType dt, int arrayLen) {
        this.mRS.validate();
        this.validate3DRange(xoff, yoff, zoff, w, h, d);
        int dataSize = this.mType.mElement.getBytesSize() * w * h * d;
        boolean usePadding = false;
        int sizeBytes = arrayLen * dt.mSize;
        if (this.mAutoPadding && this.mType.getElement().getVectorSize() == 3) {
            if (dataSize / 4 * 3 > sizeBytes) {
                throw new RSIllegalArgumentException("Array too small for allocation type.");
            }
            usePadding = true;
            sizeBytes = dataSize;
        } else if (dataSize > sizeBytes) {
            throw new RSIllegalArgumentException("Array too small for allocation type.");
        }
        this.mRS.nAllocationData3D(this.getIDSafe(), xoff, yoff, zoff, this.mSelectedLOD, w, h, d, array, sizeBytes, dt, this.mType.mElement.mType.mSize, usePadding);
    }

    public void copy3DRangeFrom(int xoff, int yoff, int zoff, int w, int h, int d, Object array) {
        this.copy3DRangeFromUnchecked(xoff, yoff, zoff, w, h, d, array, this.validateObjectIsPrimitiveArray(array, true), Array.getLength(array));
    }

    public void copy3DRangeFrom(int xoff, int yoff, int zoff, int w, int h, int d, Allocation data, int dataXoff, int dataYoff, int dataZoff) {
        this.mRS.validate();
        this.validate3DRange(xoff, yoff, zoff, w, h, d);
        this.mRS.nAllocationData3D(this.getIDSafe(), xoff, yoff, zoff, this.mSelectedLOD, w, h, d, data.getID(this.mRS), dataXoff, dataYoff, dataZoff, data.mSelectedLOD);
    }

    public void copyTo(Bitmap b) {
        this.mRS.validate();
        this.validateBitmapFormat(b);
        this.validateBitmapSize(b);
        this.mRS.nAllocationCopyToBitmap(this.getID(this.mRS), b);
    }

    private void copyTo(Object array, Element.DataType dt, int arrayLen) {
        this.mRS.validate();
        boolean usePadding = false;
        if (this.mAutoPadding && this.mType.getElement().getVectorSize() == 3) {
            usePadding = true;
        }
        if (usePadding ? dt.mSize * arrayLen < this.mSize / 4 * 3 : dt.mSize * arrayLen < this.mSize) {
            throw new RSIllegalArgumentException("Size of output array cannot be smaller than size of allocation.");
        }
        this.mRS.nAllocationRead(this.getID(this.mRS), array, dt, this.mType.mElement.mType.mSize, usePadding);
    }

    public void copyTo(Object array) {
        this.copyTo(array, this.validateObjectIsPrimitiveArray(array, true), Array.getLength(array));
    }

    public void copyTo(byte[] d) {
        this.validateIsInt8();
        this.copyTo(d, Element.DataType.SIGNED_8, d.length);
    }

    public void copyTo(short[] d) {
        this.validateIsInt16();
        this.copyTo(d, Element.DataType.SIGNED_16, d.length);
    }

    public void copyTo(int[] d) {
        this.validateIsInt32();
        this.copyTo(d, Element.DataType.SIGNED_32, d.length);
    }

    public void copyTo(float[] d) {
        this.validateIsFloat32();
        this.copyTo(d, Element.DataType.FLOAT_32, d.length);
    }

    private void copy1DRangeToUnchecked(int off, int count, Object array, Element.DataType dt, int arrayLen) {
        int dataSize = this.mType.mElement.getBytesSize() * count;
        boolean usePadding = false;
        if (this.mAutoPadding && this.mType.getElement().getVectorSize() == 3) {
            usePadding = true;
        }
        this.data1DChecks(off, count, arrayLen * dt.mSize, dataSize, usePadding);
        this.mRS.nAllocationRead1D(this.getIDSafe(), off, this.mSelectedLOD, count, array, dataSize, dt, this.mType.mElement.mType.mSize, usePadding);
    }

    public void copy1DRangeToUnchecked(int off, int count, Object array) {
        this.copy1DRangeToUnchecked(off, count, array, this.validateObjectIsPrimitiveArray(array, false), Array.getLength(array));
    }

    public void copy1DRangeToUnchecked(int off, int count, int[] d) {
        this.copy1DRangeToUnchecked(off, count, d, Element.DataType.SIGNED_32, d.length);
    }

    public void copy1DRangeToUnchecked(int off, int count, short[] d) {
        this.copy1DRangeToUnchecked(off, count, d, Element.DataType.SIGNED_16, d.length);
    }

    public void copy1DRangeToUnchecked(int off, int count, byte[] d) {
        this.copy1DRangeToUnchecked(off, count, d, Element.DataType.SIGNED_8, d.length);
    }

    public void copy1DRangeToUnchecked(int off, int count, float[] d) {
        this.copy1DRangeToUnchecked(off, count, d, Element.DataType.FLOAT_32, d.length);
    }

    public void copy1DRangeTo(int off, int count, Object array) {
        this.copy1DRangeToUnchecked(off, count, array, this.validateObjectIsPrimitiveArray(array, true), Array.getLength(array));
    }

    public void copy1DRangeTo(int off, int count, int[] d) {
        this.validateIsInt32();
        this.copy1DRangeToUnchecked(off, count, d, Element.DataType.SIGNED_32, d.length);
    }

    public void copy1DRangeTo(int off, int count, short[] d) {
        this.validateIsInt16();
        this.copy1DRangeToUnchecked(off, count, d, Element.DataType.SIGNED_16, d.length);
    }

    public void copy1DRangeTo(int off, int count, byte[] d) {
        this.validateIsInt8();
        this.copy1DRangeToUnchecked(off, count, d, Element.DataType.SIGNED_8, d.length);
    }

    public void copy1DRangeTo(int off, int count, float[] d) {
        this.validateIsFloat32();
        this.copy1DRangeToUnchecked(off, count, d, Element.DataType.FLOAT_32, d.length);
    }

    void copy2DRangeToUnchecked(int xoff, int yoff, int w, int h, Object array, Element.DataType dt, int arrayLen) {
        this.mRS.validate();
        this.validate2DRange(xoff, yoff, w, h);
        int dataSize = this.mType.mElement.getBytesSize() * w * h;
        boolean usePadding = false;
        int sizeBytes = arrayLen * dt.mSize;
        if (this.mAutoPadding && this.mType.getElement().getVectorSize() == 3) {
            if (dataSize / 4 * 3 > sizeBytes) {
                throw new RSIllegalArgumentException("Array too small for allocation type.");
            }
            usePadding = true;
            sizeBytes = dataSize;
        } else if (dataSize > sizeBytes) {
            throw new RSIllegalArgumentException("Array too small for allocation type.");
        }
        this.mRS.nAllocationRead2D(this.getIDSafe(), xoff, yoff, this.mSelectedLOD, this.mSelectedFace.mID, w, h, array, sizeBytes, dt, this.mType.mElement.mType.mSize, usePadding);
    }

    public void copy2DRangeTo(int xoff, int yoff, int w, int h, Object array) {
        this.copy2DRangeToUnchecked(xoff, yoff, w, h, array, this.validateObjectIsPrimitiveArray(array, true), Array.getLength(array));
    }

    public void copy2DRangeTo(int xoff, int yoff, int w, int h, byte[] data) {
        this.validateIsInt8();
        this.copy2DRangeToUnchecked(xoff, yoff, w, h, data, Element.DataType.SIGNED_8, data.length);
    }

    public void copy2DRangeTo(int xoff, int yoff, int w, int h, short[] data) {
        this.validateIsInt16();
        this.copy2DRangeToUnchecked(xoff, yoff, w, h, data, Element.DataType.SIGNED_16, data.length);
    }

    public void copy2DRangeTo(int xoff, int yoff, int w, int h, int[] data) {
        this.validateIsInt32();
        this.copy2DRangeToUnchecked(xoff, yoff, w, h, data, Element.DataType.SIGNED_32, data.length);
    }

    public void copy2DRangeTo(int xoff, int yoff, int w, int h, float[] data) {
        this.validateIsFloat32();
        this.copy2DRangeToUnchecked(xoff, yoff, w, h, data, Element.DataType.FLOAT_32, data.length);
    }

    public static Allocation createTyped(RenderScript rs, Type type, MipmapControl mips, int usage) {
        rs.validate();
        if (type.getID(rs) == 0L) {
            throw new RSInvalidStateException("Bad Type");
        }
        if (!rs.usingIO() && (usage & 0x20) != 0) {
            throw new RSRuntimeException("USAGE_IO not supported, Allocation creation failed.");
        }
        long id = rs.nAllocationCreateTyped(type.getID(rs), mips.mID, usage, 0L);
        if (id == 0L) {
            throw new RSRuntimeException("Allocation creation failed.");
        }
        return new Allocation(id, rs, type, usage);
    }

    public static Allocation createTyped(RenderScript rs, Type type, int usage) {
        return Allocation.createTyped(rs, type, MipmapControl.MIPMAP_NONE, usage);
    }

    public static Allocation createTyped(RenderScript rs, Type type) {
        return Allocation.createTyped(rs, type, MipmapControl.MIPMAP_NONE, 1);
    }

    public static Allocation createSized(RenderScript rs, Element e, int count, int usage) {
        rs.validate();
        Type.Builder b = new Type.Builder(rs, e);
        b.setX(count);
        Type t = b.create();
        long id = rs.nAllocationCreateTyped(t.getID(rs), MipmapControl.MIPMAP_NONE.mID, usage, 0L);
        if (id == 0L) {
            throw new RSRuntimeException("Allocation creation failed.");
        }
        return new Allocation(id, rs, t, usage);
    }

    public static Allocation createSized(RenderScript rs, Element e, int count) {
        return Allocation.createSized(rs, e, count, 1);
    }

    static Element elementFromBitmap(RenderScript rs, Bitmap b) {
        Bitmap.Config bc = b.getConfig();
        if (bc == Bitmap.Config.ALPHA_8) {
            return Element.A_8(rs);
        }
        if (bc == Bitmap.Config.ARGB_4444) {
            return Element.RGBA_4444(rs);
        }
        if (bc == Bitmap.Config.ARGB_8888) {
            return Element.RGBA_8888(rs);
        }
        if (bc == Bitmap.Config.RGB_565) {
            return Element.RGB_565(rs);
        }
        throw new RSInvalidStateException("Bad bitmap type: " + bc);
    }

    static Type typeFromBitmap(RenderScript rs, Bitmap b, MipmapControl mip) {
        Element e = Allocation.elementFromBitmap(rs, b);
        Type.Builder tb = new Type.Builder(rs, e);
        tb.setX(b.getWidth());
        tb.setY(b.getHeight());
        tb.setMipmaps(mip == MipmapControl.MIPMAP_FULL);
        return tb.create();
    }

    public static Allocation createFromBitmap(RenderScript rs, Bitmap b, MipmapControl mips, int usage) {
        rs.validate();
        if (b.getConfig() == null) {
            if ((usage & 0x80) != 0) {
                throw new RSIllegalArgumentException("USAGE_SHARED cannot be used with a Bitmap that has a null config.");
            }
            Bitmap newBitmap = Bitmap.createBitmap((int)b.getWidth(), (int)b.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas c = new Canvas(newBitmap);
            c.drawBitmap(b, 0.0f, 0.0f, null);
            return Allocation.createFromBitmap(rs, newBitmap, mips, usage);
        }
        Type t = Allocation.typeFromBitmap(rs, b, mips);
        if (mips == MipmapControl.MIPMAP_NONE && t.getElement().isCompatible(Element.RGBA_8888(rs)) && usage == 131) {
            long id = rs.nAllocationCreateBitmapBackedAllocation(t.getID(rs), mips.mID, b, usage);
            if (id == 0L) {
                throw new RSRuntimeException("Load failed.");
            }
            Allocation alloc = new Allocation(id, rs, t, usage);
            alloc.setBitmap(b);
            return alloc;
        }
        long id = rs.nAllocationCreateFromBitmap(t.getID(rs), mips.mID, b, usage);
        if (id == 0L) {
            throw new RSRuntimeException("Load failed.");
        }
        return new Allocation(id, rs, t, usage);
    }

    public void setSurface(Surface sur) {
        this.mRS.validate();
        if ((this.mUsage & 0x40) == 0) {
            throw new RSInvalidStateException("Allocation is not USAGE_IO_OUTPUT.");
        }
        this.mRS.nAllocationSetSurface(this.getID(this.mRS), sur);
    }

    public static Allocation createFromBitmap(RenderScript rs, Bitmap b) {
        return Allocation.createFromBitmap(rs, b, MipmapControl.MIPMAP_NONE, 131);
    }

    public static Allocation createCubemapFromBitmap(RenderScript rs, Bitmap b, MipmapControl mips, int usage) {
        boolean isPow2;
        rs.validate();
        int height = b.getHeight();
        int width = b.getWidth();
        if (width % 6 != 0) {
            throw new RSIllegalArgumentException("Cubemap height must be multiple of 6");
        }
        if (width / 6 != height) {
            throw new RSIllegalArgumentException("Only square cube map faces supported");
        }
        boolean bl = isPow2 = (height & height - 1) == 0;
        if (!isPow2) {
            throw new RSIllegalArgumentException("Only power of 2 cube faces supported");
        }
        Element e = Allocation.elementFromBitmap(rs, b);
        Type.Builder tb = new Type.Builder(rs, e);
        tb.setX(height);
        tb.setY(height);
        tb.setFaces(true);
        tb.setMipmaps(mips == MipmapControl.MIPMAP_FULL);
        Type t = tb.create();
        long id = rs.nAllocationCubeCreateFromBitmap(t.getID(rs), mips.mID, b, usage);
        if (id == 0L) {
            throw new RSRuntimeException("Load failed for bitmap " + b + " element " + e);
        }
        return new Allocation(id, rs, t, usage);
    }

    public static Allocation createCubemapFromBitmap(RenderScript rs, Bitmap b) {
        return Allocation.createCubemapFromBitmap(rs, b, MipmapControl.MIPMAP_NONE, 2);
    }

    public static Allocation createCubemapFromCubeFaces(RenderScript rs, Bitmap xpos, Bitmap xneg, Bitmap ypos, Bitmap yneg, Bitmap zpos, Bitmap zneg, MipmapControl mips, int usage) {
        return null;
    }

    public static Allocation createCubemapFromCubeFaces(RenderScript rs, Bitmap xpos, Bitmap xneg, Bitmap ypos, Bitmap yneg, Bitmap zpos, Bitmap zneg) {
        return Allocation.createCubemapFromCubeFaces(rs, xpos, xneg, ypos, yneg, zpos, zneg, MipmapControl.MIPMAP_NONE, 2);
    }

    public static Allocation createFromBitmapResource(RenderScript rs, Resources res, int id, MipmapControl mips, int usage) {
        rs.validate();
        if ((usage & 0xE0) != 0) {
            throw new RSIllegalArgumentException("Unsupported usage specified.");
        }
        Bitmap b = BitmapFactory.decodeResource((Resources)res, (int)id);
        Allocation alloc = Allocation.createFromBitmap(rs, b, mips, usage);
        b.recycle();
        return alloc;
    }

    public static Allocation createFromBitmapResource(RenderScript rs, Resources res, int id) {
        return Allocation.createFromBitmapResource(rs, res, id, MipmapControl.MIPMAP_NONE, 3);
    }

    public static Allocation createFromString(RenderScript rs, String str, int usage) {
        rs.validate();
        byte[] allocArray = null;
        try {
            allocArray = str.getBytes("UTF-8");
            Allocation alloc = Allocation.createSized(rs, Element.U8(rs), allocArray.length, usage);
            alloc.copyFrom(allocArray);
            return alloc;
        }
        catch (Exception e) {
            throw new RSRuntimeException("Could not convert string to utf-8.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        if (this.mIncCompatAllocation != 0L) {
            boolean shouldDestroy = false;
            Allocation allocation = this;
            synchronized (allocation) {
                if (!this.mIncAllocDestroyed) {
                    shouldDestroy = true;
                    this.mIncAllocDestroyed = true;
                }
            }
            if (shouldDestroy) {
                ReentrantReadWriteLock.ReadLock rlock = this.mRS.mRWLock.readLock();
                rlock.lock();
                if (this.mRS.isAlive()) {
                    this.mRS.nIncObjDestroy(this.mIncCompatAllocation);
                }
                rlock.unlock();
                this.mIncCompatAllocation = 0L;
            }
        }
        if ((this.mUsage & 0x60) != 0) {
            this.setSurface(null);
        }
        super.destroy();
    }

    static {
        Allocation.mBitmapOptions.inScaled = false;
    }

    public static enum MipmapControl {
        MIPMAP_NONE(0),
        MIPMAP_FULL(1),
        MIPMAP_ON_SYNC_TO_TEXTURE(2);

        int mID;

        private MipmapControl(int id) {
            this.mID = id;
        }
    }
}

