/*
 * Decompiled with CFR 0.152.
 */
package org.firstinspires.ftc.robotserver.internal.programmingmode;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.qualcomm.robotcore.eventloop.opmode.FtcRobotControllerServiceState;
import com.qualcomm.robotcore.util.WebHandlerManager;
import com.qualcomm.robotcore.util.WebServer;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.firstinspires.ftc.robotcore.internal.webserver.WebHandler;
import org.firstinspires.ftc.robotcore.internal.webserver.websockets.WebSocketManager;
import org.firstinspires.ftc.robotcore.internal.webserver.websockets.WebSocketNamespaceHandler;
import org.firstinspires.ftc.robotserver.internal.programmingmode.ProgrammingMode;
import org.firstinspires.ftc.robotserver.internal.programmingmode.ProgrammingModeWebHandlerDecorator;

public class ProgrammingModeManager {
    public static final String TAG = ProgrammingModeManager.class.getSimpleName();
    private volatile WebServer webServer;
    private volatile WebSocketManager webSocketManager;
    private volatile WebHandlerManager webHandlerManager;
    private final List<ProgrammingMode> registeredProgrammingModes;
    private final ProgrammingModeWebHandlerDecorator webHandlerDecorator = new ProgrammingModeWebHandlerDecorator(this);

    public ProgrammingModeManager() {
        this.registeredProgrammingModes = Collections.synchronizedList(new LinkedList());
    }

    @Nullable
    public WebServer getWebServer() {
        return this.webServer;
    }

    public void register(String uri, WebHandler webHandler) {
        this.webHandlerManager.register(uri, webHandler);
    }

    public void register(@NonNull WebSocketNamespaceHandler webHandler) {
        this.webSocketManager.registerNamespaceHandler(webHandler);
    }

    public WebHandler decorate(boolean decorateWithParams, WebHandler handler) {
        return this.webHandlerDecorator.decorate(handler, decorateWithParams);
    }

    public WebHandler getRegisteredHandler(String uri) {
        return this.webHandlerManager.getRegistered(uri);
    }

    public void setState(FtcRobotControllerServiceState rcServiceState) {
        this.webServer = rcServiceState.getWebServer();
        this.webHandlerManager = this.webServer.getWebHandlerManager();
        this.webSocketManager = this.webServer.getWebSocketManager();
        for (ProgrammingMode programmingMode : this.registeredProgrammingModes) {
            programmingMode.register(this);
        }
    }

    public void register(ProgrammingMode programmingModeHandler) {
        this.registeredProgrammingModes.add(programmingModeHandler);
        if (this.webHandlerManager != null) {
            programmingModeHandler.register(this);
        }
    }
}

