/*
 * Decompiled with CFR 0.152.
 */
package org.firstinspires.ftc.robotserver.internal.webserver;

import android.content.res.TypedArray;
import androidx.annotation.ColorInt;
import java.lang.reflect.Field;
import java.util.ArrayList;
import org.firstinspires.ftc.robotcore.internal.collections.SimpleGson;
import org.firstinspires.ftc.robotcore.internal.system.AppUtil;
import org.firstinspires.ftc.robotcore.internal.webserver.R;

public class AppThemeColors {
    public static final String TAG = AppThemeColors.class.getSimpleName();
    public static final String httpHeaderName = "Ftc-RCConsole-Theme";
    public static final String htppHeaderNameLower = "Ftc-RCConsole-Theme".toLowerCase();
    private static final String oneQuote = "\"";
    private static final String escapedQuote = "\\\"";
    @ColorInt
    public int textError;
    @ColorInt
    public int textWarning;
    @ColorInt
    public int textOkay;
    @ColorInt
    public int textBright;
    @ColorInt
    public int textLight;
    @ColorInt
    public int textMedium;
    @ColorInt
    public int textMediumDark;
    @ColorInt
    public int textVeryDark;
    @ColorInt
    public int textVeryVeryDark;
    @ColorInt
    public int backgroundLight;
    @ColorInt
    public int backgroundMediumLight;
    @ColorInt
    public int backgroundMedium;
    @ColorInt
    public int backgroundMediumMedium;
    @ColorInt
    public int backgroundMediumDark;
    @ColorInt
    public int backgroundAlmostDark;
    @ColorInt
    public int backgroundDark;
    @ColorInt
    public int backgroundVeryDark;
    @ColorInt
    public int backgroundVeryVeryDark;
    @ColorInt
    public int lineBright;
    @ColorInt
    public int lineLight;
    @ColorInt
    public int feedbackBackground;
    @ColorInt
    public int feedbackBorder;
    protected static Field[] colorFieldsArray;
    protected static int[] colorAttrArray;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeFromTheme() {
        AppUtil.getInstance();
        this.textError = AppUtil.getColor((int)R.color.text_error);
        AppUtil.getInstance();
        this.textWarning = AppUtil.getColor((int)R.color.text_warning);
        AppUtil.getInstance();
        this.textOkay = AppUtil.getColor((int)R.color.text_okay);
        TypedArray typedArray = AppUtil.getInstance().getRootActivity().obtainStyledAttributes(colorAttrArray);
        try {
            for (int i = 0; i < colorAttrArray.length; ++i) {
                int color2 = typedArray.getColor(i, 0);
                try {
                    colorFieldsArray[i].setInt(this, color2);
                    continue;
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("unable to access field" + colorFieldsArray[i].getName(), e);
                }
            }
        }
        finally {
            typedArray.recycle();
        }
    }

    public static AppThemeColors fromTheme() {
        AppThemeColors result = new AppThemeColors();
        result.initializeFromTheme();
        return result;
    }

    public static String toHeader(String less) {
        return oneQuote + less.replace(oneQuote, escapedQuote) + oneQuote;
    }

    public static String fromHeader(String header) {
        if (header.length() > 1 && header.startsWith(oneQuote) && header.endsWith(oneQuote)) {
            return header.substring(1, header.length() - 1).replace(escapedQuote, oneQuote);
        }
        return header;
    }

    public String toLess() {
        StringBuilder colorsLess = new StringBuilder();
        this.addColor(colorsLess, "textError", this.textError);
        this.addColor(colorsLess, "textWarning", this.textWarning);
        this.addColor(colorsLess, "textOkay", this.textOkay);
        for (int i = 0; i < colorFieldsArray.length; ++i) {
            try {
                Field field = colorFieldsArray[i];
                this.addColor(colorsLess, field.getName(), field.getInt(this));
                continue;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("unable to access field" + colorFieldsArray[i].getName(), e);
            }
        }
        return colorsLess.toString();
    }

    protected void addColor(StringBuilder builder, String name, @ColorInt int color2) {
        builder.append(String.format("@%s:#%06x;", name, color2 &= 0xFFFFFF));
    }

    public String toJson() {
        return SimpleGson.getInstance().toJson((Object)this);
    }

    public static AppThemeColors fromJson(String json) {
        return (AppThemeColors)SimpleGson.getInstance().fromJson(json, AppThemeColors.class);
    }

    static {
        ArrayList<Field> colorFieldsList = new ArrayList<Field>();
        ArrayList<Integer> colorAttrList = new ArrayList<Integer>();
        block10: for (Field field : AppThemeColors.class.getDeclaredFields()) {
            String name;
            if ((field.getModifiers() & 8) != 0) continue;
            switch (name = field.getName()) {
                case "textError": 
                case "textWarning": 
                case "textOkay": {
                    continue block10;
                }
                default: {
                    colorFieldsList.add(field);
                    try {
                        int id = R.attr.class.getDeclaredField(name).getInt(null);
                        colorAttrList.add(id);
                        continue block10;
                    }
                    catch (IllegalAccessException | NoSuchFieldException e) {
                        throw new RuntimeException("unable to access r.attr." + name, e);
                    }
                }
            }
        }
        colorFieldsArray = colorFieldsList.toArray(new Field[colorFieldsList.size()]);
        colorAttrArray = new int[colorAttrList.size()];
        for (int i = 0; i < colorAttrArray.length; ++i) {
            AppThemeColors.colorAttrArray[i] = (Integer)colorAttrList.get(i);
        }
    }
}

