/*
 * Decompiled with CFR 0.152.
 */
package org.firstinspires.ftc.robotserver.internal.webserver;

import com.qualcomm.robotcore.util.RobotLog;
import fi.iki.elonen.NanoHTTPD;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.firstinspires.ftc.robotcore.internal.collections.SimpleGson;
import org.firstinspires.ftc.robotcore.internal.webserver.FtcUserAgentCategory;
import org.firstinspires.ftc.robotserver.internal.webserver.SessionCookie;

public final class ConnectedHttpDevice {
    public static final String TAG = ConnectedHttpDevice.class.getSimpleName();
    private static final Map<String, String> identityToMachineName = new HashMap<String, String>();
    public final String identity;
    public final String machineName;
    public final String currentPage;

    private ConnectedHttpDevice(String identity, String currentPage, String userAgent) {
        this.identity = identity;
        this.currentPage = currentPage;
        String machineType = ConnectedHttpDevice.getMachineType(userAgent);
        String machineName = identityToMachineName.get(identity);
        if (machineName == null || !machineName.startsWith(machineType)) {
            for (int i = 1; i < Integer.MAX_VALUE && identityToMachineName.containsValue(machineName = machineType + " #" + i); ++i) {
            }
            identityToMachineName.put(identity, machineName);
        }
        this.machineName = machineName;
    }

    public static ConnectedHttpDevice from(NanoHTTPD.IHTTPSession session) {
        Map parms = session.getParameters();
        Map headers = session.getHeaders();
        String name = (String)((List)parms.get("name")).get(0);
        String remoteIp = (String)headers.get("remote-addr");
        String userAgent = (String)headers.get("user-agent");
        String identity = SessionCookie.fromSession(session);
        if (identity == null) {
            RobotLog.vv((String)TAG, (String)"cookie absent: using ip=%s", (Object[])new Object[]{remoteIp});
            identity = remoteIp;
        }
        return new ConnectedHttpDevice(identity, name, userAgent);
    }

    private static boolean testAgent(String agentLower, String target) {
        return agentLower.contains(target.toLowerCase());
    }

    private static String getMachineType(String userAgent) {
        switch (FtcUserAgentCategory.fromUserAgent((String)userAgent)) {
            case DRIVER_STATION: {
                return "DriverStation";
            }
            case ROBOT_CONTROLLER: {
                return "RobotController";
            }
            case OTHER: {
                String agentLower = userAgent.toLowerCase();
                if (ConnectedHttpDevice.testAgent(agentLower, "Windows Phone")) {
                    return "WindowsPhone";
                }
                if (ConnectedHttpDevice.testAgent(agentLower, "Windows")) {
                    return "Windows";
                }
                if (ConnectedHttpDevice.testAgent(agentLower, "Macintosh")) {
                    return "Mac";
                }
                if (ConnectedHttpDevice.testAgent(agentLower, "CrOS")) {
                    return "ChromeBook";
                }
                if (ConnectedHttpDevice.testAgent(agentLower, "android")) {
                    return "Android";
                }
                if (ConnectedHttpDevice.testAgent(agentLower, "iPhone")) {
                    return "iPhone";
                }
                if (ConnectedHttpDevice.testAgent(agentLower, "iPad")) {
                    return "iPad";
                }
                if (ConnectedHttpDevice.testAgent(agentLower, "X11")) {
                    return "Unix";
                }
                if (!ConnectedHttpDevice.testAgent(agentLower, "REV-UI")) break;
                return "REV UI";
            }
        }
        return "(unknown)";
    }

    public String toJson() {
        return SimpleGson.getInstance().toJson((Object)this);
    }

    public static ConnectedHttpDevice fromJson(String json) {
        return (ConnectedHttpDevice)SimpleGson.getInstance().fromJson(json, ConnectedHttpDevice.class);
    }

    public boolean equals(Object o) {
        if (o instanceof ConnectedHttpDevice) {
            ConnectedHttpDevice that = (ConnectedHttpDevice)o;
            return Objects.equals(this.identity, that.identity);
        }
        return false;
    }

    public int hashCode() {
        return this.identity.hashCode();
    }
}

