/*
 * Decompiled with CFR 0.152.
 */
package org.firstinspires.ftc.robotserver.internal.webserver;

import com.qualcomm.robotcore.util.RobotLog;
import com.qualcomm.robotcore.util.WebHandlerManager;
import com.qualcomm.robotcore.util.WebServer;
import com.qualcomm.robotcore.wifi.NetworkConnection;
import com.qualcomm.robotcore.wifi.NetworkConnectionFactory;
import com.qualcomm.robotcore.wifi.NetworkType;
import com.qualcomm.robotcore.wifi.WifiDirectAssistant;
import fi.iki.elonen.NanoHTTPD;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Map;
import org.firstinspires.ftc.robotcore.internal.system.AppUtil;
import org.firstinspires.ftc.robotcore.internal.webserver.R;
import org.firstinspires.ftc.robotcore.internal.webserver.RobotControllerWebInfo;
import org.firstinspires.ftc.robotcore.internal.webserver.websockets.WebSocketManager;
import org.firstinspires.ftc.robotserver.internal.webserver.RobotWebHandlerManager;
import org.firstinspires.ftc.robotserver.internal.webserver.tempfile.UploadedTempFileManagerFactory;
import org.firstinspires.ftc.robotserver.internal.webserver.websockets.FtcWebSocketServer;
import org.firstinspires.ftc.robotserver.internal.webserver.websockets.tootallnate.TooTallWebSocketServer;

public class CoreRobotWebServer
implements WebServer {
    public static final String TAG = CoreRobotWebServer.class.getSimpleName();
    private static final int DEFAULT_PORT = 8080;
    private static final boolean DBG = false;
    private final NetworkType networkType;
    private final NanoHTTPD nanoHttpd;
    private final RobotWebHandlerManager webHandlerManager;
    private final FtcWebSocketServer webSocketServer;
    private final Object startStopLock;
    private final Object lock;
    private NetworkConnection networkConnection;
    private String networkName;
    private InetAddress connectionOwnerAddress;
    private boolean serverIsAlive;
    private int port;

    public CoreRobotWebServer(NetworkType networkType) {
        this(8080, networkType);
    }

    public CoreRobotWebServer(int port, NetworkType networkType) {
        this.port = port;
        this.networkType = networkType;
        this.nanoHttpd = this.createNanoHttpd(port);
        this.nanoHttpd.setTempFileManagerFactory((NanoHTTPD.TempFileManagerFactory)new UploadedTempFileManagerFactory());
        this.webSocketServer = new TooTallWebSocketServer(new InetSocketAddress(port + 1));
        this.webHandlerManager = new RobotWebHandlerManager(this);
        this.lock = new Object();
        this.startStopLock = new Object();
    }

    public WebHandlerManager getWebHandlerManager() {
        return this.webHandlerManager;
    }

    private static void logError(String message) {
        RobotLog.ee((String)TAG, (String)message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean wasStarted() {
        Object object = this.startStopLock;
        synchronized (object) {
            return this.nanoHttpd.wasStarted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.startStopLock;
        synchronized (object) {
            try {
                if (this.wasStarted()) {
                    RobotLog.vv((String)TAG, (String)"Asked an already running WebServer to start");
                    return;
                }
                RobotLog.vv((String)TAG, (String)"starting port=%d", (Object[])new Object[]{this.port});
                this.nanoHttpd.start();
                this.webSocketServer.start();
                Object object2 = this.lock;
                synchronized (object2) {
                    this.networkConnection = NetworkConnectionFactory.getNetworkConnection((NetworkType)this.networkType, null);
                    if (this.networkConnection == null) {
                        CoreRobotWebServer.logError("Cannot start Network Connection of type: " + this.networkType);
                    }
                    this.networkConnection.enable();
                    this.networkName = this.networkConnection instanceof WifiDirectAssistant ? ((WifiDirectAssistant)this.networkConnection).getGroupNetworkName() : null;
                    this.connectionOwnerAddress = this.networkConnection.getConnectionOwnerAddress();
                    this.serverIsAlive = this.nanoHttpd.isAlive();
                }
                RobotLog.vv((String)TAG, (String)"started port=%d", (Object[])new Object[]{this.port});
            }
            catch (IOException e) {
                CoreRobotWebServer.logError(e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.startStopLock;
        synchronized (object) {
            try {
                this.webSocketServer.stop(5000);
            }
            catch (InterruptedException e) {
                RobotLog.ee((String)TAG, (Throwable)e, (String)"Error stopping WebSocket server");
            }
            RobotLog.vv((String)TAG, (String)"stopping port=%d", (Object[])new Object[]{this.port});
            this.nanoHttpd.stop();
            Object object2 = this.lock;
            synchronized (object2) {
                if (this.networkConnection != null) {
                    this.networkConnection.disable();
                    this.networkConnection = null;
                }
            }
            RobotLog.vv((String)TAG, (String)"stopped port=%d", (Object[])new Object[]{this.port});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RobotControllerWebInfo getConnectionInformation() {
        Object object = this.lock;
        synchronized (object) {
            int port;
            String serverUrl = "(unavailable)";
            if (this.connectionOwnerAddress != null && (port = this.nanoHttpd.getListeningPort()) != -1) {
                serverUrl = "http://" + this.connectionOwnerAddress.getHostAddress() + ":" + port;
            }
            return new RobotControllerWebInfo(this.networkName, this.networkConnection != null ? this.networkConnection.getPassphrase() : AppUtil.getDefContext().getString(R.string.manage_page_no_network), serverUrl, this.serverIsAlive);
        }
    }

    public WebSocketManager getWebSocketManager() {
        return this.webSocketServer.getWebSocketManager();
    }

    private NanoHTTPD createNanoHttpd(int port) {
        RobotLog.vv((String)TAG, (String)"creating NanoHTTPD(%d)", (Object[])new Object[]{port});
        return new NanoHTTPD(port){

            public NanoHTTPD.Response serve(NanoHTTPD.IHTTPSession session) {
                NanoHTTPD.Method method = session.getMethod();
                if (NanoHTTPD.Method.GET == method || NanoHTTPD.Method.PUT == method || NanoHTTPD.Method.POST == method) {
                    return CoreRobotWebServer.this.webHandlerManager.serve(session);
                }
                return 1.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.NOT_FOUND, (String)"text/plain", (String)"");
            }
        };
    }

    public static void logSession(NanoHTTPD.IHTTPSession session, boolean logPings) {
        String uri = session.getUri();
        if (!logPings && uri.equals("/ping")) {
            return;
        }
        String prefix = "\n   ";
        StringBuilder builder = new StringBuilder();
        builder.append(prefix).append(String.format("uri='%s'", session.getUri()));
        builder.append(prefix).append(String.format("method='%s'", session.getMethod()));
        if (session.getQueryParameterString() != null && session.getQueryParameterString().length() > 0) {
            builder.append(prefix).append(String.format("query='%s'", session.getQueryParameterString()));
        }
        for (Map.Entry param : session.getParameters().entrySet()) {
            builder.append(prefix).append(String.format("param('%s')=[", param.getKey()));
            boolean first = true;
            for (String value : (List)param.getValue()) {
                if (!first) {
                    builder.append(", ");
                }
                builder.append(String.format("'%s'", value));
                first = false;
            }
            builder.append("]");
        }
        for (Map.Entry header : session.getHeaders().entrySet()) {
            builder.append(prefix).append(String.format("header %s=%s", header.getKey(), header.getValue()));
        }
        RobotLog.dd((String)TAG, (String)"session(0x%08x)=%s", (Object[])new Object[]{session.hashCode(), builder.toString()});
    }
}

