/*
 * Decompiled with CFR 0.152.
 */
package org.firstinspires.ftc.robotserver.internal.webserver;

import androidx.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;

public class MimeTypesUtil {
    public static final String MIME_JSON = "application/json";
    public static final String MIME_JAVASCRIPT = "application/javascript";
    public static final String MIME_CSS = "text/css";
    public static final String MIME_TEXT = "text/plain";
    private static final Map<String, String> MIME_TYPES_BY_EXT = new HashMap<String, String>();

    private MimeTypesUtil() {
    }

    public static String getMimeType(String extension) {
        if (extension.startsWith(".")) {
            extension = extension.substring(1);
        }
        return MIME_TYPES_BY_EXT.get(extension);
    }

    @Nullable
    public static String determineMimeType(String path) {
        String mimeType = null;
        int lastDot = path.lastIndexOf(".");
        if (lastDot != -1) {
            String ext = path.substring(lastDot + 1);
            mimeType = MimeTypesUtil.getMimeType(ext);
        }
        return mimeType;
    }

    static {
        MIME_TYPES_BY_EXT.put("asc", MIME_TEXT);
        MIME_TYPES_BY_EXT.put("bin", "application/octet-stream");
        MIME_TYPES_BY_EXT.put("class", "application/octet-stream");
        MIME_TYPES_BY_EXT.put("css", MIME_CSS);
        MIME_TYPES_BY_EXT.put("cur", "image/x-win-bitmap");
        MIME_TYPES_BY_EXT.put("doc", "application/msword");
        MIME_TYPES_BY_EXT.put("exe", "application/octet-stream");
        MIME_TYPES_BY_EXT.put("flv", "video/x-flv");
        MIME_TYPES_BY_EXT.put("gif", "image/gif");
        MIME_TYPES_BY_EXT.put("gz", "application/octet-stream");
        MIME_TYPES_BY_EXT.put("gzip", "application/octet-stream");
        MIME_TYPES_BY_EXT.put("html", "text/html");
        MIME_TYPES_BY_EXT.put("htm", "text/html");
        MIME_TYPES_BY_EXT.put("ico", "image/x-icon");
        MIME_TYPES_BY_EXT.put("java", "text/x-java-source, text/java");
        MIME_TYPES_BY_EXT.put("jpeg", "image/jpeg");
        MIME_TYPES_BY_EXT.put("jpg", "image/jpeg");
        MIME_TYPES_BY_EXT.put("js", MIME_JAVASCRIPT);
        MIME_TYPES_BY_EXT.put("json", MIME_JSON);
        MIME_TYPES_BY_EXT.put("less", MIME_CSS);
        MIME_TYPES_BY_EXT.put("logcat", MIME_TEXT);
        MIME_TYPES_BY_EXT.put("m3u8", "application/vnd.apple.mpegurl");
        MIME_TYPES_BY_EXT.put("m3u", "audio/mpeg-url");
        MIME_TYPES_BY_EXT.put("md", MIME_TEXT);
        MIME_TYPES_BY_EXT.put("mov", "video/quicktime");
        MIME_TYPES_BY_EXT.put("mp3", "audio/mpeg");
        MIME_TYPES_BY_EXT.put("mp4", "video/mp4");
        MIME_TYPES_BY_EXT.put("ogg", "application/x-ogg");
        MIME_TYPES_BY_EXT.put("ogv", "video/ogg");
        MIME_TYPES_BY_EXT.put("pdf", "application/pdf");
        MIME_TYPES_BY_EXT.put("png", "image/png");
        MIME_TYPES_BY_EXT.put("svg", "image/svg+xml");
        MIME_TYPES_BY_EXT.put("swf", "application/x-shockwave-flash");
        MIME_TYPES_BY_EXT.put("ts", "video/mp2t");
        MIME_TYPES_BY_EXT.put("txt", MIME_TEXT);
        MIME_TYPES_BY_EXT.put("wav", "audio/wav");
        MIME_TYPES_BY_EXT.put("xml", "text/xml");
        MIME_TYPES_BY_EXT.put("zip", "application/octet-stream");
        MIME_TYPES_BY_EXT.put("map", "application/json map");
        MIME_TYPES_BY_EXT.put("jar", "application/octet-stream");
        MIME_TYPES_BY_EXT.put("log", MIME_TEXT);
        MIME_TYPES_BY_EXT.put("ttf", "application/x-font-truetype");
        MIME_TYPES_BY_EXT.put("otf", "application/x-font-opentype");
        MIME_TYPES_BY_EXT.put("woff", "application/font-woff");
        MIME_TYPES_BY_EXT.put("woff2", "application/font-woff2");
        MIME_TYPES_BY_EXT.put("eot", "application/vnd.ms-fontobject");
        MIME_TYPES_BY_EXT.put("sfnt", "application/font-sfnt");
    }

    public static class TypedPaths {
        private static final Map<String, String> mimeTypesByPath = new HashMap<String, String>();

        public void setMimeType(String path, String mimeType) {
            mimeTypesByPath.put(path, mimeType);
        }

        @Nullable
        String determineMimeType(String path) {
            String mimeType = mimeTypesByPath.get(path);
            if (mimeType == null) {
                mimeType = MimeTypesUtil.determineMimeType(path);
            }
            return mimeType;
        }
    }
}

