/*
 * Decompiled with CFR 0.152.
 */
package org.firstinspires.ftc.robotserver.internal.webserver;

import com.google.gson.annotations.SerializedName;
import com.qualcomm.robotcore.util.Device;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.firstinspires.ftc.robotcore.internal.collections.SimpleGson;
import org.firstinspires.ftc.robotserver.internal.webserver.ConnectedHttpDevice;

public class PingResponse {
    public static final long EXPIRATION_DURATION_SECONDS = 3L;
    private static final Comparator<ConnectedHttpDevice> CONNECTED_HTTP_DEVICE_COMPARATOR = new Comparator<ConnectedHttpDevice>(){

        @Override
        public int compare(ConnectedHttpDevice connectedHttpDevice1, ConnectedHttpDevice connectedHttpDevice2) {
            int result = connectedHttpDevice1.machineName.compareToIgnoreCase(connectedHttpDevice2.machineName);
            if (result == 0) {
                result = connectedHttpDevice1.currentPage.compareToIgnoreCase(connectedHttpDevice2.currentPage);
            }
            return result;
        }
    };
    private final transient Object pingLock = new Object();
    private final transient List<Long> pingTimes = new LinkedList<Long>();
    private final transient List<ConnectedHttpDevice> connectedDevices = new LinkedList<ConnectedHttpDevice>();
    private final String serial = Device.getSerialNumberOrUnknown();
    @SerializedName(value="connectedDevices")
    private List<ConnectedHttpDevice> sortedConnectedDevices = new ArrayList<ConnectedHttpDevice>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noteDevicePing(ConnectedHttpDevice device) {
        Object object = this.pingLock;
        synchronized (object) {
            long now = System.nanoTime();
            int index = this.connectedDevices.indexOf(device);
            if (index != -1) {
                this.pingTimes.remove(index);
                this.connectedDevices.remove(index);
            }
            this.pingTimes.add(now);
            this.connectedDevices.add(device);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOldPings() {
        Object object = this.pingLock;
        synchronized (object) {
            long minimum = System.nanoTime() - TimeUnit.SECONDS.toNanos(3L);
            while (!this.pingTimes.isEmpty() && this.pingTimes.get(0) < minimum) {
                this.pingTimes.remove(0);
                this.connectedDevices.remove(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSortedConnectedDevices() {
        Object object = this.pingLock;
        synchronized (object) {
            this.sortedConnectedDevices = new ArrayList<ConnectedHttpDevice>(this.connectedDevices);
            Collections.sort(this.sortedConnectedDevices, CONNECTED_HTTP_DEVICE_COMPARATOR);
        }
    }

    public String toJson() {
        this.updateSortedConnectedDevices();
        return SimpleGson.getInstance().toJson((Object)this);
    }
}

