/*
 * Decompiled with CFR 0.152.
 */
package org.firstinspires.ftc.robotserver.internal.webserver;

import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.AssetManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.qualcomm.robotcore.R;
import com.qualcomm.robotcore.hardware.configuration.LynxConstants;
import com.qualcomm.robotcore.robocol.Command;
import com.qualcomm.robotcore.util.Device;
import com.qualcomm.robotcore.util.IncludedFirmwareFileInfo;
import com.qualcomm.robotcore.util.RobotLog;
import com.qualcomm.robotcore.util.SerialNumber;
import com.qualcomm.robotcore.util.ThreadPool;
import com.qualcomm.robotcore.util.WebHandlerManager;
import com.qualcomm.robotcore.util.WebServer;
import fi.iki.elonen.NanoHTTPD;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import org.firstinspires.ftc.robotcore.internal.collections.SimpleGson;
import org.firstinspires.ftc.robotcore.internal.hardware.android.AndroidBoard;
import org.firstinspires.ftc.robotcore.internal.network.ApChannel;
import org.firstinspires.ftc.robotcore.internal.network.CallbackResult;
import org.firstinspires.ftc.robotcore.internal.network.InvalidNetworkSettingException;
import org.firstinspires.ftc.robotcore.internal.network.NetworkConnectionHandler;
import org.firstinspires.ftc.robotcore.internal.network.RecvLoopRunnable;
import org.firstinspires.ftc.robotcore.internal.network.RobotCoreCommandList;
import org.firstinspires.ftc.robotcore.internal.system.AppUtil;
import org.firstinspires.ftc.robotcore.internal.ui.UILocation;
import org.firstinspires.ftc.robotcore.internal.webserver.RobotControllerWebInfo;
import org.firstinspires.ftc.robotcore.internal.webserver.WebHandler;
import org.firstinspires.ftc.robotcore.internal.webserver.WebObserver;
import org.firstinspires.ftc.robotcore.internal.webserver.websockets.WebSocketManager;
import org.firstinspires.ftc.robotcore.internal.webserver.websockets.WebSocketNamespaceHandler;
import org.firstinspires.ftc.robotserver.internal.webserver.AppThemeColors;
import org.firstinspires.ftc.robotserver.internal.webserver.ConnectedHttpDevice;
import org.firstinspires.ftc.robotserver.internal.webserver.FilenameNotProvidedException;
import org.firstinspires.ftc.robotserver.internal.webserver.MimeTypesUtil;
import org.firstinspires.ftc.robotserver.internal.webserver.NoCachingWebHandler;
import org.firstinspires.ftc.robotserver.internal.webserver.PingResponse;
import org.firstinspires.ftc.robotserver.internal.webserver.RobotWebHandlerManager;
import org.firstinspires.ftc.robotserver.internal.webserver.SessionCookie;
import org.firstinspires.ftc.robotserver.internal.webserver.SessionParametersGenerator;
import org.firstinspires.ftc.robotserver.internal.webserver.controlhubupdater.ChUpdaterCommManager;
import org.firstinspires.ftc.robotserver.internal.webserver.controlhubupdater.ChUpdaterUploadResponse;

public class RobotControllerWebHandlers {
    public static final String TAG = RobotControllerWebHandlers.class.getSimpleName();
    public static boolean DEBUG = false;
    public static final String URI_RC_CONFIG = "/js/rc_config.js";
    public static final String URI_NAV_HOME = "/connection.html";
    public static final String URI_NAV_MANAGE = "/manage.html";
    public static final String URI_NAV_HELP = "/help.html";
    public static final String URI_ANON_PING = "/anonymousPing";
    public static final String URI_PING = "/ping";
    public static final String URI_LIST_LOG_FILES = "/listLogs";
    public static final String URI_DOWNLOAD_FILE = "/downloadFile";
    public static final String URI_CHANGE_NETWORK_SETTINGS = "/changeNetworkSettings";
    public static final String URI_UPLOAD_EXPANSION_HUB_FIRMWARE = "/uploadExpansionHubFirmware";
    public static final String URI_REV_HUBS_AVAILABLE_FOR_UPDATE = "/revHubsAvailableForUpdate";
    public static final String URI_PERFORM_REV_FIRMWARE_UPDATE = "/performRevFirmwareUpdate";
    public static final String URI_UPDATE_CONTROL_HUB_APK = "/updateControlHubAPK";
    public static final String URI_UPLOAD_WEBCAM_CALIBRATION_FILE = "/uploadWebcamCalibrationFile";
    public static final String URI_UPLOAD_CONTROL_HUB_OTA = "/uploadControlHubOta";
    public static final String URI_REBOOT = "/reboot";
    public static final String URI_RC_INFO = "/js/rcInfo.json";
    public static final String URI_COLORS = "/css/colors.less";
    public static final String INDEX_FILE = "frame.html";
    public static final String URI_EXIT_PROGRAM_AND_MANAGE = "/exitProgramAndManage";
    public static final String URI_TOAST = "/toast";
    public static final String PARAM_NAME = "name";
    public static final String PARAM_AP_PASSWORD = "password";
    public static final String PARAM_CHANNEL_NAME = "channelName";
    public static final String PARAM_NEW_NAME = "new_name";
    public static final String PARAM_MESSAGE = "message";
    public static final String PARAM_SERIAL_NUMBER = "serialNumber";
    public static final String PARAM_FILENAME = "filename";

    public static void initialize(WebHandlerManager manager) {
        FileUpload apkUpdateHandler;
        WebSocketManager webSocketManager = manager.getWebServer().getWebSocketManager();
        ChUpdaterCommManager chUpdaterCommManager = null;
        if (AndroidBoard.getInstance().hasControlHubUpdater()) {
            chUpdaterCommManager = new ChUpdaterCommManager(webSocketManager);
            webSocketManager.registerNamespaceHandler((WebSocketNamespaceHandler)chUpdaterCommManager);
            apkUpdateHandler = new ControlHubApkUpdate(chUpdaterCommManager);
        } else {
            apkUpdateHandler = new DragonboardAPKUpdate();
            webSocketManager.registerNamespaceAsBroadcastOnly("ControlHubUpdater");
        }
        manager.register("/", (WebHandler)new ServerRootIndex(INDEX_FILE));
        manager.register(URI_ANON_PING, (WebHandler)new AnonymousPing());
        manager.register(URI_PING, RobotControllerWebHandlers.decorateWithParms(new ClientPing()));
        manager.register(URI_LIST_LOG_FILES, (WebHandler)new ListLogFiles());
        manager.register(URI_DOWNLOAD_FILE, (WebHandler)new FileDownload());
        manager.register(URI_CHANGE_NETWORK_SETTINGS, RobotControllerWebHandlers.decorateWithParms(new ChangeNetworkSettings()));
        manager.register(URI_UPDATE_CONTROL_HUB_APK, (WebHandler)apkUpdateHandler);
        manager.register(URI_UPLOAD_EXPANSION_HUB_FIRMWARE, (WebHandler)new StandardUpload(AppUtil.LYNX_FIRMWARE_UPDATE_DIR.getAbsolutePath()));
        manager.register(URI_REV_HUBS_AVAILABLE_FOR_UPDATE, (WebHandler)new RevHubsAvailableForUpdate());
        manager.register(URI_PERFORM_REV_FIRMWARE_UPDATE, RobotControllerWebHandlers.decorateWithParms(new PerformRevFirmwareUpdate()));
        manager.register(URI_UPLOAD_WEBCAM_CALIBRATION_FILE, (WebHandler)new StandardUpload(AppUtil.WEBCAM_CALIBRATIONS_DIR.getAbsolutePath()));
        manager.register(URI_UPLOAD_CONTROL_HUB_OTA, (WebHandler)new OtaUpdate(chUpdaterCommManager));
        manager.register(URI_RC_CONFIG, (WebHandler)new RobotControllerConfiguration());
        manager.register(URI_RC_INFO, (WebHandler)new RobotControllerInfoHandler(manager.getWebServer()));
        manager.register(URI_REBOOT, (WebHandler)new Reboot());
        manager.register(URI_TOAST, (WebHandler)new SimpleSuccess());
        manager.register(URI_EXIT_PROGRAM_AND_MANAGE, (WebHandler)new SimpleSuccess());
        AppThemeColorsHandler colorsHandler = new AppThemeColorsHandler();
        manager.register(URI_COLORS, (WebHandler)colorsHandler);
        manager.registerObserver(URI_COLORS, (WebObserver)colorsHandler);
    }

    public static WebHandler decorateWithParms(WebHandler delegate) {
        return new SessionParametersGenerator(delegate);
    }

    private RobotControllerWebHandlers() {
    }

    public static class SimpleSuccess
    implements WebHandler {
        public static final String TAG = SimpleSuccess.class.getSimpleName();

        public NanoHTTPD.Response getResponse(NanoHTTPD.IHTTPSession session) {
            return RobotWebHandlerManager.OK_RESPONSE;
        }
    }

    public static class AppThemeColorsHandler
    implements WebHandler,
    WebObserver {
        public static final String TAG = AppThemeColorsHandler.class.getSimpleName();
        protected final Map<String, String> sessionColors = new ConcurrentHashMap<String, String>();

        public void observe(NanoHTTPD.IHTTPSession session) {
            String sessionCookie;
            String appThemeHeader = (String)session.getHeaders().get(AppThemeColors.htppHeaderNameLower);
            if (appThemeHeader != null && (sessionCookie = SessionCookie.fromSession(session)) != null) {
                this.sessionColors.put(sessionCookie, AppThemeColors.fromHeader(appThemeHeader));
            }
        }

        public NanoHTTPD.Response getResponse(NanoHTTPD.IHTTPSession session) throws IOException, NanoHTTPD.ResponseException {
            String colors;
            String sessionCookie = SessionCookie.fromSession(session);
            String string2 = colors = sessionCookie == null ? null : this.sessionColors.get(sessionCookie);
            if (colors == null) {
                colors = InstanceHolder.ourColors;
            }
            return NoCachingWebHandler.setNoCache(session, NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, (String)"text/css", (String)colors));
        }

        protected static class InstanceHolder {
            public static final String ourColors = AppThemeColors.fromTheme().toLess();

            protected InstanceHolder() {
            }
        }
    }

    public static class RobotControllerConfiguration
    implements WebHandler {
        public NanoHTTPD.Response getResponse(NanoHTTPD.IHTTPSession session) throws IOException, NanoHTTPD.ResponseException {
            StringBuilder js = new StringBuilder();
            this.appendVariables(js);
            return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, (String)"application/javascript", (String)js.toString());
        }

        protected void appendVariables(StringBuilder js) {
            RobotControllerConfiguration.appendVariable(js, "URI_ANON_PING", RobotControllerWebHandlers.URI_ANON_PING);
            RobotControllerConfiguration.appendVariable(js, "URI_PING", RobotControllerWebHandlers.URI_PING);
            RobotControllerConfiguration.appendVariable(js, "URI_LIST_LOG_FILES", RobotControllerWebHandlers.URI_LIST_LOG_FILES);
            RobotControllerConfiguration.appendVariable(js, "URI_DOWNLOAD_FILE", RobotControllerWebHandlers.URI_DOWNLOAD_FILE);
            RobotControllerConfiguration.appendVariable(js, "URI_CHANGE_NETWORK_SETTINGS", RobotControllerWebHandlers.URI_CHANGE_NETWORK_SETTINGS);
            RobotControllerConfiguration.appendVariable(js, "URI_UPLOAD_EXPANSION_HUB_FIRMWARE", RobotControllerWebHandlers.URI_UPLOAD_EXPANSION_HUB_FIRMWARE);
            RobotControllerConfiguration.appendVariable(js, "URI_REV_HUBS_AVAILABLE_FOR_UPDATE", RobotControllerWebHandlers.URI_REV_HUBS_AVAILABLE_FOR_UPDATE);
            RobotControllerConfiguration.appendVariable(js, "URI_PERFORM_REV_FIRMWARE_UPDATE", RobotControllerWebHandlers.URI_PERFORM_REV_FIRMWARE_UPDATE);
            RobotControllerConfiguration.appendVariable(js, "URI_UPDATE_CONTROL_HUB_APK", RobotControllerWebHandlers.URI_UPDATE_CONTROL_HUB_APK);
            RobotControllerConfiguration.appendVariable(js, "URI_UPLOAD_WEBCAM_CALIBRATION_FILE", RobotControllerWebHandlers.URI_UPLOAD_WEBCAM_CALIBRATION_FILE);
            RobotControllerConfiguration.appendVariable(js, "URI_UPLOAD_CONTROL_HUB_OTA", RobotControllerWebHandlers.URI_UPLOAD_CONTROL_HUB_OTA);
            RobotControllerConfiguration.appendVariable(js, "URI_NAV_HOME", RobotControllerWebHandlers.URI_NAV_HOME);
            RobotControllerConfiguration.appendVariable(js, "URI_NAV_MANAGE", RobotControllerWebHandlers.URI_NAV_MANAGE);
            RobotControllerConfiguration.appendVariable(js, "URI_NAV_HELP", RobotControllerWebHandlers.URI_NAV_HELP);
            RobotControllerConfiguration.appendVariable(js, "URI_RC_INFO", RobotControllerWebHandlers.URI_RC_INFO);
            RobotControllerConfiguration.appendVariable(js, "URI_REBOOT", RobotControllerWebHandlers.URI_REBOOT);
            RobotControllerConfiguration.appendVariable(js, "URI_COLORS", RobotControllerWebHandlers.URI_COLORS);
            RobotControllerConfiguration.appendVariable(js, "PARAM_NAME", RobotControllerWebHandlers.PARAM_NAME);
            RobotControllerConfiguration.appendVariable(js, "PARAM_AP_PASSWORD", RobotControllerWebHandlers.PARAM_AP_PASSWORD);
            RobotControllerConfiguration.appendVariable(js, "PARAM_CHANNEL_NAME", RobotControllerWebHandlers.PARAM_CHANNEL_NAME);
            RobotControllerConfiguration.appendVariable(js, "PARAM_NEW_NAME", RobotControllerWebHandlers.PARAM_NEW_NAME);
            RobotControllerConfiguration.appendVariable(js, "PARAM_MESSAGE", RobotControllerWebHandlers.PARAM_MESSAGE);
            RobotControllerConfiguration.appendVariable(js, "PARAM_SERIAL_NUMBER", RobotControllerWebHandlers.PARAM_SERIAL_NUMBER);
            RobotControllerConfiguration.appendVariable(js, "PARAM_FILENAME", RobotControllerWebHandlers.PARAM_FILENAME);
            RobotControllerConfiguration.appendVariable(js, "URI_EXIT_PROGRAM_AND_MANAGE", RobotControllerWebHandlers.URI_EXIT_PROGRAM_AND_MANAGE);
            RobotControllerConfiguration.appendVariable(js, "URI_TOAST", RobotControllerWebHandlers.URI_TOAST);
        }

        public static void appendVariable(StringBuilder js, String name, String value) {
            js.append("var ").append(name).append(" = '").append(value).append("';\n");
        }
    }

    public static class Reboot
    implements WebHandler {
        public static final String TAG = Reboot.class.getSimpleName();
        private static final boolean ENABLE_REBOOT = true;

        public NanoHTTPD.Response getResponse(NanoHTTPD.IHTTPSession session) {
            if (LynxConstants.isRevControlHub()) {
                ThreadPool.getDefault().submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            AppUtil.getInstance().showToast(UILocation.BOTH, AppUtil.getDefContext().getString(R.string.toastRebootRC));
                            Thread.sleep(1000L);
                            new ProcessBuilder("reboot").start();
                        }
                        catch (IOException e) {
                            RobotLog.ee((String)TAG, (Throwable)e, (String)"unable to process reboot request");
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                    }
                });
                return RobotWebHandlerManager.OK_RESPONSE;
            }
            return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.UNAUTHORIZED, (String)"text/plain", (String)"Rebooting supported only on REV Control Hub");
        }
    }

    public static class ClientPing
    extends RequireNameHandler {
        final PingResponse pingResponse = new PingResponse();

        @Override
        public NanoHTTPD.Response getResponse(NanoHTTPD.IHTTPSession session, @NonNull String name) throws IOException, NanoHTTPD.ResponseException {
            this.pingResponse.noteDevicePing(ConnectedHttpDevice.from(session));
            this.pingResponse.removeOldPings();
            return NoCachingWebHandler.setNoCache(session, NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, (String)MimeTypesUtil.getMimeType("json"), (String)this.pingResponse.toJson()));
        }
    }

    public static class AnonymousPing
    implements WebHandler {
        public NanoHTTPD.Response getResponse(NanoHTTPD.IHTTPSession session) {
            if (DEBUG) {
                RobotLog.dd((String)TAG, (String)"In AnonymousPing");
            }
            return RobotWebHandlerManager.OK_RESPONSE;
        }
    }

    public static class ChangeNetworkSettings
    implements WebHandler {
        public synchronized NanoHTTPD.Response getResponse(NanoHTTPD.IHTTPSession session) throws IOException, NanoHTTPD.ResponseException {
            String name = null;
            String password = null;
            ApChannel channel = null;
            List names = (List)session.getParameters().get(RobotControllerWebHandlers.PARAM_NAME);
            List passwords = (List)session.getParameters().get(RobotControllerWebHandlers.PARAM_AP_PASSWORD);
            List channelNames = (List)session.getParameters().get(RobotControllerWebHandlers.PARAM_CHANNEL_NAME);
            if (names != null) {
                name = (String)names.get(0);
            }
            if (passwords != null) {
                password = (String)passwords.get(0);
            }
            if (channelNames != null) {
                channel = ApChannel.fromName((String)((String)channelNames.get(0)));
            }
            try {
                NetworkConnectionHandler.getInstance().getNetworkConnection().setNetworkSettings(name, password, channel);
            }
            catch (InvalidNetworkSettingException e) {
                return RobotWebHandlerManager.internalErrorResponse(TAG, e);
            }
            return RobotWebHandlerManager.OK_RESPONSE;
        }
    }

    private static final class DragonboardAPKUpdate
    extends FileUpload {
        private static final File DESTINATION_DIR = AppUtil.RC_APP_UPDATE_DIR;
        private static final String DRAGONBOARD_APK_METADATA_TAG = "org.firstinspires.main.entry";

        private DragonboardAPKUpdate() {
        }

        private NanoHTTPD.Response invalidApk(File file, String extraError) {
            RobotLog.ii((String)TAG, (String)"Invalid APK. Removing from file system");
            boolean isRemoved = file.delete();
            if (!isRemoved) {
                RobotLog.ii((String)TAG, (String)"Invalid APK cannot be removed");
            }
            String errorString = "Invalid APK";
            if (extraError != null) {
                errorString = errorString + ": " + extraError;
            }
            return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.INTERNAL_ERROR, (String)"text/plain", (String)errorString);
        }

        private String getDescription(String filePath, PackageInfo info) {
            StringBuilder desc = new StringBuilder();
            desc.append(filePath).append(System.lineSeparator());
            desc.append(info.packageName).append(System.lineSeparator());
            boolean isValidToInstall = false;
            for (ActivityInfo activityInfo : info.activities) {
                if (activityInfo.metaData == null || !Device.isRevControlHub() || !activityInfo.metaData.getBoolean(DRAGONBOARD_APK_METADATA_TAG, false)) continue;
                desc.append(info.packageName).append("/").append(activityInfo.name).append(System.lineSeparator());
                isValidToInstall = true;
            }
            if (isValidToInstall) {
                return desc.toString();
            }
            return "";
        }

        private NanoHTTPD.Response writeDescriptionFile(String filename, String desc) {
            NanoHTTPD.Response response;
            int lastDot = filename.lastIndexOf(46);
            String descFileName = filename.substring(0, lastDot) + ".des";
            File toWrite = new File(DESTINATION_DIR, descFileName);
            FileWriter writer = new FileWriter(toWrite);
            try {
                writer.write(desc);
                response = NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, (String)"application/json", (String)"{}");
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((Writer)writer).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    RobotLog.ii((String)TAG, (String)e.getMessage());
                    return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.INTERNAL_ERROR, (String)"text/plain", (String)e.getMessage());
                }
            }
            ((Writer)writer).close();
            return response;
        }

        private NanoHTTPD.Response writeDescription(File file) {
            PackageManager pm = AppUtil.getInstance().getActivity().getPackageManager();
            PackageInfo info = pm.getPackageArchiveInfo(file.getAbsolutePath(), 129);
            if (info == null) {
                return this.invalidApk(file, null);
            }
            String desc = this.getDescription(file.getAbsolutePath(), info);
            boolean isNotValid = desc.isEmpty();
            if (isNotValid) {
                return this.invalidApk(file, "This APK does not support the Control Hub.");
            }
            return this.writeDescriptionFile(file.getName(), desc);
        }

        @Override
        public NanoHTTPD.Response hook(File uploadedFile) {
            return this.writeDescription(uploadedFile);
        }

        @Override
        public File provideDestinationDirectory(String filename, File tempFile) {
            return DESTINATION_DIR;
        }
    }

    private static class ControlHubApkUpdate
    extends ControlHubUpdaterUpload {
        protected ControlHubApkUpdate(ChUpdaterCommManager chUpdaterCommManager) {
            super(ChUpdaterCommManager.UpdateType.APP, chUpdaterCommManager);
        }

        @Override
        public File provideDestinationDirectory(String fileName, File tempFile) {
            return AppUtil.RC_APP_UPDATE_DIR;
        }
    }

    private static class OtaUpdate
    extends ControlHubUpdaterUpload {
        protected OtaUpdate(@Nullable ChUpdaterCommManager chUpdaterCommManager) {
            super(ChUpdaterCommManager.UpdateType.OTA, chUpdaterCommManager);
        }

        @Override
        public File provideDestinationDirectory(String fileName, File tempFile) {
            return AppUtil.OTA_UPDATE_DIR;
        }
    }

    private static abstract class ControlHubUpdaterUpload
    extends FileUpload {
        private final ChUpdaterCommManager.UpdateType updateType;
        private final ChUpdaterCommManager chUpdaterCommManager;

        protected ControlHubUpdaterUpload(ChUpdaterCommManager.UpdateType updateType, @Nullable ChUpdaterCommManager chUpdaterCommManager) {
            this.updateType = updateType;
            this.chUpdaterCommManager = chUpdaterCommManager;
        }

        @Override
        public final NanoHTTPD.Response hook(File uploadedFile) {
            if (!AndroidBoard.getInstance().hasControlHubUpdater() || this.chUpdaterCommManager == null) {
                if (AndroidBoard.getInstance().hasControlHubUpdater()) {
                    RobotLog.ww((String)TAG, (String)"This device should include the Control Hub Updater, yet chUpdaterCommManager is null.");
                }
                return RobotWebHandlerManager.internalErrorResponse(TAG, AppUtil.getDefContext().getString(R.string.ch_updater_not_supported));
            }
            UUID transactionId = this.chUpdaterCommManager.startUpdate(this.updateType, uploadedFile);
            return ChUpdaterUploadResponse.create(transactionId);
        }
    }

    private static final class PerformRevFirmwareUpdate
    implements WebHandler {
        private PerformRevFirmwareUpdate() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public NanoHTTPD.Response getResponse(NanoHTTPD.IHTTPSession session) {
            String result;
            RobotCoreCommandList.FWImage fwImage;
            if (session.getMethod() != NanoHTTPD.Method.POST) {
                return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.BAD_REQUEST, (String)"text/plain", (String)"Only POST method is supported");
            }
            List serialNumberParameters = (List)session.getParameters().get(RobotControllerWebHandlers.PARAM_SERIAL_NUMBER);
            if (serialNumberParameters == null) {
                return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.BAD_REQUEST, (String)"text/plain", (String)"serialNumber parameter not provided");
            }
            SerialNumber serialNumber = SerialNumber.fromString((String)((String)serialNumberParameters.get(0)));
            if (session.getParameters().containsKey(RobotControllerWebHandlers.PARAM_FILENAME)) {
                File fwFile = new File(AppUtil.LYNX_FIRMWARE_UPDATE_DIR, (String)((List)session.getParameters().get(RobotControllerWebHandlers.PARAM_FILENAME)).get(0));
                fwImage = new RobotCoreCommandList.FWImage(fwFile, false);
            } else {
                fwImage = IncludedFirmwareFileInfo.FW_IMAGE;
            }
            RobotCoreCommandList.LynxFirmwareUpdate commandPayload = new RobotCoreCommandList.LynxFirmwareUpdate();
            commandPayload.firmwareImageFile = fwImage;
            commandPayload.serialNumber = serialNumber;
            commandPayload.originatorId = UUID.randomUUID().toString();
            Command firmwareUpdateCommand = new Command("CMD_LYNX_FIRMWARE_UPDATE", commandPayload.serialize());
            FirmwareUpdateResultReceiver receiver = new FirmwareUpdateResultReceiver(commandPayload.originatorId);
            NetworkConnectionHandler.getInstance().pushReceiveLoopCallback((RecvLoopRunnable.RecvLoopCallback)receiver);
            NetworkConnectionHandler.getInstance().injectReceivedCommand(firmwareUpdateCommand);
            try {
                result = receiver.didUpdateSucceed();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                NanoHTTPD.Response response = RobotWebHandlerManager.INTERNAL_ERROR_RESPONSE;
                return response;
            }
            finally {
                NetworkConnectionHandler.getInstance().removeReceiveLoopCallback((RecvLoopRunnable.RecvLoopCallback)receiver);
            }
            return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, (String)"application/json", (String)result);
        }

        private static final class FirmwareUpdateResultReceiver
        extends RecvLoopRunnable.DegenerateCallback {
            private final CountDownLatch latch = new CountDownLatch(1);
            private final String originatorId;
            volatile String result = null;

            public FirmwareUpdateResultReceiver(String originatorId) {
                this.originatorId = originatorId;
            }

            public CallbackResult commandEvent(Command command) {
                if ("CMD_LYNX_FIRMWARE_UPDATE_RESP".equals(command.getName())) {
                    RobotCoreCommandList.LynxFirmwareUpdateResp deserializedResponse = RobotCoreCommandList.LynxFirmwareUpdateResp.deserialize((String)command.getExtra());
                    if (this.originatorId.equals(deserializedResponse.originatorId)) {
                        deserializedResponse.originatorId = null;
                        this.result = deserializedResponse.serialize();
                        this.latch.countDown();
                        return CallbackResult.HANDLED;
                    }
                }
                return CallbackResult.NOT_HANDLED;
            }

            public String didUpdateSucceed() throws InterruptedException {
                this.latch.await();
                return this.result;
            }
        }
    }

    private static final class RevHubsAvailableForUpdate
    implements WebHandler {
        private RevHubsAvailableForUpdate() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public NanoHTTPD.Response getResponse(NanoHTTPD.IHTTPSession session) {
            if (!NetworkConnectionHandler.getInstance().readyForCommandProcessing()) {
                NanoHTTPD.Response errorResponse = NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.SERVICE_UNAVAILABLE, (String)"text/plain", (String)"Currently unable to scan for REV Hubs");
                errorResponse.addHeader("Retry-After", "5");
                return errorResponse;
            }
            UsbAccessibleLynxModulesReceiver receiver = new UsbAccessibleLynxModulesReceiver();
            RobotCoreCommandList.USBAccessibleLynxModulesRequest getModulesRequest = new RobotCoreCommandList.USBAccessibleLynxModulesRequest();
            getModulesRequest.forFirmwareUpdate = true;
            Command getModulesCommand = new Command("CMD_GET_USB_ACCESSIBLE_LYNX_MODULES", getModulesRequest.serialize());
            NetworkConnectionHandler.getInstance().pushReceiveLoopCallback((RecvLoopRunnable.RecvLoopCallback)receiver);
            NetworkConnectionHandler.getInstance().injectReceivedCommand(getModulesCommand);
            String modules = "";
            try {
                modules = receiver.waitForUsbAccessibleLynxModules();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                NanoHTTPD.Response response = RobotWebHandlerManager.INTERNAL_ERROR_RESPONSE;
                return response;
            }
            finally {
                NetworkConnectionHandler.getInstance().removeReceiveLoopCallback((RecvLoopRunnable.RecvLoopCallback)receiver);
            }
            return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, (String)"application/json", (String)modules);
        }

        private static final class UsbAccessibleLynxModulesReceiver
        extends RecvLoopRunnable.DegenerateCallback {
            private final CountDownLatch latch = new CountDownLatch(1);
            volatile String usbAccessibleLynxModules;

            private UsbAccessibleLynxModulesReceiver() {
            }

            public CallbackResult commandEvent(Command command) {
                if ("CMD_GET_USB_ACCESSIBLE_LYNX_MODULES_RESP".equals(command.getName())) {
                    this.usbAccessibleLynxModules = command.getExtra();
                    this.latch.countDown();
                    return CallbackResult.HANDLED_CONTINUE;
                }
                return CallbackResult.NOT_HANDLED;
            }

            public String waitForUsbAccessibleLynxModules() throws InterruptedException {
                this.latch.await();
                return this.usbAccessibleLynxModules;
            }
        }
    }

    private static final class StandardUpload
    extends FileUpload {
        private final File destinationDir;

        StandardUpload(String destinationDir) {
            this.destinationDir = new File(destinationDir);
        }

        @Override
        public NanoHTTPD.Response hook(File uploadedFile) {
            return NanoHTTPD.newFixedLengthResponse((String)uploadedFile.getName());
        }

        @Override
        public File provideDestinationDirectory(String filename, File tempFile) {
            return this.destinationDir;
        }
    }

    public static abstract class FileUpload
    implements WebHandler {
        private static final String FILE_FORM_ID = "file";
        private static final String FILE_FORM_FORCE = "force";

        public abstract NanoHTTPD.Response hook(File var1);

        public abstract File provideDestinationDirectory(String var1, File var2);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final NanoHTTPD.Response getResponse(NanoHTTPD.IHTTPSession session) {
            FileUpload fileUpload = this;
            synchronized (fileUpload) {
                if (DEBUG) {
                    RobotLog.dd((String)TAG, (String)"In FileUpload");
                }
                HashMap fileList = new HashMap();
                try {
                    session.parseBody(fileList);
                    String fileName = this.getFileName(this.getUploadedFileName(session));
                    File tempFile = new File((String)fileList.get(FILE_FORM_ID));
                    File destDir = this.provideDestinationDirectory(fileName, tempFile);
                    File targetFile = new File(destDir, fileName);
                    boolean force = false;
                    if (session.getParameters().containsKey(FILE_FORM_FORCE)) {
                        force = ((String)((List)session.getParameters().get(FILE_FORM_FORCE)).get(0)).equalsIgnoreCase("true");
                    }
                    if (!force && targetFile.exists()) {
                        return RobotWebHandlerManager.clientBadRequestError(TAG, "The file already exists.");
                    }
                    if (!this.checkDir(destDir)) {
                        return RobotWebHandlerManager.internalErrorResponse(TAG, "Could not access upload location " + destDir.getAbsolutePath());
                    }
                    boolean success = tempFile.renameTo(targetFile);
                    if (!success) {
                        return RobotWebHandlerManager.internalErrorResponse(TAG, "Failed to move file to correct location");
                    }
                    return this.hook(targetFile);
                }
                catch (NanoHTTPD.ResponseException | IOException | FilenameNotProvidedException e) {
                    RobotLog.ee((String)TAG, (Throwable)e, (String)"Failed to retrieve uploaded file");
                    return RobotWebHandlerManager.internalErrorResponse(TAG, "Upload failed, try again");
                }
            }
        }

        protected String getFileName(String uploadedFileName) {
            return uploadedFileName;
        }

        private String getUploadedFileName(NanoHTTPD.IHTTPSession session) throws FilenameNotProvidedException {
            if (!session.getParameters().containsKey(FILE_FORM_ID)) {
                throw new FilenameNotProvidedException();
            }
            return (String)((List)session.getParameters().get(FILE_FORM_ID)).get(0);
        }

        private boolean checkDir(File dir) {
            if (!dir.exists()) {
                return dir.mkdirs();
            }
            return true;
        }
    }

    public static class FileDownload
    extends RequireNameHandler {
        public static File fileRoot = AppUtil.ROOT_FOLDER;

        @Override
        public NanoHTTPD.Response getResponse(NanoHTTPD.IHTTPSession session, @NonNull String name) throws IOException {
            if (DEBUG) {
                RobotLog.dd((String)TAG, (String)"FileDownload name=%s", (Object[])new Object[]{name});
            }
            File absoluteFile = new File(fileRoot, name);
            return this.fetchFileContent(absoluteFile);
        }

        private NanoHTTPD.Response fetchFileContent(File file) throws IOException {
            BufferedInputStream inputStream;
            try {
                inputStream = new BufferedInputStream(new FileInputStream(file));
            }
            catch (IOException e) {
                return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.NOT_FOUND, (String)"text/plain", (String)"");
            }
            NanoHTTPD.Response response = NanoHTTPD.newChunkedResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, (String)MimeTypesUtil.determineMimeType(file.getName()), (InputStream)inputStream);
            response.addHeader("Content-Disposition", "attachment; filename=\"" + file.getName() + "\"");
            return response;
        }
    }

    public static class ListLogFiles
    implements WebHandler {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public NanoHTTPD.Response getResponse(NanoHTTPD.IHTTPSession session) throws IOException, NanoHTTPD.ResponseException {
            ListLogFiles listLogFiles = this;
            synchronized (listLogFiles) {
                ArrayList<String> result = new ArrayList<String>();
                List logFiles = RobotLog.getExtantLogFiles((Context)AppUtil.getDefContext());
                for (File logFile : logFiles) {
                    File relative = AppUtil.getInstance().getRelativePath(FileDownload.fileRoot, logFile.getAbsoluteFile());
                    if (relative.isAbsolute()) {
                        RobotLog.ee((String)TAG, (String)"internal error: %s not under %s", (Object[])new Object[]{logFile, FileDownload.fileRoot});
                        continue;
                    }
                    result.add(relative.getPath());
                }
                String json = SimpleGson.getInstance().toJson(result);
                return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, (String)MimeTypesUtil.getMimeType("json"), (String)json);
            }
        }
    }

    public static class RobotControllerInfoHandler
    implements WebHandler {
        private final WebServer webServer;

        public RobotControllerInfoHandler(@NonNull WebServer webServer) {
            this.webServer = webServer;
        }

        public NanoHTTPD.Response getResponse(NanoHTTPD.IHTTPSession session) throws IOException, NanoHTTPD.ResponseException {
            if (DEBUG) {
                RobotLog.dd((String)TAG, (String)"RCInfoHandler");
            }
            RobotControllerWebInfo info = this.webServer.getConnectionInformation();
            info.setFtcUserAgentCategory(session.getHeaders());
            String jsonResponse = info.toJson();
            return NoCachingWebHandler.setNoCache(session, NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, (String)MimeTypesUtil.getMimeType("json"), (String)jsonResponse));
        }
    }

    public static class Redirection
    implements WebHandler {
        private final String targetURI;
        private final QueryParameters queryParameters;

        public Redirection(String targetURI) {
            this(targetURI, QueryParameters.PRESERVE);
        }

        public Redirection(String targetURI, QueryParameters queryParameters) {
            this.targetURI = targetURI;
            this.queryParameters = queryParameters;
        }

        public NanoHTTPD.Response getResponse(NanoHTTPD.IHTTPSession session) {
            String query;
            String location = this.targetURI;
            String string2 = query = session.getQueryParameterString() != null && session.getQueryParameterString().length() > 0 ? session.getQueryParameterString() : null;
            if (this.queryParameters == QueryParameters.PRESERVE && query != null) {
                location = location + "?" + query;
            }
            if (DEBUG) {
                String uri = session.getUri();
                if (query != null) {
                    uri = uri + "?" + query;
                }
                RobotLog.dd((String)TAG, (String)"In Redirect from='%s' to='%s'", (Object[])new Object[]{uri, location});
            }
            NanoHTTPD.Response.Status status = NanoHTTPD.Response.Status.TEMPORARY_REDIRECT;
            NanoHTTPD.Response response = NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)status, (String)"text/plain", (String)"");
            response.addHeader("Location", location);
            return response;
        }

        public static enum QueryParameters {
            PRESERVE,
            DISCARD;

        }
    }

    private static class ServerRootIndex
    implements WebHandler {
        private final String index;
        private final AssetManager assets;

        public ServerRootIndex(String indexFile) {
            this.index = indexFile;
            this.assets = AppUtil.getInstance().getApplication().getAssets();
        }

        public NanoHTTPD.Response getResponse(NanoHTTPD.IHTTPSession session) throws IOException, NanoHTTPD.ResponseException {
            try {
                InputStream file = this.assets.open(this.index);
                String mimeType = MimeTypesUtil.determineMimeType(this.index);
                return NanoHTTPD.newChunkedResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, (String)mimeType, (InputStream)file);
            }
            catch (Exception ex) {
                return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.INTERNAL_ERROR, (String)"text/plain", (String)"Internal Error");
            }
        }
    }

    public static abstract class RequireNameHandler
    implements WebHandler {
        public final NanoHTTPD.Response getResponse(NanoHTTPD.IHTTPSession session) throws IOException, NanoHTTPD.ResponseException {
            Map parms = session.getParameters();
            String name = null;
            if (parms.containsKey(RobotControllerWebHandlers.PARAM_NAME)) {
                name = (String)((List)parms.get(RobotControllerWebHandlers.PARAM_NAME)).get(0);
            }
            if (name == null) {
                return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.BAD_REQUEST, (String)"text/plain", (String)"Bad Request: name parameter is required");
            }
            if (name.length() == 0) {
                return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.BAD_REQUEST, (String)"text/plain", (String)"Bad Request: name must be non-empty");
            }
            return this.getResponse(session, name);
        }

        protected abstract NanoHTTPD.Response getResponse(NanoHTTPD.IHTTPSession var1, @NonNull String var2) throws IOException, NanoHTTPD.ResponseException;
    }
}

