/*
 * Decompiled with CFR 0.152.
 */
package org.firstinspires.ftc.robotserver.internal.webserver;

import android.content.res.AssetManager;
import com.qualcomm.robotcore.util.RobotLog;
import com.qualcomm.robotcore.util.WebHandlerManager;
import com.qualcomm.robotcore.util.WebServer;
import fi.iki.elonen.NanoHTTPD;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import org.firstinspires.ftc.robotcore.internal.system.AppUtil;
import org.firstinspires.ftc.robotcore.internal.webserver.WebHandler;
import org.firstinspires.ftc.robotcore.internal.webserver.WebObserver;
import org.firstinspires.ftc.robotserver.internal.webserver.MimeTypesUtil;
import org.firstinspires.ftc.robotserver.internal.webserver.RobotControllerWebHandlers;
import org.firstinspires.ftc.robotserver.internal.webserver.SessionCookie;

public final class RobotWebHandlerManager
implements WebHandlerManager {
    public static final String TAG = RobotWebHandlerManager.class.getSimpleName();
    private final Map<String, WebHandler> handlerMap = new ConcurrentHashMap<String, WebHandler>(37);
    private final Map<String, WebObserver> observersMap = new ConcurrentHashMap<String, WebObserver>();
    private final WebHandler serveAsset = new ServeAsset();
    private final WebServer webServer;
    public static final NanoHTTPD.Response OK_RESPONSE = NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, (String)"text/plain", (String)"");
    public static final NanoHTTPD.Response INTERNAL_ERROR_RESPONSE = NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.INTERNAL_ERROR, (String)"text/plain", (String)"Internal Error");

    public static NanoHTTPD.Response internalErrorResponse(String tag, String format, Object ... args) {
        String errorString = String.format(format, args);
        return RobotWebHandlerManager.internalErrorResponse(tag, errorString);
    }

    public static NanoHTTPD.Response internalErrorResponse(String tag, String errorString) {
        RobotLog.ee((String)tag, (String)errorString);
        return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.INTERNAL_ERROR, (String)"text/plain", (String)errorString);
    }

    public static NanoHTTPD.Response clientBadRequestError(String tag, String errorString) {
        RobotLog.ee((String)tag, (String)errorString);
        return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.BAD_REQUEST, (String)"text/plain", (String)errorString);
    }

    public static NanoHTTPD.Response internalErrorResponse(String tag, Throwable e) {
        RobotLog.ee((String)tag, (Throwable)e, (String)e.getMessage());
        return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.INTERNAL_ERROR, (String)"text/plain", (String)e.getMessage());
    }

    public RobotWebHandlerManager(WebServer webServer) {
        this.webServer = webServer;
        RobotControllerWebHandlers.initialize(this);
    }

    public WebServer getWebServer() {
        return this.webServer;
    }

    public void register(String command, WebHandler webHandler) {
        this.handlerMap.put(command, webHandler);
    }

    public WebHandler getRegistered(String command) {
        return this.handlerMap.get(command);
    }

    public void registerObserver(String key, WebObserver webObserver) {
        this.observersMap.put(key, webObserver);
    }

    NanoHTTPD.Response serve(NanoHTTPD.IHTTPSession session) {
        SessionCookie.ensureInSession(session);
        for (WebObserver observer : this.observersMap.values()) {
            observer.observe(session);
        }
        String command = session.getUri();
        WebHandler webHandler = this.handlerMap.get(command);
        try {
            if (webHandler == null) {
                return this.serveAsset.getResponse(session);
            }
            return webHandler.getResponse(session);
        }
        catch (IOException e) {
            RobotLog.logStackTrace((Throwable)e);
            return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.INTERNAL_ERROR, (String)"text/plain", (String)"Internal Error");
        }
        catch (NanoHTTPD.ResponseException e) {
            RobotLog.logStackTrace((Throwable)e);
            return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)e.getStatus(), (String)"text/plain", (String)e.getMessage());
        }
    }

    private static class ServeAsset
    implements WebHandler {
        public static final String TAG = ServeAsset.class.getSimpleName();
        public static SimpleDateFormat gmtFrmt = new SimpleDateFormat("E, d MMM yyyy HH:mm:ss 'GMT'", Locale.US);
        public static String staticDateStamp;
        private final AssetManager assetManager = AppUtil.getInstance().getRootActivity().getAssets();
        private final MimeTypesUtil.TypedPaths typedPaths = new MimeTypesUtil.TypedPaths();

        public ServeAsset() {
            String mimeTypeJson = MimeTypesUtil.getMimeType("json");
            this.typedPaths.setMimeType("css/bootstrap.min.css.map", mimeTypeJson);
            this.typedPaths.setMimeType("css/bootstrap-theme.css.map", mimeTypeJson);
            this.typedPaths.setMimeType("css/bootstrap-theme.min.css.map", mimeTypeJson);
        }

        public NanoHTTPD.Response getResponse(NanoHTTPD.IHTTPSession session) throws IOException {
            InputStream inputStream;
            String uri = session.getUri();
            String path = uri.startsWith("/") ? uri.substring(1) : uri;
            String mimeType = this.typedPaths.determineMimeType(path);
            if (mimeType == null) {
                return RobotWebHandlerManager.internalErrorResponse(TAG, "Mime type unknown: uri='%s' path='%s'", uri, path);
            }
            try {
                inputStream = this.assetManager.open(path);
            }
            catch (IOException e) {
                NanoHTTPD.Response response = NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.NOT_FOUND, (String)"text/plain", (String)"");
                response.addHeader("Date", staticDateStamp);
                return response;
            }
            return NanoHTTPD.newChunkedResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, (String)mimeType, (InputStream)inputStream);
        }

        static {
            gmtFrmt.setTimeZone(TimeZone.getTimeZone("GMT"));
            staticDateStamp = gmtFrmt.format(new Date());
        }
    }
}

