/*
 * Decompiled with CFR 0.152.
 */
package org.firstinspires.ftc.robotserver.internal.webserver;

import androidx.annotation.Nullable;
import com.qualcomm.robotcore.util.RobotLog;
import fi.iki.elonen.NanoHTTPD;
import java.util.Locale;
import java.util.UUID;

public class SessionCookie
extends NanoHTTPD.Cookie {
    public static final String TAG = SessionCookie.class.getSimpleName();
    protected static final String sessionCookieName = "consoleSession";

    public SessionCookie(String name, String value) {
        super(name, value, "");
    }

    public static void ensureInSession(NanoHTTPD.IHTTPSession session) {
        String sessionCookie = SessionCookie.fromSessionInternal(session);
        if (null == sessionCookie) {
            sessionCookie = UUID.randomUUID().toString();
            session.getCookies().set((NanoHTTPD.Cookie)new SessionCookie(sessionCookieName, sessionCookie));
            RobotLog.vv((String)TAG, (String)"added SessionCookie: cookie=%s uri='%s'", (Object[])new Object[]{sessionCookie, session.getUri()});
        }
    }

    @Nullable
    protected static String fromSessionInternal(NanoHTTPD.IHTTPSession session) {
        return session.getCookies().read(sessionCookieName);
    }

    @Nullable
    public static String fromSession(NanoHTTPD.IHTTPSession session) {
        String result = SessionCookie.fromSessionInternal(session);
        if (result == null) {
            RobotLog.ee((String)TAG, (String)"session cookie unexpectedly null uri=%s", (Object[])new Object[]{session.getUri()});
        }
        return result;
    }

    public String getHTTPHeader() {
        if (this.e == null || this.e.length() == 0) {
            return String.format(Locale.US, "%s=%s", this.n, this.v);
        }
        return super.getHTTPHeader();
    }
}

