/*
 * Decompiled with CFR 0.152.
 */
package org.firstinspires.ftc.robotserver.internal.webserver.controlhubupdater;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.os.ResultReceiver;
import androidx.annotation.Nullable;
import com.qualcomm.robotcore.util.RobotLog;
import com.qualcomm.robotcore.util.ThreadPool;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.firstinspires.ftc.robotcore.internal.collections.SimpleGson;
import org.firstinspires.ftc.robotcore.internal.network.NetworkConnectionHandler;
import org.firstinspires.ftc.robotcore.internal.network.PeerStatusCallback;
import org.firstinspires.ftc.robotcore.internal.system.AppUtil;
import org.firstinspires.ftc.robotcore.internal.ui.UILocation;
import org.firstinspires.ftc.robotcore.internal.webserver.R;
import org.firstinspires.ftc.robotcore.internal.webserver.websockets.FtcWebSocket;
import org.firstinspires.ftc.robotcore.internal.webserver.websockets.FtcWebSocketMessage;
import org.firstinspires.ftc.robotcore.internal.webserver.websockets.WebSocketManager;
import org.firstinspires.ftc.robotcore.internal.webserver.websockets.WebSocketMessageTypeHandler;
import org.firstinspires.ftc.robotcore.internal.webserver.websockets.WebSocketNamespaceHandler;
import org.firstinspires.ftc.robotserver.internal.webserver.controlhubupdater.result.OtaResultType;
import org.firstinspires.ftc.robotserver.internal.webserver.controlhubupdater.result.Result;

public final class ChUpdaterCommManager
extends WebSocketNamespaceHandler {
    public static final String WS_NAMESPACE = "ControlHubUpdater";
    private static final String BIND_MESSAGE_TYPE = "bind";
    private static final String CONFIRM_DANGEROUS_ACTION_MESSAGE_TYPE = "confirmDangerousAction";
    private static final String DELETE_UPLOADED_FILE_MESSAGE_TYPE = "deleteUploadedFile";
    private static final String NOTIFICATION_MESSAGE_TYPE = "notification";
    private static final String TAG = "ChUpdaterCommManager";
    private final Map<UUID, ChUpdaterResultReceiver> uuidResultReceiverMap = new ConcurrentHashMap<UUID, ChUpdaterResultReceiver>(4);
    private final WebSocketManager webSocketManager;
    private final Queue<String> toastQueue;
    private final Object toastQueueLock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChUpdaterCommManager(WebSocketManager webSocketManager) {
        super(WS_NAMESPACE);
        this.webSocketManager = webSocketManager;
        Object object = ChUpdaterBroadcastReceiver.outerClassReferenceLock;
        synchronized (object) {
            ChUpdaterBroadcastReceiver.outerClassReference = this;
        }
        this.toastQueue = ChUpdaterBroadcastReceiver.toastQueue;
        this.toastQueueLock = ChUpdaterBroadcastReceiver.toastQueueLock;
        QueuedToastSender queuedToastSender = new QueuedToastSender();
        boolean alreadyConnectedToPeer = NetworkConnectionHandler.getInstance().registerPeerStatusCallback((PeerStatusCallback)queuedToastSender);
        if (alreadyConnectedToPeer) {
            queuedToastSender.onPeerConnected();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSubscribe(FtcWebSocket webSocket) {
        Object object = ChUpdaterBroadcastReceiver.messagesForNewWsConnectionsLock;
        synchronized (object) {
            Iterator iterator = ChUpdaterBroadcastReceiver.messagesForNewWsConnections.iterator();
            while (iterator.hasNext()) {
                FtcWebSocketMessage message = (FtcWebSocketMessage)iterator.next();
                webSocket.send(message);
                if (ChUpdaterBroadcastReceiver.withinReconnectionAllowancePeriod) {
                    ChUpdaterBroadcastReceiver.seenMessageSet.add(message);
                    continue;
                }
                iterator.remove();
            }
        }
    }

    protected void registerMessageTypeHandlers(Map<String, WebSocketMessageTypeHandler> messageTypeHandlerMap) {
        messageTypeHandlerMap.put(BIND_MESSAGE_TYPE, new BindMessageHandler());
        messageTypeHandlerMap.put(CONFIRM_DANGEROUS_ACTION_MESSAGE_TYPE, new ConfirmDangerousActionMessageHandler());
        messageTypeHandlerMap.put(DELETE_UPLOADED_FILE_MESSAGE_TYPE, new DeleteUploadedFileMessageHandler());
    }

    public UUID startUpdate(UpdateType updateType, File file) {
        ChUpdaterResultReceiver receiver = new ChUpdaterResultReceiver(file, new Handler(Looper.getMainLooper()));
        UUID uuid = UUID.randomUUID();
        this.uuidResultReceiverMap.put(uuid, receiver);
        String action = null;
        switch (updateType) {
            case APP: {
                action = "com.revrobotics.controlhubupdater.action.UPDATE_FTC_APP";
                break;
            }
            case OTA: {
                action = "com.revrobotics.controlhubupdater.action.APPLY_OTA_UPDATE";
            }
        }
        Intent intent = new Intent();
        ComponentName updateService = new ComponentName("com.revrobotics.controlhubupdater", "com.revrobotics.controlhubupdater.UpdateService");
        intent.setComponent(updateService);
        intent.setAction(action);
        intent.putExtra("com.revrobotics.controlhubupdater.extra.UPDATE_FILE_PATH", file.getAbsolutePath());
        intent.putExtra("com.revrobotics.controlhubupdater.extra.RESULT_RECEIVER", (Parcelable)AppUtil.wrapResultReceiverForIpc((ResultReceiver)receiver));
        receiver.setSentIntent(intent);
        AppUtil.getDefContext().startService(intent);
        return uuid;
    }

    private static FtcWebSocketMessage createWsMessageFromResult(Result result, boolean isBroadcast, @Nullable String messageOverride) {
        String message = messageOverride;
        if (message == null) {
            message = result.getMessage();
        }
        String detailMessage = result.getDetailMessage();
        Result.DetailMessageType detailMessageType = result.getDetailMessageType();
        Result.PresentationType presentationType = result.getPresentationType();
        if (detailMessageType == Result.DetailMessageType.DISPLAYED && detailMessage != null) {
            message = message + "\n\n" + detailMessage;
        }
        if (isBroadcast && presentationType == Result.PresentationType.PROMPT) {
            presentationType = Result.PresentationType.ERROR;
        }
        NotificationPayload payload = new NotificationPayload(message, presentationType);
        return new FtcWebSocketMessage(WS_NAMESPACE, NOTIFICATION_MESSAGE_TYPE, payload.toJson());
    }

    private static void logResult(Result result) {
        String message = result.getMessage();
        int logPriority = result.getPresentationType() == Result.PresentationType.ERROR ? 6 : 2;
        RobotLog.internalLog((int)logPriority, (String)TAG, (Throwable)result.getCause(), (String)String.format("%s result received: %s", result.getPresentationType().name(), message));
        if (result.getDetailMessage() != null) {
            RobotLog.internalLog((int)logPriority, (String)TAG, null, (String)("detail message: " + result.getDetailMessage()));
        }
    }

    private static boolean isResultEligibleForToast(Result result) {
        return result.getPresentationType() == Result.PresentationType.SUCCESS || result.getPresentationType() == Result.PresentationType.ERROR;
    }

    private static boolean sendResultAsToastIfPossible(Result result) {
        if (ChUpdaterCommManager.isResultEligibleForToast(result) && NetworkConnectionHandler.getInstance().isPeerConnected()) {
            AppUtil.getInstance().showToast(UILocation.BOTH, result.getMessage(), 1);
            return true;
        }
        return false;
    }

    private class ChUpdaterResultReceiver
    extends ResultReceiver {
        private FtcWebSocket webSocket;
        private Result lastResult;
        private Intent sentIntent;
        private final File uploadedFile;

        ChUpdaterResultReceiver(File uploadedFile, Handler handler) {
            super(handler);
            this.uploadedFile = uploadedFile;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected synchronized void onReceiveResult(int resultCode, Bundle resultData) {
            Result result = Result.fromBundle(resultData);
            ChUpdaterCommManager.logResult(result);
            boolean eligibleForToast = ChUpdaterCommManager.isResultEligibleForToast(result);
            boolean sentToast = ChUpdaterCommManager.sendResultAsToastIfPossible(result);
            Object object = ChUpdaterCommManager.this.toastQueueLock;
            synchronized (object) {
                if (this.webSocket != null && this.webSocket.isOpen()) {
                    String messageOverride = null;
                    if (result.getResultType() == OtaResultType.VERIFICATION_SUCCEEDED && this.webSocket.getRemoteIpAddress().isLoopbackAddress()) {
                        messageOverride = AppUtil.getDefContext().getString(R.string.ota_result_type_verification_succeeded_localhost);
                    }
                    FtcWebSocketMessage resultMessage = ChUpdaterCommManager.createWsMessageFromResult(result, false, messageOverride);
                    this.webSocket.send(resultMessage);
                } else {
                    this.lastResult = result;
                    if (!sentToast && eligibleForToast) {
                        ChUpdaterCommManager.this.toastQueue.add(result.getMessage());
                    }
                }
            }
        }

        private synchronized void setWebSocket(FtcWebSocket webSocket) {
            this.webSocket = webSocket;
            if (this.lastResult != null) {
                webSocket.send(ChUpdaterCommManager.createWsMessageFromResult(this.lastResult, false, null));
            }
        }

        private void setSentIntent(Intent sentIntent) {
            this.sentIntent = sentIntent;
        }

        private void confirmDangerousAction() {
            this.sentIntent.putExtra("com.revrobotics.controlhubupdater.extra.DANGEROUS_ACTION_CONFIRMED", true);
            AppUtil.getDefContext().startService(this.sentIntent);
        }

        private void deleteAssociatedUpload() {
            this.uploadedFile.delete();
        }
    }

    private class QueuedToastSender
    implements PeerStatusCallback {
        private QueuedToastSender() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onPeerConnected() {
            Object object = ChUpdaterCommManager.this.toastQueueLock;
            synchronized (object) {
                String toastMessage = (String)ChUpdaterCommManager.this.toastQueue.poll();
                while (toastMessage != null) {
                    AppUtil.getInstance().showToast(UILocation.BOTH, toastMessage, 1);
                    toastMessage = (String)ChUpdaterCommManager.this.toastQueue.poll();
                }
            }
        }

        public void onPeerDisconnected() {
        }
    }

    private abstract class UpdaterMessageTypeHandler
    implements WebSocketMessageTypeHandler {
        private UpdaterMessageTypeHandler() {
        }

        abstract void handleUpdaterMessage(FtcWebSocket var1, UUID var2, ChUpdaterResultReceiver var3);

        public final void handleMessage(FtcWebSocketMessage message, FtcWebSocket webSocket) {
            UUID receivedUuid = UUID.fromString(message.getPayload());
            ChUpdaterResultReceiver resultReceiver = (ChUpdaterResultReceiver)((Object)ChUpdaterCommManager.this.uuidResultReceiverMap.get(receivedUuid));
            if (resultReceiver != null) {
                this.handleUpdaterMessage(webSocket, receivedUuid, resultReceiver);
            } else {
                RobotLog.ww((String)ChUpdaterCommManager.TAG, (String)("Received message with unknown UUID " + receivedUuid));
            }
        }
    }

    private class DeleteUploadedFileMessageHandler
    extends UpdaterMessageTypeHandler {
        private DeleteUploadedFileMessageHandler() {
        }

        @Override
        void handleUpdaterMessage(FtcWebSocket webSocket, UUID receivedUuid, ChUpdaterResultReceiver associatedResultReceiver) {
            RobotLog.ww((String)ChUpdaterCommManager.TAG, (String)("Deleting uploaded file associated with UUID " + receivedUuid));
            associatedResultReceiver.deleteAssociatedUpload();
        }
    }

    private class ConfirmDangerousActionMessageHandler
    extends UpdaterMessageTypeHandler {
        private ConfirmDangerousActionMessageHandler() {
        }

        @Override
        void handleUpdaterMessage(FtcWebSocket webSocket, UUID receivedUuid, ChUpdaterResultReceiver associatedResultReceiver) {
            RobotLog.ww((String)ChUpdaterCommManager.TAG, (String)("Confirming dangerous action for UUID " + receivedUuid));
            associatedResultReceiver.confirmDangerousAction();
        }
    }

    private class BindMessageHandler
    extends UpdaterMessageTypeHandler {
        private BindMessageHandler() {
        }

        @Override
        void handleUpdaterMessage(FtcWebSocket webSocket, UUID receivedUuid, ChUpdaterResultReceiver associatedResultReceiver) {
            RobotLog.dd((String)ChUpdaterCommManager.TAG, (String)("Binding WebSocket " + webSocket + " to UUID " + receivedUuid));
            associatedResultReceiver.setWebSocket(webSocket);
        }
    }

    public static enum UpdateType {
        OTA,
        APP;

    }

    private static class NotificationPayload {
        final String message;
        final Result.PresentationType presentationType;

        NotificationPayload(String message, Result.PresentationType presentationType) {
            this.message = message;
            this.presentationType = presentationType;
        }

        String toJson() {
            return SimpleGson.getInstance().toJson((Object)this);
        }
    }

    public static class ChUpdaterBroadcastReceiver
    extends BroadcastReceiver {
        private static final int RECONNECTION_ALLOWANCE_SECONDS = 10;
        private static ChUpdaterCommManager outerClassReference;
        private static final Object outerClassReferenceLock;
        private static final List<FtcWebSocketMessage> messagesForNewWsConnections;
        private static Set<FtcWebSocketMessage> seenMessageSet;
        private static boolean withinReconnectionAllowancePeriod;
        private static final Object messagesForNewWsConnectionsLock;
        private static final Queue<String> toastQueue;
        private static final Object toastQueueLock;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            Result result = Result.fromBundle(intent.getBundleExtra("com.revrobotics.controlhubupdater.broadcast.extra.BUNDLE"));
            ChUpdaterCommManager.logResult(result);
            boolean eligibleForToast = ChUpdaterCommManager.isResultEligibleForToast(result);
            boolean sentToast = ChUpdaterCommManager.sendResultAsToastIfPossible(result);
            if (eligibleForToast && !sentToast) {
                Object object = toastQueueLock;
                synchronized (object) {
                    toastQueue.add(result.getMessage());
                }
            }
            FtcWebSocketMessage wsMessage = ChUpdaterCommManager.createWsMessageFromResult(result, true, null);
            int webSocketsThatReceivedMessage = 0;
            Object object = outerClassReferenceLock;
            synchronized (object) {
                if (outerClassReference != null) {
                    webSocketsThatReceivedMessage = outerClassReference.webSocketManager.broadcastToNamespace(ChUpdaterCommManager.WS_NAMESPACE, wsMessage);
                }
            }
            object = messagesForNewWsConnectionsLock;
            synchronized (object) {
                if (webSocketsThatReceivedMessage == 0 || withinReconnectionAllowancePeriod) {
                    messagesForNewWsConnections.add(wsMessage);
                    if (webSocketsThatReceivedMessage > 0) {
                        seenMessageSet.add(wsMessage);
                    }
                }
            }
        }

        static {
            outerClassReferenceLock = new Object();
            messagesForNewWsConnections = new ArrayList<FtcWebSocketMessage>();
            seenMessageSet = new HashSet<FtcWebSocketMessage>();
            withinReconnectionAllowancePeriod = true;
            messagesForNewWsConnectionsLock = new Object();
            toastQueue = new LinkedBlockingQueue<String>();
            toastQueueLock = new Object();
            ThreadPool.getDefaultScheduler().schedule(new AllowancePeriodExpiredRunnable(), 10L, TimeUnit.SECONDS);
        }

        private static class AllowancePeriodExpiredRunnable
        implements Runnable {
            private AllowancePeriodExpiredRunnable() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = messagesForNewWsConnectionsLock;
                synchronized (object) {
                    withinReconnectionAllowancePeriod = false;
                    for (FtcWebSocketMessage message : seenMessageSet) {
                        messagesForNewWsConnections.remove(message);
                    }
                    seenMessageSet = null;
                }
            }
        }
    }
}

