/*
 * Decompiled with CFR 0.152.
 */
package org.firstinspires.ftc.robotserver.internal.webserver.controlhubupdater.result;

import org.firstinspires.ftc.robotcore.internal.system.AppUtil;
import org.firstinspires.ftc.robotcore.internal.webserver.R;
import org.firstinspires.ftc.robotserver.internal.webserver.controlhubupdater.result.Result;
import org.firstinspires.ftc.robotserver.internal.webserver.controlhubupdater.result.ResultType;

public enum AppResultType implements ResultType
{
    ATTEMPTING_INSTALLATION(1, Result.PresentationType.STATUS, Result.DetailMessageType.SUBSTITUTED, AppUtil.getDefContext().getString(R.string.app_result_type_attempting_installation)),
    INSTALLATION_SUCCEEDED(2, Result.PresentationType.SUCCESS, Result.DetailMessageType.LOGGED, AppUtil.getDefContext().getString(R.string.app_result_type_installation_succeeded)),
    INVALID_APK_FILE(3, Result.PresentationType.ERROR, Result.DetailMessageType.DISPLAYED, AppUtil.getDefContext().getString(R.string.app_result_type_invalid_apk_file)),
    IO_EXCEPTION_DURING_LOADING(4, Result.PresentationType.ERROR, Result.DetailMessageType.LOGGED, AppUtil.getDefContext().getString(R.string.app_result_type_io_exception)),
    TIMEOUT_EXPIRED(5, Result.PresentationType.ERROR, Result.DetailMessageType.LOGGED, AppUtil.getDefContext().getString(R.string.app_result_type_timeout_expired)),
    GENERIC_INSTALL_FAILURE(6, Result.PresentationType.ERROR, Result.DetailMessageType.LOGGED, AppUtil.getDefContext().getString(R.string.app_result_type_generic_install_failure)),
    INSTALLATION_BLOCKED(7, Result.PresentationType.ERROR, Result.DetailMessageType.LOGGED, AppUtil.getDefContext().getString(R.string.app_result_type_installation_blocked)),
    INSTALLATION_ABORTED(8, Result.PresentationType.ERROR, Result.DetailMessageType.LOGGED, AppUtil.getDefContext().getString(R.string.app_result_type_installation_aborted)),
    STORAGE_FAILURE(9, Result.PresentationType.ERROR, Result.DetailMessageType.DISPLAYED, AppUtil.getDefContext().getString(R.string.app_result_type_storage_failure)),
    INCOMPATIBLE_WITH_DEVICE(10, Result.PresentationType.ERROR, Result.DetailMessageType.DISPLAYED, AppUtil.getDefContext().getString(R.string.app_result_type_incompatible_with_device)),
    UNKNOWN_INSTALL_STATUS(11, Result.PresentationType.ERROR, Result.DetailMessageType.LOGGED, AppUtil.getDefContext().getString(R.string.app_result_type_unknown_install_status)),
    ILLEGAL_PACKAGE(12, Result.PresentationType.ERROR, Result.DetailMessageType.DISPLAYED, AppUtil.getDefContext().getString(R.string.app_result_type_illegal_package)),
    UNINSTALL_REQUIRED(13, Result.PresentationType.PROMPT, Result.DetailMessageType.SUBSTITUTED, AppUtil.getDefContext().getString(R.string.app_result_type_uninstall_required)),
    UNINSTALL_FAILED(14, Result.PresentationType.ERROR, Result.DetailMessageType.DISPLAYED, AppUtil.getDefContext().getString(R.string.app_result_type_uninstall_failed)),
    FAILED_AND_REVERTED(15, Result.PresentationType.ERROR, Result.DetailMessageType.LOGGED, AppUtil.getDefContext().getString(R.string.app_result_type_failed_and_reverted)),
    FAILED_TO_RESTORE(16, Result.PresentationType.ERROR, Result.DetailMessageType.LOGGED, AppUtil.getDefContext().getString(R.string.app_result_type_failed_to_restore)),
    REBOOTING_WITH_NEW_AP_SERVICE(17, Result.PresentationType.SUCCESS, Result.DetailMessageType.LOGGED, AppUtil.getDefContext().getString(R.string.app_result_type_rebooting_with_new_ap_service)),
    AUTO_UPDATED_APP(18, Result.PresentationType.SUCCESS, Result.DetailMessageType.SUBSTITUTED, AppUtil.getDefContext().getString(R.string.app_result_type_auto_updated_app)),
    REPLACED_WRONG_APP_VARIANT(19, Result.PresentationType.ERROR, Result.DetailMessageType.SUBSTITUTED, AppUtil.getDefContext().getString(R.string.app_result_type_replaced_wrong_app_variant)),
    UNINSTALLED_WRONG_APP_VARIANT(20, Result.PresentationType.ERROR, Result.DetailMessageType.SUBSTITUTED, AppUtil.getDefContext().getString(R.string.app_result_type_uninstalled_wrong_app_variant)),
    INSTALLED_MISSING_APP(21, Result.PresentationType.ERROR, Result.DetailMessageType.SUBSTITUTED, AppUtil.getDefContext().getString(R.string.app_result_type_installed_missing_app)),
    UNINSTALLING_EXISTING_APP(22, Result.PresentationType.STATUS, Result.DetailMessageType.LOGGED, AppUtil.getDefContext().getString(R.string.app_result_type_uninstalling_existing_app)),
    BACKUP_UNINSTALLING_EXISTING_APP(23, Result.PresentationType.STATUS, Result.DetailMessageType.LOGGED, AppUtil.getDefContext().getString(R.string.app_result_type_backup_uninstalling_existing_app)),
    UNINSTALL_REQUIRED_BACKUP_POSSIBLE(24, Result.PresentationType.PROMPT, Result.DetailMessageType.SUBSTITUTED, AppUtil.getDefContext().getString(R.string.app_result_type_uninstall_required_backup_possible));

    private final int code;
    private final Result.PresentationType presentationType;
    private final Result.DetailMessageType detailMessageType;
    private final String message;

    private AppResultType(int code, Result.PresentationType presentationType, Result.DetailMessageType detailMessageType, String message) {
        this.code = code;
        this.presentationType = presentationType;
        this.detailMessageType = detailMessageType;
        this.message = message;
    }

    @Override
    public Result.Category getCategory() {
        return Result.Category.APP_UPDATE;
    }

    @Override
    public int getCode() {
        return this.code;
    }

    @Override
    public Result.PresentationType getPresentationType() {
        return this.presentationType;
    }

    @Override
    public Result.DetailMessageType getDetailMessageType() {
        return this.detailMessageType;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public static AppResultType fromCode(int code) {
        for (AppResultType resultType : AppResultType.values()) {
            if (code != resultType.getCode()) continue;
            return resultType;
        }
        return null;
    }
}

