/*
 * Decompiled with CFR 0.152.
 */
package org.firstinspires.ftc.robotserver.internal.webserver.controlhubupdater.result;

import org.firstinspires.ftc.robotcore.internal.system.AppUtil;
import org.firstinspires.ftc.robotcore.internal.webserver.R;
import org.firstinspires.ftc.robotserver.internal.webserver.controlhubupdater.result.Result;
import org.firstinspires.ftc.robotserver.internal.webserver.controlhubupdater.result.ResultType;

public enum CommonResultType implements ResultType
{
    NO_UPDATE_FILE(1, Result.PresentationType.ERROR, Result.DetailMessageType.LOGGED, AppUtil.getDefContext().getString(R.string.common_result_type_no_update_file)),
    FILE_DOES_NOT_EXIST(2, Result.PresentationType.ERROR, Result.DetailMessageType.LOGGED, AppUtil.getDefContext().getString(R.string.common_result_type_file_does_not_exist)),
    PERFORMING_STARTUP_OPERATIONS(3, Result.PresentationType.ERROR, Result.DetailMessageType.LOGGED, AppUtil.getDefContext().getString(R.string.common_result_type_performing_startup_operations)),
    BUSY_WITH_PREVIOUS_REQUEST(4, Result.PresentationType.ERROR, Result.DetailMessageType.LOGGED, AppUtil.getDefContext().getString(R.string.common_result_type_busy_with_previous_request));

    private final int code;
    private final Result.PresentationType presentationType;
    private final Result.DetailMessageType detailMessageType;
    private final String message;

    private CommonResultType(int code, Result.PresentationType presentationType, Result.DetailMessageType detailMessageType, String message) {
        this.code = code;
        this.presentationType = presentationType;
        this.detailMessageType = detailMessageType;
        this.message = message;
    }

    @Override
    public Result.Category getCategory() {
        return Result.Category.COMMON;
    }

    @Override
    public int getCode() {
        return this.code;
    }

    @Override
    public Result.PresentationType getPresentationType() {
        return this.presentationType;
    }

    @Override
    public Result.DetailMessageType getDetailMessageType() {
        return this.detailMessageType;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public static CommonResultType fromCode(int code) {
        for (CommonResultType resultType : CommonResultType.values()) {
            if (code != resultType.getCode()) continue;
            return resultType;
        }
        return null;
    }
}

