/*
 * Decompiled with CFR 0.152.
 */
package org.firstinspires.ftc.robotserver.internal.webserver.controlhubupdater.result;

import org.firstinspires.ftc.robotcore.internal.system.AppUtil;
import org.firstinspires.ftc.robotcore.internal.webserver.R;
import org.firstinspires.ftc.robotserver.internal.webserver.controlhubupdater.result.Result;
import org.firstinspires.ftc.robotserver.internal.webserver.controlhubupdater.result.ResultType;

public enum OtaResultType implements ResultType
{
    VERIFICATION_SUCCEEDED(1, Result.PresentationType.STATUS, Result.DetailMessageType.LOGGED, AppUtil.getDefContext().getString(R.string.ota_result_type_verification_succeeded)),
    INVALID_FILE_LOCATION(2, Result.PresentationType.ERROR, Result.DetailMessageType.LOGGED, AppUtil.getDefContext().getString(R.string.ota_result_type_invalid_file_location)),
    INVALID_UPDATE_FILE(3, Result.PresentationType.ERROR, Result.DetailMessageType.LOGGED, AppUtil.getDefContext().getString(R.string.ota_result_type_invalid_update_file)),
    ERROR_READING_FILE(4, Result.PresentationType.ERROR, Result.DetailMessageType.LOGGED, AppUtil.getDefContext().getString(R.string.ota_result_type_error_reading_file)),
    FAILED_TO_INSTALL(5, Result.PresentationType.ERROR, Result.DetailMessageType.DISPLAYED, AppUtil.getDefContext().getString(R.string.ota_result_type_failed_to_install)),
    OTA_UPDATE_FINISHED(6, Result.PresentationType.SUCCESS, Result.DetailMessageType.LOGGED, AppUtil.getDefContext().getString(R.string.ota_result_type_ota_update_finished)),
    DOWNGRADE_NOT_AUTHORIZED(7, Result.PresentationType.PROMPT, Result.DetailMessageType.LOGGED, AppUtil.getDefContext().getString(R.string.ota_result_type_downgrade_not_authorized)),
    DEVICE_NOT_SUPPORTED(8, Result.PresentationType.ERROR, Result.DetailMessageType.LOGGED, AppUtil.getDefContext().getString(R.string.ota_result_type_device_not_supported));

    private final int code;
    private final Result.PresentationType presentationType;
    private final Result.DetailMessageType detailMessageType;
    private final String message;

    private OtaResultType(int code, Result.PresentationType presentationType, Result.DetailMessageType detailMessageType, String message) {
        this.code = code;
        this.presentationType = presentationType;
        this.detailMessageType = detailMessageType;
        this.message = message;
    }

    @Override
    public Result.Category getCategory() {
        return Result.Category.OTA_UPDATE;
    }

    @Override
    public int getCode() {
        return this.code;
    }

    @Override
    public Result.DetailMessageType getDetailMessageType() {
        return this.detailMessageType;
    }

    @Override
    public Result.PresentationType getPresentationType() {
        return this.presentationType;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public static OtaResultType fromCode(int code) {
        for (OtaResultType resultType : OtaResultType.values()) {
            if (code != resultType.getCode()) continue;
            return resultType;
        }
        return null;
    }
}

