/*
 * Decompiled with CFR 0.152.
 */
package org.firstinspires.ftc.robotserver.internal.webserver.controlhubupdater.result;

import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import org.firstinspires.ftc.robotserver.internal.webserver.controlhubupdater.result.AppResultType;
import org.firstinspires.ftc.robotserver.internal.webserver.controlhubupdater.result.CommonResultType;
import org.firstinspires.ftc.robotserver.internal.webserver.controlhubupdater.result.OtaResultType;
import org.firstinspires.ftc.robotserver.internal.webserver.controlhubupdater.result.ResultType;
import org.firstinspires.ftc.robotserver.internal.webserver.controlhubupdater.result.UnknownResultType;

public final class Result {
    @NonNull
    private final ResultType resultType;
    @Nullable
    private String detailMessage;
    @Nullable
    private Throwable cause;

    private Result(@NonNull ResultType resultType, @Nullable String detailMessage, @Nullable Throwable cause) {
        this.resultType = resultType;
        this.detailMessage = detailMessage;
        this.cause = cause;
    }

    public Category getCategory() {
        return this.resultType.getCategory();
    }

    public int getCode() {
        return this.resultType.getCode();
    }

    public String getMessage() {
        String message = this.resultType.getMessage();
        if (this.getDetailMessageType() == DetailMessageType.SUBSTITUTED) {
            String localDetailMessage = this.detailMessage;
            if (localDetailMessage == null) {
                localDetailMessage = "";
            }
            message = String.format(message, localDetailMessage);
        }
        return message;
    }

    @Nullable
    public String getDetailMessage() {
        if (this.getDetailMessageType() == DetailMessageType.SUBSTITUTED) {
            return null;
        }
        return this.detailMessage;
    }

    public DetailMessageType getDetailMessageType() {
        return this.resultType.getDetailMessageType();
    }

    @Nullable
    public Throwable getCause() {
        return this.cause;
    }

    public ResultType getResultType() {
        return this.resultType;
    }

    public PresentationType getPresentationType() {
        return this.resultType.getPresentationType();
    }

    public static Result fromBundle(Bundle bundle) {
        ResultType resultType = null;
        Category category = Category.fromString(bundle.getString("category"));
        int code = bundle.getInt("resultCode");
        if (category != null) {
            switch (category) {
                case COMMON: {
                    resultType = CommonResultType.fromCode(code);
                    break;
                }
                case OTA_UPDATE: {
                    resultType = OtaResultType.fromCode(code);
                    break;
                }
                case APP_UPDATE: {
                    resultType = AppResultType.fromCode(code);
                }
            }
        }
        if (resultType == null) {
            String message = bundle.getString("message");
            PresentationType presentationType = PresentationType.fromString(bundle.getString("presentationType"));
            DetailMessageType detailMessageType = DetailMessageType.fromString(bundle.getString("detailMessageType"));
            resultType = new UnknownResultType(category, code, presentationType, detailMessageType, message);
        }
        String detailMessage = bundle.getString("detailMessage");
        Throwable cause = (Throwable)bundle.getSerializable("cause");
        return new Result(resultType, detailMessage, cause);
    }

    public static enum DetailMessageType {
        LOGGED,
        DISPLAYED,
        SUBSTITUTED;


        public static DetailMessageType fromString(String string2) {
            for (DetailMessageType detailMessageType : DetailMessageType.values()) {
                if (!detailMessageType.name().equals(string2)) continue;
                return detailMessageType;
            }
            return null;
        }
    }

    public static enum PresentationType {
        SUCCESS,
        ERROR,
        STATUS,
        PROMPT;


        public static PresentationType fromString(String string2) {
            for (PresentationType presentationType : PresentationType.values()) {
                if (!presentationType.name().equals(string2)) continue;
                return presentationType;
            }
            return null;
        }
    }

    public static enum Category {
        COMMON,
        OTA_UPDATE,
        APP_UPDATE;


        public static Category fromString(String string2) {
            for (Category category : Category.values()) {
                if (!category.name().equals(string2)) continue;
                return category;
            }
            return null;
        }
    }
}

