/*
 * Decompiled with CFR 0.152.
 */
package org.firstinspires.ftc.robotserver.internal.webserver.tempfile;

import androidx.annotation.Nullable;
import fi.iki.elonen.NanoHTTPD;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class UploadedTempFile
implements NanoHTTPD.TempFile {
    private final File file;
    @Nullable
    private OutputStream outputStream;

    UploadedTempFile(File tempDir) throws IOException {
        this.file = File.createTempFile("upload-", "", tempDir);
    }

    public void delete() throws IOException {
        if (this.outputStream != null) {
            this.outputStream.close();
        }
        if (!this.file.exists()) {
            return;
        }
        if (!this.file.delete()) {
            throw new IOException("File failed to delete successfully");
        }
    }

    public String getName() {
        return this.file.getAbsolutePath();
    }

    public OutputStream open() throws FileNotFoundException {
        if (this.outputStream == null) {
            this.outputStream = new FileOutputStream(this.file);
        }
        return this.outputStream;
    }
}

