/*
 * Decompiled with CFR 0.152.
 */
package org.firstinspires.ftc.robotserver.internal.webserver.tempfile;

import android.os.Environment;
import com.qualcomm.robotcore.util.RobotLog;
import fi.iki.elonen.NanoHTTPD;
import java.io.File;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.firstinspires.ftc.robotserver.internal.webserver.tempfile.UploadedTempFile;

public class UploadedTempFileManager
implements NanoHTTPD.TempFileManager {
    private static final String TAG = "UploadedTempFileManager";
    private static final File tempDir = new File(Environment.getExternalStorageDirectory(), "tmp");
    private final List<NanoHTTPD.TempFile> tempFileList = new CopyOnWriteArrayList<NanoHTTPD.TempFile>();

    UploadedTempFileManager() {
        if (!tempDir.exists() && !tempDir.mkdirs()) {
            RobotLog.ee((String)TAG, (String)"Failed to create temp directory");
        }
    }

    public void clear() {
        for (NanoHTTPD.TempFile tempFile : this.tempFileList) {
            try {
                tempFile.delete();
            }
            catch (Exception e) {
                RobotLog.ee((String)TAG, (Throwable)e, (String)"Failed to delete temp file");
            }
        }
        this.tempFileList.clear();
    }

    public NanoHTTPD.TempFile createTempFile(String filenameHint) throws Exception {
        UploadedTempFile newTempFile = new UploadedTempFile(tempDir);
        this.tempFileList.add(newTempFile);
        return newTempFile;
    }
}

