/*
 * Decompiled with CFR 0.152.
 */
package org.firstinspires.ftc.robotserver.internal.webserver.websockets;

import androidx.annotation.NonNull;
import com.google.gson.JsonSyntaxException;
import com.qualcomm.robotcore.util.RobotLog;
import java.net.InetAddress;
import java.util.Locale;
import org.firstinspires.ftc.robotcore.internal.collections.SimpleGson;
import org.firstinspires.ftc.robotcore.internal.webserver.websockets.CloseCode;
import org.firstinspires.ftc.robotcore.internal.webserver.websockets.FtcWebSocket;
import org.firstinspires.ftc.robotcore.internal.webserver.websockets.FtcWebSocketMessage;
import org.firstinspires.ftc.robotcore.internal.webserver.websockets.WebSocketCommandResponse;
import org.firstinspires.ftc.robotcore.internal.webserver.websockets.WebSocketManager;
import org.firstinspires.ftc.robotserver.internal.webserver.websockets.WebSocketManagerImpl;

public final class FtcWebSocketImpl
implements FtcWebSocket {
    private static final String TAG = "FtcWebSocket";
    private static final boolean DEBUG = false;
    private final InetAddress remoteIpAddress;
    private final String remoteHostname;
    private final int port;
    private final RawWebSocket rawWebSocket;
    private final WebSocketManager manager;

    private FtcWebSocketImpl(int port, InetAddress remoteIpAddress, String remoteHostname, WebSocketManager webSocketManager, RawWebSocket rawWebSocket) {
        this.remoteIpAddress = remoteIpAddress;
        this.remoteHostname = remoteHostname;
        this.port = port;
        this.rawWebSocket = rawWebSocket;
        this.manager = webSocketManager;
    }

    void internalSend(@NonNull FtcWebSocketMessage message) {
        String json = message.toJson();
        this.rawWebSocket.send(json);
    }

    public void send(@NonNull FtcWebSocketMessage message) {
        if (message.getNamespace().equals("system")) {
            throw new IllegalArgumentException("System namespace messages cannot be sent using this method.");
        }
        this.internalSend(message);
    }

    public void sendCommandResponse(WebSocketCommandResponse response) {
        String payload = SimpleGson.getInstance().toJson((Object)response, WebSocketCommandResponse.class);
        this.rawWebSocket.send(payload);
    }

    public InetAddress getRemoteIpAddress() {
        return this.remoteIpAddress;
    }

    public String getRemoteHostname() {
        return this.remoteHostname;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isOpen() {
        return this.rawWebSocket.isOpen();
    }

    public void close(CloseCode closeCode, String reason) {
        this.rawWebSocket.close(closeCode.getValue(), reason);
    }

    public String toString() {
        return String.format(Locale.ROOT, "websocket (ip=%s port=%d)", this.getRemoteIpAddress(), this.getPort());
    }

    private void onOpen() {
        RobotLog.vv((String)TAG, (String)"Opening %s", (Object[])new Object[]{this});
        ((WebSocketManagerImpl)this.manager).onWebSocketConnected(this);
    }

    private void onClose(CloseCode closeCode, String reason, boolean initiatedByRemote) {
        RobotLog.vv((String)TAG, (String)"%s has closed. closeCode:%s initiatedByRemote:%b Reason: %s", (Object[])new Object[]{this, closeCode.toString(), initiatedByRemote, reason});
        ((WebSocketManagerImpl)this.manager).onWebSocketClose(this);
    }

    private void onMessage(String message) {
        try {
            FtcWebSocketMessage ftcMessage = FtcWebSocketMessage.fromJson((String)message);
            ((WebSocketManagerImpl)this.manager).onWebSocketMessage(ftcMessage, this);
        }
        catch (JsonSyntaxException e) {
            RobotLog.logExceptionHeader((String)TAG, (Exception)((Object)e), (String)"Malformed json received from %s", (Object[])new Object[]{this});
        }
    }

    private void onException(Throwable exception) {
        RobotLog.ee((String)TAG, (String)"%s experienced an exception:", (Object[])new Object[]{this});
        RobotLog.logStackTrace((String)TAG, (Throwable)exception);
    }

    public static abstract class RawWebSocket {
        private FtcWebSocketImpl ftcWebSocket;

        public RawWebSocket(int port, InetAddress remoteIpAddress, String remoteHostname, WebSocketManager webSocketManager) {
            this.ftcWebSocket = new FtcWebSocketImpl(port, remoteIpAddress, remoteHostname, webSocketManager, this);
        }

        protected abstract boolean isOpen();

        protected abstract void send(String var1);

        protected abstract void close(int var1, String var2);

        public void onOpen() {
            this.ftcWebSocket.onOpen();
        }

        public void onMessage(String message) {
            this.ftcWebSocket.onMessage(message);
        }

        public void onClose(CloseCode closeCode, String reason, boolean initiatedByRemote) {
            this.ftcWebSocket.onClose(closeCode, reason, initiatedByRemote);
        }

        public void onException(Throwable exception) {
            this.ftcWebSocket.onException(exception);
        }
    }
}

