/*
 * Decompiled with CFR 0.152.
 */
package org.firstinspires.ftc.robotserver.internal.webserver.websockets;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.gson.JsonSyntaxException;
import com.qualcomm.robotcore.util.RobotLog;
import com.qualcomm.robotcore.util.Util;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.firstinspires.ftc.robotcore.internal.collections.SimpleGson;
import org.firstinspires.ftc.robotcore.internal.system.AppUtil;
import org.firstinspires.ftc.robotcore.internal.webserver.websockets.CommandNotImplementedException;
import org.firstinspires.ftc.robotcore.internal.webserver.websockets.FtcWebSocket;
import org.firstinspires.ftc.robotcore.internal.webserver.websockets.FtcWebSocketMessage;
import org.firstinspires.ftc.robotcore.internal.webserver.websockets.WebSocketCommandException;
import org.firstinspires.ftc.robotcore.internal.webserver.websockets.WebSocketCommandResponse;
import org.firstinspires.ftc.robotcore.internal.webserver.websockets.WebSocketManager;
import org.firstinspires.ftc.robotcore.internal.webserver.websockets.WebSocketNamespaceHandler;
import org.firstinspires.ftc.robotserver.internal.webserver.websockets.FtcWebSocketImpl;
import org.firstinspires.ftc.robotserver.internal.webserver.websockets.command.WebSocketCommand;

public final class WebSocketManagerImpl
implements WebSocketManager {
    private static final String SUBSCRIBE_TO_NAMESPACE_MESSAGE_TYPE = "subscribeToNamespace";
    private static final String UNSUBSCRIBE_FROM_NAMESPACE_MESSAGE_TYPE = "unsubscribeFromNamespace";
    private static final String REQUEST_CURRENT_TIME_MESSAGE_TYPE = "requestCurrentTime";
    private static final String NOTIFY_CURRENT_TIME_MESSAGE_TYPE = "notifyCurrentTime";
    private static final String TAG = "WebSocketManager";
    private final ConcurrentMap<String, WebSocketNamespaceHandler> namespaceHandlerMap = new ConcurrentHashMap<String, WebSocketNamespaceHandler>();
    private final ConcurrentMap<String, Set<FtcWebSocket>> namespaceSubscribersMap = new ConcurrentHashMap<String, Set<FtcWebSocket>>();

    public WebSocketManagerImpl() {
        AppUtil.getInstance().setWebSocketManager((WebSocketManager)this);
    }

    public void registerNamespaceHandler(@NonNull WebSocketNamespaceHandler handler) {
        this.internalRegisterNamespaceHandler(handler);
        RobotLog.vv((String)TAG, (String)"Registered handler for namespace %s", (Object[])new Object[]{handler.getNamespace()});
    }

    public void registerNamespaceAsBroadcastOnly(@NonNull String namespace) {
        this.internalRegisterNamespaceHandler(new BroadcastOnlyNamespaceHandler(namespace));
        RobotLog.vv((String)TAG, (String)"Registered broadcast-only namespace %s", (Object[])new Object[]{namespace});
    }

    public int broadcastToNamespace(@NonNull String namespace, @NonNull FtcWebSocketMessage message) {
        if (!namespace.equals(message.getNamespace())) {
            throw new IllegalArgumentException("Cannot broadcast to a different namespace than is listed in the message");
        }
        if (!this.namespaceSubscribersMap.containsKey(namespace)) {
            throw new IllegalStateException("You must register a namespace before broadcasting to it.");
        }
        int numberOfConnections = 0;
        for (FtcWebSocket webSocket : (Set)this.namespaceSubscribersMap.get(namespace)) {
            webSocket.send(message);
            ++numberOfConnections;
        }
        return numberOfConnections;
    }

    public boolean webSocketIsSubscribedToNamespace(@NonNull String namespace, @NonNull FtcWebSocket webSocket) {
        Set subscribersSet = (Set)this.namespaceSubscribersMap.get(namespace);
        if (subscribersSet == null) {
            throw new IllegalStateException("Namespace " + namespace + " is not registered");
        }
        return subscribersSet.contains(webSocket);
    }

    synchronized void onWebSocketClose(FtcWebSocket webSocket) {
        for (String namespace : this.namespaceSubscribersMap.keySet()) {
            this.unsubscribeWebSocketFromNamespace(webSocket, namespace);
        }
    }

    void onWebSocketMessage(FtcWebSocketMessage message, FtcWebSocketImpl webSocket) {
        String namespace = message.getNamespace();
        String type = message.getType();
        if (namespace.equals("system")) {
            this.handleSystemNamespace(message, webSocket);
            return;
        }
        if (!this.namespaceHandlerMap.containsKey(message.getNamespace())) {
            RobotLog.ww((String)TAG, (String)"Received message to unregistered namespace %s", (Object[])new Object[]{message.getNamespace()});
            return;
        }
        boolean handled = ((WebSocketNamespaceHandler)this.namespaceHandlerMap.get(message.getNamespace())).onMessage(message, (FtcWebSocket)webSocket);
        if (!handled) {
            RobotLog.ww((String)TAG, (String)"Received unsupported message with type %s to namespace %s", (Object[])new Object[]{message.getType(), message.getNamespace()});
            try {
                WebSocketCommand command = (WebSocketCommand)SimpleGson.getInstance().fromJson(message.getPayload(), WebSocketCommand.class);
                if (command.commandKey != null) {
                    CommandNotImplementedException notImplementedException = new CommandNotImplementedException(namespace, type);
                    WebSocketCommandResponse commandResponse = WebSocketCommandResponse.createError((Object)command.commandKey, (WebSocketCommandException)notImplementedException);
                    webSocket.sendCommandResponse(commandResponse);
                }
            }
            catch (JsonSyntaxException jsonSyntaxException) {
                // empty catch block
            }
        }
    }

    void onWebSocketConnected(FtcWebSocket webSocket) {
        if (!AppUtil.getInstance().isSaneWallClockTime(AppUtil.getInstance().getWallClockTime())) {
            ((FtcWebSocketImpl)webSocket).internalSend(new FtcWebSocketMessage("system", REQUEST_CURRENT_TIME_MESSAGE_TYPE));
        }
    }

    private synchronized void internalRegisterNamespaceHandler(@NonNull WebSocketNamespaceHandler handler) {
        String namespace = handler.getNamespace();
        if (!Util.isGoodString((String)namespace)) {
            throw new IllegalArgumentException("namespace must not be null, empty, or in need of trimming");
        }
        if (namespace.equals("system")) {
            throw new IllegalArgumentException("namespace system is reserved.");
        }
        if (this.namespaceHandlerMap.containsKey(namespace) && !(this.namespaceHandlerMap.get(namespace) instanceof BroadcastOnlyNamespaceHandler)) {
            throw new IllegalArgumentException("namespace " + namespace + " is already registered with a handler");
        }
        this.namespaceHandlerMap.put(namespace, handler);
        this.namespaceSubscribersMap.putIfAbsent(namespace, new CopyOnWriteArraySet());
    }

    private synchronized void unsubscribeWebSocketFromNamespace(FtcWebSocket webSocket, String namespace) {
        if (!this.namespaceHandlerMap.containsKey(namespace)) {
            RobotLog.ee((String)TAG, (String)"Cannot unsubscribe %s from namespace (%s) because there is no corresponding namespace handler registered", (Object[])new Object[]{webSocket, namespace});
            return;
        }
        if (((Set)this.namespaceSubscribersMap.get(namespace)).remove(webSocket)) {
            ((WebSocketNamespaceHandler)this.namespaceHandlerMap.get(namespace)).onUnsubscribe(webSocket);
            RobotLog.vv((String)TAG, (String)"Unsubscribed %s from namespace (%s)", (Object[])new Object[]{webSocket, namespace});
        }
    }

    private synchronized void subscribeWebSocketToNamespace(FtcWebSocketImpl webSocket, String namespace) {
        if (!this.namespaceHandlerMap.containsKey(namespace)) {
            RobotLog.ee((String)TAG, (String)"Cannot subscribe %s to namespace (%s) because there is no corresponding namespace handler registered", (Object[])new Object[]{webSocket, namespace});
            return;
        }
        if (((Set)this.namespaceSubscribersMap.get(namespace)).add(webSocket)) {
            ((WebSocketNamespaceHandler)this.namespaceHandlerMap.get(namespace)).onSubscribe((FtcWebSocket)webSocket);
            RobotLog.vv((String)TAG, (String)"Subscribed %s to namespace (%s)", (Object[])new Object[]{webSocket, namespace});
        }
    }

    private void handleSystemNamespace(FtcWebSocketMessage message, FtcWebSocketImpl webSocket) {
        if (message.getType().equals(SUBSCRIBE_TO_NAMESPACE_MESSAGE_TYPE)) {
            String namespace = message.getPayload();
            this.subscribeWebSocketToNamespace(webSocket, namespace);
        } else if (message.getType().equals(UNSUBSCRIBE_FROM_NAMESPACE_MESSAGE_TYPE)) {
            String namespace = message.getPayload();
            this.unsubscribeWebSocketFromNamespace(webSocket, namespace);
        } else if (message.getType().equals(NOTIFY_CURRENT_TIME_MESSAGE_TYPE)) {
            this.handleNotifyCurrentTimeMessage(message);
        }
    }

    private void handleNotifyCurrentTimeMessage(FtcWebSocketMessage message) {
        TimePayload payload = TimePayload.fromJson(message.getPayload());
        AppUtil.getInstance().setWallClockIfCurrentlyInsane(payload.timeMs, payload.timezone);
    }

    private static final class TimePayload {
        long timeMs;
        @Nullable
        String timezone;

        private TimePayload() {
        }

        private static TimePayload fromJson(String json) {
            return (TimePayload)SimpleGson.getInstance().fromJson(json, TimePayload.class);
        }
    }

    private static final class BroadcastOnlyNamespaceHandler
    extends WebSocketNamespaceHandler {
        private BroadcastOnlyNamespaceHandler(String namespace) {
            super(namespace);
        }
    }
}

