/*
 * Decompiled with CFR 0.152.
 */
package org.firstinspires.ftc.robotserver.internal.webserver.websockets.command;

import androidx.annotation.NonNull;
import com.google.gson.JsonSyntaxException;
import com.qualcomm.robotcore.util.RobotLog;
import org.firstinspires.ftc.robotcore.internal.collections.SimpleGson;
import org.firstinspires.ftc.robotcore.internal.webserver.websockets.FtcWebSocket;
import org.firstinspires.ftc.robotcore.internal.webserver.websockets.FtcWebSocketMessage;
import org.firstinspires.ftc.robotcore.internal.webserver.websockets.InternalWebSocketCommandException;
import org.firstinspires.ftc.robotcore.internal.webserver.websockets.WebSocketCommandException;
import org.firstinspires.ftc.robotcore.internal.webserver.websockets.WebSocketCommandResponse;
import org.firstinspires.ftc.robotcore.internal.webserver.websockets.WebSocketMessageTypeHandler;
import org.firstinspires.ftc.robotserver.internal.webserver.websockets.command.WebSocketCommand;

public abstract class WebSocketCommandHandler<P, R>
implements WebSocketMessageTypeHandler {
    public static String TAG = "WSCommandHandler";

    @NonNull
    protected abstract Class<P> getPayloadClass();

    @NonNull
    protected abstract Class<R> getResultClass();

    public abstract R handleCommand(P var1, FtcWebSocket var2) throws WebSocketCommandException;

    public final void handleMessage(FtcWebSocketMessage message, FtcWebSocket webSocket) {
        WebSocketCommand command;
        String payloadString = message.getPayload();
        try {
            command = (WebSocketCommand)SimpleGson.getInstance().fromJson(payloadString, WebSocketCommand.class);
        }
        catch (JsonSyntaxException e) {
            RobotLog.ee((String)TAG, (String)("Payload is not valid. Make sure it has a key field, a commandPayload field, and is valid JSON: " + payloadString));
            return;
        }
        Object payload = null;
        if (command.commandPayload != null && !command.commandPayload.isEmpty()) {
            payload = SimpleGson.getInstance().fromJson(command.commandPayload, this.getPayloadClass());
        }
        try {
            R result = this.handleCommand(payload, webSocket);
            String resultJson = "{}";
            if (result != null) {
                resultJson = SimpleGson.getInstance().toJson(result, this.getResultClass());
            }
            webSocket.sendCommandResponse(WebSocketCommandResponse.createSuccess((Object)command.commandKey, (String)resultJson));
        }
        catch (WebSocketCommandException e) {
            webSocket.sendCommandResponse(WebSocketCommandResponse.createError((Object)command.commandKey, (WebSocketCommandException)e));
        }
        catch (RuntimeException e) {
            InternalWebSocketCommandException internalException = new InternalWebSocketCommandException(e.getMessage(), (Throwable)e);
            webSocket.sendCommandResponse(WebSocketCommandResponse.createError((Object)command.commandKey, (WebSocketCommandException)internalException));
        }
    }
}

