/*
 * Decompiled with CFR 0.152.
 */
package org.firstinspires.ftc.robotserver.internal.webserver.websockets.tootallnate;

import com.qualcomm.robotcore.util.RobotLog;
import com.qualcomm.robotcore.util.ThreadPool;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.firstinspires.ftc.robotcore.internal.webserver.websockets.CloseCode;
import org.firstinspires.ftc.robotcore.internal.webserver.websockets.WebSocketManager;
import org.firstinspires.ftc.robotserver.internal.webserver.websockets.FtcWebSocketImpl;
import org.firstinspires.ftc.robotserver.internal.webserver.websockets.FtcWebSocketServer;
import org.firstinspires.ftc.robotserver.internal.webserver.websockets.WebSocketManagerImpl;
import org.firstinspires.ftc.robotserver.internal.webserver.websockets.WebSocketNamespaceHandlerRegistry;
import org.firstinspires.ftc.robotserver.internal.webserver.websockets.tootallnate.TooTallWebSocket;
import org.java_websocket.WebSocket;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.server.WebSocketServer;

public class TooTallWebSocketServer
extends WebSocketServer
implements FtcWebSocketServer {
    private static final String TAG = "TooTallWebSocketServer";
    private static final int DECODER_THREAD_COUNT = 1;
    private final WebSocketManagerImpl manager = new WebSocketManagerImpl();
    private final Map<WebSocket, FtcWebSocketImpl.RawWebSocket> wsMap = new ConcurrentHashMap<WebSocket, FtcWebSocketImpl.RawWebSocket>();

    public TooTallWebSocketServer(InetSocketAddress address) {
        super(address, 1);
        this.setReuseAddr(true);
        this.setConnectionLostTimeout(5);
        WebSocketNamespaceHandlerRegistry.onWebSocketServerCreation(this.manager);
    }

    public void onOpen(WebSocket conn, ClientHandshake handshake) {
        TooTallWebSocket webSocket = new TooTallWebSocket(conn, this.getPort(), conn.getRemoteSocketAddress().getAddress(), conn.getRemoteSocketAddress().getHostName(), this.manager);
        this.wsMap.put(conn, webSocket);
        webSocket.onOpen();
    }

    public void onClose(WebSocket conn, int code, String reason, boolean remote) {
        this.wsMap.get(conn).onClose(CloseCode.find((int)code), reason, remote);
    }

    public void onMessage(WebSocket conn, String message) {
        ThreadPool.getDefault().submit(() -> this.wsMap.get(conn).onMessage(message));
    }

    public void onError(WebSocket conn, Exception ex) {
        if (conn != null) {
            this.wsMap.get(conn).onException(ex);
        } else {
            RobotLog.ee((String)TAG, (Throwable)ex, (String)"WebSocket server error");
        }
    }

    public void onStart() {
        RobotLog.vv((String)TAG, (String)"Started WebSocket server on port %d", (Object[])new Object[]{this.getPort()});
    }

    @Override
    public WebSocketManager getWebSocketManager() {
        return this.manager;
    }
}

