/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.math.BigInteger;

public final class Long8 {
    private Long8() {
    }

    private static BigInteger toUnsignedBigInteger(long i) {
        if (i >= 0L) {
            return BigInteger.valueOf(i);
        }
        int upper = (int)(i >>> 32);
        int lower = (int)i;
        return BigInteger.valueOf(Integer8.toUnsignedLong(upper)).shiftLeft(32).add(BigInteger.valueOf(Integer8.toUnsignedLong(lower)));
    }

    public static int hashCode(long value) {
        return (int)(value ^ value >>> 32);
    }

    public static int compare(long x, long y) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    public static int compareUnsigned(long x, long y) {
        return Long8.compare(x + Long.MIN_VALUE, y + Long.MIN_VALUE);
    }

    public static long divideUnsigned(long dividend, long divisor) {
        if (divisor < 0L) {
            return Long8.compareUnsigned(dividend, divisor) < 0 ? 0L : 1L;
        }
        if (dividend > 0L) {
            return dividend / divisor;
        }
        return Long8.toUnsignedBigInteger(dividend).divide(Long8.toUnsignedBigInteger(divisor)).longValue();
    }

    public static long remainderUnsigned(long dividend, long divisor) {
        if (dividend > 0L && divisor > 0L) {
            return dividend % divisor;
        }
        if (Long8.compareUnsigned(dividend, divisor) < 0) {
            return dividend;
        }
        return Long8.toUnsignedBigInteger(dividend).remainder(Long8.toUnsignedBigInteger(divisor)).longValue();
    }

    public static long sum(long a, long b) {
        return a + b;
    }

    public static long max(long a, long b) {
        return Math.max(a, b);
    }

    public static long min(long a, long b) {
        return Math.min(a, b);
    }
}

