/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import sun.misc.Unsafe;

final class DesugarUnsafe {
    private static final Unsafe theUnsafe;

    DesugarUnsafe() {
    }

    private static Field getField() {
        try {
            return Unsafe.class.getDeclaredField("theUnsafe");
        }
        catch (NoSuchFieldException e) {
            for (Field f : Unsafe.class.getDeclaredFields()) {
                if (!Modifier.isStatic(f.getModifiers()) || !Unsafe.class.isAssignableFrom(f.getType())) continue;
                return f;
            }
            throw new Error("Couldn't find the Unsafe", e);
        }
    }

    public static Unsafe getUnsafe() {
        return theUnsafe;
    }

    public static final int getAndAddInt(Unsafe unsafe, Object o, long offset, int delta) {
        int v;
        while (!unsafe.compareAndSwapInt(o, offset, v = unsafe.getIntVolatile(o, offset), v + delta)) {
        }
        return v;
    }

    public static final long getAndAddLong(Unsafe unsafe, Object o, long offset, long delta) {
        long v;
        while (!unsafe.compareAndSwapLong(o, offset, v = unsafe.getLongVolatile(o, offset), v + delta)) {
        }
        return v;
    }

    public static final int getAndSetInt(Unsafe unsafe, Object o, long offset, int newValue) {
        int v;
        while (!unsafe.compareAndSwapInt(o, offset, v = unsafe.getIntVolatile(o, offset), newValue)) {
        }
        return v;
    }

    public static final long getAndSetLong(Unsafe unsafe, Object o, long offset, long newValue) {
        long v;
        while (!unsafe.compareAndSwapLong(o, offset, v = unsafe.getLongVolatile(o, offset), newValue)) {
        }
        return v;
    }

    public static final Object getAndSetObject(Unsafe unsafe, Object o, long offset, Object newValue) {
        Object v;
        while (!unsafe.compareAndSwapObject(o, offset, v = unsafe.getObjectVolatile(o, offset), newValue)) {
        }
        return v;
    }

    static {
        Field field = DesugarUnsafe.getField();
        field.setAccessible(true);
        try {
            theUnsafe = (Unsafe)field.get(null);
        }
        catch (IllegalAccessException e) {
            throw new Error("Couldn't get the Unsafe", e);
        }
    }
}

