/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.bosch;

import com.qualcomm.robotcore.hardware.I2cAddr;
import org.firstinspires.ftc.robotcore.external.navigation.Acceleration;
import org.firstinspires.ftc.robotcore.external.navigation.AngularVelocity;
import org.firstinspires.ftc.robotcore.external.navigation.AxesOrder;
import org.firstinspires.ftc.robotcore.external.navigation.AxesReference;
import org.firstinspires.ftc.robotcore.external.navigation.MagneticFlux;
import org.firstinspires.ftc.robotcore.external.navigation.Orientation;
import org.firstinspires.ftc.robotcore.external.navigation.Position;
import org.firstinspires.ftc.robotcore.external.navigation.Quaternion;
import org.firstinspires.ftc.robotcore.external.navigation.Temperature;
import org.firstinspires.ftc.robotcore.external.navigation.Velocity;

public interface BNO055IMU {
    public static final I2cAddr I2CADDR_ALTERNATE = null;
    public static final I2cAddr I2CADDR_DEFAULT = null;
    public static final I2cAddr I2CADDR_UNSPECIFIED = null;

    public boolean initialize(Parameters var1);

    public boolean isAccelerometerCalibrated();

    public boolean isGyroCalibrated();

    public boolean isMagnetometerCalibrated();

    public boolean isSystemCalibrated();

    public byte read8(Register var1);

    public byte[] read(Register var1, int var2);

    public CalibrationData readCalibrationData();

    public CalibrationStatus getCalibrationStatus();

    public Parameters getParameters();

    public SystemError getSystemError();

    public SystemStatus getSystemStatus();

    public Acceleration getAcceleration();

    public Acceleration getGravity();

    public Acceleration getLinearAcceleration();

    public Acceleration getOverallAcceleration();

    public AngularVelocity getAngularVelocity();

    public MagneticFlux getMagneticFieldStrength();

    public Orientation getAngularOrientation();

    public Orientation getAngularOrientation(AxesReference var1, AxesOrder var2, org.firstinspires.ftc.robotcore.external.navigation.AngleUnit var3);

    public Position getPosition();

    public Quaternion getQuaternionOrientation();

    public Temperature getTemperature();

    public Velocity getVelocity();

    public void close();

    public void startAccelerationIntegration(Position var1, Velocity var2, int var3);

    public void stopAccelerationIntegration();

    public void write(Register var1, byte[] var2);

    public void write8(Register var1, int var2);

    public void writeCalibrationData(CalibrationData var1);

    public static enum TempUnit {
        CELSIUS{
            public final byte bVal = Integer.valueOf(0).byteValue();

            @Override
            public org.firstinspires.ftc.robotcore.external.navigation.TempUnit toTempUnit() {
                return org.firstinspires.ftc.robotcore.external.navigation.TempUnit.CELSIUS;
            }
        }
        ,
        FARENHEIT{
            public final byte bVal = Integer.valueOf(0).byteValue();

            @Override
            public org.firstinspires.ftc.robotcore.external.navigation.TempUnit toTempUnit() {
                return org.firstinspires.ftc.robotcore.external.navigation.TempUnit.CELSIUS;
            }
        };

        public final byte bVal = Integer.valueOf(0).byteValue();

        public org.firstinspires.ftc.robotcore.external.navigation.TempUnit toTempUnit() {
            return org.firstinspires.ftc.robotcore.external.navigation.TempUnit.CELSIUS;
        }

        public static TempUnit fromTempUnit(org.firstinspires.ftc.robotcore.external.navigation.TempUnit arg0) {
            return CELSIUS;
        }
    }

    public static enum SystemStatus {
        UNKNOWN{
            public final byte bVal = Integer.valueOf(0).byteValue();

            @Override
            public String toShortString() {
                return "".toString();
            }
        }
        ,
        IDLE{
            public final byte bVal = Integer.valueOf(0).byteValue();

            @Override
            public String toShortString() {
                return "".toString();
            }
        }
        ,
        SYSTEM_ERROR{
            public final byte bVal = Integer.valueOf(0).byteValue();

            @Override
            public String toShortString() {
                return "".toString();
            }
        }
        ,
        INITIALIZING_PERIPHERALS{
            public final byte bVal = Integer.valueOf(0).byteValue();

            @Override
            public String toShortString() {
                return "".toString();
            }
        }
        ,
        SYSTEM_INITIALIZATION{
            public final byte bVal = Integer.valueOf(0).byteValue();

            @Override
            public String toShortString() {
                return "".toString();
            }
        }
        ,
        SELF_TEST{
            public final byte bVal = Integer.valueOf(0).byteValue();

            @Override
            public String toShortString() {
                return "".toString();
            }
        }
        ,
        RUNNING_FUSION{
            public final byte bVal = Integer.valueOf(0).byteValue();

            @Override
            public String toShortString() {
                return "".toString();
            }
        }
        ,
        RUNNING_NO_FUSION{
            public final byte bVal = Integer.valueOf(0).byteValue();

            @Override
            public String toShortString() {
                return "".toString();
            }
        };

        public final byte bVal = Integer.valueOf(0).byteValue();

        public String toShortString() {
            return "".toString();
        }

        public static SystemStatus from(int arg0) {
            return UNKNOWN;
        }
    }

    public static enum SystemError {
        UNKNOWN{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        NO_ERROR{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        PERIPHERAL_INITIALIZATION_ERROR{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        SYSTEM_INITIALIZATION_ERROR{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        SELF_TEST_FAILED{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        REGISTER_MAP_OUT_OF_RANGE{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        REGISTER_MAP_ADDRESS_OUT_OF_RANGE{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        REGISTER_MAP_WRITE_ERROR{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        LOW_POWER_MODE_NOT_AVAILABLE{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        ACCELEROMETER_POWER_MODE_NOT_AVAILABLE{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        FUSION_CONFIGURATION_ERROR{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        SENSOR_CONFIGURATION_ERROR{
            public final byte bVal = Integer.valueOf(0).byteValue();
        };

        public final byte bVal = Integer.valueOf(0).byteValue();

        public static SystemError from(int arg0) {
            return UNKNOWN;
        }
    }

    public static enum SensorMode {
        CONFIG{
            public final byte bVal = Integer.valueOf(0).byteValue();

            @Override
            public boolean isFusionMode() {
                return false;
            }
        }
        ,
        ACCONLY{
            public final byte bVal = Integer.valueOf(0).byteValue();

            @Override
            public boolean isFusionMode() {
                return false;
            }
        }
        ,
        MAGONLY{
            public final byte bVal = Integer.valueOf(0).byteValue();

            @Override
            public boolean isFusionMode() {
                return false;
            }
        }
        ,
        GYRONLY{
            public final byte bVal = Integer.valueOf(0).byteValue();

            @Override
            public boolean isFusionMode() {
                return false;
            }
        }
        ,
        ACCMAG{
            public final byte bVal = Integer.valueOf(0).byteValue();

            @Override
            public boolean isFusionMode() {
                return false;
            }
        }
        ,
        ACCGYRO{
            public final byte bVal = Integer.valueOf(0).byteValue();

            @Override
            public boolean isFusionMode() {
                return false;
            }
        }
        ,
        MAGGYRO{
            public final byte bVal = Integer.valueOf(0).byteValue();

            @Override
            public boolean isFusionMode() {
                return false;
            }
        }
        ,
        AMG{
            public final byte bVal = Integer.valueOf(0).byteValue();

            @Override
            public boolean isFusionMode() {
                return false;
            }
        }
        ,
        IMU{
            public final byte bVal = Integer.valueOf(0).byteValue();

            @Override
            public boolean isFusionMode() {
                return false;
            }
        }
        ,
        COMPASS{
            public final byte bVal = Integer.valueOf(0).byteValue();

            @Override
            public boolean isFusionMode() {
                return false;
            }
        }
        ,
        M4G{
            public final byte bVal = Integer.valueOf(0).byteValue();

            @Override
            public boolean isFusionMode() {
                return false;
            }
        }
        ,
        NDOF_FMC_OFF{
            public final byte bVal = Integer.valueOf(0).byteValue();

            @Override
            public boolean isFusionMode() {
                return false;
            }
        }
        ,
        NDOF{
            public final byte bVal = Integer.valueOf(0).byteValue();

            @Override
            public boolean isFusionMode() {
                return false;
            }
        }
        ,
        DISABLED{
            public final byte bVal = Integer.valueOf(0).byteValue();

            @Override
            public boolean isFusionMode() {
                return false;
            }
        };

        public final byte bVal = Integer.valueOf(0).byteValue();

        public boolean isFusionMode() {
            return false;
        }

        public static SensorMode fromByte(byte arg0) {
            return CONFIG;
        }
    }

    public static enum Register {
        PAGE_ID{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        CHIP_ID{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        ACC_ID{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        MAG_ID{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        GYR_ID{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        SW_REV_ID_LSB{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        SW_REV_ID_MSB{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        BL_REV_ID{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        ACC_DATA_X_LSB{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        ACC_DATA_X_MSB{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        ACC_DATA_Y_LSB{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        ACC_DATA_Y_MSB{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        ACC_DATA_Z_LSB{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        ACC_DATA_Z_MSB{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        MAG_DATA_X_LSB{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        MAG_DATA_X_MSB{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        MAG_DATA_Y_LSB{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        MAG_DATA_Y_MSB{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        MAG_DATA_Z_LSB{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        MAG_DATA_Z_MSB{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        GYR_DATA_X_LSB{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        GYR_DATA_X_MSB{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        GYR_DATA_Y_LSB{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        GYR_DATA_Y_MSB{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        GYR_DATA_Z_LSB{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        GYR_DATA_Z_MSB{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        EUL_H_LSB{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        EUL_H_MSB{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        EUL_R_LSB{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        EUL_R_MSB{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        EUL_P_LSB{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        EUL_P_MSB{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        QUA_DATA_W_LSB{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        QUA_DATA_W_MSB{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        QUA_DATA_X_LSB{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        QUA_DATA_X_MSB{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        QUA_DATA_Y_LSB{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        QUA_DATA_Y_MSB{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        QUA_DATA_Z_LSB{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        QUA_DATA_Z_MSB{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        LIA_DATA_X_LSB{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        LIA_DATA_X_MSB{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        LIA_DATA_Y_LSB{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        LIA_DATA_Y_MSB{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        LIA_DATA_Z_LSB{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        LIA_DATA_Z_MSB{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        GRV_DATA_X_LSB{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        GRV_DATA_X_MSB{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        GRV_DATA_Y_LSB{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        GRV_DATA_Y_MSB{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        GRV_DATA_Z_LSB{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        GRV_DATA_Z_MSB{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        TEMP{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        CALIB_STAT{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        SELFTEST_RESULT{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        INTR_STAT{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        SYS_CLK_STAT{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        SYS_STAT{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        SYS_ERR{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        UNIT_SEL{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        DATA_SELECT{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        OPR_MODE{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        PWR_MODE{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        SYS_TRIGGER{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        TEMP_SOURCE{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        AXIS_MAP_CONFIG{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        AXIS_MAP_SIGN{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        SIC_MATRIX_0_LSB{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        SIC_MATRIX_0_MSB{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        SIC_MATRIX_1_LSB{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        SIC_MATRIX_1_MSB{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        SIC_MATRIX_2_LSB{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        SIC_MATRIX_2_MSB{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        SIC_MATRIX_3_LSB{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        SIC_MATRIX_3_MSB{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        SIC_MATRIX_4_LSB{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        SIC_MATRIX_4_MSB{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        SIC_MATRIX_5_LSB{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        SIC_MATRIX_5_MSB{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        SIC_MATRIX_6_LSB{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        SIC_MATRIX_6_MSB{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        SIC_MATRIX_7_LSB{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        SIC_MATRIX_7_MSB{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        SIC_MATRIX_8_LSB{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        SIC_MATRIX_8_MSB{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        ACC_OFFSET_X_LSB{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        ACC_OFFSET_X_MSB{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        ACC_OFFSET_Y_LSB{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        ACC_OFFSET_Y_MSB{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        ACC_OFFSET_Z_LSB{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        ACC_OFFSET_Z_MSB{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        MAG_OFFSET_X_LSB{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        MAG_OFFSET_X_MSB{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        MAG_OFFSET_Y_LSB{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        MAG_OFFSET_Y_MSB{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        MAG_OFFSET_Z_LSB{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        MAG_OFFSET_Z_MSB{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        GYR_OFFSET_X_LSB{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        GYR_OFFSET_X_MSB{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        GYR_OFFSET_Y_LSB{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        GYR_OFFSET_Y_MSB{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        GYR_OFFSET_Z_LSB{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        GYR_OFFSET_Z_MSB{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        ACC_RADIUS_LSB{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        ACC_RADIUS_MSB{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        MAG_RADIUS_LSB{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        MAG_RADIUS_MSB{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        ACC_CONFIG{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        MAG_CONFIG{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        GYR_CONFIG_0{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        GYR_CONFIG_1{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        ACC_SLEEP_CONFIG{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        GYR_SLEEP_CONFIG{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        INT_MSK{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        INT_EN{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        ACC_AM_THRES{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        ACC_INT_SETTINGS{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        ACC_HG_DURATION{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        ACC_HG_THRES{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        ACC_NM_THRES{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        ACC_NM_SET{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        GRYO_INT_SETTING{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        GRYO_HR_X_SET{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        GRYO_DUR_X{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        GRYO_HR_Y_SET{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        GRYO_DUR_Y{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        GRYO_HR_Z_SET{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        GRYO_DUR_Z{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        GRYO_AM_THRES{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        GRYO_AM_SET{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        UNIQUE_ID_FIRST{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        UNIQUE_ID_LAST{
            public final byte bVal = Integer.valueOf(0).byteValue();
        };

        public final byte bVal = Integer.valueOf(0).byteValue();
    }

    public static enum PitchMode {
        WINDOWS{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        ANDROID{
            public final byte bVal = Integer.valueOf(0).byteValue();
        };

        public final byte bVal = Integer.valueOf(0).byteValue();
    }

    public static class Parameters
    implements Cloneable {
        public String calibrationDataFile;
        public String loggingTag;
        public boolean loggingEnabled;
        public boolean useExternalCrystal;
        public AccelBandwidth accelBandwidth;
        public AccelPowerMode accelPowerMode;
        public AccelRange accelRange;
        public AccelUnit accelUnit;
        public AccelerationIntegrator accelerationIntegrationAlgorithm;
        public AngleUnit angleUnit;
        public CalibrationData calibrationData;
        public GyroBandwidth gyroBandwidth;
        public GyroPowerMode gyroPowerMode;
        public GyroRange gyroRange;
        public MagOpMode magOpMode;
        public MagPowerMode magPowerMode;
        public MagRate magRate;
        public PitchMode pitchMode;
        public SensorMode mode;
        public TempUnit temperatureUnit;
        public I2cAddr i2cAddr;

        public Parameters clone() {
            return null;
        }
    }

    public static enum MagRate {
        HZ2{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        HZ6{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        HZ8{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        HZ10{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        HZ15{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        HZ20{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        HZ25{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        HZ30{
            public final byte bVal = Integer.valueOf(0).byteValue();
        };

        public final byte bVal = Integer.valueOf(0).byteValue();
    }

    public static enum MagPowerMode {
        NORMAL{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        SLEEP{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        SUSPEND{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        FORCE{
            public final byte bVal = Integer.valueOf(0).byteValue();
        };

        public final byte bVal = Integer.valueOf(0).byteValue();
    }

    public static enum MagOpMode {
        LOW{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        REGULAR{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        ENHANCED{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        HIGH{
            public final byte bVal = Integer.valueOf(0).byteValue();
        };

        public final byte bVal = Integer.valueOf(0).byteValue();
    }

    public static enum GyroRange {
        DPS2000{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        DPS1000{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        DPS500{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        DPS250{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        DPS125{
            public final byte bVal = Integer.valueOf(0).byteValue();
        };

        public final byte bVal = Integer.valueOf(0).byteValue();
    }

    public static enum GyroPowerMode {
        NORMAL{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        FAST{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        DEEP{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        SUSPEND{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        ADVANCED{
            public final byte bVal = Integer.valueOf(0).byteValue();
        };

        public final byte bVal = Integer.valueOf(0).byteValue();
    }

    public static enum GyroBandwidth {
        HZ523{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        HZ230{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        HZ116{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        HZ47{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        HZ23{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        HZ12{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        HZ64{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        HZ32{
            public final byte bVal = Integer.valueOf(0).byteValue();
        };

        public final byte bVal = Integer.valueOf(0).byteValue();
    }

    public static class CalibrationStatus {
        public final byte calibrationStatus = Integer.valueOf(0).byteValue();

        public CalibrationStatus(int arg0) {
        }

        public String toString() {
            return "".toString();
        }
    }

    public static class CalibrationData
    implements Cloneable {
        public short dxAccel;
        public short dxGyro;
        public short dxMag;
        public short dyAccel;
        public short dyGyro;
        public short dyMag;
        public short dzAccel;
        public short dzGyro;
        public short dzMag;
        public short radiusAccel;
        public short radiusMag;

        public String serialize() {
            return "".toString();
        }

        public CalibrationData clone() {
            return null;
        }

        public static CalibrationData deserialize(String arg0) {
            return null;
        }
    }

    public static enum AngleUnit {
        DEGREES{
            public final byte bVal = Integer.valueOf(0).byteValue();

            @Override
            public org.firstinspires.ftc.robotcore.external.navigation.AngleUnit toAngleUnit() {
                return org.firstinspires.ftc.robotcore.external.navigation.AngleUnit.DEGREES;
            }
        }
        ,
        RADIANS{
            public final byte bVal = Integer.valueOf(0).byteValue();

            @Override
            public org.firstinspires.ftc.robotcore.external.navigation.AngleUnit toAngleUnit() {
                return org.firstinspires.ftc.robotcore.external.navigation.AngleUnit.DEGREES;
            }
        };

        public final byte bVal = Integer.valueOf(0).byteValue();

        public org.firstinspires.ftc.robotcore.external.navigation.AngleUnit toAngleUnit() {
            return org.firstinspires.ftc.robotcore.external.navigation.AngleUnit.DEGREES;
        }

        public static AngleUnit fromAngleUnit(org.firstinspires.ftc.robotcore.external.navigation.AngleUnit arg0) {
            return DEGREES;
        }
    }

    public static interface AccelerationIntegrator {
        public Acceleration getAcceleration();

        public Position getPosition();

        public Velocity getVelocity();

        public void initialize(Parameters var1, Position var2, Velocity var3);

        public void update(Acceleration var1);
    }

    public static enum AccelUnit {
        METERS_PERSEC_PERSEC{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        MILLI_EARTH_GRAVITY{
            public final byte bVal = Integer.valueOf(0).byteValue();
        };

        public final byte bVal = Integer.valueOf(0).byteValue();
    }

    public static enum AccelRange {
        G2{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        G4{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        G8{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        G16{
            public final byte bVal = Integer.valueOf(0).byteValue();
        };

        public final byte bVal = Integer.valueOf(0).byteValue();
    }

    public static enum AccelPowerMode {
        NORMAL{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        SUSPEND{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        LOW1{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        STANDBY{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        LOW2{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        DEEP{
            public final byte bVal = Integer.valueOf(0).byteValue();
        };

        public final byte bVal = Integer.valueOf(0).byteValue();
    }

    public static enum AccelBandwidth {
        HZ7_81{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        HZ15_63{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        HZ31_25{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        HZ62_5{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        HZ125{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        HZ250{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        HZ500{
            public final byte bVal = Integer.valueOf(0).byteValue();
        }
        ,
        HZ1000{
            public final byte bVal = Integer.valueOf(0).byteValue();
        };

        public final byte bVal = Integer.valueOf(0).byteValue();
    }
}

