/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.robotcore.hardware;

import com.qualcomm.robotcore.exception.RobotCoreException;
import com.qualcomm.robotcore.hardware.AnalogInputController;
import com.qualcomm.robotcore.hardware.CRServo;
import com.qualcomm.robotcore.hardware.ColorSensor;
import com.qualcomm.robotcore.hardware.DcMotor;
import com.qualcomm.robotcore.hardware.DcMotorController;
import com.qualcomm.robotcore.hardware.DigitalChannelController;
import com.qualcomm.robotcore.hardware.GyroSensor;
import com.qualcomm.robotcore.hardware.HardwareDevice;
import com.qualcomm.robotcore.hardware.I2cDeviceSynch;
import com.qualcomm.robotcore.hardware.IrSeekerSensor;
import com.qualcomm.robotcore.hardware.LED;
import com.qualcomm.robotcore.hardware.PWMOutput;
import com.qualcomm.robotcore.hardware.PWMOutputController;
import com.qualcomm.robotcore.hardware.RobotCoreLynxModule;
import com.qualcomm.robotcore.hardware.RobotCoreLynxUsbDevice;
import com.qualcomm.robotcore.hardware.ScannedDevices;
import com.qualcomm.robotcore.hardware.Servo;
import com.qualcomm.robotcore.hardware.ServoControllerEx;
import com.qualcomm.robotcore.hardware.TouchSensor;
import com.qualcomm.robotcore.hardware.configuration.DeviceConfiguration;
import com.qualcomm.robotcore.hardware.configuration.typecontainers.AnalogSensorConfigurationType;
import com.qualcomm.robotcore.hardware.configuration.typecontainers.DigitalIoDeviceConfigurationType;
import com.qualcomm.robotcore.hardware.configuration.typecontainers.I2cDeviceConfigurationType;
import com.qualcomm.robotcore.hardware.configuration.typecontainers.MotorConfigurationType;
import com.qualcomm.robotcore.hardware.configuration.typecontainers.ServoConfigurationType;
import com.qualcomm.robotcore.util.SerialNumber;
import java.net.InetAddress;
import java.util.List;
import org.firstinspires.ftc.robotcore.external.hardware.camera.WebcamName;

public interface DeviceManager {
    public CRServo createCRServoEx(ServoControllerEx var1, int var2, String var3, ServoConfigurationType var4);

    public ColorSensor createAdafruitI2cColorSensor(RobotCoreLynxModule var1, DeviceConfiguration.I2cChannel var2, String var3);

    public ColorSensor createLynxColorRangeSensor(RobotCoreLynxModule var1, DeviceConfiguration.I2cChannel var2, String var3);

    public ColorSensor createModernRoboticsI2cColorSensor(RobotCoreLynxModule var1, DeviceConfiguration.I2cChannel var2, String var3);

    public DcMotor createDcMotor(DcMotorController var1, int var2, MotorConfigurationType var3, String var4);

    public DcMotor createDcMotorEx(DcMotorController var1, int var2, MotorConfigurationType var3, String var4);

    public GyroSensor createModernRoboticsI2cGyroSensor(RobotCoreLynxModule var1, DeviceConfiguration.I2cChannel var2, String var3);

    public HardwareDevice createLimelight3A(SerialNumber var1, String var2, InetAddress var3);

    public I2cDeviceSynch createI2cDeviceSynch(RobotCoreLynxModule var1, DeviceConfiguration.I2cChannel var2, String var3);

    public IrSeekerSensor createMRI2cIrSeekerSensorV3(RobotCoreLynxModule var1, DeviceConfiguration.I2cChannel var2, String var3);

    public LED createLED(DigitalChannelController var1, int var2, String var3);

    public PWMOutput createPwmOutputDevice(PWMOutputController var1, int var2, String var3);

    public RobotCoreLynxUsbDevice createLynxUsbDevice(SerialNumber var1, String var2) throws RobotCoreException, InterruptedException;

    public ScannedDevices scanForUsbDevices() throws RobotCoreException;

    public Servo createServoEx(ServoControllerEx var1, int var2, String var3, ServoConfigurationType var4);

    public TouchSensor createMRDigitalTouchSensor(DigitalChannelController var1, int var2, String var3);

    public List<HardwareDevice> createAnalogSensorInstances(AnalogInputController var1, int var2, AnalogSensorConfigurationType var3);

    public List<HardwareDevice> createCustomServoDeviceInstances(ServoControllerEx var1, int var2, ServoConfigurationType var3);

    public List<HardwareDevice> createDigitalDeviceInstances(DigitalChannelController var1, int var2, DigitalIoDeviceConfigurationType var3);

    public List<HardwareDevice> createI2cDeviceInstances(RobotCoreLynxModule var1, DeviceConfiguration.I2cChannel var2, I2cDeviceConfigurationType var3, String var4);

    public WebcamName createWebcamName(SerialNumber var1, String var2) throws RobotCoreException, InterruptedException;

    public static enum UsbDeviceType {
        FTDI_USB_UNKNOWN_DEVICE{}
        ,
        LYNX_USB_DEVICE{}
        ,
        WEBCAM{}
        ,
        ETHERNET_DEVICE{}
        ,
        UNKNOWN_DEVICE{};


        public static UsbDeviceType from(String arg0) {
            return FTDI_USB_UNKNOWN_DEVICE;
        }
    }
}

