/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.abi;

import java.math.BigInteger;
import java.util.List;
import java.util.stream.Collectors;
import org.fisco.bcos.sdk.abi.TypeEncoder;
import org.fisco.bcos.sdk.abi.Utils;
import org.fisco.bcos.sdk.abi.datatypes.Function;
import org.fisco.bcos.sdk.abi.datatypes.Type;
import org.fisco.bcos.sdk.abi.datatypes.Uint;
import org.fisco.bcos.sdk.crypto.CryptoSuite;
import org.fisco.bcos.sdk.utils.Numeric;

public class FunctionEncoder {
    private CryptoSuite cryptoSuite;

    public FunctionEncoder(CryptoSuite cryptoSuite) {
        this.cryptoSuite = cryptoSuite;
    }

    public String encode(Function function) {
        List<Type> parameters = function.getInputParameters();
        String methodSignature = FunctionEncoder.buildMethodSignature(function.getName(), parameters);
        String methodId = this.buildMethodId(methodSignature);
        StringBuilder result = new StringBuilder();
        result.append(methodId);
        return FunctionEncoder.encodeParameters(parameters, result);
    }

    public static String encodeConstructor(List<Type> parameters) {
        return FunctionEncoder.encodeParameters(parameters, new StringBuilder());
    }

    public static String encodeParameters(List<Type> parameters, StringBuilder result) {
        int dynamicDataOffset = Utils.getLength(parameters) * 32;
        StringBuilder dynamicData = new StringBuilder();
        for (Type parameter : parameters) {
            String encodedValue = TypeEncoder.encode(parameter);
            if (parameter.dynamicType()) {
                String encodedDataOffset = TypeEncoder.encodeNumeric(new Uint(BigInteger.valueOf(dynamicDataOffset)));
                result.append(encodedDataOffset);
                dynamicData.append(encodedValue);
                dynamicDataOffset += encodedValue.length() >> 1;
                continue;
            }
            result.append(encodedValue);
        }
        result.append((CharSequence)dynamicData);
        return result.toString();
    }

    public static String buildMethodSignature(String methodName, List<Type> parameters) {
        StringBuilder result = new StringBuilder();
        result.append(methodName);
        result.append("(");
        String params = parameters.stream().map(Type::getTypeAsString).collect(Collectors.joining(","));
        result.append(params);
        result.append(")");
        return result.toString();
    }

    public String buildMethodId(String methodSignature) {
        byte[] input = methodSignature.getBytes();
        byte[] hash = this.cryptoSuite.hash(input);
        return Numeric.toHexString(hash).substring(0, 10);
    }

    public CryptoSuite getCryptoSuite() {
        return this.cryptoSuite;
    }

    public void setCryptoSuite(CryptoSuite cryptoSuite) {
        this.cryptoSuite = cryptoSuite;
    }
}

