/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.amop.topic;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.socket.SocketChannel;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.fisco.bcos.sdk.amop.Amop;
import org.fisco.bcos.sdk.amop.AmopCallback;
import org.fisco.bcos.sdk.amop.topic.AmopMsgIn;
import org.fisco.bcos.sdk.amop.topic.AmopRespError;
import org.fisco.bcos.sdk.amop.topic.RequestVerifyData;
import org.fisco.bcos.sdk.amop.topic.TopicManager;
import org.fisco.bcos.sdk.amop.topic.TopicType;
import org.fisco.bcos.sdk.amop.topic.UpdateTopicStatus;
import org.fisco.bcos.sdk.channel.Channel;
import org.fisco.bcos.sdk.channel.ResponseCallback;
import org.fisco.bcos.sdk.channel.model.Options;
import org.fisco.bcos.sdk.crypto.CryptoSuite;
import org.fisco.bcos.sdk.crypto.keypair.CryptoKeyPair;
import org.fisco.bcos.sdk.model.AmopMsg;
import org.fisco.bcos.sdk.model.Message;
import org.fisco.bcos.sdk.model.MsgType;
import org.fisco.bcos.sdk.model.Response;
import org.fisco.bcos.sdk.network.MsgHandler;
import org.fisco.bcos.sdk.utils.Hex;
import org.fisco.bcos.sdk.utils.ObjectMapperFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmopMsgHandler
implements MsgHandler {
    private static Logger logger = LoggerFactory.getLogger(AmopMsgHandler.class);
    private TopicManager topicManager;
    private Channel channel;
    private long defaultTimeout = 5000L;
    private Map<String, ResponseCallback> seq2Callback = new ConcurrentHashMap<String, ResponseCallback>();
    private boolean isRunning = false;
    private CryptoSuite cryptoSuite = new CryptoSuite(0);

    public AmopMsgHandler(Channel channel, TopicManager topicManager) {
        this.topicManager = topicManager;
        this.channel = channel;
    }

    public void setIsRunning(boolean isRunning) {
        this.isRunning = isRunning;
    }

    @Override
    public void onConnect(ChannelHandlerContext ctx) {
        if (!this.isRunning) {
            logger.warn("Amop on connect, amop is not running, exit.");
            return;
        }
        String host = ((SocketChannel)ctx.channel()).remoteAddress().getAddress().getHostAddress();
        Integer port = ((SocketChannel)ctx.channel()).remoteAddress().getPort();
        String ipAndPort = host + ":" + port;
        logger.info("Node connected, update topics to node. node:" + ipAndPort);
        try {
            Set<String> topics = this.topicManager.getSubByPeer(ipAndPort);
            byte[] topicBytes = ObjectMapperFactory.getObjectMapper().writeValueAsBytes((Object)topics.toArray());
            Message msg = new Message();
            msg.setType((short)MsgType.AMOP_CLIENT_TOPICS.getType());
            msg.setResult(0);
            msg.setSeq(this.newSeq());
            msg.setData(topicBytes);
            ctx.writeAndFlush((Object)msg);
        }
        catch (JsonProcessingException e) {
            logger.warn("Amop on connect, subscribe error: {}", (Object)e.getMessage());
        }
    }

    @Override
    public void onMessage(ChannelHandlerContext ctx, Message msg) {
        logger.trace("receive msg, msg type:{}, seq:{}", (Object)msg.getType(), (Object)msg.getSeq());
        if (!this.isRunning) {
            logger.warn("Amop on msg, amop is not running, exit.");
        }
        if (msg.getType() == (short)MsgType.AMOP_RESPONSE.getType()) {
            this.onAmopResponse(ctx, msg);
            return;
        }
        if (msg.getType() == (short)MsgType.REQUEST_TOPICCERT.getType()) {
            this.onVerifyRequest(ctx, msg);
        } else if (msg.getType() == (short)MsgType.AMOP_REQUEST.getType() || msg.getType() == (short)MsgType.AMOP_MULBROADCAST.getType()) {
            AmopMsg amopMsg = new AmopMsg(msg);
            try {
                amopMsg.decodeAmopBody(msg.getData());
            }
            catch (Exception e) {
                logger.error("Receive an invalid message, msg type:{}, seq:{}", (Object)msg.getType(), (Object)msg.getSeq());
                return;
            }
            if (this.isVerifyingPrivateTopic(amopMsg)) {
                this.onPrivateTopicRandomValue(ctx, amopMsg);
            } else {
                this.onAmopMsg(ctx, amopMsg);
            }
        } else {
            logger.error("amop module receive a not supported type message, type:{}", (Object)msg.getType());
        }
    }

    @Override
    public void onDisconnect(ChannelHandlerContext ctx) {
    }

    public void onVerifyRequest(final ChannelHandlerContext ctx, Message msg) {
        RequestVerifyData data;
        logger.trace("private topic verify step 1: node request random number. seq:{} type:{}, content:{}", new Object[]{msg.getSeq(), msg.getType(), new String(msg.getData())});
        this.responseVerifyRequest(ctx, msg);
        String content = new String(msg.getData());
        try {
            data = (RequestVerifyData)ObjectMapperFactory.getObjectMapper().readValue(content, RequestVerifyData.class);
        }
        catch (JsonProcessingException e) {
            logger.error("receive request start private topic verify message, message is invalid, seq:{} msgtype:{}", (Object)msg.getSeq(), (Object)msg.getType());
            return;
        }
        final String topic = data.getTopic();
        final String nodeId = data.getNodeId();
        logger.trace("private topic verify step 1: node request random number. seq:{} topic:{} nodeId:{}", new Object[]{msg.getSeq(), topic, nodeId});
        final String rmdString = UUID.randomUUID().toString().replaceAll("-", "");
        AmopMsg respMsg = new AmopMsg();
        respMsg.setType((short)MsgType.AMOP_REQUEST.getType());
        respMsg.setSeq(Amop.newSeq());
        respMsg.setResult(0);
        respMsg.setData(rmdString.getBytes());
        respMsg.setTopic(data.getTopicForCert());
        Options opt = new Options();
        opt.setTimeout(this.defaultTimeout);
        ResponseCallback callback = new ResponseCallback(){

            @Override
            public void onResponse(Response response) {
                if (0 != response.getErrorCode()) {
                    logger.error("get random value signature of amop private topic failed :{}:{}", (Object)response.getErrorCode(), (Object)response.getErrorMessage());
                    return;
                }
                AmopMsg amopMsg = new AmopMsg();
                amopMsg.decodeAmopBody(response.getContentBytes());
                int valid = AmopMsgHandler.this.checkSignature(topic, rmdString.getBytes(), amopMsg.getData());
                try {
                    AmopMsgHandler.this.sendUpdateTopicStatus(valid, topic, nodeId, ctx);
                }
                catch (JsonProcessingException e) {
                    logger.error("update topic status error: {}", (Object)e.getMessage());
                }
            }
        };
        logger.trace("private topic verify step 2: send out random number. seq:{} topic:{} data:{}", new Object[]{respMsg.getSeq(), respMsg.getTopic(), new String(respMsg.getData())});
        this.channel.asyncSendToRandom(respMsg.getMessage(), callback, opt);
    }

    public void responseVerifyRequest(ChannelHandlerContext ctx, Message msg) {
        Message response = new Message();
        response.setSeq(msg.getSeq());
        response.setResult(0);
        response.setType((short)MsgType.REQUEST_TOPICCERT.getType());
        response.setData("".getBytes());
        ctx.writeAndFlush((Object)response);
    }

    public int checkSignature(String topic, byte[] randomValue, byte[] signature) {
        List<String> pubKeys = this.topicManager.getPublicKeysByTopic(topic);
        for (String publicKey : pubKeys) {
            if (this.cryptoSuite.verify(publicKey, Hex.toHexString(this.cryptoSuite.hash(randomValue)), Hex.toHexString(signature))) {
                return 0;
            }
            logger.warn("verify topic {} failed, randomValue: {}, publicKey: {}", new Object[]{topic, Hex.toHexString(randomValue), publicKey});
        }
        return 1;
    }

    private boolean isVerifyingPrivateTopic(AmopMsg amopMsg) {
        return amopMsg.getTopic().length() > "#!$VerifyChannel_".length() && "#!$VerifyChannel_".equals(amopMsg.getTopic().substring(0, "#!$VerifyChannel_".length()));
    }

    public static boolean isPrivateTopic(String topic) {
        return topic.length() > "#!$TopicNeedVerify_".length() && "#!$TopicNeedVerify_".equals(topic.substring(0, "#!$TopicNeedVerify_".length()));
    }

    public static String removePrivateTopicPrefix(String topic) {
        if (AmopMsgHandler.isPrivateTopic(topic)) {
            return topic.substring("#!$TopicNeedVerify_".length());
        }
        return topic;
    }

    private String getSimpleTopic(String fullTopic) {
        return fullTopic.substring("#!$VerifyChannel_".length(), fullTopic.length() - 33);
    }

    public void onPrivateTopicRandomValue(ChannelHandlerContext ctx, AmopMsg msg) {
        logger.trace("private topic verify step 2: receive random value, seq:{} type:{} topic:{} data:{}", new Object[]{msg.getSeq(), msg.getType(), msg.getTopic(), new String(msg.getData())});
        byte[] randValue = msg.getData();
        String topic = msg.getTopic();
        CryptoKeyPair cryptoKeyPair = this.topicManager.getPrivateKeyByTopic(this.getSimpleTopic(topic));
        String signature = "";
        if (null == cryptoKeyPair) {
            logger.error("topic:{} not subscribed, reject message", (Object)this.getSimpleTopic(topic));
            return;
        }
        try {
            signature = this.cryptoSuite.getSignatureImpl().signWithStringSignature(Hex.toHexString(this.cryptoSuite.hash(randValue)), cryptoKeyPair);
        }
        catch (Exception e) {
            logger.error("please check the public key of topic {} is correct configured, error {}", (Object)topic, (Object)e.getMessage());
        }
        this.sendSignedRandomNumber(signature, topic, msg.getSeq(), ctx);
    }

    public void onAmopMsg(ChannelHandlerContext ctx, AmopMsg amopMsg) {
        logger.debug("receive a Amop message. seq:{} msgtype:{}", (Object)amopMsg.getSeq(), (Object)amopMsg.getType());
        if (!this.topicManager.isSubTopic(amopMsg.getTopic())) {
            logger.warn("receive an amop msg which is not subscribed, topic:{}", (Object)amopMsg.getTopic());
            return;
        }
        AmopCallback callback = this.topicManager.getCallback(amopMsg.getTopic());
        if (callback == null) {
            logger.error("can not process Amop message, callback for topic {} is not found", (Object)amopMsg.getTopic());
            return;
        }
        AmopMsgIn msgIn = new AmopMsgIn();
        msgIn.setTopic(amopMsg.getTopic());
        if (AmopMsgHandler.isPrivateTopic(amopMsg.getTopic())) {
            msgIn.setTopic(AmopMsgHandler.removePrivateTopicPrefix(amopMsg.getTopic()));
            msgIn.setTopicType(TopicType.PRIVATE_TOPIC);
        }
        msgIn.setMessageID(amopMsg.getSeq());
        msgIn.setContent(amopMsg.getData());
        msgIn.setResult(amopMsg.getResult());
        msgIn.setCtx(ctx);
        msgIn.setType(amopMsg.getType());
        byte[] content = callback.receiveAmopMsg(msgIn);
        if (amopMsg.getType() == (short)MsgType.AMOP_MULBROADCAST.getType()) {
            return;
        }
        amopMsg.setResult(0);
        amopMsg.setType((short)MsgType.AMOP_RESPONSE.getType());
        amopMsg.setData(content);
        logger.trace("Send response, seq:{} topic:{} content:{}", new Object[]{amopMsg.getSeq(), amopMsg.getTopic(), new String(content)});
        ctx.writeAndFlush((Object)amopMsg.getMessage());
    }

    public void onAmopResponse(ChannelHandlerContext ctx, Message msg) {
        Response resp;
        logger.debug("receive amop response. seq:{} msgtype:{} ", (Object)msg.getSeq(), (Object)msg.getType());
        ResponseCallback callback = this.seq2Callback.get(msg.getSeq());
        if (null != callback) {
            resp = new Response();
            resp.setMessageID(msg.getSeq());
            resp.setErrorCode(msg.getResult());
            if (msg.getResult() != 0) {
                resp.setErrorMessage("response errors");
            }
            if (msg.getResult().intValue() == AmopRespError.REJECT_AMOP_REQ_FOR_OVER_BANDWIDTHLIMIT.getError()) {
                logger.error("AMOP request was rejected due to over bandwidth limit, message: {}", (Object)msg.getSeq());
                resp.setErrorMessage("AMOP request was rejected due to over bandwidth limit");
            }
            if (msg.getResult().intValue() == AmopRespError.NO_AVAILABLE_SESSION.getError()) {
                logger.error("AMOP request was rejected due to over bandwidth limit, message: {}", (Object)msg.getSeq());
                resp.setErrorMessage("AMOP request was rejected due to over bandwidth limit");
            }
            if (msg.getData() != null) {
                AmopMsg amopMsg = new AmopMsg();
                amopMsg.decodeAmopBody(msg.getData());
                resp.setContent(new String(amopMsg.getData()));
            }
        } else {
            logger.error("can not found response callback, timeout:{}", (Object)msg.getData());
            return;
        }
        callback.onResponse(resp);
    }

    private void sendSignedRandomNumber(String signature, String topic, String seq, ChannelHandlerContext ctx) {
        AmopMsg msg = new AmopMsg();
        msg.setTopic(topic);
        msg.setResult(0);
        msg.setSeq(seq);
        msg.setType((short)MsgType.AMOP_RESPONSE.getType());
        msg.setData(Hex.decode(signature));
        logger.trace("private topic verify step 3: sign on random value and send out, seq:{} type:{} topic:{} data:{}", new Object[]{msg.getSeq(), msg.getType(), msg.getTopic(), new String(msg.getData())});
        ctx.writeAndFlush((Object)msg.getMessage());
    }

    public void sendUpdateTopicStatus(int valid, String topic, String nodeId, ChannelHandlerContext ctx) throws JsonProcessingException {
        UpdateTopicStatus updateTopicStatus = new UpdateTopicStatus();
        updateTopicStatus.setCheckResult(valid);
        updateTopicStatus.setNodeId(nodeId);
        updateTopicStatus.setTopic(topic);
        String jsonStr = ObjectMapperFactory.getObjectMapper().writeValueAsString((Object)updateTopicStatus);
        Message msg = new Message();
        msg.setData(jsonStr.getBytes());
        msg.setSeq(this.newSeq());
        msg.setResult(0);
        msg.setType((short)MsgType.UPDATE_TOPIICSTATUS.getType());
        logger.info("private topic verify step4: finish signature verify, send out msg to update topic status, seq:{} topic:{} valid:{}", new Object[]{msg.getSeq(), topic, valid});
        ctx.writeAndFlush((Object)msg);
    }

    public void addCallback(String seq, ResponseCallback callback) {
        this.seq2Callback.put(seq, callback);
    }

    private String newSeq() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }
}

