/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.client.protocol.response;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.fisco.bcos.sdk.client.protocol.model.JsonTransactionResponse;
import org.fisco.bcos.sdk.client.protocol.response.BcosBlockHeader;
import org.fisco.bcos.sdk.model.JsonRpcResponse;
import org.fisco.bcos.sdk.utils.ObjectMapperFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public class BcosBlock
extends JsonRpcResponse<Block> {
    @Override
    @JsonDeserialize(using=BlockDeserialiser.class)
    public void setResult(Block result) {
        super.setResult(result);
    }

    public Block getBlock() {
        return (Block)this.getResult();
    }

    public static class Block
    extends BcosBlockHeader.BlockHeader {
        private List<TransactionResult> transactions;

        public List<TransactionResult> getTransactions() {
            return this.transactions;
        }

        @JsonDeserialize(using=TransactionResultDeserialiser.class)
        public void setTransactions(List<TransactionResult> transactions) {
            this.transactions = transactions;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Block block = (Block)o;
            return Objects.equals(this.transactions, block.transactions);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.transactions);
        }

        @Override
        public String toString() {
            return "{transactions=" + this.transactions + ", number='" + this.number + '\'' + ", hash='" + this.hash + '\'' + ", parentHash='" + this.parentHash + '\'' + ", logsBloom='" + this.logsBloom + '\'' + ", transactionsRoot='" + this.transactionsRoot + '\'' + ", receiptsRoot='" + this.receiptsRoot + '\'' + ", dbHash='" + this.dbHash + '\'' + ", stateRoot='" + this.stateRoot + '\'' + ", sealer='" + this.sealer + '\'' + ", sealerList=" + this.sealerList + ", extraData=" + this.extraData + ", gasLimit='" + this.gasLimit + '\'' + ", gasUsed='" + this.gasUsed + '\'' + ", timestamp='" + this.timestamp + '\'' + ", signatureList=" + this.signatureList + '}';
        }
    }

    public static class BlockDeserialiser
    extends JsonDeserializer<Block> {
        private ObjectReader objectReader = ObjectMapperFactory.getObjectReader();

        public Block deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            if (jsonParser.getCurrentToken() != JsonToken.VALUE_NULL) {
                return (Block)this.objectReader.readValue(jsonParser, Block.class);
            }
            return null;
        }
    }

    public static class TransactionResultDeserialiser
    extends JsonDeserializer<List<TransactionResult>> {
        private ObjectReader objectReader = ObjectMapperFactory.getObjectReader();

        public List<TransactionResult> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            ArrayList<TransactionResult> transactionResults;
            block3: {
                JsonToken nextToken;
                block2: {
                    transactionResults = new ArrayList<TransactionResult>();
                    nextToken = jsonParser.nextToken();
                    if (nextToken != JsonToken.START_OBJECT) break block2;
                    Iterator transactionObjectIterator = this.objectReader.readValues(jsonParser, TransactionObject.class);
                    while (transactionObjectIterator.hasNext()) {
                        transactionResults.add((TransactionResult)transactionObjectIterator.next());
                    }
                    break block3;
                }
                if (nextToken != JsonToken.VALUE_STRING) break block3;
                jsonParser.getValueAsString();
                Iterator transactionHashIterator = this.objectReader.readValues(jsonParser, TransactionHash.class);
                while (transactionHashIterator.hasNext()) {
                    transactionResults.add((TransactionResult)transactionHashIterator.next());
                }
            }
            return transactionResults;
        }
    }

    public static class TransactionObject
    extends JsonTransactionResponse
    implements TransactionResult<JsonTransactionResponse> {
        @Override
        public JsonTransactionResponse get() {
            return this;
        }
    }

    public static class TransactionHash
    implements TransactionResult<String> {
        private String value;

        public TransactionHash() {
        }

        public TransactionHash(String value) {
            this.value = value;
        }

        @Override
        public String get() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TransactionHash that = (TransactionHash)o;
            return Objects.equals(this.value, that.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "TransactionHash{value='" + this.value + '\'' + '}';
        }
    }

    public static interface TransactionResult<T> {
        public T get();
    }
}

