/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.client.protocol.response;

import java.math.BigInteger;
import java.util.Objects;
import org.fisco.bcos.sdk.model.JsonRpcResponse;
import org.fisco.bcos.sdk.utils.Numeric;

public class Call
extends JsonRpcResponse<CallOutput> {
    @Override
    public void setResult(CallOutput result) {
        super.setResult(result);
    }

    public CallOutput getCallResult() {
        return (CallOutput)this.getResult();
    }

    public static class CallOutput {
        private String currentBlockNumber;
        private String status;
        private String output;

        public BigInteger getCurrentBlockNumber() {
            return Numeric.decodeQuantity(this.currentBlockNumber);
        }

        public void setCurrentBlockNumber(String currentBlockNumber) {
            this.currentBlockNumber = currentBlockNumber;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getOutput() {
            return this.output;
        }

        public void setOutput(String output) {
            this.output = output;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CallOutput that = (CallOutput)o;
            return Objects.equals(Numeric.decodeQuantity(this.currentBlockNumber), Numeric.decodeQuantity(that.currentBlockNumber)) && Objects.equals(this.status, that.status) && Objects.equals(this.output, that.output);
        }

        public int hashCode() {
            return Objects.hash(Numeric.decodeQuantity(this.currentBlockNumber), this.status, this.output);
        }

        public String toString() {
            return "CallOutput{currentBlockNumber='" + this.currentBlockNumber + '\'' + ", status='" + this.status + '\'' + ", output='" + this.output + '\'' + '}';
        }
    }
}

