/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.config.model;

import java.io.File;
import java.io.InputStream;
import java.util.Map;
import org.fisco.bcos.sdk.config.exceptions.ConfigException;
import org.fisco.bcos.sdk.config.model.ConfigProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CryptoMaterialConfig {
    private static Logger logger = LoggerFactory.getLogger(CryptoMaterialConfig.class);
    private String certPath = "conf";
    private String caCertPath;
    private String sdkCertPath;
    private String sdkPrivateKeyPath;
    private String enSSLCertPath;
    private String enSSLPrivateKeyPath;
    private String cryptoProvider = "ssm";
    private String sslKeyIndex;
    private String enSslKeyIndex;
    private InputStream caInputStream;
    private InputStream sdkCertInputStream;
    private InputStream sdkPrivateKeyInputStream;
    private InputStream enSSLCertInputStream;
    private InputStream enSSLPrivateKeyInputStream;
    private int sslCryptoType;

    protected CryptoMaterialConfig() {
    }

    public CryptoMaterialConfig(ConfigProperty configProperty, int cryptoType) throws ConfigException {
        this.sslCryptoType = cryptoType;
        Map<String, Object> cryptoMaterialProperty = configProperty.getCryptoMaterial();
        this.certPath = ConfigProperty.getConfigFilePath(ConfigProperty.getValue(cryptoMaterialProperty, "certPath", this.certPath));
        CryptoMaterialConfig defaultCryptoMaterialConfig = this.getDefaultCaCertPath(cryptoType, this.certPath);
        this.caCertPath = ConfigProperty.getConfigFilePath(ConfigProperty.getValue(cryptoMaterialProperty, "caCert", defaultCryptoMaterialConfig.getCaCertPath()));
        this.sdkCertPath = ConfigProperty.getConfigFilePath(ConfigProperty.getValue(cryptoMaterialProperty, "sslCert", defaultCryptoMaterialConfig.getSdkCertPath()));
        this.sdkPrivateKeyPath = ConfigProperty.getConfigFilePath(ConfigProperty.getValue(cryptoMaterialProperty, "sslKey", defaultCryptoMaterialConfig.getSdkPrivateKeyPath()));
        this.enSSLCertPath = ConfigProperty.getConfigFilePath(ConfigProperty.getValue(cryptoMaterialProperty, "enSslCert", defaultCryptoMaterialConfig.getEnSSLCertPath()));
        this.enSSLPrivateKeyPath = ConfigProperty.getConfigFilePath(ConfigProperty.getValue(cryptoMaterialProperty, "enSslKey", defaultCryptoMaterialConfig.getEnSSLPrivateKeyPath()));
        this.caInputStream = ConfigProperty.getConfigInputStream(ConfigProperty.getValue(cryptoMaterialProperty, "caCert", defaultCryptoMaterialConfig.getCaCertPath()));
        this.sdkCertInputStream = ConfigProperty.getConfigInputStream(ConfigProperty.getValue(cryptoMaterialProperty, "sslCert", defaultCryptoMaterialConfig.getSdkCertPath()));
        this.sdkPrivateKeyInputStream = ConfigProperty.getConfigInputStream(ConfigProperty.getValue(cryptoMaterialProperty, "sslKey", defaultCryptoMaterialConfig.getSdkPrivateKeyPath()));
        this.enSSLCertInputStream = ConfigProperty.getConfigInputStream(ConfigProperty.getValue(cryptoMaterialProperty, "enSslCert", defaultCryptoMaterialConfig.getEnSSLCertPath()));
        this.enSSLPrivateKeyInputStream = ConfigProperty.getConfigInputStream(ConfigProperty.getValue(cryptoMaterialProperty, "enSslKey", defaultCryptoMaterialConfig.getEnSSLPrivateKeyPath()));
        this.cryptoProvider = ConfigProperty.getValue(cryptoMaterialProperty, "cryptoProvider", defaultCryptoMaterialConfig.getCryptoProvider());
        this.sslKeyIndex = ConfigProperty.getValue(cryptoMaterialProperty, "sslKeyIndex", defaultCryptoMaterialConfig.getSslKeyIndex());
        this.enSslKeyIndex = ConfigProperty.getValue(cryptoMaterialProperty, "enSslKeyIndex", defaultCryptoMaterialConfig.getEnSslKeyIndex());
        logger.debug("Load cryptoMaterial, caCertPath: {}, sdkCertPath: {}, sdkPrivateKeyPath:{}, enSSLCertPath: {}, enSSLPrivateKeyPath:{}", new Object[]{this.getCaCertPath(), this.getSdkCertPath(), this.getSdkPrivateKeyPath(), this.getEnSSLCertPath(), this.getEnSSLPrivateKeyPath()});
    }

    public CryptoMaterialConfig getDefaultCaCertPath(int cryptoType, String certPath) throws ConfigException {
        CryptoMaterialConfig cryptoMaterialConfig = new CryptoMaterialConfig();
        cryptoMaterialConfig.setCertPath(certPath);
        String smDir = "gm";
        if (cryptoType == 0) {
            cryptoMaterialConfig.setCaCertPath(certPath + File.separator + "ca.crt");
            cryptoMaterialConfig.setSdkCertPath(certPath + File.separator + "sdk.crt");
            cryptoMaterialConfig.setSdkPrivateKeyPath(certPath + File.separator + "sdk.key");
            cryptoMaterialConfig.setCryptoProvider("ssm");
        } else if (cryptoType == 1) {
            cryptoMaterialConfig.setCaCertPath(certPath + File.separator + smDir + File.separator + "gmca.crt");
            cryptoMaterialConfig.setSdkCertPath(certPath + File.separator + smDir + File.separator + "gmsdk.crt");
            cryptoMaterialConfig.setSdkPrivateKeyPath(certPath + File.separator + smDir + File.separator + "gmsdk.key");
            cryptoMaterialConfig.setEnSSLCertPath(certPath + File.separator + smDir + File.separator + "gmensdk.crt");
            cryptoMaterialConfig.setEnSSLPrivateKeyPath(certPath + File.separator + smDir + File.separator + "gmensdk.key");
            cryptoMaterialConfig.setCryptoProvider("ssm");
        } else {
            throw new ConfigException("load CryptoMaterialConfig failed, only support ecdsa and sm now, expected 0 or 1, but provided " + cryptoType);
        }
        return cryptoMaterialConfig;
    }

    public String getCertPath() {
        return this.certPath;
    }

    public void setCertPath(String certPath) {
        this.certPath = certPath;
    }

    public String getCaCertPath() {
        return this.caCertPath;
    }

    public void setCaCertPath(String caCertPath) {
        this.caCertPath = caCertPath;
    }

    public String getSdkCertPath() {
        return this.sdkCertPath;
    }

    public void setSdkCertPath(String sdkCertPath) {
        this.sdkCertPath = sdkCertPath;
    }

    public String getSdkPrivateKeyPath() {
        return this.sdkPrivateKeyPath;
    }

    public void setSdkPrivateKeyPath(String sdkPrivateKeyPath) {
        this.sdkPrivateKeyPath = sdkPrivateKeyPath;
    }

    public String getEnSSLCertPath() {
        return this.enSSLCertPath;
    }

    public void setEnSSLCertPath(String enSSLCertPath) {
        this.enSSLCertPath = enSSLCertPath;
    }

    public String getEnSSLPrivateKeyPath() {
        return this.enSSLPrivateKeyPath;
    }

    public void setEnSSLPrivateKeyPath(String enSSLPrivateKeyPath) {
        this.enSSLPrivateKeyPath = enSSLPrivateKeyPath;
    }

    public int getSslCryptoType() {
        return this.sslCryptoType;
    }

    public void setSslCryptoType(int sslCryptoType) {
        this.sslCryptoType = sslCryptoType;
    }

    public InputStream getCaInputStream() {
        return this.caInputStream;
    }

    public void setCaInputStream(InputStream caInputStream) {
        this.caInputStream = caInputStream;
    }

    public InputStream getSdkCertInputStream() {
        return this.sdkCertInputStream;
    }

    public void setSdkCertInputStream(InputStream sdkCertInputStream) {
        this.sdkCertInputStream = sdkCertInputStream;
    }

    public InputStream getSdkPrivateKeyInputStream() {
        return this.sdkPrivateKeyInputStream;
    }

    public void setSdkPrivateKeyInputStream(InputStream sdkPrivateKeyInputStream) {
        this.sdkPrivateKeyInputStream = sdkPrivateKeyInputStream;
    }

    public InputStream getEnSSLCertInputStream() {
        return this.enSSLCertInputStream;
    }

    public void setEnSSLCertInputStream(InputStream enSSLCertInputStream) {
        this.enSSLCertInputStream = enSSLCertInputStream;
    }

    public InputStream getEnSSLPrivateKeyInputStream() {
        return this.enSSLPrivateKeyInputStream;
    }

    public void setEnSSLPrivateKeyInputStream(InputStream enSSLPrivateKeyInputStream) {
        this.enSSLPrivateKeyInputStream = enSSLPrivateKeyInputStream;
    }

    public String getCryptoProvider() {
        return this.cryptoProvider;
    }

    public void setCryptoProvider(String cryptoProvider) {
        this.cryptoProvider = cryptoProvider;
    }

    public String getSslKeyIndex() {
        return this.sslKeyIndex;
    }

    public void setSslKeyIndex(String sslKeyIndex) {
        this.sslKeyIndex = sslKeyIndex;
    }

    public String getEnSslKeyIndex() {
        return this.enSslKeyIndex;
    }

    public void setEnSslKeyIndex(String enSslKeyIndex) {
        this.enSslKeyIndex = enSslKeyIndex;
    }

    public String toString() {
        return "CryptoMaterialConfig{certPath='" + this.certPath + '\'' + ", caCertPath='" + this.caCertPath + '\'' + ", sdkCertPath='" + this.sdkCertPath + '\'' + ", sdkPrivateKeyPath='" + this.sdkPrivateKeyPath + '\'' + ", enSSLCertPath='" + this.enSSLCertPath + '\'' + ", enSSLPrivateKeyPath='" + this.enSSLPrivateKeyPath + '\'' + ", sslCryptoType=" + this.sslCryptoType + '}';
    }
}

