/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.contract.precompiled.model;

import org.fisco.bcos.sdk.channel.model.ChannelPrococolExceiption;
import org.fisco.bcos.sdk.channel.model.EnumNodeVersion;
import org.fisco.bcos.sdk.transaction.model.exception.ContractException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Version {
    private static Logger logger = LoggerFactory.getLogger(Version.class);
    private final String minVersion;
    private String maxVersion;
    private String interfaceName;

    public Version(String interfaceName, String minVersion) {
        this.interfaceName = interfaceName;
        this.minVersion = minVersion;
    }

    public void checkVersion(String currentVersion) throws ContractException {
        try {
            EnumNodeVersion.Version minSupportVersion = EnumNodeVersion.getClassVersion(this.minVersion);
            EnumNodeVersion.Version supportedVersion = EnumNodeVersion.getClassVersion(currentVersion);
            String errorMessage = "The fisco bcos node with supported_version lower than " + minSupportVersion.toVersionString() + " does not support the interface " + this.interfaceName + ", current fisco-bcos supported_version:" + supportedVersion.toVersionString();
            if (supportedVersion.getMajor() < minSupportVersion.getMajor()) {
                logger.error(errorMessage);
                throw new ContractException(errorMessage);
            }
            if (supportedVersion.getMajor() == minSupportVersion.getMajor() && supportedVersion.getMinor() < minSupportVersion.getMinor()) {
                logger.error(errorMessage);
                throw new ContractException(errorMessage);
            }
            if (this.maxVersion == null || this.maxVersion.equals("")) {
                return;
            }
            EnumNodeVersion.Version maxSupportedVersion = EnumNodeVersion.getClassVersion(this.maxVersion);
            errorMessage = "The fisco bcos node with supported_version larger than " + maxSupportedVersion.toVersionString() + " does not support the interface " + this.interfaceName + ", current fisco-bcos supported_version:" + supportedVersion.toVersionString();
            if (supportedVersion.getMajor() > maxSupportedVersion.getMajor()) {
                throw new ContractException(errorMessage);
            }
            if (supportedVersion.getMajor() == maxSupportedVersion.getMajor() && supportedVersion.getMinor() > maxSupportedVersion.getMinor()) {
                throw new ContractException(errorMessage);
            }
        }
        catch (ChannelPrococolExceiption e) {
            logger.error("checkVersion for interface " + this.interfaceName + " failed, error info: " + e.getMessage());
            throw new ContractException("checkVersion for interface " + this.interfaceName + " failed, error info: " + e.getMessage());
        }
    }

    public String getMinVersion() {
        return this.minVersion;
    }

    public String getMaxVersion() {
        return this.maxVersion;
    }

    public void setMaxVersion(String maxVersion) {
        this.maxVersion = maxVersion;
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public void setInterfaceName(String interfaceName) {
        this.interfaceName = interfaceName;
    }
}

