/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.crypto.keystore;

import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemReader;
import org.bouncycastle.util.io.pem.PemWriter;
import org.fisco.bcos.sdk.crypto.exceptions.LoadKeyStoreException;
import org.fisco.bcos.sdk.crypto.exceptions.SaveKeyStoreException;
import org.fisco.bcos.sdk.crypto.keystore.KeyTool;

public class PEMKeyStore
extends KeyTool {
    public static final String PRIVATE_KEY = "PRIVATE KEY";
    private PemObject pem;

    public PEMKeyStore(String keyStoreFile) {
        super(keyStoreFile);
    }

    public PEMKeyStore(InputStream keyStoreFileInputStream) {
        super(keyStoreFileInputStream);
    }

    @Override
    protected PublicKey getPublicKey() {
        try {
            X509EncodedKeySpec encodedKeySpec = new X509EncodedKeySpec(this.pem.getContent());
            KeyFactory keyFactory = KeyFactory.getInstance("EC", "BC");
            return keyFactory.generatePublic(encodedKeySpec);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException | InvalidKeySpecException e) {
            throw new LoadKeyStoreException("getPublicKey from pem file " + this.keyStoreFile + " failed, error message: " + e.getMessage(), e);
        }
    }

    public static void storeKeyPairWithPemFormat(String hexedPrivateKey, String privateKeyFilePath, String curveName) throws SaveKeyStoreException {
        try {
            KeyPair keyPair = PEMKeyStore.convertHexedStringToKeyPair(hexedPrivateKey, curveName);
            PemWriter writer = new PemWriter((Writer)new FileWriter(privateKeyFilePath));
            BCECPrivateKey bcecPrivateKey = (BCECPrivateKey)keyPair.getPrivate();
            writer.writeObject((PemObjectGenerator)new PemObject(PRIVATE_KEY, bcecPrivateKey.getEncoded()));
            writer.flush();
            writer.close();
            PEMKeyStore.storePublicKeyWithPem(keyPair.getPublic(), privateKeyFilePath);
        }
        catch (IOException | LoadKeyStoreException e) {
            throw new SaveKeyStoreException("save keys into " + privateKeyFilePath + " failed, error information: " + e.getMessage(), e);
        }
    }

    @Override
    protected void load(InputStream in) {
        try {
            PemReader pemReader = new PemReader((Reader)new InputStreamReader(in));
            this.pem = pemReader.readPemObject();
            pemReader.close();
        }
        catch (IOException e) {
            String errorMessage = "load key info from the pem file " + this.keyStoreFile + " failed, error message:" + e.getMessage();
            logger.error(errorMessage);
            throw new LoadKeyStoreException(errorMessage, e);
        }
        if (this.pem == null) {
            logger.error("The file " + this.keyStoreFile + " does not represent a pem account.");
            throw new LoadKeyStoreException("The file does not represent a pem account.");
        }
    }

    @Override
    protected PrivateKey getPrivateKey() {
        try {
            PKCS8EncodedKeySpec encodedKeySpec = new PKCS8EncodedKeySpec(this.pem.getContent());
            KeyFactory keyFacotry = KeyFactory.getInstance("EC", "BC");
            return keyFacotry.generatePrivate(encodedKeySpec);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException | InvalidKeySpecException e) {
            String errorMessage = "getPrivateKey from pem file " + this.keyStoreFile + " failed, error message:" + e.getMessage();
            logger.error(errorMessage);
            throw new LoadKeyStoreException(errorMessage, e);
        }
    }
}

