/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.network;

import io.netty.channel.ChannelHandlerContext;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import org.fisco.bcos.sdk.config.ConfigOption;
import org.fisco.bcos.sdk.config.exceptions.ConfigException;
import org.fisco.bcos.sdk.model.Message;
import org.fisco.bcos.sdk.network.ConnectionInfo;
import org.fisco.bcos.sdk.network.ConnectionManager;
import org.fisco.bcos.sdk.network.MsgHandler;
import org.fisco.bcos.sdk.network.Network;
import org.fisco.bcos.sdk.network.NetworkException;
import org.fisco.bcos.sdk.utils.SystemInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkImp
implements Network {
    private static Logger logger = LoggerFactory.getLogger(NetworkImp.class);
    private ConnectionManager connManager;
    private ConfigOption configOption;
    private MsgHandler handler;

    public NetworkImp(ConfigOption configOption, MsgHandler handler) throws ConfigException {
        this.configOption = configOption;
        this.handler = handler;
        this.connManager = new ConnectionManager(configOption, handler);
    }

    @Override
    public ConfigOption getConfigOption() {
        return this.configOption;
    }

    @Override
    public int getSslCryptoType() {
        return this.configOption.getCryptoMaterialConfig().getSslCryptoType();
    }

    @Override
    public void broadcast(Message out) {
        Map<String, ChannelHandlerContext> conns = this.connManager.getAvailableConnections();
        conns.forEach((peer, ctx) -> {
            ctx.writeAndFlush((Object)out);
            logger.trace("send message to  {} success ", peer);
        });
    }

    @Override
    public void sendToPeer(Message out, String peerIpPort) throws NetworkException {
        ChannelHandlerContext ctx = this.connManager.getConnectionCtx(peerIpPort);
        if (!Objects.isNull(ctx)) {
            logger.warn("send message to  {} failed ", (Object)peerIpPort);
            throw new NetworkException("Peer not available. Peer: " + peerIpPort);
        }
        ctx.writeAndFlush((Object)out);
        logger.trace("send message to  {} success ", (Object)peerIpPort);
    }

    @Override
    public List<ConnectionInfo> getConnectionInfo() {
        return this.connManager.getConnectionInfoList();
    }

    private CheckCertExistenceResult checkCertExistence(boolean isSM) throws NetworkException {
        CheckCertExistenceResult result = new CheckCertExistenceResult();
        result.setCheckPassed(true);
        String errorMessage = "[";
        if (this.configOption.getCryptoMaterialConfig().getCaInputStream() == null) {
            result.setCheckPassed(false);
            errorMessage = errorMessage + this.configOption.getCryptoMaterialConfig().getCaCertPath() + ",";
        }
        if (this.configOption.getCryptoMaterialConfig().getSdkCertInputStream() == null) {
            result.setCheckPassed(false);
            errorMessage = errorMessage + this.configOption.getCryptoMaterialConfig().getSdkCertPath() + ",";
        }
        if (this.configOption.getCryptoMaterialConfig().getSdkPrivateKeyInputStream() == null) {
            result.setCheckPassed(false);
            errorMessage = errorMessage + this.configOption.getCryptoMaterialConfig().getSdkPrivateKeyPath() + ",";
        }
        if (!isSM) {
            errorMessage = errorMessage + "]";
            result.setErrorMessage(errorMessage);
            return result;
        }
        if (!this.configOption.getCryptoMaterialConfig().getCryptoProvider().equalsIgnoreCase("hsm")) {
            if (this.configOption.getCryptoMaterialConfig().getEnSSLPrivateKeyInputStream() == null) {
                errorMessage = errorMessage + this.configOption.getCryptoMaterialConfig().getEnSSLPrivateKeyPath() + ",";
                result.setCheckPassed(false);
            }
            if (this.configOption.getCryptoMaterialConfig().getEnSSLCertInputStream() == null) {
                errorMessage = errorMessage + this.configOption.getCryptoMaterialConfig().getEnSSLCertPath() + ",";
                result.setCheckPassed(false);
            }
        }
        errorMessage = errorMessage + "]";
        result.setErrorMessage(errorMessage);
        return result;
    }

    @Override
    public void start() throws NetworkException {
        CheckCertExistenceResult result = null;
        String ecdsaCryptoInfo = this.configOption.getCryptoMaterialConfig().toString();
        String tipsInformation = "\n* TRACE INFORMATION:\n----------------------------\n";
        try {
            try {
                tipsInformation = tipsInformation + "====> STEP1: try to connect nodes with ecdsa context...\n";
                logger.info("{}", (Object)tipsInformation);
                result = this.checkCertExistence(false);
                if (result.isCheckPassed()) {
                    String message = "<==== STEP1-1: Load certificates for ecdsa context success...";
                    tipsInformation = tipsInformation + message + "\n";
                    logger.info("====> {}, start connManager with ECDSA sslContext", (Object)message);
                    this.connManager.startConnect(this.configOption);
                    this.connManager.startReconnectSchedule();
                    return;
                }
                String errorMessage = "<==== STEP1 Result: try to connect nodes with ecdsa context failed for cert missing\n* Missed certificates: " + result.getErrorMessage() + "\n";
                errorMessage = errorMessage + "currentPath: " + new File("").getAbsolutePath() + "\n";
                tipsInformation = tipsInformation + errorMessage + "\n";
                logger.warn(errorMessage);
            }
            catch (NetworkException e) {
                if (e.getErrorCode() == 2) {
                    String errorMessage = "<==== connect nodes failed, reason:\n" + e.getMessage();
                    tipsInformation = tipsInformation + errorMessage + "\n";
                    logger.warn("{}", (Object)errorMessage);
                    throw new NetworkException(tipsInformation);
                }
                String errorMessage = "<==== STEP1 Result: try to connect nodes with ecdsa context failed. reason:\n" + e.getMessage();
                tipsInformation = tipsInformation + errorMessage + "\n";
                logger.info("{}", (Object)errorMessage);
                this.configOption.reloadConfig(1);
                this.connManager.stopNetty();
            }
            String message = "----------------------------\n";
            message = message + "====> STEP2: connect nodes with ecdsa context failed, try to connect nodes with sm-context...";
            tipsInformation = tipsInformation + message + "\n";
            logger.info("{}", (Object)message);
            this.configOption.reloadConfig(1);
            result = this.checkCertExistence(true);
            if (!result.isCheckPassed()) {
                message = "<==== STEP2 Result: connect with sm context failed for cert missing.\n* Missed certificates: \n" + result.getErrorMessage() + "\n";
                message = message + "currentPath: " + new File("").getAbsolutePath() + "\n";
                message = message + "----------------------------\n";
                message = message + "<====> Error: try to connect nodes with both ecdsa and sm context failed <====>\n";
                message = message + "<====>\u001b[1;31m Please refer to github issue: https://github.com/FISCO-BCOS/java-sdk/issues/536 \u001b[0m\n";
                message = message + "<====>\u001b[1;31m Please refer to fisco-docs: https://fisco-bcos-documentation.readthedocs.io/zh_CN/latest/docs/faq/connect.html \u001b[0m\n";
                message = message + "----------------------------\n";
                message = message + SystemInformation.getSystemInformation();
                tipsInformation = tipsInformation + message + "\n";
                logger.warn("{}", (Object)message);
                throw new NetworkException(tipsInformation);
            }
            try {
                message = "<==== STEP2-1: Load certificates for sm context success...";
                tipsInformation = tipsInformation + message + "\n";
                logger.info("{}", (Object)message);
                this.connManager = new ConnectionManager(this.configOption, this.handler);
                this.connManager.startConnect(this.configOption);
                this.connManager.startReconnectSchedule();
            }
            catch (Exception e) {
                message = "<==== STEP2 Result: connect nodes with sm context failed for " + e.getMessage() + "\n";
                message = message + "----------------------------\n";
                message = message + "<====> Error: try to connect nodes with both ecdsa and sm context failed <====>\n";
                message = message + "<====>\u001b[1;31m Please refer to github issue: https://github.com/FISCO-BCOS/java-sdk/issues/536 \u001b[0m\n";
                message = message + "<====>\u001b[1;31m Please refer to fisco-docs: https://fisco-bcos-documentation.readthedocs.io/zh_CN/latest/docs/faq/connect.html \u001b[0m\n";
                message = message + "----------------------------\n";
                message = message + SystemInformation.getSystemInformation();
                tipsInformation = tipsInformation + message;
                logger.warn("{}, e: ", (Object)message, (Object)e);
                throw new NetworkException(tipsInformation);
            }
        }
        catch (ConfigException e) {
            throw new NetworkException(e);
        }
        catch (Exception e) {
            throw new NetworkException(e);
        }
    }

    @Override
    public Map<String, ChannelHandlerContext> getAvailableConnections() {
        return this.connManager.getAvailableConnections();
    }

    @Override
    public void removeConnection(String peerIpPort) {
        this.connManager.removeConnection(peerIpPort);
    }

    @Override
    public void setMsgHandleThreadPool(ExecutorService threadPool) {
        this.connManager.setMsgHandleThreadPool(threadPool);
    }

    @Override
    public ConnectionManager getConnManager() {
        return this.connManager;
    }

    @Override
    public void stop() {
        logger.debug("stop Network...");
        this.connManager.stopReconnectSchedule();
        this.connManager.stopNetty();
    }

    private class CheckCertExistenceResult {
        private boolean checkPassed = true;
        private String errorMessage = "";

        private CheckCertExistenceResult() {
        }

        public boolean isCheckPassed() {
            return this.checkPassed;
        }

        public void setCheckPassed(boolean checkPassed) {
            this.checkPassed = checkPassed;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }
    }
}

