/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.channel;

import io.netty.util.Timeout;
import org.fisco.bcos.sdk.channel.model.ChannelMessageError;
import org.fisco.bcos.sdk.model.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ResponseCallback {
    private static Logger logger = LoggerFactory.getLogger(ResponseCallback.class);
    private Timeout timeout;

    public abstract void onResponse(Response var1);

    public void onTimeout() {
        logger.error("Processing message timeout:{}");
        this.cancelTimeout();
        Response response = new Response();
        response.setErrorCode(ChannelMessageError.MESSAGE_TIMEOUT.getError());
        response.setErrorMessage("Processing message timeout");
        response.setContent("");
        this.onResponse(response);
    }

    public void cancelTimeout() {
        if (this.getTimeout() != null && !this.getTimeout().isCancelled()) {
            this.getTimeout().cancel();
        }
    }

    public void onError(String errorMessage) {
        this.cancelTimeout();
        Response response = new Response();
        response.setErrorCode(ChannelMessageError.INTERNAL_MESSAGE_HANDLE_FAILED.getError());
        response.setErrorMessage(errorMessage);
        this.onResponse(response);
    }

    public Timeout getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Timeout timeout) {
        this.timeout = timeout;
    }
}

