/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.crypto;

import java.security.KeyPair;
import org.fisco.bcos.sdk.config.ConfigOption;
import org.fisco.bcos.sdk.config.model.AccountConfig;
import org.fisco.bcos.sdk.crypto.exceptions.LoadKeyStoreException;
import org.fisco.bcos.sdk.crypto.exceptions.UnsupportedCryptoTypeException;
import org.fisco.bcos.sdk.crypto.hash.Hash;
import org.fisco.bcos.sdk.crypto.hash.Keccak256;
import org.fisco.bcos.sdk.crypto.hash.SDFSM3Hash;
import org.fisco.bcos.sdk.crypto.hash.SM3Hash;
import org.fisco.bcos.sdk.crypto.keypair.CryptoKeyPair;
import org.fisco.bcos.sdk.crypto.keypair.ECDSAKeyPair;
import org.fisco.bcos.sdk.crypto.keypair.SDFSM2KeyPair;
import org.fisco.bcos.sdk.crypto.keypair.SM2KeyPair;
import org.fisco.bcos.sdk.crypto.keystore.KeyTool;
import org.fisco.bcos.sdk.crypto.keystore.P12KeyStore;
import org.fisco.bcos.sdk.crypto.keystore.PEMKeyStore;
import org.fisco.bcos.sdk.crypto.signature.ECDSASignature;
import org.fisco.bcos.sdk.crypto.signature.SDFSM2Signature;
import org.fisco.bcos.sdk.crypto.signature.SM2Signature;
import org.fisco.bcos.sdk.crypto.signature.Signature;
import org.fisco.bcos.sdk.crypto.signature.SignatureResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CryptoSuite {
    private static Logger logger = LoggerFactory.getLogger(CryptoSuite.class);
    public int cryptoTypeConfig;
    public Signature signatureImpl;
    public Hash hashImpl;
    private CryptoKeyPair keyPairFactory;
    private CryptoKeyPair cryptoKeyPair;
    private ConfigOption config;

    public CryptoSuite(int cryptoTypeConfig, CryptoKeyPair cryptoKeyPair) {
        this(cryptoTypeConfig);
        this.cryptoKeyPair = cryptoKeyPair;
    }

    public CryptoSuite(int cryptoTypeConfig, String hexedPrivateKey) {
        this(cryptoTypeConfig);
        this.cryptoKeyPair = this.keyPairFactory.createKeyPair(hexedPrivateKey);
    }

    public CryptoSuite(int cryptoTypeConfig, ConfigOption configOption) {
        this.config = configOption;
        int cryptoType = cryptoTypeConfig;
        if (cryptoTypeConfig == 1 && configOption != null && configOption.getCryptoMaterialConfig().getCryptoProvider() != null && configOption.getCryptoMaterialConfig().getCryptoProvider().equalsIgnoreCase("hsm")) {
            cryptoType = 2001;
        }
        this.initCryptoSuite(cryptoType);
        if (configOption.getCryptoMaterialConfig().getCryptoProvider().equalsIgnoreCase("hsm")) {
            this.loadAccount(configOption);
        }
        if (configOption == null || !configOption.getAccountConfig().isAccountConfigured()) {
            this.createKeyPair();
            return;
        }
        this.loadAccount(configOption);
    }

    public CryptoSuite(int cryptoTypeConfig) {
        this.initCryptoSuite(cryptoTypeConfig);
    }

    protected void initCryptoSuite(int cryptoTypeConfig) {
        this.cryptoTypeConfig = cryptoTypeConfig;
        if (cryptoTypeConfig == 1) {
            this.signatureImpl = new SM2Signature();
            this.hashImpl = new SM3Hash();
            this.keyPairFactory = new SM2KeyPair();
        } else if (cryptoTypeConfig == 0) {
            this.signatureImpl = new ECDSASignature();
            this.hashImpl = new Keccak256();
            this.keyPairFactory = new ECDSAKeyPair();
        } else if (cryptoTypeConfig == 2001) {
            logger.info("Use hsm crypto");
            this.signatureImpl = new SDFSM2Signature();
            this.hashImpl = new SDFSM3Hash();
            this.keyPairFactory = new SDFSM2KeyPair();
            this.cryptoTypeConfig = 1;
        } else {
            throw new UnsupportedCryptoTypeException("only support 0/1/2001 crypto type");
        }
        this.keyPairFactory.setConfig(this.config);
        if (cryptoTypeConfig != 2001) {
            this.createKeyPair();
        }
    }

    public void loadSDFInternalAccount(String accountKeyIndex, String password) {
        logger.info("using hsm internal key, key index = " + accountKeyIndex);
        long index = Long.parseLong(accountKeyIndex);
        SDFSM2KeyPair factory = (SDFSM2KeyPair)this.keyPairFactory;
        SDFSM2KeyPair keyPair = factory.createKeyPair(index, password);
        this.setCryptoKeyPair(keyPair);
    }

    public void loadAccount(String accountFileFormat, String accountFilePath, String password) {
        KeyTool keyTool = null;
        if (accountFileFormat.compareToIgnoreCase("p12") == 0) {
            keyTool = new P12KeyStore(accountFilePath, password);
        } else if (accountFileFormat.compareToIgnoreCase("pem") == 0) {
            keyTool = new PEMKeyStore(accountFilePath);
        } else {
            throw new LoadKeyStoreException("unsupported account file format : " + accountFileFormat + ", current supported are p12 and pem");
        }
        logger.info("Load account from {}", (Object)accountFilePath);
        this.createKeyPair(keyTool.getKeyPair());
    }

    private void loadAccount(ConfigOption configOption) {
        String accountFilePath;
        AccountConfig accountConfig = configOption.getAccountConfig();
        String cryptoType = configOption.getCryptoMaterialConfig().getCryptoProvider();
        logger.debug("cryptoType = " + cryptoType);
        if (cryptoType != null && cryptoType.equalsIgnoreCase("hsm")) {
            logger.debug("use hsm key");
            String accountKeyIndex = accountConfig.getAccountKeyIndex();
            if (accountKeyIndex != null) {
                this.loadSDFInternalAccount(accountKeyIndex, accountConfig.getAccountPassword());
                logger.debug("Load sdf internal account, keyIndex = ", (Object)accountKeyIndex);
                return;
            }
        }
        if ((accountFilePath = accountConfig.getAccountFilePath()) == null || accountFilePath.equals("")) {
            if (accountConfig.getAccountFileFormat().compareToIgnoreCase("p12") == 0) {
                accountFilePath = this.keyPairFactory.getP12KeyStoreFilePath(accountConfig.getAccountAddress());
            } else if (accountConfig.getAccountFileFormat().compareToIgnoreCase("pem") == 0) {
                accountFilePath = this.keyPairFactory.getPemKeyStoreFilePath(accountConfig.getAccountAddress());
            }
        }
        this.loadAccount(accountConfig.getAccountFileFormat(), accountFilePath, accountConfig.getAccountPassword());
    }

    public void setConfig(ConfigOption config) {
        this.config = config;
        this.keyPairFactory.setConfig(config);
    }

    public int getCryptoTypeConfig() {
        return this.cryptoTypeConfig;
    }

    public Signature getSignatureImpl() {
        return this.signatureImpl;
    }

    public Hash getHashImpl() {
        return this.hashImpl;
    }

    public String hash(String inputData) {
        return this.hashImpl.hash(inputData);
    }

    public byte[] hash(byte[] inputBytes) {
        return this.hashImpl.hash(inputBytes);
    }

    public SignatureResult sign(byte[] message, CryptoKeyPair keyPair) {
        return this.signatureImpl.sign(message, keyPair);
    }

    public SignatureResult sign(String message, CryptoKeyPair keyPair) {
        return this.signatureImpl.sign(message, keyPair);
    }

    public String sign(KeyTool keyTool, String message) {
        CryptoKeyPair cryptoKeyPair = this.keyPairFactory.createKeyPair(keyTool.getKeyPair());
        return this.signatureImpl.signWithStringSignature(message, cryptoKeyPair);
    }

    public boolean verify(KeyTool keyTool, String message, String signature) {
        return this.verify(keyTool.getHexedPublicKey(), message, signature);
    }

    public boolean verify(KeyTool keyTool, byte[] message, byte[] signature) {
        return this.verify(keyTool.getHexedPublicKey(), message, signature);
    }

    public boolean verify(String publicKey, String message, String signature) {
        return this.signatureImpl.verify(publicKey, message, signature);
    }

    public boolean verify(String publicKey, byte[] message, byte[] signature) {
        return this.signatureImpl.verify(publicKey, message, signature);
    }

    public CryptoKeyPair createKeyPair() {
        this.cryptoKeyPair = this.keyPairFactory.generateKeyPair();
        this.cryptoKeyPair.setConfig(this.config);
        return this.cryptoKeyPair;
    }

    public CryptoKeyPair createKeyPair(KeyPair keyPair) {
        this.cryptoKeyPair = this.keyPairFactory.createKeyPair(keyPair);
        this.cryptoKeyPair.setConfig(this.config);
        return this.cryptoKeyPair;
    }

    public CryptoKeyPair createKeyPair(String hexedPrivateKey) {
        this.cryptoKeyPair = this.keyPairFactory.createKeyPair(hexedPrivateKey);
        this.cryptoKeyPair.setConfig(this.config);
        return this.cryptoKeyPair;
    }

    public void setCryptoKeyPair(CryptoKeyPair cryptoKeyPair) {
        this.cryptoKeyPair = cryptoKeyPair;
        this.cryptoKeyPair.setConfig(this.config);
    }

    public CryptoKeyPair getCryptoKeyPair() {
        return this.cryptoKeyPair;
    }

    public ConfigOption getConfig() {
        return this.config;
    }

    public CryptoKeyPair getKeyPairFactory() {
        return this.keyPairFactory;
    }
}

