/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.eventsub;

import java.math.BigInteger;
import java.util.List;
import org.fisco.bcos.sdk.utils.AddressUtils;
import org.fisco.bcos.sdk.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventLogParams {
    private static Logger logger = LoggerFactory.getLogger(EventLogParams.class);
    private String fromBlock;
    private String toBlock;
    private List<String> addresses;
    private List<Object> topics;

    public static Logger getLogger() {
        return logger;
    }

    public static void setLogger(Logger logger) {
        EventLogParams.logger = logger;
    }

    public String getFromBlock() {
        return this.fromBlock;
    }

    public void setFromBlock(String fromBlock) {
        this.fromBlock = fromBlock;
    }

    public String getToBlock() {
        return this.toBlock;
    }

    public void setToBlock(String toBlock) {
        this.toBlock = toBlock;
    }

    public List<String> getAddresses() {
        return this.addresses;
    }

    public void setAddresses(List<String> addresses) {
        this.addresses = addresses;
    }

    public List<Object> getTopics() {
        return this.topics;
    }

    public void setTopics(List<Object> topics) {
        this.topics = topics;
    }

    public String toString() {
        return "EventLogFilterParams [fromBlock=" + this.fromBlock + ", toBlock=" + this.toBlock + ", addresses=" + this.addresses + ", topics=" + this.topics + "]";
    }

    public boolean checkAddresses() {
        if (this.getAddresses() == null) {
            return false;
        }
        for (String address : this.getAddresses()) {
            if (AddressUtils.isValidAddress(address)) continue;
            return false;
        }
        return true;
    }

    private boolean checkTopics() {
        if (this.getTopics() == null || this.getTopics().size() > 4) {
            return false;
        }
        for (Object topic : this.getTopics()) {
            if (topic == null) continue;
            if (topic instanceof String) {
                if (!((String)topic).isEmpty()) continue;
                return false;
            }
            if (topic instanceof List) {
                for (Object o : (List)topic) {
                    if (!((String)o).isEmpty()) continue;
                    return false;
                }
                continue;
            }
            return false;
        }
        return true;
    }

    private boolean checkToBlock(BigInteger blockNumber) {
        BigInteger toBlock = new BigInteger(this.getToBlock());
        return blockNumber.compareTo(BigInteger.ONE) <= 0 || blockNumber.compareTo(BigInteger.ONE) > 0 && toBlock.compareTo(blockNumber) > 0;
    }

    private boolean checkFromBlock(BigInteger blockNumber) {
        BigInteger fromBlock = new BigInteger(this.getFromBlock());
        if (fromBlock.compareTo(BigInteger.ZERO) <= 0) {
            return false;
        }
        if (blockNumber.compareTo(BigInteger.ONE) > 0 && fromBlock.compareTo(blockNumber) > 0) {
            logger.info(" future block range request, from: {}, to: {}", (Object)this.getFromBlock(), (Object)this.getToBlock());
        }
        return true;
    }

    private boolean checkFromToBlock(BigInteger blockNumber) throws NumberFormatException {
        BigInteger fromBlock = new BigInteger(this.getFromBlock());
        BigInteger toBlock = new BigInteger(this.getToBlock());
        if (fromBlock.compareTo(BigInteger.ZERO) <= 0 || fromBlock.compareTo(toBlock) > 0) {
            return false;
        }
        if (blockNumber.compareTo(BigInteger.ONE) > 0 && fromBlock.compareTo(blockNumber) > 0) {
            logger.info(" future block range request, from: {}, to: {}", (Object)this.getFromBlock(), (Object)this.getToBlock());
        }
        return true;
    }

    private boolean checkBlockRange(BigInteger blockNumber) {
        if (StringUtils.isEmpty(this.getFromBlock()) || StringUtils.isEmpty(this.getToBlock())) {
            return false;
        }
        boolean isValidBlockRange = true;
        try {
            if (this.getFromBlock().equals("latest") && !this.getToBlock().equals("latest")) {
                isValidBlockRange = this.checkToBlock(blockNumber);
            } else if (!this.getFromBlock().equals("latest") && this.getToBlock().equals("latest")) {
                isValidBlockRange = this.checkFromBlock(blockNumber);
            } else if (!this.getFromBlock().equals("latest") && !this.getToBlock().equals("latest")) {
                isValidBlockRange = this.checkFromToBlock(blockNumber);
            }
        }
        catch (Exception e) {
            isValidBlockRange = false;
        }
        return isValidBlockRange;
    }

    public boolean checkParams(BigInteger blockNumber) {
        return this.checkBlockRange(blockNumber) && this.checkAddresses() && this.checkTopics();
    }
}

